/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.mdt;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.util.DebugUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;

public final class MatlabEventQueue<V> {
    private static final ExecutorServiceWrapper executorWrapper = new ExecutorServiceWrapper();

    private MatlabEventQueue() {
    }

    public static <V> Future<V> invoke(MatlabCallable<V> matlabCallable) {
        if (!Matlab.isMatlabAvailable()) {
            assert (DebugUtils.warning((String)"MATLAB is not running"));
            return null;
        }
        assert (matlabCallable != null) : "Precondition violated: argument \"task\" must not be null.";
        if (MatlabEventQueue.isMatlabThread()) {
            Present present = new Present(matlabCallable);
            return present;
        }
        if (executorWrapper.exec.isShutdown()) {
            return null;
        }
        FutureTaskProxy futureTaskProxy = null;
        try {
            futureTaskProxy = new FutureTaskProxy(new CallableProxy(matlabCallable));
            executorWrapper.exec.submit(futureTaskProxy);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return null;
        }
        return futureTaskProxy;
    }

    public static boolean isMatlabThread() {
        return NativeMatlab.nativeIsMatlabThread();
    }

    public static void shutdown() {
        MatlabEventQueue.executorWrapper.shutdown();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    MatlabEventQueue.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private static final class CallableProxy<V>
    implements Callable<V> {
        private final MatlabCallable<V> task;
        private volatile boolean isCanceled;
        private volatile V result;
        private volatile boolean isRunning;
        private volatile Exception exception;

        private CallableProxy(MatlabCallable<V> matlabCallable) {
            assert (matlabCallable != null);
            this.task = matlabCallable;
            this.isCanceled = false;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void cancel() {
            if (this.isCanceled) {
                return;
            }
            this.isCanceled = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CallableProxy.this.task.callOnEdt(null, false);
                }
            });
        }

        @Override
        public V call() throws Exception {
            if (this.isCanceled) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CallableProxy.this.task.callOnEdt(null, false);
                    }
                });
                throw new CancellationException();
            }
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            Matlab.whenMatlabIdle(new Runnable(){

                @Override
                public void run() {
                    block11: {
                        CallableProxy.this.isRunning = true;
                        try {
                            if (!CallableProxy.this.isCanceled) {
                                CallableProxy.this.result = CallableProxy.this.task.call();
                                break block11;
                            }
                            return;
                        }
                        catch (Exception exception) {
                            CallableProxy.this.exception = exception;
                            if (!(exception instanceof InterruptedException) && !(exception instanceof CancellationException)) assert (DebugUtils.outputException((Throwable)exception));
                        }
                        catch (Error error) {
                            assert (DebugUtils.warning((String)error.getMessage()));
                            throw error;
                        }
                        finally {
                            countDownLatch.countDown();
                            CallableProxy.this.isRunning = false;
                        }
                    }
                    if (CallableProxy.this.exception == null) {
                        atomicBoolean.set(true);
                    }
                }
            });
            countDownLatch.await();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CallableProxy.this.task.callOnEdt(CallableProxy.this.result, atomicBoolean.get());
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }

    private static final class Present<V>
    implements Future<V> {
        private final MatlabCallable<V> task;
        private final AtomicReference<V> result = new AtomicReference();
        private final AtomicReference<Exception> exception = new AtomicReference();
        private volatile boolean isDone;

        /*
         * Loose catch block
         */
        private Present(MatlabCallable<V> matlabCallable) {
            assert (matlabCallable != null) : "Precondition violated";
            this.task = matlabCallable;
            this.isDone = false;
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            try {
                Object v = matlabCallable.call();
                this.result.set(v);
                atomicBoolean.set(true);
                this.isDone = true;
            }
            catch (Exception exception) {
                this.exception.set(exception);
                if (!(exception instanceof InterruptedException) && !(exception instanceof CancellationException)) assert (DebugUtils.outputException((Throwable)exception));
                this.isDone = true;
                SwingUtilities.invokeLater(new Runnable(atomicBoolean){
                    final /* synthetic */ AtomicBoolean val$completedNormally;
                    {
                        this.val$completedNormally = atomicBoolean;
                    }

                    @Override
                    public void run() {
                        Present.this.task.callOnEdt(Present.this.result.get(), this.val$completedNormally.get());
                    }
                });
            }
            catch (Error error) {
                assert (DebugUtils.warning((String)error.getMessage()));
                throw error;
                {
                    catch (Throwable throwable) {
                        this.isDone = true;
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        @Override
        public boolean cancel(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            if (this.exception.get() != null) {
                if (this.exception.get() instanceof InterruptedException) {
                    InterruptedException interruptedException = new InterruptedException();
                    interruptedException.initCause(this.exception.get());
                    throw interruptedException;
                }
                if (this.exception.get() instanceof ExecutionException) {
                    throw (ExecutionException)this.exception.get();
                }
            }
            return this.result.get();
        }

        @Override
        public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }
    }

    private static final class FutureTaskProxy<V>
    extends FutureTask<V> {
        private final CallableProxy<V> callable;
        private static final MatlabMCR matlab = new MatlabMCR();

        private FutureTaskProxy(CallableProxy<V> callableProxy) {
            super(callableProxy);
            assert (callableProxy != null) : "Precondition violated";
            this.callable = callableProxy;
        }

        @Override
        public boolean cancel(boolean bl) {
            if (this.isCancelled()) {
                return false;
            }
            if (bl) {
                this.callable.cancel();
                if (this.callable.isRunning()) {
                    matlab.interrupt();
                }
            }
            return super.cancel(bl);
        }

        @Override
        public V get() {
            throw new UnsupportedOperationException("This call will block EDT and is not allowed.");
        }
    }

    private static final class ExecutorServiceWrapper {
        private final ExecutorService exec = Executors.newSingleThreadExecutor();

        private ExecutorServiceWrapper() {
        }

        private void shutdown() {
            if (this.exec.isShutdown()) {
                return;
            }
            this.exec.shutdown();
            try {
                if (!this.exec.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.exec.shutdownNow();
                    if (!this.exec.awaitTermination(60L, TimeUnit.SECONDS)) assert (DebugUtils.warning((String)"MatlabEventQueue executor service did not terminate"));
                }
            }
            catch (InterruptedException interruptedException) {
                this.exec.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

