/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.ClassLoaderManager;
import com.mathworks.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CustomClassLoader
extends ClassLoader {
    private boolean fIsValid = true;
    private int fDebuggingID;
    private Hashtable fClassCache = new Hashtable(200);
    private String[] fClassPath = null;
    private boolean fIsLocked = false;
    private Vector fNativeLibraryPath = null;
    private final Hashtable fNativeLibraryCache = new Hashtable();

    public void setValid(boolean bl) {
        this.fIsValid = bl;
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    public boolean isLocked() {
        return this.fIsLocked;
    }

    public CustomClassLoader(ClassLoader classLoader, String[] stringArray, Vector vector, int n) {
        super(classLoader);
        this.fClassPath = stringArray;
        this.fNativeLibraryPath = vector;
        this.fDebuggingID = n;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        if (ClassLoaderManager.getCurrentVerboseLevel() >= 2) {
            System.out.println("Searching for class in file system: " + string);
        }
        Object var2_2 = null;
        if (this.fIsValid) {
            Class clazz = (Class)this.fClassCache.get(string);
            if (clazz != null) {
                return clazz;
            }
            return this.loadClassFromClassPath(string);
        }
        throw new ClassNotFoundException();
    }

    protected Class loadClassFromClassPath(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        String string2 = null;
        for (int i = 0; i < this.fClassPath.length; ++i) {
            byte[] byArray = null;
            string2 = this.fClassPath[i];
            File file = new File(string2);
            try {
                if (file.isDirectory()) {
                    byArray = CustomClassLoader.loadBytesFromDirectory(file, string);
                } else if (file.isFile()) {
                    byArray = CustomClassLoader.loadBytesFromZipfile(file, string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (byArray == null) continue;
            if (ClassLoaderManager.getCurrentVerboseLevel() >= 1) {
                System.out.println("Found " + string + " in: " + file.getAbsolutePath());
                System.out.println("Loaded " + string + " from: " + file.getAbsolutePath() + " [" + byArray.length + " bytes]");
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            this.fClassCache.put(string, clazz);
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] loadBytesFromDirectory(File file, String string) throws Exception {
        String string2 = string.replace('.', File.separatorChar) + ".class";
        File file2 = new File(file, string2);
        if (file2.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byte[] byArray = CustomClassLoader.loadBytesFromStream(fileInputStream);
                return byArray;
            }
            finally {
                fileInputStream.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] loadBytesFromZipfile(File file, String string) throws Exception {
        if (ClassLoaderManager.getCurrentVerboseLevel() >= 2) {
            System.out.println("Loading Bytes From Compressed archive: " + file + " " + string);
        }
        String string2 = string.replace('.', '/') + ".class";
        ZipFile zipFile = new ZipFile(file);
        try {
            ZipEntry zipEntry = zipFile.getEntry(string2);
            if (zipEntry != null) {
                byte[] byArray = CustomClassLoader.loadBytesFromStream(zipFile.getInputStream(zipEntry));
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            zipFile.close();
        }
    }

    protected static byte[] loadBytesFromStream(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            FileUtils.copyStream((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected String findLibrary(String string) {
        String string2 = null;
        String string3 = System.getProperty("file.separator");
        String string4 = null;
        File file = null;
        string2 = (String)this.fNativeLibraryCache.get(string = System.mapLibraryName(string));
        if (string2 != null) {
            return string2;
        }
        if (ClassLoaderManager.getCurrentVerboseLevel() >= 1) {
            System.out.println("FileSystem:findLibrary: " + string);
        }
        Enumeration enumeration = this.fNativeLibraryPath.elements();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            file = new File(string4 + string3 + string);
            if (!file.isFile()) continue;
            string2 = file.getAbsolutePath();
            if (ClassLoaderManager.getCurrentVerboseLevel() >= 1) {
                System.out.println("Loaded native library: " + string + " from " + string2);
            }
            this.fIsLocked = true;
            this.fNativeLibraryCache.put(string, string2);
            break;
        }
        return string2;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        if (ClassLoaderManager.getCurrentVerboseLevel() >= 2) {
            System.out.println("getResourceAsStream: " + string);
        }
        InputStream inputStream = null;
        String string2 = null;
        inputStream = CustomClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null) {
            for (int i = 0; i < this.fClassPath.length; ++i) {
                string2 = this.fClassPath[i];
                File file = new File(string2);
                inputStream = file.isDirectory() ? CustomClassLoader.loadResourceFromDirectory(file, string) : CustomClassLoader.loadResourceFromZipfile(file, string);
                if (inputStream == null) continue;
                return inputStream;
            }
        }
        return inputStream;
    }

    private static InputStream loadResourceFromDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                return new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    private static InputStream loadResourceFromZipfile(File file, String string) {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                return zipFile.getInputStream(zipEntry);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected URL findResource(String string) {
        if (ClassLoaderManager.getCurrentVerboseLevel() >= 2) {
            System.out.println("findResource: " + string);
        }
        URL uRL = null;
        for (int i = 0; i < this.fClassPath.length; ++i) {
            String string2 = this.fClassPath[i];
            File file = new File(string2);
            uRL = file.isDirectory() ? CustomClassLoader.createURLFromDirectory(file, string) : CustomClassLoader.createURLFromZipFile(file, string);
            if (uRL == null) continue;
            return uRL;
        }
        uRL = CustomClassLoader.getSystemResource(string);
        return uRL;
    }

    private static URL createURLFromDirectory(File file, String string) {
        URL uRL = null;
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            String string3 = "file:" + file2.getAbsolutePath();
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println(malformedURLException);
            }
        }
        return uRL;
    }

    private static URL createURLFromZipFile(File file, String string) {
        Object object;
        ZipEntry zipEntry = null;
        URL uRL = null;
        try {
            object = new ZipFile(file.getAbsolutePath());
            zipEntry = ((ZipFile)object).getEntry(string);
            ((ZipFile)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (zipEntry != null) {
            object = "jar:file:" + file.getAbsolutePath() + "!/" + string;
            try {
                uRL = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println(malformedURLException);
            }
        }
        return uRL;
    }

    protected void finalize() throws Throwable {
        if (ClassLoaderManager.getCurrentVerboseLevel() >= 2) {
            System.out.println("Garbage collected ClassLoader. ID: " + this.fDebuggingID);
        }
    }

    public String getLoadedNativeLibrariesString() {
        if (this.fNativeLibraryCache.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration enumeration = this.fNativeLibraryCache.elements();
        while (enumeration.hasMoreElements()) {
            stringBuilder.append("*" + (String)enumeration.nextElement() + "\n");
        }
        return stringBuilder.toString();
    }
}

