/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo.log;

import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.FileModes;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogManager;
import com.sun.jini.mahalo.log.LogRecovery;
import com.sun.jini.mahalo.log.MultiLogManagerAdmin;
import com.sun.jini.mahalo.log.SimpleLogFile;
import com.sun.jini.mahalo.log.TransientLogFile;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;

public class MultiLogManager
implements LogManager,
FileModes,
Administrable,
MultiLogManagerAdmin {
    private static final String LOG_FILE = "Log.";
    private static final Logger persistenceLogger = Logger.getLogger("com.sun.jini.mahalo.persistence");
    private static final Logger operationsLogger = Logger.getLogger("com.sun.jini.mahalo.operations");
    private static final Logger initLogger = Logger.getLogger("com.sun.jini.mahalo.init");
    private final LogRecovery client;
    private final Map logByID;
    private final Object logByIDLock;
    private boolean destroyed;
    private String directory;
    private static final FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering((class$java$io$FilenameFilter == null ? (class$java$io$FilenameFilter = MultiLogManager.class$("java.io.FilenameFilter")) : class$java$io$FilenameFilter).getName(), "accept", new Object[]{file, string});
            }
            boolean bl = string.startsWith(MultiLogManager.LOG_FILE);
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting((class$java$io$FilenameFilter == null ? (class$java$io$FilenameFilter = MultiLogManager.class$("java.io.FilenameFilter")) : class$java$io$FilenameFilter).getName(), "accept", new Boolean(bl));
            }
            return bl;
        }
    };
    final LogRemovalManager logMgrRef;
    static /* synthetic */ Class class$java$io$FilenameFilter;

    public MultiLogManager() {
        this.logByID = new HashMap();
        this.logByIDLock = new Object();
        this.destroyed = false;
        this.directory = null;
        this.logMgrRef = new LogRemovalManager(){

            public void release(long l) {
                MultiLogManager.this.release(l);
            }
        };
        this.directory = null;
        this.client = null;
    }

    public MultiLogManager(LogRecovery logRecovery, String string) {
        block7: {
            this.logByID = new HashMap();
            this.logByIDLock = new Object();
            this.destroyed = false;
            this.directory = null;
            this.logMgrRef = new /* invalid duplicate definition of identical inner class */;
            if (string == null) {
                throw new IllegalArgumentException("MultiLogManager: must use non-null path");
            }
            if (logRecovery == null) {
                throw new IllegalArgumentException("MultiLogManager: must use non-null recovery client");
            }
            this.client = logRecovery;
            this.directory = string;
            if (!this.directory.endsWith(File.separator)) {
                this.directory = this.directory.concat(File.separator);
            }
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "directory = {0}", this.directory);
            }
            File file = new File(this.directory);
            try {
                if (!file.exists() && !file.mkdirs() && persistenceLogger.isLoggable(Level.SEVERE)) {
                    persistenceLogger.log(Level.SEVERE, "Could not create {0}", file);
                }
            }
            catch (SecurityException securityException) {
                if (!persistenceLogger.isLoggable(Level.SEVERE)) break block7;
                persistenceLogger.log(Level.SEVERE, "Error accessing Version File", securityException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientLog logFor(long l) throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(MultiLogManager.class.getName(), "logFor", new Long(l));
        }
        ClientLog clientLog = null;
        Long l2 = new Long(l);
        ClientLog clientLog2 = null;
        Object object = this.logByIDLock;
        synchronized (object) {
            if (this.destroyed) {
                throw new LogException("Manger has been destroyed");
            }
            clientLog = (ClientLog)this.logByID.get(l2);
            if (clientLog == null) {
                ClientLog clientLog3 = clientLog = this.directory == null ? new TransientLogFile(l) : new SimpleLogFile(this.directory + LOG_FILE + l, l, this.logMgrRef);
                if (persistenceLogger.isLoggable(Level.FINEST)) {
                    persistenceLogger.log(Level.FINEST, "Created ClientLog: {0}", this.directory + LOG_FILE + l);
                }
                clientLog2 = this.logByID.put(l2, clientLog);
            }
        }
        if (clientLog2 != null) {
            throw new LogException("Previous mapping for cookie(" + l + ") -- internal table corrupt?");
        }
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "Using ClientLog {0} for cookie {1}", new Object[]{clientLog, new Long(l)});
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "logFor", clientLog);
        }
        return clientLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(long l) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(MultiLogManager.class.getName(), "release", new Long(l));
        }
        Object var3_2 = null;
        Object object = this.logByIDLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            var3_2 = this.logByID.remove(new Long(l));
        }
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "Released ClientLog for cookie {0}", new Long(l));
            if (var3_2 == null) {
                persistenceLogger.log(Level.FINEST, "Note: ClientLog already removed");
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "release");
        }
    }

    public void recover() throws LogException {
        block10: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(MultiLogManager.class.getName(), "recover");
            }
            if (this.directory == null) {
                return;
            }
            SimpleLogFile simpleLogFile = null;
            File file = null;
            String[] stringArray = null;
            try {
                file = new File(this.directory);
                stringArray = file.list(filter);
                if (stringArray.length == 0) {
                    return;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = this.directory + stringArray[i];
                    simpleLogFile = new SimpleLogFile(string, this.logMgrRef);
                    if (persistenceLogger.isLoggable(Level.FINEST)) {
                        persistenceLogger.log(Level.FINEST, "Recovering log: {0}", string);
                    }
                    try {
                        simpleLogFile.recover(this.client);
                        this.logByID.put(new Long(simpleLogFile.cookie()), simpleLogFile);
                        continue;
                    }
                    catch (LogException logException) {
                        if (!persistenceLogger.isLoggable(Level.WARNING)) continue;
                        persistenceLogger.log(Level.WARNING, "Unable to recover log state", logException);
                    }
                }
            }
            catch (SecurityException securityException) {
                if (!persistenceLogger.isLoggable(Level.WARNING)) break block10;
                persistenceLogger.log(Level.WARNING, "Unable to recover log state", securityException);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "recover");
        }
    }

    public Object getAdmin() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(MultiLogManager.class.getName(), "getAdmin");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "getAdmin", this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(MultiLogManager.class.getName(), "destroy");
        }
        if (this.directory == null) {
            this.logByID.clear();
            this.destroyed = true;
            return;
        }
        Object object = this.logByIDLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            if (this.logByID.size() > 0) {
                Object[] objectArray = this.logByID.values().toArray();
                SimpleLogFile simpleLogFile = null;
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        simpleLogFile = (SimpleLogFile)objectArray[i];
                        if (simpleLogFile != null) {
                            simpleLogFile.invalidate();
                            continue;
                        }
                        if (!persistenceLogger.isLoggable(Level.FINEST)) continue;
                        persistenceLogger.log(Level.FINEST, "Observed a null log file entry for: {0}", simpleLogFile);
                        continue;
                    }
                    catch (LogException logException) {
                        if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                        persistenceLogger.log(Levels.HANDLED, "Unable to recover log state", logException);
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                        persistenceLogger.log(Levels.HANDLED, "Problem enumerating internal log state", noSuchElementException);
                    }
                }
                this.logByID.clear();
                this.destroyed = true;
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "destroy");
        }
    }

    public static interface LogRemovalManager {
        public void release(long var1);
    }
}

