/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.ParticipantTask;
import com.sun.jini.mahalo.PrepareAndCommitRecord;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;

public class PrepareAndCommitJob
extends Job
implements TransactionConstants {
    ServerTransaction tr;
    ClientLog log;
    ParticipantHandle handle;
    int maxtries = 5;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger persistenceLogger = TxnManagerImpl.persistenceLogger;

    public PrepareAndCommitJob(Transaction transaction, TaskManager taskManager, WakeupManager wakeupManager, ClientLog clientLog, ParticipantHandle participantHandle) {
        super(taskManager, wakeupManager);
        if (clientLog == null) {
            throw new IllegalArgumentException("PrepareAndCommitJob: PrepareAndCommitJob: log is null");
        }
        this.log = clientLog;
        if (!(transaction instanceof ServerTransaction)) {
            throw new IllegalArgumentException("PrepareAndCommitJob: PrepareAndCommitJob: must be a ServerTransaction");
        }
        this.tr = (ServerTransaction)transaction;
        if (participantHandle == null) {
            throw new IllegalArgumentException("PrepareAndCommitJob: PrepareJob: must have participants");
        }
        this.handle = participantHandle;
    }

    Object doWork(TaskManager.Task task, Object object) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(PrepareAndCommitJob.class.getName(), "doWork", new Object[]{task, object});
        }
        ParticipantHandle participantHandle = (ParticipantHandle)object;
        TransactionParticipant transactionParticipant = null;
        int n = participantHandle.getPrepState();
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", new Integer(n));
                }
                return new Integer(n);
            }
        }
        if (transactionParticipant == null) {
            transactionParticipant = participantHandle.getPreParedParticipant();
        }
        try {
            if (this.attempt(task) > this.maxtries) {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", new Integer(6));
                }
                return new Integer(6);
            }
        }
        catch (JobException jobException) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", null);
            }
            return null;
        }
        if (transactionParticipant == null) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", null);
            }
            return null;
        }
        Integer n2 = null;
        try {
            n = transactionParticipant.prepareAndCommit(this.tr.mgr, this.tr.id);
            n2 = new Integer(n);
        }
        catch (TransactionException transactionException) {
            n = 6;
            n2 = new Integer(n);
        }
        catch (RemoteException remoteException) {
        }
        catch (RuntimeException runtimeException) {
            n = 6;
            n2 = new Integer(n);
        }
        if (n2 != null) {
            block22: {
                participantHandle.setPrepState(n);
                try {
                    this.log.write(new PrepareAndCommitRecord(participantHandle, n));
                }
                catch (LogException logException) {
                    if (!persistenceLogger.isLoggable(Level.WARNING)) break block22;
                    persistenceLogger.log(Level.WARNING, "Problem writing PrepareAndCommitRecord.", logException);
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", n2);
            }
            return n2;
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", null);
        }
        return null;
    }

    TaskManager.Task[] createTasks() {
        TaskManager.Task[] taskArray = new TaskManager.Task[]{new ParticipantTask(this.getPool(), this.getMgr(), this, this.handle)};
        return taskArray;
    }

    Object computeResult() throws JobException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(PrepareAndCommitJob.class.getName(), "computeResult");
        }
        try {
            if (!this.isCompleted(0L)) {
                throw new ResultNotReadyException("Cannot compute result since there are jobs pending");
            }
        }
        catch (JobNotStartedException jobNotStartedException) {
            throw new ResultNotReadyException("Cannot compute result since jobs were not created");
        }
        int n = 4;
        n = (Integer)this.results[0];
        Integer n2 = new Integer(n);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "computeResult", n2);
        }
        return n2;
    }
}

