/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import com.mathworks.mwt.ObjBuffer;
import com.mathworks.mwt.text.UndoableTextEdit;
import com.mathworks.mwt.undo.CannotRedoException;
import com.mathworks.mwt.undo.CannotUndoException;
import com.mathworks.mwt.undo.UndoableEdit;

class UndoableCompoundEdit
implements UndoableEdit {
    private ObjBuffer fEdits;
    private String fCommandID;

    public UndoableCompoundEdit() {
        this("");
    }

    public UndoableCompoundEdit(String string) {
        this.fCommandID = string;
        this.fEdits = new ObjBuffer();
    }

    public boolean isEmpty() {
        return this.fEdits.length() == 0;
    }

    public String getCommandID() {
        return this.fCommandID;
    }

    @Override
    public String getName() {
        return this.fCommandID;
    }

    public UndoableEdit getEditAt(int n) {
        if (n < 0 || n > this.fEdits.length() - 1) {
            throw new IllegalArgumentException();
        }
        return (UndoableEdit)this.fEdits.getAt(n);
    }

    public int numEdits() {
        return this.fEdits.length();
    }

    public UndoableEdit getFirstEdit() {
        if (this.fEdits.length() == 0) {
            return null;
        }
        return this.getEditAt(0);
    }

    public UndoableEdit getLastEdit() {
        if (this.fEdits.length() == 0) {
            return null;
        }
        return this.getEditAt(this.fEdits.length() - 1);
    }

    public boolean merge(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof UndoableCompoundEdit) {
            UndoableCompoundEdit undoableCompoundEdit = (UndoableCompoundEdit)undoableEdit;
            this.fEdits.ensureCapacity(this.fEdits.length() + undoableCompoundEdit.numEdits());
            for (int i = 0; i < undoableCompoundEdit.numEdits(); ++i) {
                this.merge(undoableCompoundEdit.getEditAt(i));
            }
        } else {
            UndoableEdit undoableEdit2 = this.getLastEdit();
            if (undoableEdit2 == null || !(undoableEdit2 instanceof UndoableTextEdit) || !((UndoableTextEdit)undoableEdit2).merge(undoableEdit)) {
                this.fEdits.append(undoableEdit);
            }
        }
        return true;
    }

    @Override
    public void undo() throws CannotUndoException {
        for (int i = this.fEdits.length() - 1; i >= 0; --i) {
            this.getEditAt(i).undo();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        int n = this.fEdits.length();
        for (int i = 0; i < n; ++i) {
            this.getEditAt(i).redo();
        }
    }

    public String toString() {
        String string = "[CompoundEdit " + this.fCommandID + "\n";
        int n = this.fEdits.length();
        for (int i = 0; i < n; ++i) {
            string = string + "      " + this.getEditAt(i).toString() + "\n";
        }
        string = string + "  ]";
        return string;
    }
}

