/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Locale;

public class MWLabel
extends MWCanvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 0;
    public static final int BOTTOM = 2;
    public static final int TEXT_FIELD_CENTER = 3;
    private String fText;
    private int fAlignment;
    private int fVerticalAlignment = 1;
    private int fTextX;
    private int fTextY;

    public MWLabel(String string, int n) {
        this.setText(string);
        this.setAlignment(n);
    }

    public MWLabel(String string) {
        this(string, 0);
    }

    public MWLabel() {
        this("", 0);
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        this.fText = string;
        this.repaint();
    }

    public int getAlignment() {
        return this.fAlignment;
    }

    public void setAlignment(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.fAlignment = n;
                break;
            }
            default: {
                this.fAlignment = 0;
            }
        }
        this.repaint();
    }

    public int getVerticalAlignment() {
        return this.fVerticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.fVerticalAlignment = n;
                break;
            }
            default: {
                this.fVerticalAlignment = 1;
            }
        }
        this.repaint();
    }

    private void drawLabel(Graphics graphics, boolean bl) {
        Dimension dimension = this.getSize();
        String string = this.fText;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = this.getLineCount();
        if (PlatformInfo.isMacintosh() && fontMetrics.getLeading() > fontMetrics.getMaxAscent() >> 1 && n5 <= 1 && (Locale.getDefault().equals(Locale.JAPAN) || Locale.getDefault().equals(Locale.JAPANESE)) && this.fVerticalAlignment != 3 && (n -= fontMetrics.getLeading() - (fontMetrics.getMaxAscent() >> 3)) > dimension.height) {
            n -= fontMetrics.getMaxAscent() >> 3;
        }
        switch (this.fVerticalAlignment) {
            case 0: {
                this.fTextY = 0;
                break;
            }
            case 2: {
                this.fTextY = dimension.height - n * n5;
                break;
            }
            default: {
                this.fTextY = (dimension.height - n * n5) / 2;
            }
        }
        this.fTextY += fontMetrics.getMaxAscent();
        if (this.fVerticalAlignment == 3) {
            this.fTextY += fontMetrics.getLeading();
        }
        int n6 = this.fTextY;
        while (n2 < n4) {
            for (n2 = n3; n2 < n4 && string.charAt(n2) != '\n' && string.charAt(n2) != '\r'; ++n2) {
            }
            int n7 = fontMetrics.stringWidth(string.substring(n3, n2));
            switch (this.fAlignment) {
                case 0: {
                    this.fTextX = 0;
                    break;
                }
                case 1: {
                    this.fTextX = (dimension.width - n7) / 2;
                    break;
                }
                case 2: {
                    this.fTextX = dimension.width - n7;
                }
            }
            String string2 = string.substring(n3, n2);
            if (bl) {
                Decorations.drawLabel(graphics, string2, this.fTextX, n6, false, false);
            } else {
                graphics.drawString(string2, this.fTextX, n6);
            }
            n3 = ++n2;
            n6 += n;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        if (this.fText != null) {
            if (this.isEnabled()) {
                graphics.setFont(this.getFont());
                graphics.setColor(this.getForeground());
                this.drawLabel(graphics, false);
            } else {
                graphics.setFont(this.getFont());
                this.drawLabel(graphics, true);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics;
        Dimension dimension = new Dimension(70, 20);
        Font font = this.getFont();
        if (font != null && this.fText != null && (fontMetrics = this.getFontMetrics(font)) != null) {
            dimension.width = this.maxStringWidth(fontMetrics);
            dimension.height = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
            dimension.height *= this.getLineCount();
        }
        return dimension;
    }

    private int maxStringWidth(FontMetrics fontMetrics) {
        String string = this.fText;
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n < n3) {
            for (n = n2; n < n3 && string.charAt(n) != '\n' && string.charAt(n) != '\r'; ++n) {
            }
            int n5 = fontMetrics.stringWidth(string.substring(n2, n));
            if (n4 < n5) {
                n4 = n5;
            }
            n2 = ++n;
        }
        return n4;
    }

    private int getLineCount() {
        String string = this.fText;
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        if (n3 == 0) {
            return 0;
        }
        while (n3 > 0 && (string.charAt(n3 - 1) == '\n' || string.charAt(n3 - 1) == '\r')) {
            --n3;
        }
        if (n3 == 0) {
            n3 = string.length();
        }
        while (n < n3) {
            if (string.charAt(n) == '\n' || string.charAt(n) == '\r') {
                if (bl) {
                    ++n2;
                }
                bl = true;
            } else if (bl) {
                ++n2;
                bl = false;
            }
            ++n;
        }
        return n2;
    }
}

