/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mde.help.ClearSearchAction;
import com.mathworks.mde.help.DemoUtils;
import com.mathworks.mde.help.HelpBrowser;
import com.mathworks.mde.help.HelpNavigatorAction;
import com.mathworks.mde.help.search.HelpBrowserSearchResult;
import com.mathworks.mde.help.search.HelpPageDisplayHandler;
import com.mathworks.mde.help.search.HighlightProvider;
import com.mathworks.mde.help.search.MultiSearchEngine;
import com.mathworks.mde.help.search.SearchPanelAction;
import com.mathworks.mde.help.search.SearchPanelActionFactory;
import com.mathworks.mde.help.search.SearchPanelHeader;
import com.mathworks.mde.help.search.SearchPanelHeaderColumn;
import com.mathworks.mde.help.search.SearchResultsContainer;
import com.mathworks.mde.help.search.SearchResultsDisplay;
import com.mathworks.mde.help.search.SearchResultsListDisplay;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.DemoInfoItem;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.RankedSearchResult;
import com.mathworks.mlwidgets.help.search.SearchCompletionObserver;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mlwidgets.help.search.SearchEngine;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchResults;
import com.mathworks.mlwidgets.html.CharsetDetectionStrategy;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.PopupListener;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class SearchResultsPanel {
    private MJPanel fPanel;
    private MJScrollPane fScrollPane;
    private SearchResultsDisplay fResultsDisplay;
    private HelpPageDisplayHandler fDisplayHandler;
    private SearchEngine<RankedSearchResult> fEngine;
    private SearchCriteria fCriteria;
    private SearchResultsContainer fResults;
    private SearchPanelHeaderColumn fSortedColumn = SearchPanelHeaderColumn.RELEVANCE;
    private boolean fSortReversed = false;

    public SearchResultsPanel() {
        this(new MultiSearchEngine(), new DefaultTopicDisplayHandler());
    }

    public SearchResultsPanel(SearchEngine<RankedSearchResult> searchEngine, HelpPageDisplayHandler helpPageDisplayHandler) {
        this.fPanel = new MJPanel();
        this.fPanel.setLayout((LayoutManager)new BorderLayout());
        this.fEngine = searchEngine;
        this.fDisplayHandler = helpPageDisplayHandler;
        this.setupInputMap();
        this.setupContextMenu();
        this.registerPanelActions();
        this.clear();
    }

    private void setupInputMap() {
        InputMap inputMap = this.fPanel.getInputMap(1);
        MInputMap mInputMap = new MInputMap();
        mInputMap.setParent(inputMap);
        this.fPanel.setInputMap(1, (InputMap)mInputMap);
    }

    private void setupContextMenu() {
        this.fPanel.addMouseListener((MouseListener)new PopupListener(){

            protected void showPopup(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = SearchResultsPanel.this.buildContextMenu();
                if (jPopupMenu != null) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public Component getComponent() {
        return this.fPanel;
    }

    public void search(SearchCriteria searchCriteria, String string) {
        this.search(searchCriteria, string, null);
    }

    public void search(final SearchCriteria searchCriteria, String string, final SearchCompletionObserver<RankedSearchResult> searchCompletionObserver) {
        this.clearCriteriaAndResults();
        this.showMessagePane(SearchResultsPanel.createSearchingForMessage(string));
        this.fEngine.search(searchCriteria, (SearchCompletionObserver)new SearchCompletionObserver<RankedSearchResult>(){

            public void searchComplete(SearchResults<RankedSearchResult> searchResults) {
                if (searchResults.getNumResults() == 0) {
                    SearchResultsPanel.this.showNoResultsFound();
                } else {
                    SearchResultsPanel.this.updateWithResults(searchCriteria, (SearchResults<RankedSearchResult>)searchResults);
                }
                if (searchCompletionObserver != null) {
                    searchCompletionObserver.searchComplete(searchResults);
                }
            }

            public void searchFailed(SearchException searchException) {
                if (searchCompletionObserver != null) {
                    searchCompletionObserver.searchFailed(searchException);
                }
            }
        });
    }

    private static String createSearchingForMessage(String string) {
        String string2 = "<b>" + string + "</b>";
        String string3 = HelpUtils.getLocalizedString((String)"search.search_in_progress");
        String string4 = MessageFormat.format(string3, string2);
        return "<html>" + string4 + "</html>";
    }

    public void displaySearchException(SearchException searchException) {
        this.showMessagePane(searchException.getMessage());
        this.fDisplayHandler.displayTopic(searchException.getMapPath(), searchException.getTopicKey());
    }

    private void showMessagePane(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doShowMessagePane(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchResultsPanel.this.doShowMessagePane(string);
                }
            });
        }
    }

    private void doShowMessagePane(String string) {
        assert (SwingUtilities.isEventDispatchThread());
        this.removeAllChildren();
        final HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string);
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("1px:grow", "p:grow")){

            public void setFont(Font font) {
                super.setFont(font);
                hyperlinkTextLabel.setFont(font);
            }

            public void setBackground(Color color) {
                super.setBackground(color);
                hyperlinkTextLabel.getComponent().setBackground(color);
            }

            public void setForeground(Color color) {
                super.setForeground(color);
                hyperlinkTextLabel.getComponent().setForeground(color);
            }
        };
        hyperlinkTextLabel.getComponent().setBackground(this.fPanel.getBackground());
        hyperlinkTextLabel.getComponent().setForeground(this.fPanel.getForeground());
        hyperlinkTextLabel.setFont(this.fPanel.getFont());
        hyperlinkTextLabel.getComponent().setName("HelpSearchMessageLabel");
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
        mJPanel.setOpaque(false);
        mJPanel.add((Component)hyperlinkTextLabel.getComponent(), (Object)cellConstraints.xy(1, 1, CellConstraints.LEFT, CellConstraints.FILL));
        this.fPanel.add((Component)mJPanel, (Object)"Center");
        this.fPanel.revalidate();
        this.fPanel.repaint();
    }

    private void showNoResultsFound() {
        this.showMessagePane(HelpUtils.getLocalizedString((String)"search.no_matches_found"));
        String string = MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env_csh");
        this.fDisplayHandler.displayTopic(string, "matlab_env_helpsearch_no_matches");
    }

    private void updateWithResults(SearchCriteria searchCriteria, SearchResults<RankedSearchResult> searchResults) {
        this.setCurrentResults(searchCriteria, searchResults);
        this.updateResultsDisplay();
    }

    private void setCurrentResults(SearchCriteria searchCriteria, SearchResults<RankedSearchResult> searchResults) {
        this.fCriteria = searchCriteria;
        HighlightProvider highlightProvider = new HighlightProvider(searchCriteria);
        this.fResults = new SearchResultsContainer(highlightProvider, searchResults, this.buildExceptionHandler());
        this.fSortedColumn = SearchPanelHeaderColumn.RELEVANCE;
        this.fSortReversed = false;
    }

    private void updateResultsDisplay() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SearchResultsPanel.this.fResults != null) {
                    SearchResultsPanel.this.removeAllChildren();
                    SearchPanelHeader searchPanelHeader = new SearchPanelHeader();
                    searchPanelHeader.sortByRelevance();
                    searchPanelHeader.addSortListener(new SearchPanelHeader.SortListener(){

                        @Override
                        public void sortChanged(SearchPanelHeaderColumn searchPanelHeaderColumn, boolean bl) {
                            SearchResultsPanel.this.sortResults(searchPanelHeaderColumn, bl);
                        }
                    });
                    SearchResultsPanel.this.fPanel.add((Component)searchPanelHeader.getComponent(), (Object)"North");
                    SearchResultsPanel.this.useResultsDisplay(new SearchResultsListDisplay(SearchResultsPanel.this.fCriteria, SearchResultsPanel.this.fResults, SearchResultsPanel.this.fDisplayHandler));
                    SearchResultsPanel.this.fResultsDisplay.selectResult(0);
                    SearchResultsPanel.this.fResultsDisplay.requestFocusInWindow();
                    SearchResultsPanel.this.fPanel.revalidate();
                    SearchResultsPanel.this.fPanel.repaint();
                } else {
                    SearchResultsPanel.this.clear();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private SearchResultsContainer.SearchResultExceptionHandler buildExceptionHandler() {
        return new SearchResultsContainer.SearchResultExceptionHandler(){

            @Override
            public void handleException() {
                SearchResultsPanel.this.showMessagePane(HelpUtils.getLocalizedString((String)"search.general_error"));
            }
        };
    }

    private MInputMap getMInputMap() {
        return (MInputMap)this.fPanel.getInputMap(1);
    }

    private void registerPanelActions() {
        SearchPanelAction.setResultsPanel(this);
        for (SearchPanelAction searchPanelAction : SearchPanelAction.values()) {
            String string = searchPanelAction.getKeybindingId();
            if (string == null) continue;
            ExtendedAction extendedAction = searchPanelAction.getAction();
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("HelpBrowser", string, extendedAction);
            MatlabKeyBindings.getManager().addKeyBindings("HelpBrowser", string, (ExtendedInputMap)this.getMInputMap());
            MatlabKeyBindings.getManager().addToActionMap(extendedAction, this.fPanel.getActionMap());
        }
        if (ClearSearchAction.isInitialized()) {
            ClearSearchAction clearSearchAction = ClearSearchAction.getInstance();
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("HelpBrowser", "clear-search", (ExtendedAction)clearSearchAction);
            MatlabKeyBindings.getManager().addKeyBindings("HelpBrowser", "clear-search", (ExtendedInputMap)this.getMInputMap());
            MatlabKeyBindings.getManager().addToActionMap((ExtendedAction)clearSearchAction, this.fPanel.getActionMap());
        }
    }

    private JPopupMenu buildContextMenu() {
        if (this.fResultsDisplay == null) {
            return null;
        }
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        if (HelpNavigatorAction.COLLAPSE_ALL.isSupported()) {
            mJPopupMenu.add((Action)HelpNavigatorAction.COLLAPSE_ALL.getAction());
        }
        if (HelpNavigatorAction.EXPAND_ALL.isSupported()) {
            mJPopupMenu.add((Action)HelpNavigatorAction.EXPAND_ALL.getAction());
        }
        for (SearchPanelAction searchPanelAction : SearchPanelAction.values()) {
            if (!searchPanelAction.isSupported()) continue;
            mJPopupMenu.add((Action)searchPanelAction.getAction());
        }
        if (mJPopupMenu.getComponents().length > 0) {
            mJPopupMenu.addSeparator();
        }
        mJPopupMenu.add((Action)((Object)ClearSearchAction.getInstance()));
        return mJPopupMenu;
    }

    public void sortResults(SearchPanelHeaderColumn searchPanelHeaderColumn, boolean bl) {
        HelpBrowserSearchResult helpBrowserSearchResult = this.fResultsDisplay.getSelectedResult();
        if (searchPanelHeaderColumn == this.fSortedColumn) {
            if (bl != this.fSortReversed) {
                this.fResults.reverseSort();
                this.fResultsDisplay.afterReversal();
                for (MouseListener mouseListener : this.fPanel.getMouseListeners()) {
                    this.fResultsDisplay.addMouseListener(mouseListener);
                }
            }
        } else {
            this.fResults.sort(searchPanelHeaderColumn.getComparator(), bl);
            this.useResultsDisplay(searchPanelHeaderColumn.getDisplayForColumn(this.fCriteria, this.fResults, this.fDisplayHandler));
            this.fPanel.revalidate();
            this.fPanel.repaint();
        }
        int n = this.fResults.getIndexOf(helpBrowserSearchResult);
        this.fResultsDisplay.selectResult(n);
        this.fResultsDisplay.scrollToSelectedResult();
        this.fResultsDisplay.requestFocusInWindow();
        this.fSortedColumn = searchPanelHeaderColumn;
        this.fSortReversed = bl;
    }

    private void useResultsDisplay(SearchResultsDisplay searchResultsDisplay) {
        boolean bl = this.fPanel.isFocusCycleRoot();
        if (this.fScrollPane != null) {
            this.fPanel.setFocusCycleRoot(true);
            this.fPanel.remove((Component)this.fScrollPane);
        }
        searchResultsDisplay.setFont(this.fPanel.getFont());
        searchResultsDisplay.setForeground(this.fPanel.getForeground());
        searchResultsDisplay.setBackground(this.fPanel.getBackground());
        this.fScrollPane = new MJScrollPane((Component)searchResultsDisplay.getComponent());
        this.fScrollPane.setBorder(null);
        this.fScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        for (MouseListener mouseListener : this.fPanel.getMouseListeners()) {
            searchResultsDisplay.addMouseListener(mouseListener);
        }
        this.fPanel.add((Component)this.fScrollPane, (Object)"Center");
        this.fPanel.setFocusCycleRoot(bl);
        SearchResultsPanel.updateHelpNavigatorGlobalActions(searchResultsDisplay);
        this.fResultsDisplay = searchResultsDisplay;
        this.fResultsDisplay.getComponent().requestFocusInWindow();
    }

    public void clear() {
        this.clearCriteriaAndResults();
        this.removeAllChildren();
        this.showMessagePane(HelpUtils.getLocalizedString((String)"search.no_search_yet"));
        this.fPanel.revalidate();
        this.fPanel.repaint();
    }

    private void clearCriteriaAndResults() {
        this.fCriteria = null;
        if (this.fResults != null) {
            this.fResults.cleanUp();
            this.fResults = null;
        }
    }

    private void removeAllChildren() {
        this.fPanel.removeAll();
        this.fScrollPane = null;
        this.fResultsDisplay = null;
    }

    public void setForeground(Color color) {
        this.fPanel.setForeground(color);
        if (this.fResultsDisplay != null) {
            this.fResultsDisplay.setForeground(color);
        } else {
            for (Component component : this.fPanel.getComponents()) {
                component.setForeground(color);
            }
        }
    }

    public void setBackground(Color color) {
        this.fPanel.setBackground(color);
        if (this.fResultsDisplay != null) {
            this.fResultsDisplay.setBackground(color);
        } else {
            for (Component component : this.fPanel.getComponents()) {
                component.setBackground(color);
            }
        }
    }

    public void setFont(Font font) {
        this.fPanel.setFont(font);
        if (this.fResultsDisplay != null) {
            this.fResultsDisplay.setFont(font);
        } else {
            for (Component component : this.fPanel.getComponents()) {
                component.setFont(font);
            }
        }
    }

    public SearchResultsDisplay getResultsDisplay() {
        return this.fResultsDisplay;
    }

    public void updateHelpNavigatorGlobalActions() {
        SearchResultsPanel.updateHelpNavigatorGlobalActions(this.fResultsDisplay);
    }

    private static void updateHelpNavigatorGlobalActions(SearchResultsDisplay searchResultsDisplay) {
        if (searchResultsDisplay == null) {
            HelpNavigatorAction.COLLAPSE_ALL.updateUnderlyingAction(null);
            HelpNavigatorAction.EXPAND_ALL.updateUnderlyingAction(null);
        } else {
            SearchPanelActionFactory searchPanelActionFactory = searchResultsDisplay.getActionFactory();
            HelpNavigatorAction.COLLAPSE_ALL.updateUnderlyingAction(searchPanelActionFactory.getCollapseAllAction());
            HelpNavigatorAction.EXPAND_ALL.updateUnderlyingAction(searchPanelActionFactory.getExpandAllAction());
        }
    }

    private static class DefaultTopicDisplayHandler
    implements HelpPageDisplayHandler {
        private DefaultTopicDisplayHandler() {
        }

        @Override
        public void displayTopic(String string, String string2) {
            HelpBrowser.displayTopic(string, string2, false);
        }

        @Override
        public void displayDemo(DemoInfoItem demoInfoItem, String[] stringArray) {
            DemoUtils.displayDemoAndHighlightKeywords(demoInfoItem, null, stringArray);
            HelpBrowser.getInstance().getHelpSynchronizer().syncToDemo(DemoInfoUtils.getIdentifier((DemoInfoItem)demoInfoItem));
        }

        @Override
        public void setCurrentLocationAndHighlightKeywords(String string, String string2, String[] stringArray) {
            CharsetDetectionStrategy charsetDetectionStrategy;
            if (string2 == null || string2.trim().length() == 0) {
                charsetDetectionStrategy = CharsetDetectionStrategy.getAutoDetectStrategy();
            } else {
                try {
                    charsetDetectionStrategy = CharsetDetectionStrategy.getCharsetStrategy((String)string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    charsetDetectionStrategy = CharsetDetectionStrategy.getAutoDetectStrategy();
                }
            }
            HelpBrowser.setCurrentLocationAndHighlightKeywords(string, charsetDetectionStrategy, stringArray, false);
        }
    }
}

