/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.mde.help.HelpBrowserPrefs;
import com.mathworks.mde.help.HelpBrowserStateManager;
import com.mathworks.mde.help.SearchHistoryListener;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;

public class SearchHistoryEventDispatcher {
    private static SearchHistoryEventDispatcher sSearchHistoryEventDispatcher = new SearchHistoryEventDispatcher();
    private Set<SearchHistoryListener> fSearchHistoryListeners = Collections.synchronizedSet(new HashSet());
    private Boolean fIsSearchHistoryEmpty = null;

    private SearchHistoryEventDispatcher() {
        HelpPrefs.addPrefsListeners((PrefListener)new SearchHistoryPrefsListener(), (String[])new String[]{"HelpSearchHistoryMaximumSize"});
    }

    public static SearchHistoryEventDispatcher getInstance() {
        return sSearchHistoryEventDispatcher;
    }

    void addSearchHistoryListener(SearchHistoryListener searchHistoryListener) {
        Validate.notNull((Object)searchHistoryListener, (String)"Search History Listeners may not be null.");
        this.fSearchHistoryListeners.add(searchHistoryListener);
    }

    public void removeSearchHistoryListener(SearchHistoryListener searchHistoryListener) {
        this.fSearchHistoryListeners.remove(searchHistoryListener);
    }

    void searchHistoryCleared() {
        this.dispatchSearchHistoryEvent(SearchHistoryEvent.SEARCH_HISTORY_CLEARED);
    }

    void searchHistoryAdded() {
        this.dispatchSearchHistoryEvent(SearchHistoryEvent.SEARCH_HISTORY_ADDED);
    }

    void searchHistorySizeChanged() {
        this.dispatchSearchHistoryEvent(SearchHistoryEvent.SEARCH_HISTORY_SIZE_CHANGED);
    }

    boolean isHistoryEmpty() {
        return this.fIsSearchHistoryEmpty != null ? this.fIsSearchHistoryEmpty.booleanValue() : HelpBrowserStateManager.getInstance().isSearchHistoryEmpty();
    }

    private void dispatchSearchHistoryEvent(final SearchHistoryEvent searchHistoryEvent) {
        switch (searchHistoryEvent) {
            case SEARCH_HISTORY_ADDED: {
                this.fIsSearchHistoryEmpty = false;
                break;
            }
            case SEARCH_HISTORY_CLEARED: {
                this.fIsSearchHistoryEmpty = true;
                break;
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = new ArrayList(SearchHistoryEventDispatcher.this.fSearchHistoryListeners);
                for (SearchHistoryListener searchHistoryListener : arrayList) {
                    searchHistoryListener.searchHistoryChanged(searchHistoryEvent);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private class SearchHistoryPrefsListener
    implements PrefListener {
        private SearchHistoryPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (HelpBrowserPrefs.getSearchHistoryMaximumSize() < 0) {
                HelpBrowserPrefs.setSearchHistoryMaximumSize(0);
            } else if (HelpBrowserPrefs.getSearchHistoryMaximumSize() > 10000) {
                HelpBrowserPrefs.setSearchHistoryMaximumSize(10000);
            } else {
                SearchHistoryEventDispatcher.this.searchHistorySizeChanged();
                if (HelpBrowserPrefs.getSearchHistoryMaximumSize() == 0) {
                    SearchHistoryEventDispatcher.this.searchHistoryCleared();
                }
            }
        }
    }

    public static enum SearchHistoryEvent {
        SEARCH_HISTORY_ADDED,
        SEARCH_HISTORY_CLEARED,
        SEARCH_HISTORY_SIZE_CHANGED;

    }
}

