/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.mde.help.SearchHistoryEventDispatcher;
import com.mathworks.mde.help.SearchHistoryListener;
import com.mathworks.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HelpBrowserStateManager {
    private static final String STATE_FILE_NAME = "MATLAB_Help_Browser_State.xml";
    private static final String ENCODING_STYLE = "UTF-8";
    private static final String HELP_BROWSER_ELEMENT = "HelpBrowser";
    private static final String HELP_BROWSER_VERSION_ATTRIBUTE = "version";
    private static final String HELP_BROWSER_VERSION = "1.0";
    private static final String SEARCH_HISTORY_ELEMENT = "SearchHistory";
    private static final String SEARCH_STRING_ELEMENT = "SearchString";
    private static HelpBrowserStateManager sStateManager = new HelpBrowserStateManager();
    private static StateMgrSearchHistoryListener sSearchHistoryListener;
    private static HelpDependencyProvider sDependencyProvider;
    private static PersistenceStrategy sPersistenceStrategy;
    private static String sAbsStateFilePath;
    private static boolean sLoggingEnabled;

    private HelpBrowserStateManager() {
        sSearchHistoryListener = new StateMgrSearchHistoryListener();
        this.setPersistenceStrategy(new DefaultPersistenceStrategy());
        this.setDependencyProviderAndInitialize(new DefaultDependencyProvider());
    }

    public static HelpBrowserStateManager getInstance() {
        return sStateManager;
    }

    private static Document readPersistedState() {
        DocumentBuilder documentBuilder = HelpBrowserStateManager.createDocumentBuilder();
        if (documentBuilder == null) {
            if (HelpBrowserStateManager.isLoggingEnabled()) {
                System.out.println("In HelpBrowserStateManager.readPersistedState(), DocumentBuilder is null, returning null");
            }
            return null;
        }
        Document document = HelpBrowserStateManager.getPersistenceStrategy().parseXMLFile(documentBuilder);
        if (document == null) {
            if (HelpBrowserStateManager.isLoggingEnabled()) {
                System.out.println("In HelpBrowserStateManager.readPersistedState(), XML file didn't exist or was corrupt, creating a blank document");
            }
            document = documentBuilder.newDocument();
            Element element = document.createElement(HELP_BROWSER_ELEMENT);
            element.setAttribute(HELP_BROWSER_VERSION_ATTRIBUTE, HELP_BROWSER_VERSION);
            document.appendChild(element);
        }
        return document;
    }

    private static DocumentBuilder createDocumentBuilder() {
        DocumentBuilder documentBuilder;
        block3: {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            assert (documentBuilderFactory != null) : "In HelpBrowserStateManager.createDocumentBuilder(), DocumentBuilderFactory.newInstance() returned null.";
            documentBuilder = null;
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (Throwable throwable) {
                if (!HelpBrowserStateManager.isLoggingEnabled()) break block3;
                System.out.println("In HelpBrowserStateManager.createDocumentBuilder(), Exception " + throwable.getMessage());
            }
        }
        return documentBuilder;
    }

    private static void setHelpBrowserStateAbsFileName(String string) {
        sAbsStateFilePath = string == null ? null : string + System.getProperty("file.separator") + STATE_FILE_NAME;
    }

    void clearSearchHistory() {
        this.saveHelpBrowserState(new ArrayList<String>());
    }

    synchronized List<String> getSearchHistory() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Document document = HelpBrowserStateManager.readPersistedState();
        if (document == null) {
            if (HelpBrowserStateManager.isLoggingEnabled()) {
                System.out.println("In HelpBrowserStateManager.getSearchHistory(), State document is null, returning an empty list");
            }
            return arrayList;
        }
        NodeList nodeList = document.getElementsByTagName(SEARCH_STRING_ELEMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getTextContent();
            arrayList.add(string);
        }
        return arrayList;
    }

    boolean isSearchHistoryEmpty() {
        return this.getSearchHistory().isEmpty();
    }

    void saveHelpBrowserState(List<String> list) {
        SaveHelpBrowserStateThread saveHelpBrowserStateThread = new SaveHelpBrowserStateThread(list);
        saveHelpBrowserStateThread.run();
    }

    private synchronized void saveHelpBrowserStateMethod(List<String> list) {
        if (list == null) {
            if (HelpBrowserStateManager.isLoggingEnabled()) {
                System.out.println("In HelpBrowserStateManager.saveHelpBrowserStateMethod(), Search history list to save is null, returning");
            }
            return;
        }
        Document document = HelpBrowserStateManager.createDocumentFromHistory(list);
        HelpBrowserStateManager.getPersistenceStrategy().persistToXML(document);
    }

    private static Document createDocumentFromHistory(List<String> list) {
        DocumentBuilder documentBuilder = HelpBrowserStateManager.createDocumentBuilder();
        if (documentBuilder == null) {
            if (HelpBrowserStateManager.isLoggingEnabled()) {
                System.out.println("In HelpBrowserStateManager.createDocumentFromHistory(), DocumentBuilder is null, returning null");
            }
            return null;
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement(HELP_BROWSER_ELEMENT);
        element.setAttribute(HELP_BROWSER_VERSION_ATTRIBUTE, HELP_BROWSER_VERSION);
        document.appendChild(element);
        Element element2 = document.createElement(SEARCH_HISTORY_ELEMENT);
        element.appendChild(element2);
        for (String string : list) {
            Element element3 = document.createElement(SEARCH_STRING_ELEMENT);
            Text text = document.createTextNode(string);
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        return document;
    }

    public synchronized void setLoggingEnabled(boolean bl) {
        sLoggingEnabled = bl;
    }

    private static synchronized boolean isLoggingEnabled() {
        return sLoggingEnabled;
    }

    void setDependencyProviderAndInitialize(HelpDependencyProvider helpDependencyProvider) {
        block4: {
            try {
                sDependencyProvider = helpDependencyProvider;
                HelpBrowserStateManager.setHelpBrowserStateAbsFileName(sDependencyProvider.getPreferencesDirectory());
                sDependencyProvider.removeSearchHistoryListener(sSearchHistoryListener);
                if (this.isSearchHistoryEmpty()) {
                    sDependencyProvider.searchHistoryCleared();
                } else {
                    sDependencyProvider.searchHistoryAdded();
                }
                sDependencyProvider.addSearchHistoryListener(sSearchHistoryListener);
            }
            catch (Throwable throwable) {
                if (!HelpBrowserStateManager.isLoggingEnabled()) break block4;
                System.out.println("In HelpBrowserStateManager.setDependencyProviderAndInitialize(), Exception " + throwable.getMessage());
            }
        }
    }

    private static HelpDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    private synchronized void setPersistenceStrategy(PersistenceStrategy persistenceStrategy) {
        sPersistenceStrategy = persistenceStrategy;
    }

    private static synchronized PersistenceStrategy getPersistenceStrategy() {
        return sPersistenceStrategy;
    }

    static {
        sLoggingEnabled = false;
    }

    public static class DefaultPersistenceStrategy
    implements PersistenceStrategy {
        private Transformer fXMLWriter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Document parseXMLFile(DocumentBuilder documentBuilder) {
            assert (documentBuilder != null) : "In HelpBrowserStateManager.DefaultPersistenceStrategy.parseXMLFile(), DocumentBuilder is null.";
            if (sAbsStateFilePath == null) {
                return null;
            }
            File file = new File(sAbsStateFilePath);
            if (!file.exists() || !file.canRead()) {
                return null;
            }
            FileInputStream fileInputStream = null;
            Document document = null;
            try {
                fileInputStream = new FileInputStream(file);
                document = documentBuilder.parse(fileInputStream);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                }
                catch (Exception exception) {}
            }
            return document;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void persistToXML(Document document) {
            FileOutputStream fileOutputStream = null;
            try {
                Object object;
                if (this.fXMLWriter == null) {
                    object = TransformerFactory.newInstance();
                    this.fXMLWriter = ((TransformerFactory)object).newTransformer();
                    this.fXMLWriter.setOutputProperty("method", "xml");
                    this.fXMLWriter.setOutputProperty("indent", "yes");
                    this.fXMLWriter.setOutputProperty("encoding", HelpBrowserStateManager.ENCODING_STYLE);
                }
                if (!((File)(object = new File(sAbsStateFilePath))).exists()) {
                    ((File)object).createNewFile();
                }
                fileOutputStream = new FileOutputStream((File)object);
                this.fXMLWriter.transform(new DOMSource(document), new StreamResult(fileOutputStream));
            }
            catch (Exception exception) {
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static interface PersistenceStrategy {
        public Document parseXMLFile(DocumentBuilder var1);

        public void persistToXML(Document var1);
    }

    public static class DefaultDependencyProvider
    implements HelpDependencyProvider {
        @Override
        public String getPreferencesDirectory() {
            return FileUtils.getPreferencesDirectory();
        }

        @Override
        public void searchHistoryCleared() {
            SearchHistoryEventDispatcher.getInstance().searchHistoryCleared();
        }

        @Override
        public void searchHistoryAdded() {
            SearchHistoryEventDispatcher.getInstance().searchHistoryAdded();
        }

        @Override
        public void addSearchHistoryListener(SearchHistoryListener searchHistoryListener) {
            SearchHistoryEventDispatcher.getInstance().addSearchHistoryListener(searchHistoryListener);
        }

        @Override
        public void removeSearchHistoryListener(SearchHistoryListener searchHistoryListener) {
        }
    }

    public static interface HelpDependencyProvider {
        public String getPreferencesDirectory();

        public void searchHistoryCleared();

        public void searchHistoryAdded();

        public void addSearchHistoryListener(SearchHistoryListener var1);

        public void removeSearchHistoryListener(SearchHistoryListener var1);
    }

    private static class StateMgrSearchHistoryListener
    implements SearchHistoryListener {
        private StateMgrSearchHistoryListener() {
        }

        @Override
        public void searchHistoryChanged(SearchHistoryEventDispatcher.SearchHistoryEvent searchHistoryEvent) {
            if (searchHistoryEvent == null) {
                return;
            }
            switch (searchHistoryEvent) {
                case SEARCH_HISTORY_ADDED: {
                    break;
                }
                case SEARCH_HISTORY_CLEARED: {
                    sStateManager.clearSearchHistory();
                    break;
                }
            }
        }
    }

    private class SaveHelpBrowserStateThread
    implements Runnable {
        private List<String> iSearchHistory;

        private SaveHelpBrowserStateThread(List<String> list) {
            this.iSearchHistory = list;
        }

        @Override
        public void run() {
            HelpBrowserStateManager.this.saveHelpBrowserStateMethod(this.iSearchHistory);
        }
    }
}

