/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.jmi.Matlab;
import com.mathworks.mde.help.DemoUtils;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeUtils;
import com.mathworks.util.StringUtils;
import com.mathworks.xml.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DemoPageBuilder {
    private static final String TRANSFORM_NS = "http://www.w3.org/1999/XSL/Transform";
    private static DocumentBuilder sDocumentBuilder = null;
    private static String sMatlabRoot = Matlab.matlabRoot();

    private DemoPageBuilder() {
    }

    public static String createIndexFromXml(DemoTreeItem demoTreeItem) {
        DocumentBuilder documentBuilder = DemoPageBuilder.getDocumentBuilder();
        String string = demoTreeItem.getXmlFilename();
        try {
            Document document = DemoPageBuilder.getDemosXmlDoc(string, documentBuilder);
            DemoPageBuilder.removeDemosMissingDependencies(document);
            DemoPageBuilder.addMFileNodesToDocument(document);
            Document document2 = DemoPageBuilder.buildXslDocument(documentBuilder, string, demoTreeItem);
            return DemoPageBuilder.transformDemosXmlFile(document, document2);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println(transformerConfigurationException.getMessageAndLocation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getDemosXmlDoc(String string, DocumentBuilder documentBuilder) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Document document = documentBuilder.parse(fileInputStream, file.toURI().toString());
            return document;
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{file};
            String string2 = MessageFormat.format(HelpUtils.getLocalizedString((String)"demos.filenotfound"), objectArray);
            System.out.println(string2);
            Document document = null;
            return document;
        }
        catch (SAXException sAXException) {
            System.out.println("Could not parse " + string);
            Document document = null;
            return document;
        }
        finally {
            fileInputStream.close();
        }
    }

    private static void removeDemosMissingDependencies(Document document) {
        NodeList nodeList = document.getElementsByTagName("demoitem");
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Element element = (Element)nodeList.item(i);
            if (DemoPageBuilder.isCorrectStudentStatus(DemoPageBuilder.getAllDependencies(element))) continue;
            element.getParentNode().removeChild(element);
        }
    }

    private static void addMFileNodesToDocument(Document document) {
        NodeList nodeList = document.getElementsByTagName("callback");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getFirstChild().getNodeValue();
            String string2 = DemoPageBuilder.getDemoFuncNameFromCallback(string);
            if (!DemoPageBuilder.isNotEmpty(string2)) continue;
            Element element = document.createElement("m-file");
            nodeList.item(i).getParentNode().appendChild(element);
            element.appendChild(document.createTextNode(string2));
        }
    }

    private static Document buildXslDocument(DocumentBuilder documentBuilder, String string, DemoTreeItem demoTreeItem) {
        Document document = DemoPageBuilder.createXslDocument(documentBuilder);
        DemoPageBuilder.addVariablesToXslDoc(string, document);
        DemoPageBuilder.addSectionToXslDoc(demoTreeItem, document);
        return document;
    }

    private static Document createXslDocument(DocumentBuilder documentBuilder) {
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS(TRANSFORM_NS, "stylesheet");
        element.setAttribute("version", "1.0");
        element.setAttribute("xmlns", TRANSFORM_NS);
        document.appendChild(element);
        Element element2 = document.createElementNS(TRANSFORM_NS, "import");
        element.appendChild(element2);
        String string = XMLUtils.filePathAsUrl((String)(sMatlabRoot + "/toolbox/matlab/helptools/private/demos.xsl"));
        element2.setAttribute("href", string);
        return document;
    }

    private static void addVariablesToXslDoc(String string, Document document) {
        String string2 = DemoUtils.getDemosroot(string);
        DemoPageBuilder.addVariableToDom(document, "demosroot", string2);
        DemoPageBuilder.addVariableToDom(document, "productlink", HelpUtils.getLocalizedString((String)"demos.productlink"));
        DemoPageBuilder.addVariableToDom(document, "mfile", HelpUtils.getLocalizedString((String)"demos.mfile"));
        DemoPageBuilder.addVariableToDom(document, "mfiledesc", HelpUtils.getLocalizedString((String)"demos.mfiledesc"));
        DemoPageBuilder.addVariableToDom(document, "model", HelpUtils.getLocalizedString((String)"demos.model"));
        DemoPageBuilder.addVariableToDom(document, "modeldesc", HelpUtils.getLocalizedString((String)"demos.modeldesc"));
        DemoPageBuilder.addVariableToDom(document, "video", HelpUtils.getLocalizedString((String)"demos.video"));
        DemoPageBuilder.addVariableToDom(document, "videodesc", HelpUtils.getLocalizedString((String)"demos.videodesc"));
        DemoPageBuilder.addVariableToDom(document, "mgui", HelpUtils.getLocalizedString((String)"demos.mgui"));
        DemoPageBuilder.addVariableToDom(document, "mguidesc", HelpUtils.getLocalizedString((String)"demos.mguidesc"));
        DemoPageBuilder.addVariableToDom(document, "uses", HelpUtils.getLocalizedString((String)"demos.uses"));
        DemoPageBuilder.addVariableToDom(document, "languageDir", DemoPageBuilder.getLanguageDir(string2));
    }

    private static void addSectionToXslDoc(DemoTreeItem demoTreeItem, Document document) {
        String string = "";
        List<String> list = DemoPageBuilder.productTreeLabels(demoTreeItem);
        if (list.size() == 2) {
            string = list.get(0);
        }
        String string2 = "";
        if (list.size() == 3) {
            string2 = list.get(0);
            string = list.get(1);
        }
        DemoPageBuilder.addVariableToDom(document, "section", string);
        DemoPageBuilder.addVariableToDom(document, "subsection", string2);
    }

    private static String transformDemosXmlFile(Document document, Document document2) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new DOMSource(document2));
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    private static synchronized DocumentBuilder getDocumentBuilder() {
        if (sDocumentBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setXIncludeAware(true);
            try {
                sDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
                sDocumentBuilder.setErrorHandler(new DemoErrorHandler());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                System.out.println("Could not configure XML parser: " + parserConfigurationException.getMessage());
            }
        }
        return sDocumentBuilder;
    }

    private static String getLanguageDir(String string) {
        String[] stringArray = HelpUtils.getDemosDirectoryName();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                String string3 = string + File.separator + string2;
                File file = new File(string3);
                if (!file.exists()) continue;
                return string2;
            }
        }
        return "";
    }

    private static boolean isCorrectStudentStatus(String[] stringArray) {
        boolean bl = true;
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null || string.length() <= 0) continue;
                if (string.equals("nonstudent")) {
                    bl = !Matlab.isStudentVersion();
                } else if (string.equals("student")) {
                    bl = Matlab.isStudentVersion();
                }
                if (bl) continue;
                return bl;
            }
        }
        return bl;
    }

    private static String[] getAllDependencies(Element element) {
        String[] stringArray = new String[50];
        int n = 0;
        NodeList nodeList = element.getElementsByTagName("dependency");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null) continue;
            stringArray[n] = node.getFirstChild().getNodeValue();
            ++n;
        }
        return stringArray;
    }

    public static String getDemoFuncNameFromCallback(String string) {
        if (string.startsWith("web") || string.startsWith("playbackdemo")) {
            return "";
        }
        String[] stringArray = new String[]{"xpgallry", "xpmovie", "sshow", "playshow"};
        String string2 = string;
        for (String string3 : stringArray) {
            if (!string2.startsWith(string3)) continue;
            string2 = string2.substring(string3.length() + 1, string2.length());
            string2 = StringUtils.replaceAllStrings((String)string2, (String)"'", (String)"");
        }
        if (string2.contains(" ")) {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        if (string2.indexOf(40) != -1) {
            string2 = string2.substring(0, string2.indexOf(40));
        }
        string2 = StringUtils.stripChar((String)string2, (char)' ');
        string2 = StringUtils.stripChar((String)string2, (char)';');
        string2 = StringUtils.stripChar((String)string2, (char)')');
        return string2;
    }

    private static void addVariableToDom(Document document, String string, String string2) {
        Element element = document.createElementNS(TRANSFORM_NS, "variable");
        document.getFirstChild().appendChild(element);
        element.setAttribute("name", string);
        element.appendChild(document.createCDATASection(string2));
    }

    private static List<String> productTreeLabels(DemoTreeItem demoTreeItem) {
        TreeNode treeNode;
        HelpTreeItem helpTreeItem;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = DemoPageBuilder.getXmlFilenameFromItem(demoTreeItem);
        if (DemoPageBuilder.isEmptyOrNull(string)) {
            return arrayList;
        }
        DemoTreeItem demoTreeItem2 = demoTreeItem;
        do {
            arrayList.add(DemoPageBuilder.getLabelFromItem(demoTreeItem2));
        } while ((helpTreeItem = HelpTreeUtils.getItemForTreeNode((TreeNode)(treeNode = demoTreeItem2.getParent()))) != null && helpTreeItem instanceof DemoTreeItem && string.equals(DemoPageBuilder.getXmlFilenameFromItem(demoTreeItem2 = (DemoTreeItem)helpTreeItem)));
        return arrayList;
    }

    private static String getXmlFilenameFromItem(DemoTreeItem demoTreeItem) {
        if (demoTreeItem == null) {
            return "";
        }
        return DemoPageBuilder.convertNullToEmpty(demoTreeItem.getXmlFilename());
    }

    private static String getLabelFromItem(DemoTreeItem demoTreeItem) {
        if (demoTreeItem == null) {
            return "";
        }
        return DemoPageBuilder.convertNullToEmpty(demoTreeItem.getLabel());
    }

    private static String convertNullToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static boolean isEmptyOrNull(String string) {
        return string == null || string.length() == 0;
    }

    private static boolean isNotEmpty(String string) {
        return !DemoPageBuilder.isEmptyOrNull(string);
    }

    private static class DemoErrorHandler
    implements ErrorHandler {
        private DemoErrorHandler() {
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }
    }
}

