/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.explorer;

import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.explorer.Explorer;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleDOMParser;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.PickerButton;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarFactory;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolBarRegistry;
import com.mathworks.widgets.desk.DTToolSet;
import com.mathworks.xml.XMLUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class ToolbarUtils {
    private static final String CURRENT_CONFIG_FILE_ENDING = "_r6.xml";
    private static final String TOOLSTRIP_CONFIG_FILE_ENDING = "_r7.xml";

    private ToolbarUtils() {
    }

    public static JToolBar fixLook(JToolBar jToolBar) {
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    public static void register(final DTToolBarInfo dTToolBarInfo, final JToolBar jToolBar) {
        final MJPopupMenu mJPopupMenu = new MJPopupMenu();
        if (MLDesktop.getInstance().useToolstrip()) {
            mJPopupMenu.add(Explorer.getInstance().getMoveToolbarAction());
        }
        mJPopupMenu.add((Action)new MJAbstractAction(ExplorerResources.getString((String)"toolbar.popup.customize")){

            public void actionPerformed(ActionEvent actionEvent) {
                MLDesktop.getInstance().showToolBarCustomizationPanel(dTToolBarInfo.getKey());
            }
        });
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (MJUtilities.isMacintoshPopupTrigger((MouseEvent)mouseEvent) || !PlatformInfo.isMacintosh() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    mJPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        jToolBar.addMouseListener(mouseAdapter);
        MLDesktop.getInstance().getToolBarRegistry().register(dTToolBarInfo.getKey(), new DTToolBarRegistry.Registrant(){
            private DTToolBarConfiguration fConfig;
            {
                this.updateToolbars(false, dTToolBarInfo.getKey(), ToolbarUtils.load(dTToolBarInfo.getKey(), dTToolBarInfo.getToolSet(), dTToolBarInfo.getDefaultConfig()));
            }

            public String getToolBarLabel(String string) {
                return dTToolBarInfo.getLabel();
            }

            public DTToolBarInfo getToolBarInfo(String string) {
                return dTToolBarInfo;
            }

            public DTToolBarConfiguration getToolBarConfiguration(String string) {
                return this.fConfig;
            }

            public void updateToolBars(String string, DTToolBarConfiguration dTToolBarConfiguration) {
                this.updateToolbars(true, string, dTToolBarConfiguration);
            }

            public void updateToolbars(boolean bl, String string, DTToolBarConfiguration dTToolBarConfiguration) {
                this.fConfig = dTToolBarConfiguration;
                if (bl) {
                    ToolbarUtils.save(dTToolBarInfo, this.fConfig);
                }
                DTToolBarFactory.udpateToolBar((JToolBar)jToolBar, (DTToolSet)dTToolBarInfo.getToolSet(), (DTToolBarConfiguration)this.fConfig, (Object)((Object)Explorer.getInstance()));
                ToolbarUtils.fixLook(jToolBar);
                ToolbarUtils.addToComponents(jToolBar, mouseAdapter);
            }
        });
    }

    static void addToComponents(JComponent jComponent, MouseListener mouseListener) {
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            component.removeMouseListener(mouseListener);
            if (component instanceof JButton) {
                component.addMouseListener(mouseListener);
                continue;
            }
            if (!(component instanceof PickerButton)) continue;
            ToolbarUtils.addToComponents((JComponent)component, mouseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(DTToolBarInfo dTToolBarInfo, DTToolBarConfiguration dTToolBarConfiguration) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file = new File(new File(Prefs.getPropertyDirectory()), "doc_toolbar_" + dTToolBarInfo.getKey() + ToolbarUtils.getConfigFileEnding());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = dTToolBarConfiguration.toXML(document, null);
            document.appendChild(element);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            XMLUtils.serializeXML((Object)document, (Object)outputStreamWriter, (String)"utf-8");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static DTToolBarConfiguration load(String string, DTToolSet dTToolSet, DTToolBarConfiguration dTToolBarConfiguration) {
        if (!MLDesktop.getInstance().useToolstrip()) {
            DTToolBarConfiguration dTToolBarConfiguration2 = new DTToolBarConfiguration(Arrays.asList("context.back", "context.forward", "cwd.address", "cwd.actions"));
            DTToolBarConfiguration dTToolBarConfiguration3 = ToolbarUtils.read("doc_toolbar_" + string + "_r5.xml", dTToolSet, dTToolBarConfiguration2);
            if (!dTToolBarConfiguration3.equals((Object)dTToolBarConfiguration2)) {
                return dTToolBarConfiguration3;
            }
        }
        return ToolbarUtils.read("doc_toolbar_" + string + ToolbarUtils.getConfigFileEnding(), dTToolSet, dTToolBarConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DTToolBarConfiguration read(String string, DTToolSet dTToolSet, DTToolBarConfiguration dTToolBarConfiguration) {
        File file = new File(Prefs.getPropertyDirectory(), string);
        BufferedReader bufferedReader = null;
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
                SimpleDOMParser simpleDOMParser = new SimpleDOMParser();
                SimpleElement simpleElement = simpleDOMParser.parse((Reader)bufferedReader);
                DTToolBarConfiguration dTToolBarConfiguration2 = new DTToolBarConfiguration(simpleElement);
                dTToolBarConfiguration2 = DTToolBarFactory.reconcile((DTToolSet)dTToolSet, (DTToolBarConfiguration)dTToolBarConfiguration2, (DTToolBarConfiguration)dTToolBarConfiguration);
                fileInputStream.close();
                DTToolBarConfiguration dTToolBarConfiguration3 = dTToolBarConfiguration2;
                return dTToolBarConfiguration3;
            }
            catch (Exception exception) {
                DTToolBarConfiguration dTToolBarConfiguration4 = dTToolBarConfiguration;
                return dTToolBarConfiguration4;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return dTToolBarConfiguration;
    }

    private static String getConfigFileEnding() {
        return MLDesktop.getInstance().useToolstrip() ? TOOLSTRIP_CONFIG_FILE_ENDING : CURRENT_CONFIG_FILE_ENDING;
    }
}

