/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.ProvisionalIcon;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.EditorEventListener;
import com.mathworks.mde.editor.plugins.matlab.EditorSaveRunAndPublishUtils;
import com.mathworks.mde.editor.plugins.matlab.RunMenuItemSelectionManager;
import com.mathworks.mde.editor.plugins.matlab.RunMenuUtils;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mvm.exec.MvmCompileException;
import com.mathworks.mvm.exec.MvmException;
import com.mathworks.mvm.exec.MvmRuntimeException;
import com.mathworks.mwswing.IconSet;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.Prefs;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.accessories.CalloutToolTip;
import com.mathworks.toolstrip.accessories.TSRobot;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunMenu {
    public static final String RUN_MENU_ERROR_HANDLING_PREF = "RunMenuErrorHandlingOn";
    public static final String PANEL_NAME = "RunMenuPanel";
    public static final String RUN_MENU_LABEL_PREFIX = "RunMenuLabel";
    public static final String EDITABLE_RUN_MENU_PANEL_NAME = "EditableRunMenuPanel";
    public static final String EDITABLE_RUN_MENU_TEXTFIELD_NAME = "EditableRunMenuTextField";
    public static final String TYPE_CODE_TO_RUN_PANEL_NAME = "TypeCodeToRunPanel";
    public static final String TYPE_CODE_TO_RUN_TEXTFIELD_NAME = "TypeCodeToRunTextField";
    private TSSplitButton fRunButton;
    private CalloutToolTip fRunButtonBalloonTip;
    private final Editor fEditor;
    private boolean fErrorHasOccurred;
    private String fTooltipString;
    private final MJPanel fPanel;
    private MenuItemTextField fTextFieldToCommit;
    private static final List<String> ERROR_IDS_NOT_ENOUGH_INPUT_ARGS = Arrays.asList("MATLAB:minrhs", "MATLAB:nargchk:notEnoughInputs", "MATLAB:narginchk:notEnoughInputs");
    private static final List<String> ERROR_IDS_TOO_MANY_INPUT_ARGS = Arrays.asList("MATLAB:TooManyInputs", "MATLAB:nargchk:tooManyInputs", "MATLAB:narginchk:tooManyInputs");
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(RunMenu.class.getPackage().getName() + ".resources.RES_matlab");
    private boolean fAugmentedRun;
    private RunButtonStateChangeListener fRunButtonStateListener;
    private static final int TOOLTIP_ARROW_SIZE = 11;
    private final RunMenuItemSelectionManager fSelectionManager;
    private final EditorEventListener fCommitConfigurationsEditorEventListener;

    public RunMenu(@NotNull Editor editor, @NotNull RunButtonStateChangeListener runButtonStateChangeListener) {
        Validate.notNull((Object)editor, (String)"The given Editor cannot be null.");
        Validate.notNull((Object)runButtonStateChangeListener, (String)"The given RunButtonStateChangeListener cannot be null.");
        this.fEditor = editor;
        this.fPanel = new MJPanel();
        this.fSelectionManager = new RunMenuItemSelectionManager(this.fPanel);
        this.fPanel.setName(PANEL_NAME);
        this.fPanel.setBorder(BorderFactory.createEmptyBorder());
        this.fCommitConfigurationsEditorEventListener = new EditorEventListener(){

            public void eventOccurred(EditorEvent editorEvent) {
                if (editorEvent == EditorEvent.CLOSED) {
                    ConfigurationManager.getInstance().persist(false);
                }
            }
        };
        this.fEditor.addEventListener(this.fCommitConfigurationsEditorEventListener);
        this.fRunButtonStateListener = runButtonStateChangeListener;
        this.fAugmentedRun = RunMenu.shouldRunButtonBeAugmented(editor);
    }

    public void setRunButton(TSSplitButton tSSplitButton) {
        this.fRunButton = tSSplitButton;
    }

    public void show(PopupListener.PopupCallback popupCallback) {
        this.fTextFieldToCommit = null;
        RunConfiguration runConfiguration = this.fErrorHasOccurred ? RunMenuUtils.getMostRecentlyActionedConfiguration(this.fEditor) : null;
        this.buildMenu(false, runConfiguration);
        popupCallback.show((JComponent)this.fPanel);
        this.showTooltipIfError(this.fPanel);
    }

    private void buildMenu(boolean bl, @Nullable RunConfiguration runConfiguration) {
        this.fPanel.removeAll();
        this.fSelectionManager.setSelectedPosition(-1);
        List<JComponent> list = this.createComponents(runConfiguration, bl);
        this.fPanel.setLayout((LayoutManager)RunMenuUtils.getMenuLayout(list.size()));
        this.fPanel.setBackground(ToolstripTheme.getInstance().getPopupNonSelectedBackgroundColor());
        CellConstraints cellConstraints = new CellConstraints();
        for (int i = 0; i < list.size(); ++i) {
            JComponent jComponent = list.get(i);
            assert (jComponent instanceof RunMenuItemSelectionManager.SelectableMenuItem) : "All RunMenu items must be a RunMenuItemSelectionManager.SelectableMenuItem";
            this.fPanel.add((Component)jComponent, (Object)cellConstraints.xy(1, i + 1));
        }
        this.fPanel.revalidate();
        this.fPanel.repaint();
        OverlayManager overlayManager = OverlayManagers.get((Component)this.fPanel);
        if (overlayManager != null) {
            overlayManager.packOverlay((Component)this.fPanel);
        }
    }

    private List<JComponent> createComponents(RunConfiguration runConfiguration, boolean bl) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        List<RunConfiguration> list = RunMenuUtils.getConfigurations(this.fEditor, this.fErrorHasOccurred);
        int n = 0;
        int n2 = 0;
        for (RunConfiguration runConfiguration2 : list) {
            String string;
            if (RunMenuUtils.areConfigurationsEqual(runConfiguration, (AbstractFileConfiguration)runConfiguration2)) {
                string = runConfiguration2.getMatlabExpressionToRun();
                arrayList.add((JComponent)this.createEditableExpressionMenuItem(string, runConfiguration2));
            } else if (RunMenuUtils.isAutoGeneratedConfiguration(runConfiguration, list, this.fEditor)) {
                string = RunMenuUtils.getFunctionHeader(this.fEditor);
                arrayList.add((JComponent)this.createEditableExpressionMenuItem(string, runConfiguration2));
            } else {
                string = this.createNonEditableMenuItem(runConfiguration2, n2);
                string.setName(RUN_MENU_LABEL_PREFIX + ++n);
                arrayList.add((JComponent)((Object)string));
            }
            ++n2;
        }
        if (bl) {
            arrayList.add((JComponent)this.createEditableExpressionMenuItem(RunMenuUtils.getFunctionHeader(this.fEditor), null));
        }
        arrayList.add((JComponent)this.createTypeCodeToRunMenuItem(n2));
        return arrayList;
    }

    public void dispose() {
        this.fEditor.removeEventListener(this.fCommitConfigurationsEditorEventListener);
    }

    private MJLabel createNonEditableMenuItem(final @NotNull RunConfiguration runConfiguration, final int n) {
        String string = runConfiguration.getMatlabExpressionToRun();
        NonEditableRunMenuItem nonEditableRunMenuItem = new NonEditableRunMenuItem(string);
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.add((Action)this.createEditContextMenuItem(runConfiguration));
        mJPopupMenu.add((Action)this.createDeleteContextMenuItem(runConfiguration));
        nonEditableRunMenuItem.setComponentPopupMenu((JPopupMenu)mJPopupMenu);
        nonEditableRunMenuItem.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    RunMenuUtils.dismissMenuAndRunConfiguration(runConfiguration, RunMenu.this.fPanel, RunMenu.this.fEditor, RunMenu.this.getMatlabExecutionErrorHandler());
                }
            }
        });
        nonEditableRunMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                RunMenu.this.hideTooltipIfLinux();
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    RunMenu.this.commitOutstandingConfigurations();
                    RunMenuUtils.dismissMenuAndRunConfiguration(runConfiguration, RunMenu.this.fPanel, RunMenu.this.fEditor, RunMenu.this.getMatlabExecutionErrorHandler());
                    RunMenu.this.updateRunButtonState(RunMenu.this.fEditor);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RunMenu.this.fSelectionManager.setSelectedPosition(n);
                RunMenuUtils.adjustPaintedSelection(RunMenu.this.fPanel, n);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RunMenu.this.fSelectionManager.setSelectedPosition(-1);
                RunMenuUtils.adjustPaintedSelection(RunMenu.this.fPanel, -1);
            }
        });
        return nonEditableRunMenuItem;
    }

    private MJAbstractAction createDeleteContextMenuItem(final RunConfiguration runConfiguration) {
        return new MJAbstractAction(BUNDLE.getString("runmenu.contextmenu.delete")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationManager.getInstance().removeConfiguration((AbstractFileConfiguration)runConfiguration);
                RunMenu.this.commitOutstandingConfigurations();
                RunMenu.this.buildMenu(false, null);
                RunMenu.this.updateRunButtonState(RunMenu.this.fEditor);
            }
        };
    }

    private MJAbstractAction createEditContextMenuItem(final RunConfiguration runConfiguration) {
        return new MJAbstractAction(BUNDLE.getString("runmenu.contextmenu.edit")){

            public void actionPerformed(ActionEvent actionEvent) {
                RunMenu.this.commitOutstandingConfigurations();
                RunMenu.this.buildMenu(false, runConfiguration);
            }
        };
    }

    private MJPanel createEditableMenuItem(final @NotNull MenuItemTextField menuItemTextField) {
        EditableItemPanel editableItemPanel = new EditableItemPanel(menuItemTextField);
        if (menuItemTextField.getText() != null && menuItemTextField.getText().equals(BUNDLE.getString("runmenu.typeCodeToRun"))) {
            editableItemPanel.setName(TYPE_CODE_TO_RUN_PANEL_NAME);
            menuItemTextField.setName(TYPE_CODE_TO_RUN_TEXTFIELD_NAME);
        } else {
            editableItemPanel.setName(EDITABLE_RUN_MENU_PANEL_NAME);
            menuItemTextField.setName(EDITABLE_RUN_MENU_TEXTFIELD_NAME);
        }
        FormLayout formLayout = new FormLayout("pref,pref:grow", "pref");
        editableItemPanel.setLayout((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        MJLabel mJLabel = RunMenuUtils.createNonEditableMenuItemLabel(BUNDLE.getString("runmenu.run") + ": ");
        editableItemPanel.add((Component)mJLabel, cellConstraints.xy(1, 1));
        menuItemTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                menuItemTextField.setBackground(ToolstripTheme.getInstance().getPopupItemHoverFocusColor());
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                RunMenu.this.hideTooltipIfNecessary();
            }
        });
        editableItemPanel.add(menuItemTextField, cellConstraints.xy(2, 1));
        RunMenuUtils.applyTSStyle((JComponent)((Object)editableItemPanel));
        return editableItemPanel;
    }

    private void hideTooltipIfLinux() {
        if (PlatformInfo.isLinux()) {
            this.hideTooltipIfNecessary();
        }
    }

    private void hideTooltipIfNecessary() {
        if (this.fRunButtonBalloonTip != null && this.fRunButtonBalloonTip.isShowing()) {
            this.fRunButtonBalloonTip.hide();
        }
    }

    private MenuItemTextField createEditableExpressionTextField(String string, RunConfiguration runConfiguration) {
        MenuItemTextField menuItemTextField;
        this.fTextFieldToCommit = menuItemTextField = new MenuItemTextField(string, this.fEditor, runConfiguration){

            @Override
            public Color getBackground() {
                return ToolstripTheme.getInstance().getPopupItemHoverFocusColor();
            }
        };
        menuItemTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    RunMenu.this.hideTooltipIfLinux();
                }
                if (keyEvent.getKeyChar() == '\n') {
                    RunMenu.this.hideTooltipIfLinux();
                    RunConfiguration runConfiguration = RunMenu.this.commitOutstandingConfigurations();
                    if (runConfiguration != null) {
                        EditorSaveRunAndPublishUtils.saveFileAndDoConfigurationAction(RunMenu.this.fEditor, (AbstractFileConfiguration)runConfiguration, RunConfiguration.TYPE, RunMenu.this.getMatlabExecutionErrorHandler());
                    }
                    RunMenuUtils.closeRunMenu((Component)RunMenu.this.fPanel);
                    RunMenu.this.updateRunButtonState(RunMenu.this.fEditor);
                }
            }
        });
        menuItemTextField.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                RunMenuUtils.setSelectionInExpression(menuItemTextField);
                menuItemTextField.requestFocusInWindow();
            }
        });
        menuItemTextField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        return menuItemTextField;
    }

    private MenuItemTextField createTypeCodeToRunTextField(String string, final int n) {
        TypeCodeToRunMenuItemTextField typeCodeToRunMenuItemTextField = new TypeCodeToRunMenuItemTextField(string, this.fEditor);
        typeCodeToRunMenuItemTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    RunMenu.this.typeCodeToRunCommitAndRebuildMenu();
                }
            }
        });
        typeCodeToRunMenuItemTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                RunMenu.this.typeCodeToRunCommitAndRebuildMenu();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RunMenu.this.fSelectionManager.setSelectedPosition(n);
                RunMenuUtils.adjustPaintedSelection(RunMenu.this.fPanel, n);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RunMenu.this.fSelectionManager.setSelectedPosition(-1);
                RunMenuUtils.adjustPaintedSelection(RunMenu.this.fPanel, -1);
            }
        });
        return typeCodeToRunMenuItemTextField;
    }

    private void typeCodeToRunCommitAndRebuildMenu() {
        this.commitOutstandingConfigurations();
        this.buildMenu(true, null);
        this.updateRunButtonState(this.fEditor);
    }

    private RunConfiguration commitOutstandingConfigurations() {
        RunConfiguration runConfiguration = null;
        if (this.fTextFieldToCommit != null) {
            if (this.fEditor.negotiateSave() && !EditorSaveRunAndPublishUtils.showErrorIfFileIsNotActionable(this.fEditor, RunConfiguration.TYPE)) {
                RunConfiguration runConfiguration2 = RunMenuUtils.getConfigurationWithSameExpression(this.fTextFieldToCommit.getText(), this.fEditor);
                if (this.fTextFieldToCommit.hasRunConfiguration() && !RunMenuUtils.isAutoGeneratedConfiguration(this.fTextFieldToCommit.getConfiguration(), RunMenuUtils.getConfigurations(this.fEditor, this.fErrorHasOccurred), this.fEditor)) {
                    if (runConfiguration2 == null) {
                        this.fTextFieldToCommit.updateMatlabExpression();
                        runConfiguration = this.fTextFieldToCommit.getConfiguration();
                    } else {
                        if (!runConfiguration2.equals((Object)this.fTextFieldToCommit.getConfiguration())) {
                            ConfigurationManager.getInstance().removeConfiguration((AbstractFileConfiguration)this.fTextFieldToCommit.getConfiguration());
                        }
                        runConfiguration = runConfiguration2;
                    }
                } else if (runConfiguration2 == null) {
                    runConfiguration = RunMenuUtils.createConfiguration(this.fTextFieldToCommit.getText(), this.fEditor);
                    this.commitConfiguration(runConfiguration, this.fEditor);
                } else {
                    runConfiguration = runConfiguration2;
                }
            }
            this.fTextFieldToCommit = null;
        }
        return runConfiguration;
    }

    private void commitConfiguration(RunConfiguration runConfiguration, Editor editor) {
        ConfigurationManager.getInstance().addConfiguration((AbstractFileConfiguration)runConfiguration);
    }

    public MatlabExecutionErrorHandler getMatlabExecutionErrorHandler() {
        return new MatlabExecutionErrorHandler(){

            private boolean shouldHandleError(MvmException mvmException) {
                if (!Prefs.getBooleanPref((String)RunMenu.RUN_MENU_ERROR_HANDLING_PREF, (boolean)true)) {
                    return false;
                }
                assert (RunMenu.this.fEditor.getStorageLocation() instanceof FileStorageLocation) : "Storage location is expected to be file-based.";
                File file = ((FileStorageLocation)RunMenu.this.fEditor.getStorageLocation()).getFile();
                boolean bl = mvmException instanceof MvmCompileException;
                String string = mvmException.getID();
                boolean bl2 = ERROR_IDS_NOT_ENOUGH_INPUT_ARGS.contains(string);
                boolean bl3 = ERROR_IDS_TOO_MANY_INPUT_ARGS.contains(string);
                if (bl) {
                    RunMenu.this.fTooltipString = "runmenu.compileErrorTooltipMessage";
                } else if (bl2) {
                    RunMenu.this.fTooltipString = "runmenu.notEnoughInputArgsTooltipMessage";
                } else if (bl3) {
                    RunMenu.this.fTooltipString = "runmenu.tooManyInputArgsTooltipMessage";
                }
                return bl || RunMenu.inputArgumentErrorOriginatesInFile(mvmException, file, bl2, bl3);
            }

            public void handleError(MvmException mvmException) {
                if (this.shouldHandleError(mvmException)) {
                    assert (RunMenu.this.fRunButton != null) : "The Run button is expected to be not null.";
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Toolstrip toolstrip = TSRobot.getToolstripFor((Component)RunMenu.this.fRunButton);
                            if (toolstrip != null) {
                                if (Toolstrip.State.COLLAPSED == toolstrip.getAttribute((Attribute)Toolstrip.STATE)) {
                                    toolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.EXPANDED_AS_POPUP);
                                }
                                TSRobot tSRobot = new TSRobot(toolstrip);
                                tSRobot.ensureVisible(new String[]{"editor", "run"});
                                if (WindowUtils.getTopmostWindow((Component)RunMenu.this.fRunButton) != null) {
                                    RunMenu.this.fErrorHasOccurred = true;
                                    RunMenu.this.fRunButton.doDropDownClick();
                                }
                            }
                        }
                    });
                }
            }
        };
    }

    public static boolean inputArgumentErrorOriginatesInFile(MvmException mvmException, File file, boolean bl, boolean bl2) {
        boolean bl3 = false;
        StackTraceElement[] stackTraceElementArray = mvmException.getStackTrace();
        if (bl || bl2) {
            bl3 = RunMenu.recursionIsDetected(bl, bl2, mvmException, stackTraceElementArray, file) ? false : (mvmException instanceof MvmRuntimeException && !mvmException.getFunctionName().isEmpty() ? mvmException.getFunctionName().equals(FilenameUtils.removeExtension((String)file.getName())) : RunMenu.inputArgumentErrorBasedOnStackTrace(stackTraceElementArray, file, bl2));
        }
        return bl3;
    }

    private static boolean recursionIsDetected(boolean bl, boolean bl2, MvmException mvmException, StackTraceElement[] stackTraceElementArray, File file) {
        boolean bl3;
        block4: {
            block3: {
                bl3 = false;
                if (!bl) break block3;
                int n = 0;
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    if (!stackTraceElement.getMethodName().equals(FilenameUtils.removeExtension((String)file.getName()))) continue;
                    ++n;
                }
                if (n <= true) break block4;
                bl3 = true;
                break block4;
            }
            if (bl2 && mvmException instanceof MvmRuntimeException && !mvmException.getFunctionName().isEmpty() && mvmException.getFunctionName().equals(FilenameUtils.removeExtension((String)file.getName()))) {
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    if (!stackTraceElement.getMethodName().equals(FilenameUtils.removeExtension((String)file.getName()))) continue;
                    bl3 = true;
                    break;
                }
            }
        }
        return bl3;
    }

    private static boolean inputArgumentErrorBasedOnStackTrace(StackTraceElement[] stackTraceElementArray, File file, boolean bl) {
        if (bl) {
            return stackTraceElementArray.length == 0 || stackTraceElementArray.length == 1 && stackTraceElementArray[0].getMethodName() != null && stackTraceElementArray[0].getMethodName().equals(FilenameUtils.removeExtension((String)file.getName()));
        }
        return stackTraceElementArray.length > 0 && stackTraceElementArray[0].getMethodName() != null && stackTraceElementArray[0].getMethodName().equals(FilenameUtils.removeExtension((String)file.getName()));
    }

    private void showTooltipIfError(final MJPanel mJPanel) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RunMenu.this.fErrorHasOccurred) {
                    assert (RunMenu.this.fTextFieldToCommit != null) : "We expect fTextFieldToCommit to not be null on error.";
                    if (mJPanel.isShowing()) {
                        String string = RunMenuUtils.getFunctionHeader(RunMenu.this.fEditor);
                        MJLabel mJLabel = new MJLabel(MessageFormat.format(BUNDLE.getString(RunMenu.this.fTooltipString), RunMenuUtils.getFunctionName(RunMenu.this.fEditor), string));
                        mJLabel.setBorder(BorderFactory.createEmptyBorder(8, 6, 8, 6));
                        RunMenu.this.fRunButtonBalloonTip = new CalloutToolTip((Component)RunMenu.this.fRunButton, new Rectangle((int)mJPanel.getLocationOnScreen().getX(), (int)RunMenu.this.fTextFieldToCommit.getLocationOnScreen().getY(), mJPanel.getWidth(), RunMenu.this.fTextFieldToCommit.getHeight()), (Component)mJLabel, new Dimension(mJLabel.getPreferredSize().width + 11, mJLabel.getPreferredSize().height), CalloutToolTip.EAST_WEST_PLACEMENT);
                        RunMenu.this.fRunButtonBalloonTip.show();
                    }
                    RunMenu.this.fErrorHasOccurred = false;
                }
            }
        });
    }

    private MJPanel createTypeCodeToRunMenuItem(int n) {
        return this.createEditableMenuItem(this.createTypeCodeToRunTextField(BUNDLE.getString("runmenu.typeCodeToRun"), n));
    }

    private MJPanel createEditableExpressionMenuItem(String string, @Nullable RunConfiguration runConfiguration) {
        return this.createEditableMenuItem(this.createEditableExpressionTextField(string, runConfiguration));
    }

    void updateRunButtonState(Editor editor) {
        boolean bl = this.fAugmentedRun;
        boolean bl2 = RunMenu.shouldRunButtonBeAugmented(editor);
        if (bl != bl2) {
            this.fAugmentedRun = bl2;
            this.fireRunButtonStateChanged();
        }
    }

    private static boolean shouldRunButtonBeAugmented(Editor editor) {
        String string;
        if (!(editor.getStorageLocation() instanceof FileStorageLocation)) {
            return false;
        }
        String string2 = RunMenuUtils.getMostRecentlyActionedConfiguration(editor).getMatlabExpressionToRun();
        return !string2.equals(string = RunMenuUtils.getFunctionName(editor));
    }

    public boolean isRunButtonAugmented() {
        return this.fAugmentedRun;
    }

    void fireRunButtonStateChanged() {
        this.fRunButtonStateListener.runButtonStateChanged();
    }

    public Icon getRunIcon() {
        IconSet iconSet = new IconSet(Arrays.asList(ProvisionalIcon.RUN_16.getIcon(), ProvisionalIcon.RUN_24.getIcon()));
        IconSet iconSet2 = new IconSet(Arrays.asList(ProvisionalIcon.RUN_AUGMENTED_16.getIcon(), ProvisionalIcon.RUN_AUGMENTED_24.getIcon()));
        return this.isRunButtonAugmented() ? iconSet2 : iconSet;
    }

    public static interface RunButtonStateChangeListener {
        public void runButtonStateChanged();
    }

    private static class TypeCodeToRunMenuItemTextField
    extends MenuItemTextField {
        TypeCodeToRunMenuItemTextField(String string, Editor editor) {
            super(string, editor, null);
            this.setFont(ToolstripTheme.getInstance().getPopupDescriptionFont());
            this.setFont(this.getFont().deriveFont(2));
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private static class MenuItemTextField
    extends JTextField {
        private RunConfiguration fConfiguration;
        private final Editor fEditor;

        MenuItemTextField(String string, Editor editor, RunConfiguration runConfiguration) {
            super(string);
            this.fEditor = editor;
            this.fConfiguration = runConfiguration;
            RunMenuUtils.applyTSStyle(this);
        }

        boolean hasRunConfiguration() {
            return this.fConfiguration != null;
        }

        RunConfiguration getConfiguration() {
            return this.fConfiguration;
        }

        void updateMatlabExpression() {
            this.fConfiguration.setMatlabExpression(this.getText());
        }

        @Override
        public Dimension getPreferredSize() {
            return RunMenuUtils.getTSLabelDimension(this.getText());
        }
    }

    private static class NonEditableRunMenuItem
    extends MJLabel
    implements RunMenuItemSelectionManager.SelectableMenuItem {
        private final String fExpression;

        NonEditableRunMenuItem(String string) {
            super(BUNDLE.getString("runmenu.run") + ": " + string);
            RunMenuUtils.applyTSStyle((JComponent)((Object)this));
            this.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.setOpaque(true);
            this.fExpression = string;
        }

        public Dimension getPreferredSize() {
            return RunMenuUtils.getTSLabelDimension(this.getText());
        }

        public String getMatlabExpression() {
            return this.fExpression;
        }

        @Override
        public JComponent getFocusableComponent() {
            return this;
        }
    }

    private static class EditableItemPanel
    extends MJPanel
    implements RunMenuItemSelectionManager.SelectableMenuItem {
        private final JTextField fTextField;

        EditableItemPanel(JTextField jTextField) {
            this.fTextField = jTextField;
        }

        @Override
        public JComponent getFocusableComponent() {
            return this.fTextField;
        }
    }
}

