/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.dataview.BasicUiInfoProvider;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.widgets.datamodel.TextFileBackingStore;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.apache.commons.lang.Validate;

public class TextFileUiInfoProvider
extends BasicUiInfoProvider {
    private TextFileBackingStore fBackingStore;
    private String fUntitledName;
    private PropertyChangeListener fBackedDataListener;

    public TextFileUiInfoProvider(TextFileBackingStore textFileBackingStore) {
        Validate.notNull((Object)textFileBackingStore, (String)"BackingStore cannot be null.");
        this.fBackingStore = textFileBackingStore;
        this.updateProperties();
        this.fBackedDataListener = this.createBackedDataListener();
        this.fBackingStore.addPropertyChangeListener("backingData", this.fBackedDataListener);
    }

    public void dispose() {
        this.fBackingStore.removePropertyChangeListener(this.fBackedDataListener);
    }

    private PropertyChangeListener createBackedDataListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TextFileUiInfoProvider.this.updateProperties();
            }
        };
    }

    private void updateProperties() {
        File file = this.fBackingStore.getFile();
        this.setUniqueKey(file == null ? this.getUntitledName() : file.getPath());
        this.setShortName(file == null ? this.getUntitledName() : file.getName());
        this.setLongName(file == null ? this.getUntitledName() : file.getPath());
    }

    private String getUntitledName() {
        if (this.fUntitledName == null) {
            this.fUntitledName = EditorUtils.getNextUntitledFilename();
        }
        return this.fUntitledName;
    }
}

