/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.common.icons.ShortcutIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlwidgets.shortcuts.Category;
import com.mathworks.mlwidgets.shortcuts.Shortcut;
import com.mathworks.mlwidgets.shortcuts.ShortcutEditor;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mlwidgets.shortcuts.ShortcutsOrganizer;
import com.mathworks.mlwidgets.util.productinfo.InfoListener;
import com.mathworks.mlwidgets.util.productinfo.Product;
import com.mathworks.mlwidgets.util.productinfo.ProductIcon;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.mlwidgets.util.productinfo.ProductItem;
import com.mathworks.mwswing.FocusReturnHandler;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.PanelMenuItemUI;
import com.mathworks.widgets.PanelMenuUI;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import com.sun.java.swing.plaf.windows.WindowsMenuUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.MenuItemUI;

public class MatlabStartButton
extends MJToggleButton
implements InfoListener {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop");
    private static final String MATLAB = "matlab";
    private static final String TOOLBOX = "toolbox";
    private static final String BLOCKSET = "blockset";
    private static final String SIMULINK = "simulink";
    private static final String LINKSANDTARGETS = "links_targets";
    private static final String sProtoImagePath = "$toolbox/matlab/helptools/internal.gif";
    private static int sHashCounter = 0;
    private static MatlabStartButton sButton;
    private static boolean sSubMenusInitialized;
    private Matlab fMatlab = null;
    private MJPopupMenu fMenu;
    private Hashtable fMenuItems;
    private Hashtable fWrappingMenus;
    private boolean fPressed = false;
    private DeactivateHandler fDeactivateHandler;
    private boolean fMouseInBounds;
    private MyWrappingMenu fMatlabMenu = new MyWrappingMenu(sRes.getString("start.Matlab"));
    private MyWrappingMenu fToolboxMenu = new MyWrappingMenu(sRes.getString("start.Toolboxes"));
    private MyWrappingMenu fSimulinkMenu = new MyWrappingMenu(sRes.getString("start.Simulink"));
    private MyWrappingMenu fBlocksetMenu = new MyWrappingMenu(sRes.getString("start.Blocksets"));
    private MyWrappingMenu fLinksMenu = new MyWrappingMenu(sRes.getString("start.Links"));
    private MyWrappingMenu fProtoMenu = new MyWrappingMenu("Internal Tools");
    private Product[] fProds;
    private boolean fInitiallyPressed = false;
    private boolean fListenersEnabled = false;
    private boolean fPressPending = false;
    private DropTargetListener fDropTargetListener = null;

    public MatlabStartButton() {
        super(sRes.getString("start.ButtonTitle"));
        sButton = this;
        if (this.fMatlab == null) {
            this.fMatlab = new Matlab();
        }
        this.fMenuItems = new Hashtable(501);
        ImageIcon imageIcon = ApplicationIcon.MATLAB_14x14.getIcon();
        this.setIcon(imageIcon);
        this.setStartButtonState(false);
        this.addItemListener(new MyItemListener());
        this.fMatlab.eval("", (CompletionObserver)new IsReadyCompletionObserver());
        String string = Locale.getDefault().getLanguage();
        if (!string.equals("ja")) {
            this.setFont(this.getFont().deriveFont(1));
        }
        this.setHorizontalTextPosition(4);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setName("Matlab Start Button");
        this.getAccessibleContext().setAccessibleName("Matlab Start Button");
        this.fDropTargetListener = new DragListener();
        new DropTarget((Component)((Object)this), this.fDropTargetListener);
        new FocusReturnHandler((Component)((Object)this));
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public void infoChanged(final Product[] productArray) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.fMenu != null && this.fMenu.isVisible()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
            this.fProds = productArray;
            if (this.fInitiallyPressed && this.fProds.length > 0) {
                this.createMenu();
                this.continueInitializingMenus();
                this.setStartButtonState(true);
                sButton.setCursor(Cursor.getDefaultCursor());
                if (this.fPressPending) {
                    this.showMenu();
                }
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MatlabStartButton.this.infoChanged(productArray);
                }
            });
        }
    }

    private void createMenu() {
        Object object;
        Object object2;
        Object object3;
        if (this.fMenu != null && this.fMenu.isShowing()) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        sSubMenusInitialized = false;
        this.fMenu = new MJPopupMenu();
        this.fMenu.getAccessibleContext().setAccessibleName("Start Button Menu");
        if (this.fWrappingMenus != null) {
            object3 = this.fWrappingMenus.keys();
            while (object3.hasMoreElements()) {
                ((MyWrappingMenu)this.fWrappingMenus.get(object3.nextElement())).removeAll();
            }
            this.fWrappingMenus.clear();
        }
        if (this.fMenuItems != null) {
            this.fMenuItems.clear();
        }
        if (!this.fListenersEnabled) {
            this.addKeyListener(new MyKeyListener());
            this.addMouseListener(new MyMouseListener());
            this.fListenersEnabled = true;
        }
        this.fMenu.setName("StartMainMenu");
        this.fMenu.setLightWeightPopupEnabled(false);
        this.fMenu.addPopupMenuListener((PopupMenuListener)new MyPopupListener());
        object3 = new MyWrappingMenu(sRes.getString("start.DesktopTools"));
        object3.setName("start_DesktopMenu");
        object3.getAccessibleContext().setAccessibleName(sRes.getString("start.DesktopTools"));
        this.fMatlabMenu.setName("start_MatlabMenu");
        this.fMatlabMenu.getAccessibleContext().setAccessibleName(sRes.getString("start.Matlab"));
        this.fMatlabMenu.setIcon(ApplicationIcon.MATLAB.getIcon());
        this.fToolboxMenu.setName("start_toolboxMenu");
        this.fToolboxMenu.getAccessibleContext().setAccessibleName(sRes.getString("start.Toolboxes"));
        this.fToolboxMenu.setIcon(ApplicationIcon.MATLAB.getIcon());
        this.fSimulinkMenu.setName("start_simulinkMenu");
        this.fSimulinkMenu.getAccessibleContext().setAccessibleName(sRes.getString("start.Simulink"));
        this.fSimulinkMenu.setIcon(ApplicationIcon.SIMULINK.getIcon());
        this.fBlocksetMenu.setName("start_blocksetMenu");
        this.fBlocksetMenu.getAccessibleContext().setAccessibleName(sRes.getString("start.Blocksets"));
        this.fBlocksetMenu.setIcon(ApplicationIcon.SIMULINK.getIcon());
        this.fLinksMenu.setName("start_linksMenu");
        this.fLinksMenu.getAccessibleContext().setAccessibleName(sRes.getString("start.Links"));
        this.fLinksMenu.setIcon(ApplicationIcon.LINK.getIcon());
        this.fProtoMenu.setName("start_protoMenu");
        this.fProtoMenu.setIcon(ProductIcon.getIcon((String)sProtoImagePath));
        Vector vector = ProductInfoUtils.getCategoriesWithDisplayItems();
        this.fWrappingMenus = new Hashtable(13);
        if (vector.contains(MATLAB) && ProductInfoUtils.areaContainsProducts((String)MATLAB)) {
            this.fMenu.add((JMenuItem)((Object)this.fMatlabMenu));
            this.fWrappingMenus.put(MATLAB, this.fMatlabMenu);
            vector.removeElement(MATLAB);
        }
        if (vector.contains(TOOLBOX) && ProductInfoUtils.areaContainsProducts((String)TOOLBOX)) {
            this.fMenu.add((JMenuItem)((Object)this.fToolboxMenu));
            this.fWrappingMenus.put(TOOLBOX, this.fToolboxMenu);
            vector.removeElement(TOOLBOX);
        }
        if (vector.contains(SIMULINK) && ProductInfoUtils.areaContainsProducts((String)SIMULINK)) {
            this.fMenu.add((JMenuItem)((Object)this.fSimulinkMenu));
            this.fWrappingMenus.put(SIMULINK, this.fSimulinkMenu);
            vector.removeElement(SIMULINK);
        }
        if (vector.contains(BLOCKSET) && ProductInfoUtils.areaContainsProducts((String)BLOCKSET)) {
            this.fMenu.add((JMenuItem)((Object)this.fBlocksetMenu));
            this.fWrappingMenus.put(BLOCKSET, this.fBlocksetMenu);
            vector.removeElement(BLOCKSET);
        }
        if (vector.contains(LINKSANDTARGETS) && ProductInfoUtils.areaContainsProducts((String)LINKSANDTARGETS)) {
            this.fMenu.add((JMenuItem)((Object)this.fLinksMenu));
            this.fWrappingMenus.put(LINKSANDTARGETS, this.fLinksMenu);
            vector.removeElement(LINKSANDTARGETS);
        }
        if (vector.contains("internal") && ProductInfoUtils.areaContainsProducts((String)"internal")) {
            this.fMenu.add((JMenuItem)((Object)this.fProtoMenu));
            this.fWrappingMenus.put("internal", this.fProtoMenu);
            vector.removeElement("internal");
            this.addMenuItem(this.fProtoMenu, "Add MWTools to path", "addpath([matlabroot filesep 'toolbox' filesep 'mwtools'])", sHashCounter, ProductIcon.getUnknownIcon());
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!ProductInfoUtils.areaContainsProducts((String)object2)) continue;
            object = new MyWrappingMenu((String)object2);
            object.setIcon(ProductIcon.getIcon((String)ProductInfoUtils.getIconLocationForCategory((String)object2)));
            this.fMenu.add((JMenuItem)object);
            this.fWrappingMenus.put(((String)object2).toLowerCase(), object);
        }
        this.fMenu.addSeparator();
        object2 = ApplicationIcon.TOOLS.getIcon();
        object = ApplicationIcon.GENERIC_GUI.getIcon();
        MyWrappingMenu myWrappingMenu = new MyWrappingMenu(sRes.getString("start.Shortcuts"));
        myWrappingMenu.setName("start_ShortcutsMenu");
        myWrappingMenu.getAccessibleContext().setAccessibleName(sRes.getString("start.Shortcuts"));
        myWrappingMenu.setIcon(ShortcutIcon.ALL.getIcon());
        this.fMenu.add((JMenuItem)((Object)myWrappingMenu));
        this.fMenu.addSeparator();
        object3.setIcon((Icon)object2);
        this.addMenuItem((MJMenu)object3, sRes.getString("title.CommandHistory"), "com.mathworks.mde.desk.MLDesktop.getInstance.showCommandHistory", sHashCounter, (Icon)object);
        this.addMenuItem((MJMenu)object3, sRes.getString("title.CurrentDirectory"), "filebrowser", sHashCounter, (Icon)object);
        ImageIcon imageIcon = ApplicationIcon.EDITOR.getIcon();
        this.addMenuItem((MJMenu)object3, sRes.getString("title.Workspace"), "workspace", sHashCounter, (Icon)object);
        this.addMenuItem((MJMenu)object3, sRes.getString("menuitem.FileExchangeDesktopClient"), "com.mathworks.mde.desk.MLDesktop.getInstance.showFileExchange", sHashCounter, (Icon)object);
        this.fMenu.add((JMenuItem)object3);
        this.addMenuItem((MJMenu)object3, sRes.getString("start.Editor"), "edit", sHashCounter, imageIcon);
        this.addMenuItem((MJMenu)object3, sRes.getString("start.Path"), "pathtool", sHashCounter, (Icon)object);
        ImageIcon imageIcon2 = MiscellaneousIcon.VIEW_XML.getIcon();
        this.addMenuItem((MJMenu)object3, sRes.getString("start.srcViewer"), "com.mathworks.mde.desk.InfoXmlSourceViewer.invoke", sHashCounter, imageIcon2);
        boolean bl = Matlab.isStudentVersion();
        ImageIcon imageIcon3 = CommonIcon.WEB.getIcon();
        MyWrappingMenu myWrappingMenu2 = new MyWrappingMenu(sRes.getString("start.Web"));
        myWrappingMenu2.setName("start_webMenu");
        myWrappingMenu2.getAccessibleContext().setAccessibleName(sRes.getString("start.Web"));
        myWrappingMenu2.setIcon(imageIcon3);
        this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.TheMathWorksWebSite"), "web " + MLDesktop.WEB_MATHWORKS + " -browser -display;", sHashCounter, imageIcon3);
        if (bl) {
            this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.StudentLogin"), "web " + MLDesktop.WEB_LOGIN + " -browser -display;", sHashCounter, imageIcon3);
        }
        this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.Products"), "web " + (Matlab.isStudentVersion() ? MLDesktop.WEB_STUDENT_PRODUCTS : MLDesktop.WEB_PRODUCTS) + " -browser -display;", sHashCounter, imageIcon3);
        this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.Support"), "web " + MLDesktop.WEB_SUPPORT + " -browser -display;", sHashCounter, imageIcon3);
        this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.Training"), "web " + MLDesktop.WEB_TRAINING + " -browser -display;", sHashCounter, imageIcon3);
        if (bl) {
            this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.StudentFAQ"), "web " + MLDesktop.WEB_STUDENT_FAQ + " -browser -display;", sHashCounter, imageIcon3);
            this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.StudentCenter"), "web " + MLDesktop.WEB_STUDENT_CENTER + " -browser -display;", sHashCounter, imageIcon3);
            this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.WebStore"), "web " + MLDesktop.WEB_STORE + " -browser -display;", sHashCounter, imageIcon3);
        } else {
            this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.Account"), "web " + MLDesktop.WEB_LOGIN + " -browser -display;", sHashCounter, imageIcon3);
        }
        myWrappingMenu2.addSeparator();
        this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.MATLABCentral"), "web " + MLDesktop.WEB_MATLAB_CENTRAL + " -browser -display;", sHashCounter, imageIcon3);
        this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.MATLABFileExchange"), "web " + MLDesktop.WEB_FILE_EXCHANGE + " -browser -display;", sHashCounter, imageIcon3);
        this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.MATLABNewsgroupAccess"), "web " + MLDesktop.WEB_NEWSREADER + " -browser -display;", sHashCounter, imageIcon3);
        this.addMenuItem(myWrappingMenu2, sRes.getString("menuitem.Newsletters"), "web " + MLDesktop.WEB_NEWSLETTERS + " -browser -display;", sHashCounter, imageIcon3);
        this.fMenu.add((JMenuItem)((Object)myWrappingMenu2));
        if (!bl) {
            this.addPopupMenuItem(this.fMenu, sRes.getString("menuitem.Trials"), "web " + MLDesktop.WEB_TRIALS + " -browser -display;", sHashCounter, imageIcon3);
            this.addPopupMenuItem(this.fMenu, sRes.getString("menuitem.CheckForUpdates"), "com.mathworks.mde.webintegration.checkforupdates.CheckForUpdatesDialogFactory.invoke(com.mathworks.mde.desk.MLDesktop.getInstance.getMainFrame);", sHashCounter, imageIcon3);
        }
        this.fMenu.addSeparator();
        this.addPopupMenuItem(this.fMenu, sRes.getString("start.Prefs"), "preferences", sHashCounter, CommonIcon.SETTINGS.getIcon());
        ImageIcon imageIcon4 = CommonIcon.FIND_FILES.getIcon();
        this.addPopupMenuItem(this.fMenu, sRes.getString("menuitem.FindFiles"), "com.mathworks.mde.find.FindFiles.invoke", sHashCounter, imageIcon4);
        this.addPopupMenuItem(this.fMenu, sRes.getString("start.Help"), "helpbrowser", sHashCounter, CommonIcon.HELP.getIcon());
        this.addPopupMenuItem(this.fMenu, sRes.getString("start.Demos"), "demo", sHashCounter, ApplicationIcon.DEMOS.getIcon());
    }

    private void continueInitializingMenus() {
        MyWrappingMenu myWrappingMenu = null;
        boolean bl = true;
        for (int i = 0; i < this.fProds.length; ++i) {
            if (this.fProds[i] == null || this.fProds[i].getName() == null || this.fProds[i].getFilename() == null) continue;
            String string = this.fProds[i].getCategory().toLowerCase();
            String string2 = this.fProds[i].getName();
            ProductItem[] productItemArray = this.fProds[i].getItems();
            if (productItemArray == null) continue;
            if (this.fWrappingMenus.containsKey(string)) {
                myWrappingMenu = (MyWrappingMenu)this.fWrappingMenus.get(string);
            }
            MyWrappingMenu myWrappingMenu2 = new MyWrappingMenu(string2);
            myWrappingMenu2.setName("start_" + string2);
            if (!(string2.toLowerCase().equals(MATLAB) || string2.toLowerCase().equals(SIMULINK) || string2.toLowerCase().equals("internal") || myWrappingMenu == null)) {
                myWrappingMenu.add((JMenuItem)((Object)myWrappingMenu2));
            }
            File file = new File(this.fProds[i].getFilename());
            myWrappingMenu2.setIcon(ProductIcon.getIcon((String)this.fProds[i].getIconLoc(), (String)file.getParent()));
            for (ProductItem productItem : productItemArray) {
                boolean bl2;
                String string3;
                int n;
                String[] stringArray;
                if (productItem.getDependencies() != null) {
                    stringArray = productItem.getDependencies();
                    for (n = 0; n < stringArray.length; ++n) {
                        string3 = stringArray[n];
                        bl2 = ProductInfoUtils.isProductInstalled((String)(string3 = string3.trim()).toLowerCase());
                        if (bl2) continue;
                        bl = false;
                    }
                }
                if (productItem.getUnsupportedPlatforms() != null) {
                    stringArray = productItem.getUnsupportedPlatforms();
                    for (n = 0; n < stringArray.length; ++n) {
                        string3 = stringArray[n];
                        string3 = string3.trim();
                        bl2 = false;
                        if (string3.equals("pc")) {
                            bl2 = PlatformInfo.isWindows();
                        } else if (string3.equals("unix")) {
                            bl2 = PlatformInfo.isUnix();
                        }
                        if (!bl2) continue;
                        bl = false;
                    }
                }
                if (bl) {
                    if (string2.toLowerCase().equals(MATLAB)) {
                        this.addMenuItem(this.fMatlabMenu, productItem.getLabel(), productItem.getCallback(), sHashCounter, ProductIcon.getIcon((String)productItem.getIconLocation(), (String)file.getParent()));
                    } else if (string2.toLowerCase().equals(SIMULINK)) {
                        this.addMenuItem(this.fSimulinkMenu, productItem.getLabel(), productItem.getCallback(), sHashCounter, ProductIcon.getIcon((String)productItem.getIconLocation(), (String)file.getParent()));
                    } else if (string2.toLowerCase().equals("internal")) {
                        this.addMenuItem(this.fProtoMenu, productItem.getLabel(), productItem.getCallback(), sHashCounter, ProductIcon.getIcon((String)productItem.getIconLocation(), (String)file.getParent()));
                    } else {
                        this.addMenuItem(myWrappingMenu2, productItem.getLabel(), productItem.getCallback(), sHashCounter, ProductIcon.getIcon((String)productItem.getIconLocation(), (String)file.getParent()));
                    }
                }
                bl = true;
            }
        }
    }

    private void addMenuItem(MJMenu mJMenu, String string, String string2, int n, Icon icon) {
        this.fMenuItems.put(Integer.toString(n), new StartMenuItem(string, string2, null, null));
        MyMenuItem myMenuItem = new MyMenuItem(new MyAction("  " + string, n));
        myMenuItem.setName(mJMenu.getName() + "_" + string);
        myMenuItem.setIcon(icon);
        mJMenu.add((JMenuItem)((Object)myMenuItem));
        ++sHashCounter;
    }

    private void addPopupMenuItem(MJPopupMenu mJPopupMenu, String string, String string2, int n, Icon icon) {
        this.fMenuItems.put(Integer.toString(n), new StartMenuItem(string, string2, null, null));
        MyMenuItem myMenuItem = new MyMenuItem(new MyAction("  " + string, n));
        myMenuItem.setName(mJPopupMenu.getName() + "_" + string);
        myMenuItem.setIcon(icon);
        mJPopupMenu.add((JMenuItem)((Object)myMenuItem));
        ++sHashCounter;
    }

    private void setStartButtonState(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            sButton.setEnabled(bl);
        } else {
            SwingUtilities.invokeLater(new SetButtonEnabledDispatch(bl));
        }
    }

    private void continueCreatingShortcutsMenu(MyWrappingMenu myWrappingMenu) {
        Shortcut[] shortcutArray = ShortcutUtils.getTopLevelItems();
        this.addShortcutsToNode(shortcutArray, myWrappingMenu, true);
        myWrappingMenu.addSeparator();
        MyMenuItem myMenuItem = new MyMenuItem(new NewFavoriteAction());
        myMenuItem.setIcon(ShortcutIcon.NEW.getIcon());
        myWrappingMenu.add((JMenuItem)((Object)myMenuItem));
        MyMenuItem myMenuItem2 = new MyMenuItem(new OrganizeFavsAction());
        myMenuItem2.setIcon(ShortcutIcon.ORGANIZE.getIcon());
        myWrappingMenu.add((JMenuItem)((Object)myMenuItem2));
    }

    private void addShortcutsToNode(Shortcut[] shortcutArray, MyWrappingMenu myWrappingMenu, boolean bl) {
        for (int i = 0; i < shortcutArray.length; ++i) {
            Shortcut shortcut = shortcutArray[i];
            if (shortcut instanceof Category) {
                MyWrappingMenu myWrappingMenu2 = new MyWrappingMenu(shortcut.getLabel());
                myWrappingMenu2.setIcon(shortcut.getIcon());
                if (!shortcut.getLabel().equals(ShortcutUtils.getTopLevelNodeName())) {
                    myWrappingMenu.add((JMenuItem)((Object)myWrappingMenu2));
                }
                this.addShortcutsToNode(((Category)shortcut).getItems().toArray(new Shortcut[0]), myWrappingMenu2, true);
                continue;
            }
            this.addMenuItem(myWrappingMenu, shortcut.getLabel(), shortcut.getCallback(), sHashCounter, shortcut.getIcon());
        }
        if (shortcutArray.length == 0) {
            this.addMenuItem(myWrappingMenu, sRes.getString("start.Empty"), "", sHashCounter, null);
        }
    }

    public static void refresh() {
        MatlabStartButton.refresh(true);
    }

    public final Object getPopupForQE() {
        return this.fMenu;
    }

    public void addNotify() {
        this.fDeactivateHandler = new DeactivateHandler();
        SwingUtilities.windowForComponent((Component)((Object)this)).addWindowListener(this.fDeactivateHandler);
        super.addNotify();
    }

    public void removeNotify() {
        SwingUtilities.windowForComponent((Component)((Object)this)).removeWindowListener(this.fDeactivateHandler);
        this.fDeactivateHandler = null;
        super.removeNotify();
    }

    private void notifyMouseEntered(boolean bl) {
        this.fMouseInBounds = bl;
    }

    private void showMenu() {
        this.fPressPending = false;
        int n = this.getX();
        int n2 = this.getY() - this.fMenu.getPreferredSize().height;
        this.fMenu.show((Component)((Object)this), n, n2);
    }

    private static void refresh(boolean bl) {
        if (bl) {
            ProductInfoUtils.clearAndReparseProducts();
        }
        if (sButton != null && !bl) {
            sButton.createMenu();
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width += 4;
        dimension.height = 21;
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    static /* synthetic */ Product[] access$1002(MatlabStartButton matlabStartButton, Product[] productArray) {
        matlabStartButton.fProds = productArray;
        return productArray;
    }

    static {
        sSubMenusInitialized = false;
    }

    class DragListener
    implements DropTargetListener {
        DragListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
                dropTargetDragEvent.acceptDrag(1);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
                dropTargetDragEvent.acceptDrag(1);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
                Transferable transferable = dropTargetDropEvent.getTransferable();
                String string = null;
                try {
                    string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ShortcutEditor.invoke((String)"Add Shortcuts to Start Button", null, (String)string, null, null);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    private class OrganizeFavsAction
    extends AbstractAction {
        public OrganizeFavsAction() {
            super("  " + sRes.getString("start.OrganizeShortcuts"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            sButton.doClick();
            ShortcutsOrganizer.invoke((Frame)((Frame)SwingUtilities.windowForComponent((Component)((Object)sButton))));
        }
    }

    private class NewFavoriteAction
    extends AbstractAction {
        public NewFavoriteAction() {
            super("  " + sRes.getString("start.AddShortcut"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            sButton.doClick();
            ShortcutEditor.invoke();
        }
    }

    private class DeactivateHandler
    extends WindowAdapter {
        private DeactivateHandler() {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (!MatlabStartButton.this.fMouseInBounds && MatlabStartButton.this.fMenu != null && MatlabStartButton.this.fMenu.isVisible()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private class MyMenuItem
    extends MJMenuItem
    implements MouseListener {
        public MyMenuItem(Action action) {
            super(action);
            this.addMouseListener(this);
            if (PlatformInfo.isWindowsVistaAppearance()) {
                this.setUI((MenuItemUI)new WindowsMenuItemUI());
            } else {
                this.setUI((MenuItemUI)new PanelMenuItemUI());
            }
            this.setMargin(new Insets(2, 2, 2, 6));
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MatlabStartButton.this.notifyMouseEntered(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MatlabStartButton.this.notifyMouseEntered(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class MyWrappingMenu
    extends MJMenu
    implements MouseListener {
        private final int screenHeight;
        private int fLastDesktopY;

        public MyWrappingMenu() {
            this("");
        }

        public MyWrappingMenu(String string) {
            super("  " + string);
            this.screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
            this.fLastDesktopY = -1;
            this.addMouseListener(this);
            if (PlatformInfo.isWindowsVistaAppearance()) {
                this.setUI((MenuItemUI)new WindowsMenuUI());
            } else {
                this.setUI((MenuItemUI)new PanelMenuUI());
            }
            this.setMargin(new Insets(2, 2, 2, 6));
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MatlabStartButton.this.notifyMouseEntered(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MatlabStartButton.this.notifyMouseEntered(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void setPopupMenuVisible(boolean bl) {
            if (this.getName() != null && this.getName().equals("start_ShortcutsMenu") && this.getItemCount() == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                MatlabStartButton.this.continueCreatingShortcutsMenu(this);
                this.setCursor(Cursor.getDefaultCursor());
            } else if (!sSubMenusInitialized && this.getItemCount() == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                sSubMenusInitialized = true;
                MatlabStartButton.this.continueInitializingMenus();
                this.setCursor(Cursor.getDefaultCursor());
            }
            Rectangle rectangle = SwingUtilities.windowForComponent((Component)((Object)MatlabStartButton.this)).getBounds();
            if (this.fLastDesktopY == -1) {
                this.fLastDesktopY = rectangle.y + rectangle.height;
            }
            if (bl) {
                JPopupMenu jPopupMenu = this.getPopupMenu();
                int n = this.getPopupMenu().getInvoker().getLocationOnScreen().y;
                int n2 = rectangle.y + rectangle.height;
                if (n2 != this.fLastDesktopY) {
                    this.unwrapMenu(this);
                }
                int n3 = jPopupMenu.getPreferredSize().height;
                this.fLastDesktopY = n2;
                boolean bl2 = this.screenHeight - n <= n3;
                int n4 = n - n3;
                int n5 = this.getItemCount() != 0 ? n / (n3 / this.getItemCount()) : 0;
                if (n4 < 0 && this.getItemCount() > n5 && bl2) {
                    int n6;
                    Component[] componentArray = this.getMenuComponents();
                    MyWrappingMenu myWrappingMenu = new MyWrappingMenu(sRes.getString("start.More"));
                    for (n6 = 0; n6 < n5 - 1; ++n6) {
                        if (componentArray[n6] instanceof MyWrappingMenu) {
                            jPopupMenu.add((JMenuItem)((Object)((MyWrappingMenu)((Object)componentArray[n6]))));
                            continue;
                        }
                        if (componentArray[n6] instanceof MyMenuItem) {
                            jPopupMenu.add((JMenuItem)((Object)((MyMenuItem)((Object)componentArray[n6]))));
                            continue;
                        }
                        if (!(componentArray[n6] instanceof JPopupMenu.Separator)) continue;
                        jPopupMenu.addSeparator();
                    }
                    jPopupMenu.add((JMenuItem)((Object)myWrappingMenu));
                    for (n6 = n5 - 1; n6 < componentArray.length; ++n6) {
                        if (componentArray[n6] instanceof MyWrappingMenu) {
                            myWrappingMenu.add((JMenuItem)((Object)((MyWrappingMenu)((Object)componentArray[n6]))));
                            continue;
                        }
                        if (componentArray[n6] instanceof MJMenu) {
                            myWrappingMenu.add((JMenuItem)((MJMenu)componentArray[n6]));
                            continue;
                        }
                        if (componentArray[n6] instanceof MyMenuItem) {
                            myWrappingMenu.add((JMenuItem)((Object)((MyMenuItem)((Object)componentArray[n6]))));
                            continue;
                        }
                        if (!(componentArray[n6] instanceof JPopupMenu.Separator)) continue;
                        myWrappingMenu.addSeparator();
                    }
                }
                jPopupMenu.setBounds(0, 0, 0, 0);
            }
            this.revalidate();
            this.getPopupMenu().invalidate();
            super.setPopupMenuVisible(bl);
        }

        private void unwrapMenu(MyWrappingMenu myWrappingMenu) {
            Component[] componentArray = myWrappingMenu.getMenuComponents();
            myWrappingMenu.removeAll();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof MyWrappingMenu) {
                    this.unwrapMenu((MyWrappingMenu)((Object)componentArray[i]));
                    if (((MyWrappingMenu)((Object)componentArray[i])).getText().trim().equals(sRes.getString("start.More").trim())) continue;
                    this.add(componentArray[i]);
                    continue;
                }
                if (componentArray[i] instanceof MyMenuItem) {
                    myWrappingMenu.add((JMenuItem)((Object)((MyMenuItem)((Object)componentArray[i]))));
                    continue;
                }
                if (!(componentArray[i] instanceof JPopupMenu.Separator)) continue;
                myWrappingMenu.addSeparator();
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MatlabStartButton.this.fPressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MatlabStartButton.this.fPressed = false;
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        private int fLastKeyCode;

        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.fLastKeyCode = keyEvent.getKeyCode();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (MatlabStartButton.this.fMenu != null && this.fLastKeyCode == 10) {
                MatlabStartButton.this.doClick();
            }
        }
    }

    private class MyPopupListener
    implements PopupMenuListener {
        private MyPopupListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!MatlabStartButton.this.fPressed) {
                        sButton.setSelected(false);
                    }
                }
            });
            MatlabStartButton.this.fMouseInBounds = false;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class IsReadyCompletionObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            MatlabStartButton.this.setStartButtonState(true);
        }
    }

    private class CallbackCompletionObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MatlabStartButton.this.setCursor(Cursor.getDefaultCursor());
                    MatlabStartButton.this.getParent().getParent().setCursor(Cursor.getDefaultCursor());
                }
            });
        }
    }

    private class StartMenuItem {
        private String fLabel;
        private String fCallback;
        private String fIcon;
        private String fDepen;

        public StartMenuItem(String string, String string2, String string3, String string4) {
            this.fLabel = string;
            this.fCallback = string2;
            this.fIcon = string3;
            this.fDepen = string4;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getCallback() {
            return this.fCallback;
        }

        public String getIcon() {
            return this.fIcon;
        }

        public String getDependency() {
            return this.fDepen;
        }
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!MatlabStartButton.this.fInitiallyPressed && MatlabStartButton.this.fProds == null) {
                MatlabStartButton.this.fInitiallyPressed = true;
                MatlabStartButton.access$1002(MatlabStartButton.this, ProductInfoUtils.getAllProductsInfo());
                MatlabStartButton.this.fPressPending = MatlabStartButton.this.fProds.length == 0;
                ProductInfoUtils.registerInfoListener((InfoListener)sButton);
                ShortcutUtils.addFavoritesListener((ActionListener)new FavoritesChangedListener());
                sButton.setCursor(Cursor.getPredefinedCursor(3));
                if (MatlabStartButton.this.fProds.length > 0) {
                    MatlabStartButton.this.createMenu();
                    MatlabStartButton.this.continueInitializingMenus();
                    MatlabStartButton.this.setStartButtonState(true);
                    sButton.setCursor(Cursor.getDefaultCursor());
                    MatlabStartButton.this.showMenu();
                }
            }
            if (MatlabStartButton.this.fInitiallyPressed && MatlabStartButton.this.fMenu != null && !MatlabStartButton.this.fMenu.isVisible() && MatlabStartButton.this.isSelected()) {
                MatlabStartButton.this.showMenu();
            }
        }
    }

    private class FavoritesChangedListener
    implements ActionListener {
        private FavoritesChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MatlabStartButton.refresh(false);
        }
    }

    private class MyAction
    extends AbstractAction {
        int fCommandNumberKey;

        public MyAction(String string, int n) {
            super(string);
            this.fCommandNumberKey = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            sButton.doClick();
            MatlabStartButton.this.setCursor(Cursor.getPredefinedCursor(3));
            MatlabStartButton.this.getParent().getParent().setCursor(Cursor.getPredefinedCursor(3));
            MatlabStartButton.this.fMatlab.evalConsoleOutput(((StartMenuItem)MatlabStartButton.this.fMenuItems.get(Integer.toString(this.fCommandNumberKey))).getCallback(), (CompletionObserver)new CallbackCompletionObserver());
            MatlabStartButton.this.setSelected(false);
        }
    }

    private class SetButtonEnabledDispatch
    implements Runnable {
        boolean fState;

        public SetButtonEnabledDispatch(boolean bl) {
            this.fState = bl;
        }

        @Override
        public void run() {
            sButton.setEnabled(this.fState);
        }
    }
}

