/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.mde.desk.MLMenuBar;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mde.desk.PlotGalleryManager;
import com.mathworks.mde.desk.PlotableClientBase;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTMenu;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMenuOmission;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class MLMultipleClientFrame
extends DTMultipleClientFrame {
    private DTMenu fDebugMenu;
    private List<PlotGalleryManager> fPlotGalleryManagers;
    private DTClient fLastPlotableClient;

    public MLMultipleClientFrame(Desktop desktop, String string, Icon icon, DTGroup dTGroup, boolean bl) {
        super(desktop, string, icon, dTGroup, bl);
    }

    void addPlotGalleryManager(PlotGalleryManager plotGalleryManager) {
        if (this.fPlotGalleryManagers == null) {
            this.fPlotGalleryManagers = new ArrayList<PlotGalleryManager>();
        }
        this.fPlotGalleryManagers.add(plotGalleryManager);
    }

    public void removeClient(DTClient dTClient) {
        if (dTClient == this.fLastPlotableClient) {
            this.fLastPlotableClient = null;
            this.updatePlots();
        }
        super.removeClient(dTClient);
    }

    public void removeGroup(DTGroup dTGroup) {
        if (this.fLastPlotableClient != null && dTGroup == this.fLastPlotableClient.getGroup()) {
            this.fLastPlotableClient = null;
            this.updatePlots();
        }
        super.removeGroup(dTGroup);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DTClient dTClient;
        super.propertyChange(propertyChangeEvent);
        Object object = propertyChangeEvent.getSource();
        if (object instanceof DTClient && (dTClient = (DTClient)object).getComponent() instanceof PlotableClientBase) {
            if ("Occupant Selected".equals(propertyChangeEvent.getPropertyName())) {
                if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && dTClient != this.fLastPlotableClient) {
                    this.fLastPlotableClient = dTClient;
                    this.updatePlots();
                }
            } else if (dTClient == this.fLastPlotableClient && PlotableClientBase.VARIABLES_TO_PLOT.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.updatePlots();
            }
        }
    }

    private void updatePlots() {
        if (this.fPlotGalleryManagers == null) {
            return;
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.fLastPlotableClient != null) {
            PlotableClientBase plotableClientBase = (PlotableClientBase)((Object)this.fLastPlotableClient.getComponent());
            stringArray = plotableClientBase.getVariablesToPlot();
            stringArray2 = plotableClientBase.getVariableClasses();
        }
        for (PlotGalleryManager plotGalleryManager : this.fPlotGalleryManagers) {
            plotGalleryManager.variableSelectionUpdated(stringArray, stringArray2);
            if (this.fLastPlotableClient == null) continue;
            plotGalleryManager.setVariableSelectionSource((PlotableClientBase)((Object)this.fLastPlotableClient.getComponent()));
        }
    }

    protected void augmentClientMenuBar(JMenuBar jMenuBar) {
        Component component;
        int n;
        JMenuBar jMenuBar2;
        super.augmentClientMenuBar(jMenuBar);
        boolean bl = true;
        if (this.fGroup != null && (jMenuBar2 = (JMenuBar)this.fGroup.getProperty(DTProperty.MENU_BAR)) != null) {
            for (n = 0; n < jMenuBar2.getComponentCount(); ++n) {
                component = jMenuBar2.getComponent(n);
                if (!(component instanceof DTMenuOmission) || ((DTMenuOmission)component).getTag() != MLMenuMergeTag.DEBUG) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            int n2 = -1;
            for (n = 0; n < jMenuBar.getMenuCount(); ++n) {
                component = jMenuBar.getMenu(n);
                if (DTMenuMergeTag.getTag((JMenuItem)component) != DTMenuMergeTag.DESKTOP) continue;
                n2 = n;
            }
            this.fDebugMenu = new MLMenuBar.DebugMenu();
            if (n2 >= 0) {
                jMenuBar.add((Component)this.fDebugMenu, n2);
            } else {
                jMenuBar.add((JMenu)this.fDebugMenu);
            }
        }
    }

    protected void restoreClientMenuBar(JMenuBar jMenuBar) {
        super.restoreClientMenuBar(jMenuBar);
        if (this.fDebugMenu != null) {
            jMenuBar.remove((Component)this.fDebugMenu);
            this.fDebugMenu.dispose();
            this.fDebugMenu = null;
        }
    }
}

