/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class GLObjectTracker {
    private static final boolean DEBUG = Debug.debug("GLObjectTracker");
    private static final int BUFFERS = 0;
    private static final int BUFFERS_ARB = 1;
    private static final int FENCES_APPLE = 2;
    private static final int FENCES_NV = 3;
    private static final int FRAGMENT_SHADERS_ATI = 4;
    private static final int FRAMEBUFFERS_EXT = 5;
    private static final int LISTS = 6;
    private static final int OCCLUSION_QUERIES_NV = 7;
    private static final int PROGRAM_AND_SHADER_OBJECTS_ARB = 8;
    private static final int PROGRAM_OBJECTS = 9;
    private static final int PROGRAMS_ARB = 10;
    private static final int PROGRAMS_NV = 11;
    private static final int QUERIES = 12;
    private static final int QUERIES_ARB = 13;
    private static final int RENDERBUFFERS_EXT = 14;
    private static final int SHADER_OBJECTS = 15;
    private static final int TEXTURES = 16;
    private static final int VERTEX_ARRAYS_APPLE = 17;
    private static final int VERTEX_SHADERS_EXT = 18;
    private static final int NUM_OBJECT_TYPES = 19;
    private ObjectList[] lists = new ObjectList[19];
    private int refCount;
    private boolean dirty;

    public synchronized void addBuffers(int n, IntBuffer intBuffer) {
        this.add(this.getList(0), n, intBuffer);
    }

    public synchronized void addBuffers(int n, int[] nArray, int n2) {
        this.add(this.getList(0), n, nArray, n2);
    }

    public synchronized void addBuffersARB(int n, IntBuffer intBuffer) {
        this.add(this.getList(1), n, intBuffer);
    }

    public synchronized void addBuffersARB(int n, int[] nArray, int n2) {
        this.add(this.getList(1), n, nArray, n2);
    }

    public synchronized void addFencesAPPLE(int n, IntBuffer intBuffer) {
        this.add(this.getList(2), n, intBuffer);
    }

    public synchronized void addFencesAPPLE(int n, int[] nArray, int n2) {
        this.add(this.getList(2), n, nArray, n2);
    }

    public synchronized void addFencesNV(int n, IntBuffer intBuffer) {
        this.add(this.getList(3), n, intBuffer);
    }

    public synchronized void addFencesNV(int n, int[] nArray, int n2) {
        this.add(this.getList(3), n, nArray, n2);
    }

    public synchronized void addFragmentShadersATI(int n, int n2) {
        this.add(this.getList(4), n, n2);
    }

    public synchronized void addFramebuffersEXT(int n, IntBuffer intBuffer) {
        this.add(this.getList(5), n, intBuffer);
    }

    public synchronized void addFramebuffersEXT(int n, int[] nArray, int n2) {
        this.add(this.getList(5), n, nArray, n2);
    }

    public synchronized void addLists(int n, int n2) {
        this.add(this.getList(6), n, n2);
    }

    public synchronized void addOcclusionQueriesNV(int n, IntBuffer intBuffer) {
        this.add(this.getList(7), n, intBuffer);
    }

    public synchronized void addOcclusionQueriesNV(int n, int[] nArray, int n2) {
        this.add(this.getList(7), n, nArray, n2);
    }

    public synchronized void addProgramObject(int n) {
        this.add(this.getList(9), n, 1);
    }

    public synchronized void addProgramObjectARB(int n) {
        this.add(this.getList(8), n, 1);
    }

    public synchronized void addProgramsARB(int n, IntBuffer intBuffer) {
        this.add(this.getList(10), n, intBuffer);
    }

    public synchronized void addProgramsARB(int n, int[] nArray, int n2) {
        this.add(this.getList(10), n, nArray, n2);
    }

    public synchronized void addProgramsNV(int n, IntBuffer intBuffer) {
        this.add(this.getList(11), n, intBuffer);
    }

    public synchronized void addProgramsNV(int n, int[] nArray, int n2) {
        this.add(this.getList(11), n, nArray, n2);
    }

    public synchronized void addQueries(int n, IntBuffer intBuffer) {
        this.add(this.getList(12), n, intBuffer);
    }

    public synchronized void addQueries(int n, int[] nArray, int n2) {
        this.add(this.getList(12), n, nArray, n2);
    }

    public synchronized void addQueriesARB(int n, IntBuffer intBuffer) {
        this.add(this.getList(13), n, intBuffer);
    }

    public synchronized void addQueriesARB(int n, int[] nArray, int n2) {
        this.add(this.getList(13), n, nArray, n2);
    }

    public synchronized void addRenderbuffersEXT(int n, IntBuffer intBuffer) {
        this.add(this.getList(14), n, intBuffer);
    }

    public synchronized void addRenderbuffersEXT(int n, int[] nArray, int n2) {
        this.add(this.getList(14), n, nArray, n2);
    }

    public synchronized void addShaderObject(int n) {
        this.add(this.getList(15), n, 1);
    }

    public synchronized void addShaderObjectARB(int n) {
        this.add(this.getList(8), n, 1);
    }

    public synchronized void addTextures(int n, IntBuffer intBuffer) {
        this.add(this.getList(16), n, intBuffer);
    }

    public synchronized void addTextures(int n, int[] nArray, int n2) {
        this.add(this.getList(16), n, nArray, n2);
    }

    public synchronized void addVertexArraysAPPLE(int n, IntBuffer intBuffer) {
        this.add(this.getList(17), n, intBuffer);
    }

    public synchronized void addVertexArraysAPPLE(int n, int[] nArray, int n2) {
        this.add(this.getList(17), n, nArray, n2);
    }

    public synchronized void addVertexShadersEXT(int n, int n2) {
        this.add(this.getList(18), n, n2);
    }

    public synchronized void removeBuffers(int n, IntBuffer intBuffer) {
        this.remove(this.getList(0), n, intBuffer);
    }

    public synchronized void removeBuffers(int n, int[] nArray, int n2) {
        this.remove(this.getList(0), n, nArray, n2);
    }

    public synchronized void removeBuffersARB(int n, IntBuffer intBuffer) {
        this.remove(this.getList(1), n, intBuffer);
    }

    public synchronized void removeBuffersARB(int n, int[] nArray, int n2) {
        this.remove(this.getList(1), n, nArray, n2);
    }

    public synchronized void removeFencesAPPLE(int n, IntBuffer intBuffer) {
        this.remove(this.getList(2), n, intBuffer);
    }

    public synchronized void removeFencesAPPLE(int n, int[] nArray, int n2) {
        this.remove(this.getList(2), n, nArray, n2);
    }

    public synchronized void removeFencesNV(int n, IntBuffer intBuffer) {
        this.remove(this.getList(3), n, intBuffer);
    }

    public synchronized void removeFencesNV(int n, int[] nArray, int n2) {
        this.remove(this.getList(3), n, nArray, n2);
    }

    public synchronized void removeFragmentShaderATI(int n) {
        this.remove(this.getList(4), n, 1);
    }

    public synchronized void removeFramebuffersEXT(int n, IntBuffer intBuffer) {
        this.remove(this.getList(5), n, intBuffer);
    }

    public synchronized void removeFramebuffersEXT(int n, int[] nArray, int n2) {
        this.remove(this.getList(5), n, nArray, n2);
    }

    public synchronized void removeLists(int n, int n2) {
        this.remove(this.getList(6), n, n2);
    }

    public synchronized void removeOcclusionQueriesNV(int n, IntBuffer intBuffer) {
        this.remove(this.getList(7), n, intBuffer);
    }

    public synchronized void removeOcclusionQueriesNV(int n, int[] nArray, int n2) {
        this.remove(this.getList(7), n, nArray, n2);
    }

    public synchronized void removeProgramObject(int n) {
        this.remove(this.getList(9), n, 1);
    }

    public synchronized void removeProgramOrShaderObjectARB(int n) {
        this.remove(this.getList(8), n, 1);
    }

    public synchronized void removeProgramsARB(int n, IntBuffer intBuffer) {
        this.remove(this.getList(10), n, intBuffer);
    }

    public synchronized void removeProgramsARB(int n, int[] nArray, int n2) {
        this.remove(this.getList(10), n, nArray, n2);
    }

    public synchronized void removeProgramsNV(int n, IntBuffer intBuffer) {
        this.remove(this.getList(11), n, intBuffer);
    }

    public synchronized void removeProgramsNV(int n, int[] nArray, int n2) {
        this.remove(this.getList(11), n, nArray, n2);
    }

    public synchronized void removeQueries(int n, IntBuffer intBuffer) {
        this.remove(this.getList(12), n, intBuffer);
    }

    public synchronized void removeQueries(int n, int[] nArray, int n2) {
        this.remove(this.getList(12), n, nArray, n2);
    }

    public synchronized void removeQueriesARB(int n, IntBuffer intBuffer) {
        this.remove(this.getList(13), n, intBuffer);
    }

    public synchronized void removeQueriesARB(int n, int[] nArray, int n2) {
        this.remove(this.getList(13), n, nArray, n2);
    }

    public synchronized void removeRenderbuffersEXT(int n, IntBuffer intBuffer) {
        this.remove(this.getList(14), n, intBuffer);
    }

    public synchronized void removeRenderbuffersEXT(int n, int[] nArray, int n2) {
        this.remove(this.getList(14), n, nArray, n2);
    }

    public synchronized void removeShaderObject(int n) {
        this.remove(this.getList(15), n, 1);
    }

    public synchronized void removeTextures(int n, IntBuffer intBuffer) {
        this.remove(this.getList(16), n, intBuffer);
    }

    public synchronized void removeTextures(int n, int[] nArray, int n2) {
        this.remove(this.getList(16), n, nArray, n2);
    }

    public synchronized void removeVertexArraysAPPLE(int n, IntBuffer intBuffer) {
        this.remove(this.getList(17), n, intBuffer);
    }

    public synchronized void removeVertexArraysAPPLE(int n, int[] nArray, int n2) {
        this.remove(this.getList(17), n, nArray, n2);
    }

    public synchronized void removeVertexShaderEXT(int n) {
        this.remove(this.getList(18), n, 1);
    }

    public synchronized void transferAll(GLObjectTracker gLObjectTracker) {
        for (int i = 0; i < this.lists.length; ++i) {
            this.getList(i).addAll(gLObjectTracker.lists[i]);
            if (gLObjectTracker.lists[i] == null) continue;
            gLObjectTracker.lists[i].clear();
        }
        this.dirty = true;
    }

    public synchronized void ref() {
        ++this.refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unref(GLObjectTracker gLObjectTracker) {
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (--this.refCount == 0) {
                bl = true;
            }
        }
        if (bl) {
            Object object2;
            object = GLContext.getCurrent();
            if (object != null && object instanceof GLContextImpl) {
                object2 = (GLContextImpl)object;
                if (gLObjectTracker != null && gLObjectTracker == ((GLContextImpl)object2).getDeletedObjectTracker()) {
                    try {
                        this.delete(((GLContextImpl)object2).getGL());
                        return;
                    }
                    catch (GLException gLException) {
                        gLObjectTracker.transferAll(this);
                        throw gLException;
                    }
                }
            }
            if (DEBUG) {
                object2 = null;
                if (object == null) {
                    object2 = "current context was null";
                } else if (!(object instanceof GLContextImpl)) {
                    object2 = "current context was not a GLContextImpl";
                } else if (gLObjectTracker == null) {
                    object2 = "no current deletedObjectPool";
                } else if (gLObjectTracker != ((GLContextImpl)object).getDeletedObjectTracker()) {
                    object2 = "deletedObjectTracker didn't match";
                    if (((GLContextImpl)object).getDeletedObjectTracker() == null) {
                        object2 = (String)object2 + " (other was null)";
                    }
                } else {
                    object2 = "unknown reason";
                }
                System.err.println("Deferred destruction of server-side OpenGL objects into " + gLObjectTracker + ": " + (String)object2);
            }
            if (gLObjectTracker != null) {
                gLObjectTracker.transferAll(this);
            }
        }
    }

    public void clean(GL gL) {
        if (this.dirty) {
            try {
                this.delete(gL);
                this.dirty = false;
            }
            catch (GLException gLException) {
                // empty catch block
            }
        }
    }

    private void add(ObjectList objectList, int n, IntBuffer intBuffer) {
        int n2 = intBuffer.position();
        for (int i = 0; i < n; ++i) {
            objectList.add(intBuffer.get(n2 + i));
        }
    }

    private void add(ObjectList objectList, int n, int[] nArray, int n2) {
        for (int i = 0; i < n; ++i) {
            objectList.add(nArray[i + n2]);
        }
    }

    private void add(ObjectList objectList, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            objectList.add(n + i);
        }
    }

    private void remove(ObjectList objectList, int n, IntBuffer intBuffer) {
        int n2 = intBuffer.position();
        for (int i = 0; i < n; ++i) {
            objectList.remove(intBuffer.get(n2 + i));
        }
    }

    private void remove(ObjectList objectList, int n, int[] nArray, int n2) {
        for (int i = 0; i < n; ++i) {
            objectList.remove(nArray[i + n2]);
        }
    }

    private void remove(ObjectList objectList, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            objectList.remove(n + i);
        }
    }

    private ObjectList getList(int n) {
        ObjectList objectList = this.lists[n];
        if (objectList == null) {
            Deleter deleter = null;
            String string = null;
            switch (n) {
                case 0: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteBuffers(1, new int[]{n}, 0);
                        }
                    };
                    string = "buffer";
                    break;
                }
                case 1: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteBuffersARB(1, new int[]{n}, 0);
                        }
                    };
                    string = "ARB buffer";
                    break;
                }
                case 2: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteFencesAPPLE(1, new int[]{n}, 0);
                        }
                    };
                    string = "APPLE fence";
                    break;
                }
                case 3: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteFencesNV(1, new int[]{n}, 0);
                        }
                    };
                    string = "NV fence";
                    break;
                }
                case 4: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteFragmentShaderATI(n);
                        }
                    };
                    string = "ATI fragment shader";
                    break;
                }
                case 5: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteFramebuffersEXT(1, new int[]{n}, 0);
                        }
                    };
                    string = "EXT framebuffer";
                    break;
                }
                case 6: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteLists(n, 1);
                        }
                    };
                    string = "display list";
                    break;
                }
                case 7: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteOcclusionQueriesNV(1, new int[]{n}, 0);
                        }
                    };
                    string = "NV occlusion query";
                    break;
                }
                case 8: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteObjectARB(n);
                        }
                    };
                    string = "ARB program or shader object";
                    break;
                }
                case 9: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteProgram(n);
                        }
                    };
                    string = "program object";
                    break;
                }
                case 10: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteProgramsARB(1, new int[]{n}, 0);
                        }
                    };
                    string = "ARB program object";
                    break;
                }
                case 11: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteProgramsNV(1, new int[]{n}, 0);
                        }
                    };
                    string = "NV program";
                    break;
                }
                case 12: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteQueries(1, new int[]{n}, 0);
                        }
                    };
                    string = "query";
                    break;
                }
                case 13: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteQueriesARB(1, new int[]{n}, 0);
                        }
                    };
                    string = "ARB query";
                    break;
                }
                case 14: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteRenderbuffersEXT(1, new int[]{n}, 0);
                        }
                    };
                    string = "EXT renderbuffer";
                    break;
                }
                case 15: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteShader(n);
                        }
                    };
                    string = "shader object";
                    break;
                }
                case 16: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteTextures(1, new int[]{n}, 0);
                        }
                    };
                    string = "texture";
                    break;
                }
                case 17: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteVertexArraysAPPLE(1, new int[]{n}, 0);
                        }
                    };
                    string = "APPLE vertex array";
                    break;
                }
                case 18: {
                    deleter = new Deleter(){

                        public void delete(GL gL, int n) {
                            gL.glDeleteVertexShaderEXT(n);
                        }
                    };
                    string = "EXT vertex shader";
                    break;
                }
                default: {
                    throw new InternalError("Unexpected OpenGL object type " + n);
                }
            }
            objectList = new ObjectList(deleter);
            objectList.setName(string);
            this.lists[n] = objectList;
        }
        return objectList;
    }

    private void delete(GL gL) {
        for (int i = 0; i < this.lists.length; ++i) {
            ObjectList objectList = this.lists[i];
            if (objectList == null) continue;
            objectList.delete(gL);
            this.lists[i] = null;
        }
    }

    static class ObjectList {
        private static final int MIN_CAPACITY = 4;
        private int size;
        private int capacity;
        private int[] data;
        private Deleter deleter;
        private String name;

        public ObjectList(Deleter deleter) {
            this.deleter = deleter;
            this.clear();
        }

        public void add(int n) {
            if (this.size == this.capacity) {
                int n2 = 2 * this.capacity;
                int[] nArray = new int[n2];
                System.arraycopy(this.data, 0, nArray, 0, this.size);
                this.data = nArray;
                this.capacity = n2;
            }
            this.data[this.size++] = n;
        }

        public void addAll(ObjectList objectList) {
            if (objectList == null) {
                return;
            }
            for (int i = 0; i < objectList.size; ++i) {
                this.add(objectList.data[i]);
            }
        }

        public boolean remove(int n) {
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] != n) continue;
                if (i < this.size - 1) {
                    System.arraycopy(this.data, i + 1, this.data, i, this.size - i - 1);
                }
                --this.size;
                if (this.size < this.capacity / 4 && this.capacity > 4) {
                    int n2 = this.capacity / 4;
                    if (n2 < 4) {
                        n2 = 4;
                    }
                    int[] nArray = new int[n2];
                    System.arraycopy(this.data, 0, nArray, 0, this.size);
                    this.data = nArray;
                    this.capacity = n2;
                }
                return true;
            }
            return false;
        }

        public void setName(String string) {
            if (DEBUG) {
                this.name = string;
            }
        }

        public void delete(GL gL) {
            while (this.size > 0) {
                int n = this.data[this.size - 1];
                --this.size;
                if (DEBUG) {
                    System.err.println("Deleting server-side OpenGL object " + n + (this.name != null ? " (" + this.name + ")" : ""));
                }
                this.deleter.delete(gL, n);
            }
        }

        public void clear() {
            this.size = 0;
            this.capacity = 4;
            this.data = new int[this.capacity];
        }
    }

    static abstract class Deleter {
        Deleter() {
        }

        public abstract void delete(GL var1, int var2);
    }
}

