/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.tcp;

import com.sun.jini.action.GetBooleanAction;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.ConnectionManager;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.tcp.Constraints;
import net.jini.security.proxytrust.TrustEquivalence;

public final class TcpEndpoint
implements Endpoint,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -2840731722681368933L;
    private static final Map internTable = new WeakHashMap();
    private static final Logger logger = Logger.getLogger("net.jini.jeri.tcp.client");
    private static final boolean useNIO = (Boolean)AccessController.doPrivileged(new GetBooleanAction("com.sun.jini.jeri.tcp.useNIO"));
    private final String host;
    private final int port;
    private final SocketFactory sf;
    private transient ConnectionManager connectionManager;
    static /* synthetic */ Class class$net$jini$jeri$tcp$TcpEndpoint;

    public static TcpEndpoint getInstance(String string, int n) {
        return TcpEndpoint.intern(new TcpEndpoint(string, n, null));
    }

    public static TcpEndpoint getInstance(String string, int n, SocketFactory socketFactory) {
        return TcpEndpoint.intern(new TcpEndpoint(string, n, socketFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TcpEndpoint intern(TcpEndpoint tcpEndpoint) {
        Map map = internTable;
        synchronized (map) {
            TcpEndpoint tcpEndpoint2;
            WeakReference weakReference = (WeakReference)internTable.get(tcpEndpoint);
            if (weakReference != null && (tcpEndpoint2 = (TcpEndpoint)weakReference.get()) != null) {
                return tcpEndpoint2;
            }
            tcpEndpoint.connectionManager = new ConnectionManager(tcpEndpoint.new ConnectionEndpointImpl());
            internTable.put(tcpEndpoint, new WeakReference<TcpEndpoint>(tcpEndpoint));
            return tcpEndpoint;
        }
    }

    private TcpEndpoint(String string, int n, SocketFactory socketFactory) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException("port number out of range: " + n);
        }
        this.host = string;
        this.port = n;
        this.sf = socketFactory;
    }

    private Object readResolve() {
        return TcpEndpoint.intern(this);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SocketFactory getSocketFactory() {
        return this.sf;
    }

    public OutboundRequestIterator newRequest(InvocationConstraints invocationConstraints) {
        if (invocationConstraints == null) {
            throw new NullPointerException();
        }
        try {
            Constraints.Distilled distilled = Constraints.distill(invocationConstraints, false);
            return this.connectionManager.newRequest(new Handle(distilled));
        }
        catch (UnsupportedConstraintException unsupportedConstraintException) {
            return new OutboundRequestIterator(){
                private boolean nextCalled = false;

                public boolean hasNext() {
                    return !this.nextCalled;
                }

                public OutboundRequest next() throws IOException {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.nextCalled = true;
                    unsupportedConstraintException.fillInStackTrace();
                    throw unsupportedConstraintException;
                }
            };
        }
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port ^ (this.sf != null ? this.sf.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TcpEndpoint)) {
            return false;
        }
        TcpEndpoint tcpEndpoint = (TcpEndpoint)object;
        return this.host.equals(tcpEndpoint.host) && this.port == tcpEndpoint.port && Util.sameClassAndEquals(this.sf, tcpEndpoint.sf);
    }

    public boolean checkTrustEquivalence(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TcpEndpoint)) {
            return false;
        }
        TcpEndpoint tcpEndpoint = (TcpEndpoint)object;
        return this.host.equals(tcpEndpoint.host) && this.port == tcpEndpoint.port && Util.sameClassAndEquals(this.sf, tcpEndpoint.sf);
    }

    public String toString() {
        return "TcpEndpoint[" + this.host + ":" + this.port + (this.sf != null ? "," + this.sf : "") + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.host == null) {
            throw new InvalidObjectException("null host");
        }
        if (this.port < 1 || this.port > 65535) {
            throw new InvalidObjectException("port number out of range: " + this.port);
        }
    }

    private static class ConnectionImpl
    implements Connection {
        private final Socket socket;

        ConnectionImpl(Socket socket) {
            this.socket = socket;
        }

        Socket getSocket() {
            return this.socket;
        }

        public InputStream getInputStream() throws IOException {
            return this.socket.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.socket.getOutputStream();
        }

        public SocketChannel getChannel() {
            return this.socket.getChannel();
        }

        public void populateContext(OutboundRequestHandle outboundRequestHandle, Collection collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
        }

        public InvocationConstraints getUnfulfilledConstraints(OutboundRequestHandle outboundRequestHandle) {
            Handle handle = (Handle)outboundRequestHandle;
            return handle.getUnfulfilledConstraints();
        }

        public void writeRequestData(OutboundRequestHandle outboundRequestHandle, OutputStream outputStream) {
            if (outputStream == null) {
                throw new NullPointerException();
            }
        }

        public IOException readResponseData(OutboundRequestHandle outboundRequestHandle, InputStream inputStream) {
            if (inputStream == null) {
                throw new NullPointerException();
            }
            return null;
        }

        public void close() {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "closed socket {0}", new Object[]{this.socket});
            }
        }
    }

    private class ConnectionEndpointImpl
    implements ConnectionEndpoint {
        static final /* synthetic */ boolean $assertionsDisabled;

        ConnectionEndpointImpl() {
        }

        public Connection connect(OutboundRequestHandle outboundRequestHandle) throws IOException {
            Socket socket;
            block10: {
                LogRecord logRecord;
                block9: {
                    int n;
                    Handle handle = (Handle)outboundRequestHandle;
                    Constraints.Distilled distilled = handle.getDistilledConstraints();
                    socket = TcpEndpoint.this.sf != null ? TcpEndpoint.this.sf.createSocket() : (useNIO ? SocketChannel.open().socket() : new Socket());
                    if (distilled.hasConnectDeadline()) {
                        long l = System.currentTimeMillis();
                        long l2 = distilled.getConnectDeadline();
                        if (l2 <= l) {
                            throw new SocketTimeoutException("deadline past before connect attempt");
                        }
                        if (!$assertionsDisabled && l <= 0L) {
                            throw new AssertionError();
                        }
                        long l3 = l2 - l;
                        n = l3 > Integer.MAX_VALUE ? 0 : (int)l3;
                    } else {
                        n = 0;
                    }
                    socket.connect(new InetSocketAddress(TcpEndpoint.this.host, TcpEndpoint.this.port), n);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "created socket {0}" + (TcpEndpoint.this.sf != null ? " using factory {1}" : ""), new Object[]{socket, TcpEndpoint.this.sf});
                    }
                    try {
                        socket.setTcpNoDelay(true);
                    }
                    catch (SocketException socketException) {
                        if (!logger.isLoggable(Levels.HANDLED)) break block9;
                        logRecord = new LogRecord(Levels.HANDLED, "exception setting TCP_NODELAY on socket {0}");
                        logRecord.setLoggerName(logger.getName());
                        logRecord.setSourceClassName(this.getClass().getName());
                        logRecord.setSourceMethodName("connect");
                        logRecord.setParameters(new Object[]{socket});
                        logRecord.setThrown(socketException);
                        logger.log(logRecord);
                    }
                }
                try {
                    socket.setKeepAlive(true);
                }
                catch (SocketException socketException) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block10;
                    logRecord = new LogRecord(Levels.HANDLED, "exception setting SO_KEEPALIVE on socket {0}");
                    logRecord.setLoggerName(logger.getName());
                    logRecord.setSourceClassName(this.getClass().getName());
                    logRecord.setSourceMethodName("connect");
                    logRecord.setParameters(new Object[]{socket});
                    logRecord.setThrown(socketException);
                    logger.log(logRecord);
                }
            }
            return new ConnectionImpl(socket);
        }

        public Connection connect(OutboundRequestHandle outboundRequestHandle, Collection collection, Collection collection2) {
            if (collection == null || collection2 == null) {
                throw new NullPointerException();
            }
            ConnectionImpl connectionImpl = null;
            Object object = collection.iterator();
            if (object.hasNext()) {
                connectionImpl = (ConnectionImpl)object.next();
            }
            if (connectionImpl == null && (object = collection2.iterator()).hasNext()) {
                connectionImpl = (ConnectionImpl)object.next();
            }
            if (connectionImpl == null) {
                return null;
            }
            object = System.getSecurityManager();
            if (object != null) {
                Socket socket = connectionImpl.getSocket();
                ((SecurityManager)object).checkConnect(socket.getInetAddress().getHostAddress(), socket.getPort());
            }
            return connectionImpl;
        }

        static {
            $assertionsDisabled = !(class$net$jini$jeri$tcp$TcpEndpoint == null ? (class$net$jini$jeri$tcp$TcpEndpoint = TcpEndpoint.class$("net.jini.jeri.tcp.TcpEndpoint")) : class$net$jini$jeri$tcp$TcpEndpoint).desiredAssertionStatus();
        }
    }

    private class Handle
    implements OutboundRequestHandle {
        private final Constraints.Distilled distilled;

        Handle(Constraints.Distilled distilled) {
            this.distilled = distilled;
        }

        TcpEndpoint getTcpEndpoint() {
            return TcpEndpoint.this;
        }

        Constraints.Distilled getDistilledConstraints() {
            return this.distilled;
        }

        InvocationConstraints getUnfulfilledConstraints() {
            return this.distilled.getUnfulfilledConstraints();
        }
    }
}

