/*
 * Decompiled with CFR 0.152.
 */
package net.jini.entry;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.WeakHashMap;
import net.jini.core.entry.Entry;

public abstract class AbstractEntry
implements Entry {
    static final long serialVersionUID = 5071868345060424804L;
    private static WeakHashMap fieldArrays;

    public boolean equals(Object object) {
        if (!(object instanceof Entry)) {
            return false;
        }
        return AbstractEntry.equals(this, (Entry)object);
    }

    public static boolean equals(Entry entry, Entry entry2) {
        if (entry == entry2) {
            return true;
        }
        if (entry.getClass() != entry2.getClass()) {
            return false;
        }
        Field[] fieldArray = AbstractEntry.fieldInfo(entry);
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                Object object = field.get(entry);
                Object object2 = field.get(entry2);
                if (object2 == object) continue;
                if (object2 == null || object == null) {
                    return false;
                }
                if (object2.equals(object)) continue;
                return false;
            }
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    public int hashCode() {
        return AbstractEntry.hashCode(this);
    }

    public static int hashCode(Entry entry) {
        int n = 0;
        Field[] fieldArray = AbstractEntry.fieldInfo(entry);
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                Object object = fieldArray[i].get(entry);
                if (object == null) continue;
                n ^= object.hashCode();
            }
            return n;
        }
        catch (IllegalAccessException illegalAccessException) {
            return 0;
        }
    }

    public String toString() {
        return AbstractEntry.toString(this);
    }

    public static String toString(Entry entry) {
        Field[] fieldArray = AbstractEntry.fieldInfo(entry);
        StringBuffer stringBuffer = new StringBuffer(entry.getClass().getName());
        stringBuffer.append('(');
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                Field field = fieldArray[i];
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(field.getName());
                stringBuffer.append('=');
                stringBuffer.append(field.get(entry));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                stringBuffer.append("<IllegalAccessException>");
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static Field[] fieldInfo(Entry entry) {
        Field[] fieldArray = null;
        if (fieldArrays == null) {
            fieldArrays = new WeakHashMap();
        } else {
            fieldArray = (Field[])fieldArrays.get(entry.getClass());
            if (fieldArray != null) {
                return fieldArray;
            }
        }
        fieldArray = entry.getClass().getFields();
        ArrayList<Field> arrayList = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            if ((fieldArray[i].getModifiers() & 0x98) != 0) {
                if (arrayList != null) continue;
                arrayList = new ArrayList<Field>();
                for (int j = 0; j < i; ++j) {
                    arrayList.add(fieldArray[j]);
                }
                continue;
            }
            if (arrayList == null) continue;
            arrayList.add(fieldArray[i]);
        }
        if (arrayList != null) {
            fieldArray = arrayList.toArray(new Field[arrayList.size()]);
        }
        fieldArrays.put(entry.getClass(), fieldArray);
        return fieldArray;
    }
}

