/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompListenableImpl;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitStorage;
import com.mathworks.toolbox.distcomp.util.RWLock;
import com.mathworks.toolbox.distcomp.util.SystemTimeProvider;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.workunit.PackageInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnit;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import net.jini.core.event.RemoteEventListener;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public abstract class WorkUnitImpl
extends DistcompListenableImpl
implements WorkUnit {
    public static final long NO_TIMEOUT = Long.MAX_VALUE;
    private final Uuid fWorkUnitId = UuidFactory.generate();
    protected String fName;
    protected long fTimeout = Long.MAX_VALUE;
    protected long fNum;
    protected int fState = 0;
    protected long fCreateTime = -1L;
    protected long fStartTime = -1L;
    protected long fFinishTime = -1L;
    private String[] fAuthorisedUsers = new String[0];
    private String fUserName;
    private TimeProvider fTimeProvider;
    private transient WorkUnitStorage fStorage;
    private transient RWLock fLock;

    protected WorkUnitImpl(long l, String string) {
        this.fTimeProvider = new SystemTimeProvider();
        this.fCreateTime = this.fTimeProvider.currentTimeMillis();
        this.fNum = l;
        this.fUserName = string;
    }

    protected WorkUnitImpl(long l, String string, TimeProvider timeProvider) {
        this.fTimeProvider = timeProvider;
        this.fCreateTime = this.fTimeProvider.currentTimeMillis();
        this.fNum = l;
        this.fUserName = string;
    }

    protected void resetWorkUnitInfoForRerun() {
        this.setWorkUnitToPending();
        this.fStartTime = -1L;
        this.fFinishTime = -1L;
    }

    protected void setWorkUnitToPending() {
        this.fState = 0;
    }

    void resetLock() {
        this.fLock = new RWLock();
    }

    protected void setWorkUnitStorage(WorkUnitStorage workUnitStorage) {
        this.fStorage = workUnitStorage;
    }

    @Override
    public Uuid getID() {
        return this.fWorkUnitId;
    }

    @Override
    public String[] getAuthorisedUsers() {
        return (String[])this.invokeWithReadLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return WorkUnitImpl.this.fAuthorisedUsers.clone();
            }
        });
    }

    @Override
    public long getTimeout() {
        return (Long)this.invokeWithReadLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return new Long(WorkUnitImpl.this.fTimeout);
            }
        });
    }

    @Override
    public String getUserName() {
        return (String)this.invokeWithReadLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return WorkUnitImpl.this.fUserName;
            }
        });
    }

    @Override
    public long getNum() {
        return (Long)this.invokeWithReadLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return new Long(WorkUnitImpl.this.fNum);
            }
        });
    }

    @Override
    public int getState() {
        return (Integer)this.invokeWithReadLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return new Integer(WorkUnitImpl.this.fState);
            }
        });
    }

    @Override
    public Date getCreateTime() {
        return (Date)this.invokeWithReadLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return WorkUnitImpl.this.fCreateTime == -1L ? null : new Date(WorkUnitImpl.this.fCreateTime);
            }
        });
    }

    @Override
    public Date getStartTime() {
        return (Date)this.invokeWithReadLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return WorkUnitImpl.this.fStartTime == -1L ? null : new Date(WorkUnitImpl.this.fStartTime);
            }
        });
    }

    @Override
    public Date getFinishTime() {
        return (Date)this.invokeWithReadLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return WorkUnitImpl.this.fFinishTime == -1L ? null : new Date(WorkUnitImpl.this.fFinishTime);
            }
        });
    }

    @Override
    public long getRunningDuration() {
        return (Long)this.invokeWithReadLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                long l = WorkUnitImpl.this.fStartTime == -1L ? 0L : (WorkUnitImpl.this.fFinishTime == -1L ? WorkUnitImpl.this.fTimeProvider.currentTimeMillis() - WorkUnitImpl.this.fStartTime : WorkUnitImpl.this.fFinishTime - WorkUnitImpl.this.fStartTime);
                return new Long(l);
            }
        });
    }

    @Override
    public void setTimeout(final long l) throws MJSException {
        this.invokeWithWriteLock(new LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                WorkUnitImpl.this.checkStateBeforeSet("Timeout");
                WorkUnitImpl.this.fTimeout = l;
                return null;
            }
        });
    }

    @Override
    public void addEventListener(final RemoteEventListener remoteEventListener, final long l, final long l2, final MarshalledObject marshalledObject) {
        this.invokeWithWriteLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                WorkUnitImpl.super.addEventListener(remoteEventListener, l, l2, marshalledObject);
                return null;
            }
        });
    }

    @Override
    public void removeEventListener(final RemoteEventListener remoteEventListener, final long l, final long l2) {
        this.invokeWithWriteLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                WorkUnitImpl.super.removeEventListener(remoteEventListener, l, l2);
                return null;
            }
        });
    }

    @Override
    public void removeEventListener(final RemoteEventListener remoteEventListener) {
        this.invokeWithWriteLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                WorkUnitImpl.super.removeEventListener(remoteEventListener);
                return null;
            }
        });
    }

    public abstract String workUnitTypeForPrinting();

    protected String getWorkUnitUserName() {
        return this.fUserName;
    }

    protected void setWorkUnitAuthorisedUsers(String[] stringArray) {
        if (stringArray == null) {
            this.fAuthorisedUsers = new String[0];
        } else {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
            this.fAuthorisedUsers = linkedHashSet.toArray(new String[linkedHashSet.size()]);
        }
    }

    protected void setWorkUnitUserName(String string) {
        this.fUserName = string;
    }

    protected void checkStateBeforeSet(String string) throws WorkUnitStateException {
        if (this.fState == 2 || this.fState == 3) {
            throw new WorkUnitStateException(string + " property of a " + this.workUnitTypeForPrinting() + " cannot be set in the running or finished state");
        }
    }

    protected void switchToFinishedState() {
        this.fState = 3;
        this.fFinishTime = this.fTimeProvider.currentTimeMillis();
        this.recordEvent(3L);
    }

    protected void switchToRunningState() {
        this.fState = 2;
        this.fStartTime = this.fTimeProvider.currentTimeMillis();
        this.recordEvent(2L);
    }

    private Object invokeAndLogError(LockedInvocation lockedInvocation, String string) throws MJSException {
        try {
            return lockedInvocation.invoke();
        }
        catch (Error error) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected Error in " + string, error);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected RuntimeException in " + string, runtimeException);
            throw runtimeException;
        }
    }

    private Object invokeAndLogError(LockedInvocationNoException lockedInvocationNoException, String string) {
        try {
            return lockedInvocationNoException.invoke();
        }
        catch (Error error) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected Error in " + string, error);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected RuntimeException in " + string, runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeWithReadLock(LockedInvocation lockedInvocation) throws MJSException {
        this.fLock.getReadLock();
        try {
            Object object = this.invokeAndLogError(lockedInvocation, "invokeWithReadLock(LockedInvocation invocation)");
            return object;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeWithWriteLock(LockedInvocation lockedInvocation) throws MJSException {
        this.fLock.getWriteLock();
        try {
            Object object = this.invokeAndLogError(lockedInvocation, "invokeWithWriteLock(LockedInvocation invocation)");
            return object;
        }
        finally {
            try {
                this.fStorage.updateWorkUnit(this);
            }
            finally {
                this.fLock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeWithWriteLock(LockedInvocationNoStorageUpdate lockedInvocationNoStorageUpdate) throws MJSException {
        this.fLock.getWriteLock();
        try {
            Object object = this.invokeAndLogError(lockedInvocationNoStorageUpdate, "invokeWithWriteLock(LockedInvocationNoStorageUpdate invocation)");
            return object;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeWithReadLock(LockedInvocationNoException lockedInvocationNoException) {
        this.fLock.getReadLock();
        try {
            Object object = this.invokeAndLogError(lockedInvocationNoException, "invokeWithReadLock(LockedInvocationNoException invocation)");
            return object;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeWithWriteLock(LockedInvocationNoException lockedInvocationNoException) {
        this.fLock.getWriteLock();
        try {
            Object object = this.invokeAndLogError(lockedInvocationNoException, "invokeWithWriteLock(LockedInvocationNoException invocation)");
            return object;
        }
        finally {
            try {
                this.fStorage.updateWorkUnit(this);
            }
            finally {
                this.fLock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeWithWriteLock(LockedInvocationNoStorageUpdateNoException lockedInvocationNoStorageUpdateNoException) {
        this.fLock.getWriteLock();
        try {
            Object object = this.invokeAndLogError(lockedInvocationNoStorageUpdateNoException, "invokeWithWriteLock(LockedInvocationNoStorageUpdateNoException invocation)");
            return object;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    protected boolean haveWriteLock() {
        return this.fLock.haveWriteLock();
    }

    @Override
    public String getName() {
        return (String)this.invokeWithReadLock(new LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return WorkUnitImpl.this.fName;
            }
        });
    }

    @Override
    public void setName(final String string) throws MJSException {
        this.invokeWithWriteLock(new LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                WorkUnitImpl.this.checkStateBeforeSet("Name");
                WorkUnitImpl.this.doSetName(string);
                return null;
            }
        });
    }

    protected void doSetName(String string) {
        this.fName = string != null && string.length() > 0 ? string : this.getDefaultName();
    }

    protected abstract String getDefaultName();

    public void switchToRunningStateForUnitTests() {
        this.fState = 2;
        this.fStartTime = this.fTimeProvider.currentTimeMillis();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WorkUnitImpl)) {
            return false;
        }
        WorkUnitImpl workUnitImpl = (WorkUnitImpl)object;
        return this.fWorkUnitId.equals((Object)workUnitImpl.fWorkUnitId);
    }

    public int hashCode() {
        return this.fWorkUnitId.hashCode();
    }

    protected static interface LockedInvocationNoStorageUpdateNoException
    extends LockedInvocationNoException {
    }

    protected static interface LockedInvocationNoException {
        public Object invoke();
    }

    protected static interface LockedInvocationNoStorageUpdate
    extends LockedInvocation {
    }

    protected static interface LockedInvocation {
        public Object invoke() throws MJSException;
    }
}

