/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.auth.AuthorisationContext;
import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.InvocationWithAuth;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.cwo.TaskCWOStreamIdentifier;
import com.mathworks.toolbox.distcomp.mjs.datastore.ByteBufferItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.mjs.remoteio.ReadableRemoteStreamImpl;
import com.mathworks.toolbox.distcomp.mjs.remoteio.RemoteInputStream;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccessProxy;
import com.mathworks.toolbox.distcomp.workunit.NullRemoteInputStreamFactoryException;
import com.mathworks.toolbox.distcomp.workunit.PackageInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskAccessLocal;
import com.mathworks.toolbox.distcomp.workunit.TaskAccessRemote;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitAccessProxy;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import net.jini.id.Uuid;

public class TaskAccessProxy
extends WorkUnitAccessProxy
implements TaskAccessLocal {
    private static final long serialVersionUID = 1L;
    private ExporterFactory fRemoteInputStreamExporterFactory = null;
    private Map<TaskCWOStreamIdentifier, ReadableRemoteStreamImpl> fExportedStreams = new HashMap<TaskCWOStreamIdentifier, ReadableRemoteStreamImpl>();

    public TaskAccessProxy(TaskAccessRemote taskAccessRemote, long l, JobManagerProxy jobManagerProxy) throws DistcompProxy.SerializeProxyException {
        super(taskAccessRemote, l, jobManagerProxy, jobManagerProxy.getRemoteAuth());
    }

    @Override
    public void addToLogOutput(final Uuid[] uuidArray, final String[] stringArray) throws RemoteException, MJSException {
        this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                TaskAccessProxy.this.getRemoteObject().addToLogOutput(uuidArray, stringArray);
                return null;
            }
        });
    }

    @Override
    public void addCommandWindowOutputStreamToTask(final TaskCWOStreamIdentifier[] taskCWOStreamIdentifierArray, InputStream[] inputStreamArray) throws MJSException, RemoteException {
        final InputStream[] inputStreamArray2 = new InputStream[inputStreamArray.length];
        for (int i = 0; i < inputStreamArray.length; ++i) {
            ReadableRemoteStreamImpl readableRemoteStreamImpl = new ReadableRemoteStreamImpl(inputStreamArray[i], this.getRemoteInputStreamExporterFactory().createExporter());
            this.fExportedStreams.put(taskCWOStreamIdentifierArray[i], readableRemoteStreamImpl);
            inputStreamArray2[i] = new RemoteInputStream(readableRemoteStreamImpl.export());
        }
        this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                TaskAccessProxy.this.getRemoteObject().addCommandWindowOutputStreamToTask(taskCWOStreamIdentifierArray, inputStreamArray2);
                return null;
            }
        });
    }

    @Override
    public void removeCommandWindowOutputStreamFromTask(final TaskCWOStreamIdentifier[] taskCWOStreamIdentifierArray) throws MJSException, RemoteException {
        for (TaskCWOStreamIdentifier taskCWOStreamIdentifier : taskCWOStreamIdentifierArray) {
            this.fExportedStreams.remove(taskCWOStreamIdentifier);
        }
        this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                TaskAccessProxy.this.getRemoteObject().removeCommandWindowOutputStreamFromTask(taskCWOStreamIdentifierArray);
                return null;
            }
        });
    }

    @Override
    public void notifyBytesAvailable(final TaskCWOStreamIdentifier taskCWOStreamIdentifier) throws MJSException, RemoteException {
        this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                TaskAccessProxy.this.getRemoteObject().notifyBytesAvailable(taskCWOStreamIdentifier);
                return null;
            }
        });
    }

    @Override
    public void initRemoteInputStreamExporterFactory(ExporterFactory exporterFactory) {
        this.fRemoteInputStreamExporterFactory = exporterFactory;
    }

    private ExporterFactory getRemoteInputStreamExporterFactory() throws NullRemoteInputStreamFactoryException {
        if (this.fRemoteInputStreamExporterFactory == null) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "RemoteInputStreamFactory was null in TaskAccessProxy, client was not configured correctly");
            throw new NullRemoteInputStreamFactoryException("Client not configured correctly");
        }
        return this.fRemoteInputStreamExporterFactory;
    }

    @Override
    public boolean[] getCaptureCommandWindowOutput(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (boolean[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getCaptureCommandWindowOutput(uuidArray);
            }
        });
    }

    @Override
    public int[] getNumOutArgs(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (int[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getNumOutArgs(uuidArray);
            }
        });
    }

    @Override
    public byte[][] getErrorStruct(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (byte[][])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getErrorStruct(uuidArray);
            }
        });
    }

    @Override
    public String[] getErrorMessage(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getErrorMessage(uuidArray);
            }
        });
    }

    @Override
    public String[] getErrorIdentifier(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getErrorIdentifier(uuidArray);
            }
        });
    }

    @Override
    public Worker[] getWorker(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (Worker[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getWorker(uuidArray);
            }
        });
    }

    @Override
    public WorkerProperties[] getWorkerProperties(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (WorkerProperties[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getWorkerProperties(uuidArray);
            }
        });
    }

    @Override
    public Uuid[] getJob(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (Uuid[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getJob(uuidArray);
            }
        });
    }

    @Override
    public int[] getLogLevel(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (int[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getLogLevel(uuidArray);
            }
        });
    }

    @Override
    public int[] getMaximumNumberOfRetries(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (int[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getMaximumNumberOfRetries(uuidArray);
            }
        });
    }

    @Override
    public int[] getAttemptedNumberOfRetries(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (int[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getAttemptedNumberOfRetries(uuidArray);
            }
        });
    }

    @Override
    public String[] getLogOutput(final Uuid[] uuidArray) throws RemoteException, MJSException {
        LargeData[] largeDataArray = this.getInvokeAndRetryWithDataStore(new DistcompAccessProxy.InvocationAndRetryWithDataStore<LargeData[]>(){

            @Override
            public LargeData[] invoke() throws RemoteException, MJSException {
                return TaskAccessProxy.this.getRemoteObject().getLogOutput(this.getDataStore(), uuidArray);
            }
        });
        String[] stringArray = new String[uuidArray.length];
        int n = 0;
        for (LargeData largeData : this.getLargeOutputsFromDataStore(largeDataArray)) {
            ByteBufferItem byteBufferItem = (ByteBufferItem)largeData;
            byteBufferItem.rewind();
            stringArray[n++] = new String(byteBufferItem.getData(byteBufferItem.getNumBytes()));
            byteBufferItem.delete();
        }
        return stringArray;
    }

    @Override
    public String[] getMLFunctionName(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[])this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

            @Override
            public Object invoke() throws MJSException, RemoteException {
                return TaskAccessProxy.this.getRemoteObject().getMLFunctionName(uuidArray);
            }
        });
    }

    @Override
    public TaskInfo[][] getFailedAttemptInformation(AuthorisationContext authorisationContext, final Uuid[] uuidArray) throws RemoteException, MJSException {
        TaskInfo[][] taskInfoArray;
        TaskInfo[][] taskInfoArray2 = taskInfoArray = authorisationContext.invokeWithAuth(new InvocationWithAuth<TaskInfo[][]>(authorisationContext.getCurrentUser()){

            @Override
            public TaskInfo[][] invoke() throws RemoteException, MJSException {
                return TaskAccessProxy.this.getInvokeAndRetryWithDataStore(new DistcompAccessProxy.InvocationAndRetryWithDataStore<TaskInfo[][]>(){

                    @Override
                    public TaskInfo[][] invoke() throws MJSException, RemoteException {
                        return TaskAccessProxy.this.getRemoteObject().getFailedAttemptInformation(this.getDataStore(), uuidArray, this.getCredentialProvider());
                    }
                });
            }
        });
        int n = taskInfoArray2.length;
        for (int i = 0; i < n; ++i) {
            TaskInfo[] taskInfoArray3;
            for (TaskInfo taskInfo : taskInfoArray3 = taskInfoArray2[i]) {
                taskInfo.setCommandWindowOutput(this.getLargeOutputsFromDataStore(new LargeData[]{taskInfo.getCommandWindowOutput()})[0]);
            }
        }
        return taskInfoArray;
    }

    @Override
    public LargeData[] getCommandWindowOutput(AuthorisationContext authorisationContext, final Uuid[] uuidArray) throws AuthorisationFailedException, RemoteException, MJSException {
        LargeData[] largeDataArray = authorisationContext.invokeWithAuth(new InvocationWithAuth<LargeData[]>(authorisationContext.getCurrentUser()){

            @Override
            public LargeData[] invoke() throws RemoteException, MJSException {
                return TaskAccessProxy.this.getInvokeAndRetryWithDataStore(new DistcompAccessProxy.InvocationAndRetryWithDataStore<LargeData[]>(){

                    @Override
                    public LargeData[] invoke() throws RemoteException, MJSException {
                        return TaskAccessProxy.this.getRemoteObject().getCommandWindowOutput(this.getDataStore(), uuidArray, this.getCredentialProvider());
                    }
                });
            }
        });
        return this.getLargeOutputsFromDataStore(largeDataArray);
    }

    @Override
    public LargeData[] getInputData(AuthorisationContext authorisationContext, final Uuid[] uuidArray) throws AuthorisationFailedException, RemoteException, MJSException {
        LargeData[] largeDataArray = authorisationContext.invokeWithAuth(new InvocationWithAuth<LargeData[]>(authorisationContext.getCurrentUser()){

            @Override
            public LargeData[] invoke() throws RemoteException, MJSException {
                return TaskAccessProxy.this.getInvokeAndRetryWithDataStore(new DistcompAccessProxy.InvocationAndRetryWithDataStore<LargeData[]>(){

                    @Override
                    public LargeData[] invoke() throws RemoteException, MJSException {
                        return TaskAccessProxy.this.getRemoteObject().getInputData(this.getDataStore(), uuidArray, this.getCredentialProvider());
                    }
                });
            }
        });
        return this.getLargeOutputsFromDataStore(largeDataArray);
    }

    @Override
    public LargeData[] getMLFunction(AuthorisationContext authorisationContext, final Uuid[] uuidArray) throws AuthorisationFailedException, RemoteException, MJSException {
        LargeData[] largeDataArray = authorisationContext.invokeWithAuth(new InvocationWithAuth<LargeData[]>(authorisationContext.getCurrentUser()){

            @Override
            public LargeData[] invoke() throws RemoteException, MJSException {
                return TaskAccessProxy.this.getInvokeAndRetryWithDataStore(new DistcompAccessProxy.InvocationAndRetryWithDataStore<LargeData[]>(){

                    @Override
                    public LargeData[] invoke() throws RemoteException, MJSException {
                        return TaskAccessProxy.this.getRemoteObject().getMLFunction(this.getDataStore(), uuidArray, this.getCredentialProvider());
                    }
                });
            }
        });
        return this.getLargeOutputsFromDataStore(largeDataArray);
    }

    @Override
    public LargeData[] getOutputData(AuthorisationContext authorisationContext, final Uuid[] uuidArray) throws AuthorisationFailedException, RemoteException, MJSException {
        LargeData[] largeDataArray = authorisationContext.invokeWithAuth(new InvocationWithAuth<LargeData[]>(authorisationContext.getCurrentUser()){

            @Override
            public LargeData[] invoke() throws RemoteException, MJSException {
                return TaskAccessProxy.this.getInvokeAndRetryWithDataStore(new DistcompAccessProxy.InvocationAndRetryWithDataStore<LargeData[]>(){

                    @Override
                    public LargeData[] invoke() throws RemoteException, MJSException {
                        return TaskAccessProxy.this.getRemoteObject().getOutputData(this.getDataStore(), uuidArray, this.getCredentialProvider());
                    }
                });
            }
        });
        return this.getLargeOutputsFromDataStore(largeDataArray);
    }

    @Override
    public void setCaptureCommandWindowOutput(AuthorisationContext authorisationContext, final Uuid[] uuidArray, final boolean[] blArray) throws AuthorisationFailedException, RemoteException, MJSException {
        authorisationContext.invokeWithAuth(new InvocationWithAuth<Object>(authorisationContext.getCurrentUser()){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                TaskAccessProxy.this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

                    @Override
                    public Object invoke() throws MJSException, RemoteException {
                        TaskAccessProxy.this.getRemoteObject().setCaptureCommandWindowOutput(uuidArray, blArray, this.getCredentialProvider());
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public void setInputData(AuthorisationContext authorisationContext, final Uuid[] uuidArray, LargeData[] largeDataArray) throws AuthorisationFailedException, RemoteException, MJSException {
        final TransferableData[] transferableDataArray = this.putLargeInputsInDataStore(largeDataArray);
        authorisationContext.invokeWithAuth(new InvocationWithAuth<Object>(authorisationContext.getCurrentUser()){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                TaskAccessProxy.this.setInvokeAndRetryWithDataStore(new DistcompAccessProxy.InvocationAndRetryWithDataStore<Object>(){

                    @Override
                    public Object invoke() throws RemoteException, MJSException {
                        TaskAccessProxy.this.getRemoteObject().setInputData(uuidArray, transferableDataArray, this.getCredentialProvider());
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public void setLogLevel(AuthorisationContext authorisationContext, final Uuid[] uuidArray, final int[] nArray) throws AuthorisationFailedException, RemoteException, MJSException {
        authorisationContext.invokeWithAuth(new InvocationWithAuth<Object>(authorisationContext.getCurrentUser()){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                TaskAccessProxy.this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

                    @Override
                    public Object invoke() throws MJSException, RemoteException {
                        TaskAccessProxy.this.getRemoteObject().setLogLevel(uuidArray, nArray, this.getCredentialProvider());
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public void setMLFunctionName(AuthorisationContext authorisationContext, final Uuid[] uuidArray, final String[] stringArray) throws AuthorisationFailedException, RemoteException, MJSException {
        authorisationContext.invokeWithAuth(new InvocationWithAuth<Object>(authorisationContext.getCurrentUser()){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                TaskAccessProxy.this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

                    @Override
                    public Object invoke() throws MJSException, RemoteException {
                        TaskAccessProxy.this.getRemoteObject().setMLFunctionName(uuidArray, stringArray, this.getCredentialProvider());
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public void setMLFunction(AuthorisationContext authorisationContext, final Uuid[] uuidArray, LargeData[] largeDataArray) throws AuthorisationFailedException, RemoteException, MJSException {
        final TransferableData[] transferableDataArray = this.putLargeInputsInDataStore(largeDataArray);
        authorisationContext.invokeWithAuth(new InvocationWithAuth<Object>(authorisationContext.getCurrentUser()){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                TaskAccessProxy.this.setInvokeAndRetryWithDataStore(new DistcompAccessProxy.InvocationAndRetryWithDataStore<Object>(){

                    @Override
                    public Object invoke() throws RemoteException, MJSException {
                        TaskAccessProxy.this.getRemoteObject().setMLFunction(uuidArray, transferableDataArray, this.getCredentialProvider());
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public void setMaximumNumberOfRetries(AuthorisationContext authorisationContext, final Uuid[] uuidArray, final int[] nArray) throws AuthorisationFailedException, RemoteException, MJSException {
        authorisationContext.invokeWithAuth(new InvocationWithAuth<Object>(authorisationContext.getCurrentUser()){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                TaskAccessProxy.this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

                    @Override
                    public Object invoke() throws MJSException, RemoteException {
                        TaskAccessProxy.this.getRemoteObject().setMaximumNumberOfRetries(uuidArray, nArray, this.getCredentialProvider());
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public void setNumOutArgs(AuthorisationContext authorisationContext, final Uuid[] uuidArray, final int[] nArray) throws AuthorisationFailedException, RemoteException, MJSException {
        authorisationContext.invokeWithAuth(new InvocationWithAuth<Object>(authorisationContext.getCurrentUser()){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                TaskAccessProxy.this.invokeAndRetry(new DistcompAccessProxy.InvocationAndRetry(){

                    @Override
                    public Object invoke() throws MJSException, RemoteException {
                        TaskAccessProxy.this.getRemoteObject().setNumOutArgs(uuidArray, nArray, this.getCredentialProvider());
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public void submitResult(AuthorisationContext authorisationContext, final Uuid[] uuidArray, LargeData[] largeDataArray, byte[][] byArray, String[] stringArray, String[] stringArray2, LargeData[] largeDataArray2) throws RemoteException, MJSException {
        final TransferableData[] transferableDataArray = this.putLargeInputsInDataStore(largeDataArray);
        final TransferableData[] transferableDataArray2 = this.appendLargeInputsToDataStore(largeDataArray2);
        final byte[][] byArray2 = byArray == null ? (Object)new byte[uuidArray.length][] : byArray;
        final String[] stringArray3 = stringArray == null ? new String[uuidArray.length] : stringArray;
        final String[] stringArray4 = stringArray2 == null ? new String[uuidArray.length] : stringArray2;
        authorisationContext.invokeWithAuth(new InvocationWithAuth<Object>(authorisationContext.getCurrentUser()){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                TaskAccessProxy.this.setInvokeAndRetryWithDataStore(new DistcompAccessProxy.InvocationAndRetryWithDataStore<Object>(){

                    @Override
                    public Object invoke() throws RemoteException, MJSException {
                        TaskAccessProxy.this.getRemoteObject().submitResult(uuidArray, transferableDataArray, byArray2, stringArray3, stringArray4, transferableDataArray2, this.getCredentialProvider());
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Override
    protected void updateDistcompProxy() throws RemoteException, MJSException {
        TaskAccessProxy taskAccessProxy = (TaskAccessProxy)this.fJobManager.getTaskAccess();
        Object object = taskAccessProxy.getSerializedProxy();
        this.setSerializedProxy(object);
    }

    private final TaskAccessRemote getRemoteObject() throws DistcompProxy.DeserializeProxyException {
        return (TaskAccessRemote)this.getSerializedProxy();
    }
}

