/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreBackedDataSender;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.storage.CredentialStorageException;
import com.mathworks.toolbox.distcomp.storage.StorageCache;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.workunit.DataAccessor;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccess;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccessImpl;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccessProxy;
import com.mathworks.toolbox.distcomp.workunit.Job;
import com.mathworks.toolbox.distcomp.workunit.JobAccessProxy;
import com.mathworks.toolbox.distcomp.workunit.JobAccessRemote;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.JobInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnit;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitAccessImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitInfo;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.jini.id.Uuid;

public class JobAccessImpl
extends WorkUnitAccessImpl
implements JobAccessRemote {
    public JobAccessImpl(long l, StorageCache storageCache, String string, JobManagerProxy jobManagerProxy, AuthorisationModule authorisationModule, ExporterFactory exporterFactory) throws ExportException, DistcompProxy.SerializeProxyException {
        super(l, storageCache, string, jobManagerProxy, authorisationModule, exporterFactory);
    }

    @Override
    protected DistcompAccessProxy createProxy(DistcompAccess distcompAccess, JobManagerProxy jobManagerProxy) throws DistcompProxy.SerializeProxyException {
        return new JobAccessProxy((JobAccessRemote)distcompAccess, this.fMinTransferUsingDataStore, jobManagerProxy);
    }

    @Override
    public Uuid[] createTask(final Uuid[] uuidArray, final TaskInfo[] taskInfoArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        return (Uuid[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            private Uuid[] iCreatedTasks;
            {
                super(uuidArray3);
                this.iCreatedTasks = new Uuid[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                this.iCreatedTasks[n] = ((Job)workUnit).createTask(taskInfoArray[n]);
            }

            @Override
            protected Object getReturnValue() {
                return this.iCreatedTasks;
            }
        });
    }

    @Override
    public String[][] getAuthorisedUsers(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[][])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            String[][] iGetAuthorisedUsers;
            {
                super(uuidArray3);
                this.iGetAuthorisedUsers = new String[uuidArray.length][];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetAuthorisedUsers[n] = workUnit.getAuthorisedUsers();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetAuthorisedUsers;
            }
        });
    }

    @Override
    public LargeData[] getFileDepData(DataStore dataStore, Uuid[] uuidArray, CredentialProviderLocal credentialProviderLocal) throws RemoteException, MJSException {
        DataStoreBackedDataSender<JobImpl> dataStoreBackedDataSender = new DataStoreBackedDataSender<JobImpl>(dataStore, this.fMinTransferUsingDataStore);
        List<JobImpl> list = this.readJobs(uuidArray);
        return dataStoreBackedDataSender.transferData(list, this.createFileDepDataAccessor(credentialProviderLocal));
    }

    private DataAccessor<JobImpl> createFileDepDataAccessor(final CredentialProviderLocal credentialProviderLocal) {
        return new DataAccessor<JobImpl>(){

            @Override
            public void doCredentialCheck(JobImpl jobImpl) throws AuthorisationFailedException, CredentialStorageException {
                JobAccessImpl.this.checkCredentials(jobImpl, credentialProviderLocal);
            }

            @Override
            public int getDataSize(JobImpl jobImpl) {
                return jobImpl.getFileDepDataSize();
            }

            @Override
            public byte[] getDataDirect(JobImpl jobImpl) throws MJSException {
                return jobImpl.getFileDepData();
            }

            @Override
            public void getDataViaStream(JobImpl jobImpl, OutputStream outputStream, int n) throws MJSException {
                jobImpl.getFileDepData(outputStream, n);
            }
        };
    }

    @Override
    public String[][] getFileDepPathList(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[][])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            String[][] iGetFileDepPathList;
            {
                super(uuidArray3);
                this.iGetFileDepPathList = new String[uuidArray.length][];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetFileDepPathList[n] = ((Job)workUnit).getFileDepPathList();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetFileDepPathList;
            }
        });
    }

    @Override
    public LargeData[] getJobScopeData(DataStore dataStore, Uuid[] uuidArray, CredentialProviderLocal credentialProviderLocal) throws RemoteException, MJSException {
        DataStoreBackedDataSender<JobImpl> dataStoreBackedDataSender = new DataStoreBackedDataSender<JobImpl>(dataStore, this.fMinTransferUsingDataStore);
        List<JobImpl> list = this.readJobs(uuidArray);
        return dataStoreBackedDataSender.transferData(list, this.createJobScopeDataAccessor(credentialProviderLocal));
    }

    private DataAccessor<JobImpl> createJobScopeDataAccessor(final CredentialProviderLocal credentialProviderLocal) {
        return new DataAccessor<JobImpl>(){

            @Override
            public void doCredentialCheck(JobImpl jobImpl) throws AuthorisationFailedException, CredentialStorageException {
                JobAccessImpl.this.checkCredentials(jobImpl, credentialProviderLocal);
            }

            @Override
            public int getDataSize(JobImpl jobImpl) {
                return jobImpl.getJobScopeDataSize();
            }

            @Override
            public byte[] getDataDirect(JobImpl jobImpl) throws MJSException {
                return jobImpl.getJobScopeData();
            }

            @Override
            public void getDataViaStream(JobImpl jobImpl, OutputStream outputStream, int n) throws MJSException {
                jobImpl.getJobScopeData(outputStream, n);
            }
        };
    }

    @Override
    public int[] getMATLABExecutionMode(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (int[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            int[] iMATLABExecutionModes;
            {
                super(uuidArray3);
                this.iMATLABExecutionModes = new int[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iMATLABExecutionModes[n] = ((Job)workUnit).getMATLABExecutionMode();
            }

            @Override
            protected Object getReturnValue() {
                return this.iMATLABExecutionModes;
            }
        });
    }

    @Override
    public int[] getMaxWorkers(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (int[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            int[] iGetMaxWorkers;
            {
                super(uuidArray3);
                this.iGetMaxWorkers = new int[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetMaxWorkers[n] = ((Job)workUnit).getMaxWorkers();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetMaxWorkers;
            }
        });
    }

    @Override
    public int[] getMinWorkers(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (int[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            int[] iGetMinWorkers;
            {
                super(uuidArray3);
                this.iGetMinWorkers = new int[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetMinWorkers[n] = ((Job)workUnit).getMinWorkers();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetMinWorkers;
            }
        });
    }

    @Override
    public String[][] getPathList(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[][])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            String[][] iGetPathList;
            {
                super(uuidArray3);
                this.iGetPathList = new String[uuidArray.length][];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetPathList[n] = ((Job)workUnit).getPathList();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetPathList;
            }
        });
    }

    @Override
    public byte[][] getProductList(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (byte[][])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            byte[][] iGetProductList;
            {
                super(uuidArray3);
                this.iGetProductList = new byte[uuidArray.length][];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetProductList[n] = ((Job)workUnit).getProductList();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetProductList;
            }
        });
    }

    @Override
    public Date[] getSubmitTime(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (Date[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            Date[] iSubmitTimes;
            {
                super(uuidArray3);
                this.iSubmitTimes = new Date[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iSubmitTimes[n] = ((Job)workUnit).getSubmitTime();
            }

            @Override
            protected Object getReturnValue() {
                return this.iSubmitTimes;
            }
        });
    }

    @Override
    public String[] getTag(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            String[] iTags;
            {
                super(uuidArray3);
                this.iTags = new String[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iTags[n] = ((Job)workUnit).getTag();
            }

            @Override
            protected Object getReturnValue() {
                return this.iTags;
            }
        });
    }

    @Override
    public String[] getApiTag(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            String[] iApiTags;
            {
                super(uuidArray3);
                this.iApiTags = new String[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) {
                this.iApiTags[n] = ((Job)workUnit).getApiTag();
            }

            @Override
            protected Object getReturnValue() {
                return this.iApiTags;
            }
        });
    }

    @Override
    public Uuid[][] getTasks(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (Uuid[][])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            Uuid[][] iGetTasks;
            {
                super(uuidArray3);
                this.iGetTasks = new Uuid[uuidArray.length][];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetTasks[n] = ((Job)workUnit).getTasks();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetTasks;
            }
        });
    }

    @Override
    public Uuid[][][] getTasks(final Uuid[] uuidArray, final int[][] nArray) throws RemoteException, MJSException {
        return (Uuid[][][])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            Uuid[][][] iGetTasks;
            {
                super(uuidArray3);
                this.iGetTasks = new Uuid[uuidArray.length][][];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetTasks[n] = ((Job)workUnit).getTasks(nArray[n]);
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetTasks;
            }
        });
    }

    @Override
    public String[] getUserName(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            String[] iGetUserName;
            {
                super(uuidArray3);
                this.iGetUserName = new String[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetUserName[n] = workUnit.getUserName();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetUserName;
            }
        });
    }

    @Override
    public WorkUnitInfo[] getWorkUnitInfoSmallItems(final Uuid[] uuidArray) throws MJSException {
        return (WorkUnitInfo[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            WorkUnitInfo[] iGetWorkUnitInfo;
            {
                super(uuidArray3);
                this.iGetWorkUnitInfo = new JobInfo[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetWorkUnitInfo[n] = workUnit.getWorkUnitInfo();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetWorkUnitInfo;
            }
        });
    }

    @Override
    public WorkUnitInfo[] getWorkUnitInfo(DataStore dataStore, final Uuid[] uuidArray, CredentialProviderLocal credentialProviderLocal) throws RemoteException, MJSException {
        WorkUnitInfo[] workUnitInfoArray = (JobInfo[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            WorkUnitInfo[] iJobInfos;
            {
                super(uuidArray3);
                this.iJobInfos = new JobInfo[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) {
                this.iJobInfos[n] = workUnit.getWorkUnitInfo();
            }

            @Override
            protected Object getReturnValue() {
                return this.iJobInfos;
            }
        });
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.createFileDepDataAccessor(credentialProviderLocal));
        arrayList.add(this.createJobScopeDataAccessor(credentialProviderLocal));
        DataStoreBackedDataSender<JobImpl> dataStoreBackedDataSender = new DataStoreBackedDataSender<JobImpl>(dataStore, this.fMinTransferUsingDataStore);
        List<JobImpl> list = this.readJobs(uuidArray);
        TransferableData[][] transferableDataArray = dataStoreBackedDataSender.transferData(list, arrayList);
        for (int i = 0; i < uuidArray.length; ++i) {
            ((JobInfo)workUnitInfoArray[i]).setFileDepData(transferableDataArray[i][0]);
            ((JobInfo)workUnitInfoArray[i]).setJobScopeData(transferableDataArray[i][1]);
        }
        return workUnitInfoArray;
    }

    @Override
    public boolean[] isRestartWorker(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (boolean[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            boolean[] iGetRestartWorker;
            {
                super(uuidArray3);
                this.iGetRestartWorker = new boolean[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetRestartWorker[n] = ((Job)workUnit).isRestartWorker();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetRestartWorker;
            }
        });
    }

    @Override
    public void setAuthorisedUsers(Uuid[] uuidArray, final String[][] stringArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                for (String string : stringArray[n]) {
                    JobAccessImpl.this.checkUserExists(string);
                }
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Job)workUnit).setAuthorisedUsers(stringArray[n]);
            }
        });
    }

    @Override
    public void setFileDepData(Uuid[] uuidArray, final TransferableData[] transferableDataArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((JobImpl)workUnit).setFileDepDataItem(transferableDataArray[n]);
            }
        });
    }

    @Override
    public void setFileDepPathList(Uuid[] uuidArray, final String[][] stringArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Job)workUnit).setFileDepPathList(stringArray[n]);
            }
        });
    }

    @Override
    public void setJobScopeData(Uuid[] uuidArray, final TransferableData[] transferableDataArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((JobImpl)workUnit).setJobScopeDataItem(transferableDataArray[n]);
            }
        });
    }

    @Override
    public void setMATLABExecutionMode(Uuid[] uuidArray, final int[] nArray) throws RemoteException, MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                ((Job)workUnit).setMATLABExecutionMode(nArray[n]);
            }
        });
    }

    @Override
    public void setMaxWorkers(Uuid[] uuidArray, final int[] nArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Job)workUnit).setMaxWorkers(nArray[n]);
            }
        });
    }

    @Override
    public void setMinWorkers(Uuid[] uuidArray, final int[] nArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Job)workUnit).setMinWorkers(nArray[n]);
            }
        });
    }

    @Override
    public void setPathList(Uuid[] uuidArray, final String[][] stringArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Job)workUnit).setPathList(stringArray[n]);
            }
        });
    }

    @Override
    public void setProductList(Uuid[] uuidArray, final byte[][] byArray) throws RemoteException, MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                ((Job)workUnit).setProductList(byArray[n]);
            }
        });
    }

    @Override
    public void setRestartWorker(Uuid[] uuidArray, final boolean[] blArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Job)workUnit).setRestartWorker(blArray[n]);
            }
        });
    }

    @Override
    public void setTag(Uuid[] uuidArray, final String[] stringArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Job)workUnit).setTag(stringArray[n]);
            }
        });
    }

    @Override
    public void setApiTag(Uuid[] uuidArray, final String[] stringArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Job)workUnit).setApiTag(stringArray[n]);
            }
        });
    }

    @Override
    public void setUserName(Uuid[] uuidArray, final String[] stringArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkUserExists(stringArray[n]);
                JobAccessImpl.this.checkCredentialsOnlyOwner(workUnit, credentialProviderLocal);
                ((Job)workUnit).setUserName(stringArray[n]);
            }
        });
    }

    @Override
    public void setWorkUnitInfoSmallItems(Uuid[] uuidArray, WorkUnitInfo[] workUnitInfoArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        final JobInfo[] jobInfoArray = (JobInfo[])workUnitInfoArray;
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                workUnit.setWorkUnitInfoSmallItems(jobInfoArray[n]);
            }
        });
    }

    @Override
    public void setWorkUnitInfo(Uuid[] uuidArray, WorkUnitInfo[] workUnitInfoArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        final JobInfo[] jobInfoArray = (JobInfo[])workUnitInfoArray;
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                workUnit.setWorkUnitInfo(jobInfoArray[n]);
            }
        });
    }

    @Override
    public void submit(Uuid[] uuidArray, final Uuid[][] uuidArray2, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                JobAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Job)workUnit).submit(uuidArray2[n]);
            }
        });
    }

    private List<JobImpl> readJobs(Uuid[] uuidArray) throws WorkUnitNotFoundException {
        ArrayList<JobImpl> arrayList = new ArrayList<JobImpl>(uuidArray.length);
        for (Uuid uuid : uuidArray) {
            arrayList.add((JobImpl)this.fStorage.readWorkUnit(uuid));
        }
        return arrayList;
    }
}

