/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.sessiontracking;

import com.mathworks.toolbox.distcomp.worker.sessiontracking.LifecycleEventType;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.LifecycleReporter;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.Logging;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.TaskTrackable;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.WorkerLifecycleEventTypes;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.WorkerTrackable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class LifecycleTracker {
    private final ScheduledExecutorService fHeartbeatExecutor;
    private final LifecycleReporter fLifecycleReporter;
    private final long fWorkerHeartbeatDelay;
    private final long fTaskHeartbeatDelay;
    private ScheduledFuture<?> fWorkerHeartbeatFuture;
    private WorkerTrackable fCurrentWorkerTrackable = null;
    private ScheduledFuture<?> fTaskHeartbeatFuture;
    private TaskTrackable fCurrentTaskTrackable = null;

    public LifecycleTracker(LifecycleReporter lifecycleReporter, long l, long l2, ScheduledExecutorService scheduledExecutorService) {
        this.fLifecycleReporter = lifecycleReporter;
        this.fWorkerHeartbeatDelay = l;
        this.fTaskHeartbeatDelay = l2;
        this.fHeartbeatExecutor = scheduledExecutorService;
    }

    public LifecycleTracker(LifecycleReporter lifecycleReporter, long l, long l2) {
        this.fLifecycleReporter = lifecycleReporter;
        this.fWorkerHeartbeatDelay = l;
        this.fTaskHeartbeatDelay = l2;
        this.fHeartbeatExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public void workerStarted(WorkerTrackable workerTrackable) {
        if (this.fCurrentWorkerTrackable != null) {
            throw new IllegalStateException("logWorkerStopped has not been called.");
        }
        this.fCurrentWorkerTrackable = workerTrackable;
        this.safeReportLifecycleEvent(this.fCurrentWorkerTrackable, WorkerLifecycleEventTypes.STARTED);
        this.startWorkerRunningHeartbeat();
    }

    public void workerStopped(WorkerTrackable workerTrackable) {
        if (!workerTrackable.equals(this.fCurrentWorkerTrackable)) {
            throw new IllegalStateException("logWorkerStarted has not been called with this token.");
        }
        this.stopWorkerRunningHeartbeat();
        this.safeReportLifecycleEvent(this.fCurrentWorkerTrackable, WorkerLifecycleEventTypes.STOPPED);
        this.fCurrentWorkerTrackable = null;
    }

    public void taskStarted(TaskTrackable taskTrackable) {
        if (this.fCurrentWorkerTrackable == null) {
            throw new IllegalStateException("logWorkerStarted has not been called.");
        }
        if (this.fCurrentTaskTrackable != null) {
            throw new IllegalStateException("logTaskStopped has not been called.");
        }
        this.fCurrentTaskTrackable = taskTrackable;
        this.safeReportLifecycleEvent(this.fCurrentWorkerTrackable, this.fCurrentTaskTrackable, WorkerLifecycleEventTypes.STARTED);
        this.startTaskRunningHeartbeat();
    }

    public void taskStopped(TaskTrackable taskTrackable) {
        if (this.fCurrentWorkerTrackable == null) {
            throw new IllegalStateException("logWorkerStarted has not been called.");
        }
        if (!taskTrackable.equals(this.fCurrentTaskTrackable)) {
            throw new IllegalStateException("logTaskStarted has not been called with this task token.");
        }
        this.stopTaskRunningHeartbeat();
        this.safeReportLifecycleEvent(this.fCurrentWorkerTrackable, this.fCurrentTaskTrackable, WorkerLifecycleEventTypes.STOPPED);
        this.fCurrentTaskTrackable = null;
    }

    private void startWorkerRunningHeartbeat() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LifecycleTracker.this.safeReportLifecycleEvent(LifecycleTracker.this.fCurrentWorkerTrackable, WorkerLifecycleEventTypes.RUNNING);
            }
        };
        this.fWorkerHeartbeatFuture = this.scheduleHeartBeat(runnable, this.fWorkerHeartbeatDelay);
    }

    private void stopWorkerRunningHeartbeat() {
        this.stopHeartBeat(this.fWorkerHeartbeatFuture);
        this.fWorkerHeartbeatFuture = null;
    }

    private void startTaskRunningHeartbeat() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LifecycleTracker.this.safeReportLifecycleEvent(LifecycleTracker.this.fCurrentWorkerTrackable, LifecycleTracker.this.fCurrentTaskTrackable, WorkerLifecycleEventTypes.RUNNING);
            }
        };
        this.fTaskHeartbeatFuture = this.scheduleHeartBeat(runnable, this.fTaskHeartbeatDelay);
    }

    private void stopTaskRunningHeartbeat() {
        this.stopHeartBeat(this.fTaskHeartbeatFuture);
        this.fTaskHeartbeatFuture = null;
    }

    private ScheduledFuture<?> scheduleHeartBeat(Runnable runnable, long l) {
        long l2 = l;
        long l3 = l;
        return this.fHeartbeatExecutor.scheduleWithFixedDelay(runnable, l2, l3, TimeUnit.SECONDS);
    }

    private void stopHeartBeat(ScheduledFuture<?> scheduledFuture) {
        boolean bl = false;
        scheduledFuture.cancel(bl);
    }

    private void safeReportLifecycleEvent(WorkerTrackable workerTrackable, LifecycleEventType lifecycleEventType) {
        block2: {
            try {
                this.fLifecycleReporter.reportLifecycleEvent(workerTrackable, lifecycleEventType);
            }
            catch (Throwable throwable) {
                Logging.LOGGER.log(Level.ALL, "Exception while reporting " + lifecycleEventType + " lifecycle event.", throwable);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Unexpected exception from LifecycleReporter");
            }
        }
    }

    private void safeReportLifecycleEvent(WorkerTrackable workerTrackable, TaskTrackable taskTrackable, LifecycleEventType lifecycleEventType) {
        block2: {
            try {
                this.fLifecycleReporter.reportLifecycleEvent(workerTrackable, taskTrackable, lifecycleEventType);
            }
            catch (Throwable throwable) {
                Logging.LOGGER.log(Level.ALL, "Exception while reporting " + lifecycleEventType + " lifecycle event.", throwable);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Unexpected exception from LifecycleReporter");
            }
        }
    }
}

