/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ResourceBundleUtilities {
    private static final Map<Package, ResourceBundleUtilities> fUtilMap = new HashMap<Package, ResourceBundleUtilities>();
    private final ResourceBundle fBundle;
    private Set<String> fKeys;

    private ResourceBundleUtilities(Package package_) {
        this.fBundle = ResourceBundleUtilities.getResourceBundle(package_);
    }

    public static synchronized ResourceBundleUtilities getInstance(Package package_) {
        assert (package_ != null) : "resourcePackage must not be null.";
        ResourceBundleUtilities resourceBundleUtilities = fUtilMap.get(package_);
        if (resourceBundleUtilities == null) {
            resourceBundleUtilities = new ResourceBundleUtilities(package_);
            fUtilMap.put(package_, resourceBundleUtilities);
        }
        return resourceBundleUtilities;
    }

    public static synchronized ResourceBundleUtilities getInstance(Class clazz) {
        assert (clazz != null) : "resourcePackageClass must not be null.";
        return ResourceBundleUtilities.getInstance(clazz.getPackage());
    }

    public static synchronized ResourceBundleUtilities getInstance(Object object) {
        assert (object != null) : "localObject must not be null.";
        return ResourceBundleUtilities.getInstance(object.getClass());
    }

    public static String getMessage(ResourceBundleMessenger resourceBundleMessenger) {
        return ResourceBundleUtilities.getInstance(resourceBundleMessenger).getString(resourceBundleMessenger);
    }

    public String getString(ResourceBundleMessenger resourceBundleMessenger) {
        assert (resourceBundleMessenger != null) : "messenger may not be null.";
        if (resourceBundleMessenger.getParams() == null || resourceBundleMessenger.getResourceKey() == null) {
            return resourceBundleMessenger.getDefaultMessage();
        }
        try {
            return this.getString(resourceBundleMessenger.getResourceKey(), resourceBundleMessenger.getParams());
        }
        catch (MissingResourceException missingResourceException) {
            ResourceBundleUtilities resourceBundleUtilities = ResourceBundleUtilities.getInstance(resourceBundleMessenger);
            if (resourceBundleUtilities != this) {
                return resourceBundleUtilities.getString(resourceBundleMessenger);
            }
            throw missingResourceException;
        }
    }

    public String getString(Object object, Object ... objectArray) {
        assert (object != null) : "key may not be null.";
        assert (objectArray != null) : "params may not be null.";
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i] instanceof ResourceBundleMessenger ? ResourceBundleUtilities.getMessage((ResourceBundleMessenger)objectArray[i]) : objectArray[i];
        }
        String string = this.fBundle.getString(object.toString());
        return String.format(string, objectArray2);
    }

    public String getString(ResourceBundleKey resourceBundleKey) {
        assert (resourceBundleKey != null) : "bundleKey may not be null.";
        String string = resourceBundleKey.getClass().getName() + "." + resourceBundleKey.toString();
        try {
            return this.getString(string, new Object[0]);
        }
        catch (MissingResourceException missingResourceException) {
            return ResourceBundleUtilities.getInstance(resourceBundleKey).getString(string, new Object[0]);
        }
    }

    public boolean hasKey(Object object) {
        assert (object != null) : "key must be non-null.";
        if (this.fKeys == null) {
            this.fKeys = new HashSet<String>();
            Enumeration<String> enumeration = this.fBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                this.fKeys.add(enumeration.nextElement());
            }
        }
        return this.fKeys.contains(object.toString());
    }

    public static String getMessage(ResourceBundleKey resourceBundleKey) {
        return ResourceBundleUtilities.getInstance(resourceBundleKey).getString(resourceBundleKey);
    }

    private static ResourceBundle getResourceBundle(Package package_) {
        assert (package_ != null) : "resourcePackage cannot be null.";
        String string = package_.getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        String string3 = string + ".resources.RES_" + string2;
        return ResourceBundle.getBundle(string3);
    }

    public static interface ResourceBundleKey {
    }

    public static interface ResourceBundleMessenger {
        public Object getResourceKey();

        public Object[] getParams();

        public String getDefaultMessage();
    }
}

