/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.model.Constraint;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.model.PropertyInfo;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideRelatedPanel;
import com.mathworks.toolbox.distcomp.ui.widget.BooleanView;
import com.mathworks.toolbox.distcomp.ui.widget.CallbackView;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import com.mathworks.toolbox.distcomp.ui.widget.EnumView;
import com.mathworks.toolbox.distcomp.ui.widget.IntegerVectorView;
import com.mathworks.toolbox.distcomp.ui.widget.IntegerView;
import com.mathworks.toolbox.distcomp.ui.widget.StringVectorView;
import com.mathworks.toolbox.distcomp.ui.widget.StringView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class PropertiesPanel {
    private AbstractStyleGuidePanel fPanel;
    private List<ConfigurablePropertyView> fEditComponents = new ArrayList<ConfigurablePropertyView>();
    private static final Font PROPERTY_FONT = new Font("Monospaced", 0, 12);
    private static final Dimension MIN_SCROLL_PANE_SIZE = new Dimension(210, 100);
    private static final Dimension MAX_SCROLL_PANE_SIZE = new Dimension(Integer.MAX_VALUE, 100);

    public static PropertiesPanel createEditPropertiesPanel(List<? extends Property> list) {
        return new PropertiesPanel(list, false);
    }

    public static PropertiesPanel createReadOnlyPropertiesPanel(List<? extends Property> list) {
        return new PropertiesPanel(list, true);
    }

    /*
     * WARNING - void declaration
     */
    private PropertiesPanel(List<? extends Property> list, boolean bl) {
        void var6_8;
        Comparable<PropertyInfo> comparable;
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel(){

            @Override
            protected int getVerticalComponentSpacing() {
                return 15;
            }
        };
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : list) {
            comparable = property.getPropertyInfo();
            if (((PropertyInfo)comparable).isHidden()) continue;
            arrayList.add(property);
        }
        JComponent[][] jComponentArray = new JComponent[arrayList.size()][2];
        boolean i = false;
        while (var6_8 < arrayList.size()) {
            Object object;
            comparable = (Property)arrayList.get((int)var6_8);
            if (((Property)comparable).getPropertyInfo().isConfigurable() && !bl) {
                object = PropertiesPanel.createEditComponent(comparable);
                this.fEditComponents.add((ConfigurablePropertyView)object);
            } else {
                object = PropertiesPanel.createReadOnlyComponent(comparable);
            }
            jComponentArray[var6_8][0] = PropertiesPanel.createPropertyLabel(comparable);
            jComponentArray[var6_8][1] = PropertiesPanel.decorateComponent(comparable, (JComponent)object);
            ++var6_8;
        }
        styleGuidePanel.addLine(jComponentArray, 8, new double[]{0.4, 0.6});
        this.fPanel = new StyleGuideEmptyPanel();
        this.fPanel.addLine((JComponent)((Object)styleGuidePanel));
        this.fPanel.addLine(new JPanel(), 8);
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    public void commitEdit() {
        for (ConfigurablePropertyView configurablePropertyView : this.fEditComponents) {
            configurablePropertyView.commitEdit();
        }
    }

    private static JComponent createPropertyLabel(Property property) {
        MJLabel mJLabel = new MJLabel(property.getPropertyInfo().getName());
        mJLabel.setFont(PROPERTY_FONT);
        String string = property.getPropertyInfo().getDescription();
        if (string == null || string.isEmpty()) {
            return mJLabel;
        }
        StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(string, true);
        mJMultilineLabel.setBackground(styleGuideEmptyPanel.getBackground());
        mJMultilineLabel.setMaxWidth(100);
        mJMultilineLabel.setSize(mJMultilineLabel.getPreferredSize());
        mJMultilineLabel.setMinimumSize(mJMultilineLabel.getPreferredSize());
        mJMultilineLabel.setMaximumSize(mJMultilineLabel.getPreferredSize());
        styleGuideEmptyPanel.addLine((JComponent)mJMultilineLabel);
        styleGuideEmptyPanel.addLine((JComponent)mJLabel);
        styleGuideEmptyPanel.addLine(new JPanel(), 8);
        return styleGuideEmptyPanel;
    }

    private static JComponent decorateComponent(Property property, JComponent jComponent) {
        String string = property.getPropertyInfo().getDescription();
        StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
        JPanel jPanel = new JPanel();
        jPanel.setMaximumSize(new Dimension(100, 1));
        jPanel.setMinimumSize(new Dimension(100, 1));
        jPanel.setPreferredSize(new Dimension(100, 1));
        jPanel.setSize(100, 1);
        JPanel jPanel2 = new JPanel();
        jPanel2.setMaximumSize(new Dimension(10, 1));
        jPanel2.setMinimumSize(new Dimension(10, 1));
        jPanel2.setPreferredSize(new Dimension(10, 1));
        jPanel2.setSize(10, 1);
        styleGuideEmptyPanel.addLine((JComponent[][])new JComponent[][]{{jPanel, jComponent, jPanel2}}, 0, 1);
        if (string == null || string.isEmpty()) {
            return styleGuideEmptyPanel;
        }
        StyleGuideEmptyPanel styleGuideEmptyPanel2 = new StyleGuideEmptyPanel();
        styleGuideEmptyPanel2.addLine((JComponent)((Object)styleGuideEmptyPanel));
        styleGuideEmptyPanel2.addLine(new JPanel(), 8);
        return styleGuideEmptyPanel2;
    }

    public static JComponent createReadOnlyComponent(final Property property) {
        MJLabel mJLabel;
        StyleGuideRelatedPanel styleGuideRelatedPanel = new StyleGuideRelatedPanel();
        String string = property.getPropertyInfo().getName() + "ValueLabel";
        String string2 = property.getDisplayString();
        if (property.getPropertyInfo().getConstraint().getConstraintType().equals((Object)Constraint.PCTConstraint.CELLSTR)) {
            MJTextArea mJTextArea = new MJTextArea(string2);
            mJTextArea.setBackground(new JPanel().getBackground());
            mJTextArea.setEditable(false);
            mJTextArea.setName(string);
            MJScrollPane mJScrollPane = new MJScrollPane((Component)mJTextArea);
            mJScrollPane.setMaximumSize(MAX_SCROLL_PANE_SIZE);
            mJScrollPane.setMinimumSize(MIN_SCROLL_PANE_SIZE);
            mJScrollPane.setPreferredSize(MIN_SCROLL_PANE_SIZE);
            property.addPropertyChangeListener(new PropertyChangeListener((JTextArea)mJTextArea){
                final /* synthetic */ JTextArea val$textArea;
                {
                    this.val$textArea = jTextArea;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    final String string = property.getDisplayString();
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            val$textArea.setText(string);
                        }
                    });
                }
            });
            mJLabel = mJScrollPane;
        } else {
            MJLabel mJLabel2 = new MJLabel(string2);
            mJLabel2.setName(string);
            mJLabel2.setMinimumSize(new Dimension(200, (int)mJLabel2.getPreferredSize().getHeight()));
            property.addPropertyChangeListener(new PropertyChangeListener((JLabel)mJLabel2){
                final /* synthetic */ JLabel val$jLabel;
                {
                    this.val$jLabel = jLabel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    final String string = property.getDisplayString();
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            val$jLabel.setText(string);
                        }
                    });
                }
            });
            mJLabel = mJLabel2;
        }
        styleGuideRelatedPanel.addLine((JComponent)mJLabel);
        return styleGuideRelatedPanel;
    }

    public static ConfigurablePropertyView createEditComponent(Property property) {
        ConfigurablePropertyView configurablePropertyView = null;
        String string = property.getPropertyInfo().getName();
        switch (property.getPropertyInfo().getConstraint().getConstraintType()) {
            case STRING: {
                string = string + "Textfield";
                configurablePropertyView = new StringView(property, string);
                break;
            }
            case CELLSTR: {
                string = string + "TextArea";
                configurablePropertyView = new StringVectorView(property, string);
                break;
            }
            case LOGICALSCALAR: {
                string = string + "Combobox";
                configurablePropertyView = new BooleanView(property, string);
                break;
            }
            case POSITIVEINTSCALAR: {
                string = string + "Textfield";
                configurablePropertyView = new IntegerView(property, string);
                break;
            }
            case DATALOCATION: {
                string = string + "Textfield";
                configurablePropertyView = new StringView(property, string);
                break;
            }
            case CALLBACK: {
                string = string + "Textfield";
                configurablePropertyView = new CallbackView(property, string);
                break;
            }
            case NONEMPTYSTRING: {
                string = string + "Textfield";
                configurablePropertyView = new StringView(property, string);
                break;
            }
            case WORKERLIMITS: {
                string = string + "Textfield";
                configurablePropertyView = new IntegerVectorView(property, string);
                break;
            }
            case ENUM: {
                string = string + "Combobox";
                configurablePropertyView = new EnumView(property, string);
            }
        }
        return configurablePropertyView;
    }
}

