/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Destroyable;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.model.PropertyInfo;
import com.mathworks.toolbox.distcomp.ui.model.ValueBackedPropertyStorage;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.profile.EditPanel;
import com.mathworks.toolbox.distcomp.ui.profile.ValidationPanel;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import com.mathworks.toolbox.distcomp.ui.profile.model.PropertyInfoProvider;
import com.mathworks.toolbox.distcomp.ui.profile.model.SchedulerComponent;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationEventData;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationListener;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationManager;
import com.mathworks.toolbox.distcomp.ui.widget.LightBoxGlassPane;
import com.mathworks.toolbox.distcomp.ui.widget.PropertiesPanel;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public final class ProfileView
extends StyleGuideEmptyPanel
implements Destroyable,
PropertyChangeListener {
    private Profile fClusterProfile;
    private ProfileManager fProfileManager;
    private ValidationManager fValidationManager;
    private String fSchedulerType;
    private ValidationPanel fValidationPanel;
    private ValidationListener fValidationListener;
    private JLabel fNameLabel;
    private JComponent fReadOnlyView;
    private EditPanel fEditPanel;
    private static final String SUPPORTED_ON_ALL_SCHEDULERS = "All";
    private MJLabel fSchedulerTypeLabel;
    private JTabbedPane fTabbedPane;
    private static final int PROPERTIES_TAB_INDEX = 0;
    private static final int VALIDATION_TAB_INDEX = 1;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");

    public ProfileView(Profile profile, ProfileManager profileManager, ValidationManager validationManager) {
        this.fClusterProfile = profile;
        this.fValidationManager = validationManager;
        this.fProfileManager = profileManager;
        this.fSchedulerType = this.getSchedulerType();
        String string = this.fClusterProfile.getName();
        AbstractStyleGuidePanel abstractStyleGuidePanel = this.createNameSection(string, this.fSchedulerType);
        AbstractStyleGuidePanel abstractStyleGuidePanel2 = this.createMainSection();
        this.addLine((JComponent)((Object)abstractStyleGuidePanel));
        this.addLine((JComponent)((Object)abstractStyleGuidePanel2), 8);
        this.fNameLabel.setName("NameLabel");
        this.fSchedulerTypeLabel.setName("SchedulerTypeLabel");
        this.fTabbedPane.setName("ProfileViewTabbedPane");
    }

    private AbstractStyleGuidePanel createMainSection() {
        StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
        this.fReadOnlyView = ProfileView.createReadOnlyMode(this.getAllPropertiesList(), this.fSchedulerType);
        this.fEditPanel = new EditPanel(this.fReadOnlyView){
            private Map<Property, Property> iActualToValueBackedPropertiesMap;
            private Map<SectionInfo, PropertiesPanel> iSortedMapSectionInfoToPropertiesPanel;

            @Override
            public void handleEditButtonClicked() {
                this.iActualToValueBackedPropertiesMap = ProfileView.createActualToValueBackedPropertyMap(ProfileView.this.getAllPropertiesList());
                Collection<Property> collection = this.iActualToValueBackedPropertiesMap.values();
                List<Property> list = Arrays.asList(collection.toArray(new Property[collection.size()]));
                this.iSortedMapSectionInfoToPropertiesPanel = ProfileView.createSectionInfoPropertiesPanelMap(list, ProfileView.this.fSchedulerType);
                JComponent jComponent = ProfileView.createEditMode(this.iSortedMapSectionInfoToPropertiesPanel);
                this.setMainSection(jComponent);
            }

            @Override
            public void handleCancelButtonClicked() {
                this.iActualToValueBackedPropertiesMap.clear();
                this.iActualToValueBackedPropertiesMap = null;
                this.iSortedMapSectionInfoToPropertiesPanel.clear();
                this.iSortedMapSectionInfoToPropertiesPanel = null;
                this.setMainSection(ProfileView.this.fReadOnlyView);
            }

            @Override
            public void handleDoneButtonClicked() {
                for (PropertiesPanel stringArray2 : this.iSortedMapSectionInfoToPropertiesPanel.values()) {
                    stringArray2.commitEdit();
                }
                List<Property> list = this.getUpdatedProperties(PropertyInfoProvider.getInstance().getProfilePropertyInfoList(), this.iActualToValueBackedPropertiesMap);
                String[] stringArray = new String[list.size()];
                Object[] objectArray = new Object[list.size()];
                String[] stringArray2 = new String[list.size()];
                for (int list2 = 0; list2 < list.size(); ++list2) {
                    stringArray[list2] = ((Property)list.get(list2)).getPropertyInfo().getName();
                    objectArray[list2] = ((Property)list.get(list2)).getValue();
                    stringArray2[list2] = ((Property)list.get(list2)).getPropertyInfo().getConstraint().getConstraintType().toString();
                }
                List<Property> list2 = this.getUpdatedProperties(PropertyInfoProvider.getInstance().getSchedulerPropertyInfoList(ProfileView.this.getSchedulerType()), this.iActualToValueBackedPropertiesMap);
                String[] stringArray3 = new String[list2.size()];
                Object[] objectArray2 = new Object[list2.size()];
                String[] stringArray4 = new String[list2.size()];
                for (int list3 = 0; list3 < list2.size(); ++list3) {
                    stringArray3[list3] = list2.get(list3).getPropertyInfo().getName();
                    objectArray2[list3] = list2.get(list3).getValue();
                    stringArray4[list3] = list2.get(list3).getPropertyInfo().getConstraint().getConstraintType().toString();
                }
                List<Property> list3 = this.getUpdatedProperties(PropertyInfoProvider.getInstance().getProjectPropertyInfoList(), this.iActualToValueBackedPropertiesMap);
                String[] stringArray5 = new String[list3.size()];
                Object[] objectArray3 = new Object[list3.size()];
                String[] stringArray6 = new String[list3.size()];
                for (int i = 0; i < list3.size(); ++i) {
                    stringArray5[i] = list3.get(i).getPropertyInfo().getName();
                    objectArray3[i] = list3.get(i).getValue();
                    stringArray6[i] = list3.get(i).getPropertyInfo().getConstraint().getConstraintType().toString();
                }
                ProfileView.this.fProfileManager.setValues(ProfileView.this.fClusterProfile.getName(), stringArray, stringArray2, objectArray, ProfileView.this.fClusterProfile.getSchedulerComponent(), stringArray3, stringArray4, objectArray2, ProfileView.this.fClusterProfile.getProjectComponent(), stringArray5, stringArray6, objectArray3);
            }

            @Override
            void handleDoneSuccessful() {
                List list = ProfileView.this.getAllPropertiesList();
                ProfileView.this.fReadOnlyView = (JComponent)((Object)ProfileView.createReadOnlyMode(list, ProfileView.this.fSchedulerType));
                this.setMainSection(ProfileView.this.fReadOnlyView);
                this.iActualToValueBackedPropertiesMap.clear();
                this.iActualToValueBackedPropertiesMap = null;
                this.iSortedMapSectionInfoToPropertiesPanel.clear();
                this.iSortedMapSectionInfoToPropertiesPanel = null;
            }

            private List<Property> getUpdatedProperties(List<PropertyInfo> list, Map<Property, Property> map) {
                ArrayList<Property> arrayList = new ArrayList<Property>();
                block0: for (PropertyInfo propertyInfo : list) {
                    for (Property property : map.keySet()) {
                        Property property2 = map.get(property);
                        if (!propertyInfo.getName().equals(property.getPropertyInfo().getName()) || !propertyInfo.isConfigurable() || ProfileView.compareValues(property, property2)) continue;
                        arrayList.add(property2);
                        continue block0;
                    }
                }
                return arrayList;
            }
        };
        this.fValidationPanel = new ValidationPanel(this.fClusterProfile, this.fSchedulerType, this.fValidationManager);
        this.fValidationManager.addValidationListener(this.fValidationPanel);
        this.fTabbedPane = new JTabbedPane();
        this.fTabbedPane.addTab(sRes.getString("ProfileView.PropertiesTab"), (Component)((Object)this.fEditPanel));
        this.fTabbedPane.addTab(sRes.getString("ProfileView.ValidationTab"), (Component)((Object)this.fValidationPanel));
        this.fValidationListener = new ValidationListener(){

            @Override
            public void handleValidationStarted(final ValidationEventData validationEventData) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (validationEventData.getProfileName().equals(ProfileView.this.fClusterProfile.getName())) {
                            ProfileView.this.fTabbedPane.setSelectedIndex(1);
                            Window window = SwingUtilities.windowForComponent((Component)((Object)ProfileView.this.fValidationPanel));
                            LightBoxGlassPane lightBoxGlassPane = new LightBoxGlassPane((JComponent)((Object)ProfileView.this.fValidationPanel));
                            if (window instanceof JDialog || window instanceof JFrame) {
                                ((RootPaneContainer)((Object)window)).setGlassPane(lightBoxGlassPane);
                            }
                            lightBoxGlassPane.setVisible(true);
                        }
                    }
                });
            }

            @Override
            public void handleValidationFinished(final ValidationEventData validationEventData) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Window window;
                        if (validationEventData.getProfileName().equals(ProfileView.this.fClusterProfile.getName()) && ((window = SwingUtilities.windowForComponent((Component)((Object)ProfileView.this.fValidationPanel))) instanceof JDialog || window instanceof JFrame)) {
                            ((RootPaneContainer)((Object)window)).getGlassPane().setVisible(false);
                        }
                    }
                });
            }

            @Override
            public void handleValidationStageUpdated(ValidationEventData validationEventData) {
            }
        };
        this.fValidationManager.addValidationListener(this.fValidationListener);
        styleGuideEmptyPanel.addLine(this.fTabbedPane, 8);
        return styleGuideEmptyPanel;
    }

    public void startEditing() {
        if (this.fTabbedPane.getSelectedIndex() != 0) {
            this.fTabbedPane.setSelectedIndex(0);
        }
        this.fEditPanel.showEditPanel();
    }

    void cancelEditing() {
        this.fEditPanel.cancelEditing();
    }

    private static boolean compareValues(Property property, Property property2) {
        Object object = property.getValue();
        Object object2 = property2.getValue();
        if (object.getClass().isArray() && object2.getClass().isArray()) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        return object.equals(object2);
    }

    private List<Property> getAllPropertiesList() {
        Property property = this.fClusterProfile.findProperty("Description");
        List<Property> list = this.getSchedulerComponentPropertyList();
        List<Property> list2 = this.getProjectComponentPropertyList();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(property);
        arrayList.addAll(list);
        String string = this.fSchedulerType;
        for (Property property2 : list2) {
            String string2 = property2.getPropertyInfo().getName();
            if (!ProfileView.isSupportedPropertyOnScheduler(string2, string)) continue;
            arrayList.add(property2);
        }
        return arrayList;
    }

    private static boolean isSupportedPropertyOnScheduler(String string, String string2) {
        String string3 = sRes.getString("ProjectComponent." + string + ".SchedulerSupport");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens() && !bl) {
            String string4 = stringTokenizer.nextToken().trim();
            bl = string4.equals(SUPPORTED_ON_ALL_SCHEDULERS) || string4.equals(string2);
        }
        return bl;
    }

    private List<Property> getSchedulerComponentPropertyList() {
        SchedulerComponent schedulerComponent = this.getSchedulerComponent();
        return schedulerComponent.getProperties();
    }

    private List<Property> getProjectComponentPropertyList() {
        String string = this.fClusterProfile.getProjectComponent();
        if (string.length() == 0) {
            return ProfileView.createProjectComponentList();
        }
        return this.fProfileManager.getProjectComponent(string).getProperties();
    }

    public static List<Property> createProjectComponentList() {
        List<PropertyInfo> list = PropertyInfoProvider.getInstance().getProjectPropertyInfoList();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (PropertyInfo propertyInfo : list) {
            Property property = new Property(new ValueBackedPropertyStorage(new DefaultValue()), propertyInfo);
            arrayList.add(property);
        }
        return arrayList;
    }

    private String getSchedulerType() {
        SchedulerComponent schedulerComponent = this.getSchedulerComponent();
        return schedulerComponent.getType();
    }

    private AbstractStyleGuidePanel createNameSection(String string, String string2) {
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        this.fNameLabel = new MJLabel(string);
        this.fNameLabel.setFont(this.fNameLabel.getFont().deriveFont(1, 14.0f));
        this.fSchedulerTypeLabel = new MJLabel(MessageFormat.format(sRes.getString("ProfileView.SchedulerTypeLabel"), string2));
        styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{this.fNameLabel, null, this.fSchedulerTypeLabel}}, 0, 1);
        return styleGuidePanel;
    }

    private void updateNameSection() {
        this.fNameLabel.setText(this.fClusterProfile.getName());
    }

    private static AbstractStyleGuidePanel createReadOnlyMode(List<Property> list, String string) {
        Map<String, List<Property>> map = ProfileView.getSectionMap(list);
        List<SectionInfo> list2 = ProfileView.createSortedSectionInfos(string, map);
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        for (SectionInfo sectionInfo : list2) {
            List<Property> list3 = map.get(sectionInfo.getName());
            Collections.sort(list3);
            AbstractStyleGuidePanel abstractStyleGuidePanel = (AbstractStyleGuidePanel)((Object)PropertiesPanel.createReadOnlyPropertiesPanel(list3).getComponent());
            ProfileView.addBorder(sectionInfo, abstractStyleGuidePanel);
            styleGuidePanel.addLine((JComponent)((Object)abstractStyleGuidePanel), 8);
        }
        styleGuidePanel.addLine(new JPanel(), 8);
        return styleGuidePanel;
    }

    private static JComponent createEditMode(Map<SectionInfo, PropertiesPanel> map) {
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        for (SectionInfo sectionInfo : map.keySet()) {
            PropertiesPanel propertiesPanel = map.get(sectionInfo);
            AbstractStyleGuidePanel abstractStyleGuidePanel = (AbstractStyleGuidePanel)((Object)propertiesPanel.getComponent());
            ProfileView.addBorder(sectionInfo, abstractStyleGuidePanel);
            styleGuidePanel.addLine((JComponent)((Object)abstractStyleGuidePanel), 8);
        }
        styleGuidePanel.addLine(new JPanel(), 8);
        return styleGuidePanel;
    }

    private static Map<SectionInfo, PropertiesPanel> createSectionInfoPropertiesPanelMap(List<Property> list, String string) {
        Map<String, List<Property>> map = ProfileView.getSectionMap(list);
        List<SectionInfo> list2 = ProfileView.createSortedSectionInfos(string, map);
        TreeMap<SectionInfo, PropertiesPanel> treeMap = new TreeMap<SectionInfo, PropertiesPanel>();
        for (SectionInfo sectionInfo : list2) {
            List<Property> list3 = map.get(sectionInfo.getName());
            Collections.sort(list3);
            PropertiesPanel propertiesPanel = PropertiesPanel.createEditPropertiesPanel(list3);
            treeMap.put(sectionInfo, propertiesPanel);
        }
        return treeMap;
    }

    private static Map<Property, Property> createActualToValueBackedPropertyMap(List<Property> list) {
        LinkedHashMap<Property, Property> linkedHashMap = new LinkedHashMap<Property, Property>();
        for (Property property : list) {
            Property property2 = new Property(new ValueBackedPropertyStorage(property.getValue()), property.getPropertyInfo());
            linkedHashMap.put(property, property2);
        }
        return linkedHashMap;
    }

    private static void addBorder(SectionInfo sectionInfo, AbstractStyleGuidePanel abstractStyleGuidePanel) {
        if (!sectionInfo.getTitle().isEmpty()) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(sectionInfo.getTitle().toUpperCase());
            abstractStyleGuidePanel.setBorder(titledBorder);
        }
    }

    private static List<SectionInfo> createSortedSectionInfos(String string, Map<String, List<Property>> map) {
        ArrayList<SectionInfo> arrayList = new ArrayList<SectionInfo>();
        for (String string2 : map.keySet()) {
            String string3 = string + ".PropertiesSection." + string2 + ".Title";
            String string4 = "";
            if (sRes.containsKey(string3)) {
                string4 = sRes.getString(string3);
            }
            int n = Integer.valueOf(sRes.getString(string + ".PropertiesSection." + string2 + ".Index"));
            arrayList.add(new SectionInfo(string2, string4, n));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static Map<String, List<Property>> getSectionMap(List<Property> list) {
        HashMap<String, List<Property>> hashMap = new HashMap<String, List<Property>>();
        for (Property property : list) {
            String string = property.getPropertyInfo().getSection();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            ((List)hashMap.get(string)).add(property);
        }
        return hashMap;
    }

    @Override
    public void destroy() {
        this.cancelEditing();
        this.fValidationManager.removeValidationListener(this.fValidationListener);
        this.fValidationManager.removeValidationListener(this.fValidationPanel);
        this.fValidationPanel.destroy();
        this.fValidationManager = null;
        this.fProfileManager = null;
        this.fClusterProfile = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() == null || !propertyChangeEvent.getNewValue().equals(this.fClusterProfile)) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("ProfileRenamed")) {
            this.updateNameSection();
        } else if (propertyChangeEvent.getPropertyName().equals("UpdateValues")) {
            this.fEditPanel.doneSuccessful();
        } else if (propertyChangeEvent.getPropertyName().equals("UpdateValuesErrored")) {
            this.fEditPanel.doneFailed();
        }
    }

    private SchedulerComponent getSchedulerComponent() {
        return this.fProfileManager.getSchedulerComponent(this.fClusterProfile.getSchedulerComponent());
    }

    public static class SectionInfo
    implements Comparable<SectionInfo> {
        private final String fName;
        private final String fTitle;
        private final int fIndex;

        public SectionInfo(String string, String string2, int n) {
            this.fName = string;
            this.fTitle = string2;
            this.fIndex = n;
        }

        public String getName() {
            return this.fName;
        }

        public String getTitle() {
            return this.fTitle;
        }

        public int getIndex() {
            return this.fIndex;
        }

        @Override
        public int compareTo(SectionInfo sectionInfo) {
            if (this.fIndex > sectionInfo.getIndex()) {
                return 1;
            }
            if (this.fIndex < sectionInfo.getIndex()) {
                return -1;
            }
            return 0;
        }
    }
}

