/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class MulticastTester {
    private static String fHostname;
    private MulticastSocket fSocket;
    private InetAddress fGroup;
    private int fPort;
    private boolean fKeepFromSelf;
    private Thread fListeningThread;
    private Thread fSendingThread;

    public MulticastTester(String string, int n) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            fHostname = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            fHostname = "Unknown host";
        }
        this.fKeepFromSelf = true;
        try {
            this.fGroup = InetAddress.getByName(string);
            this.fPort = n;
            this.fSocket = new MulticastSocket(this.fPort);
            this.fSocket.joinGroup(this.fGroup);
            this.fSocket.setTimeToLive(5);
            this.fSocket.setSoTimeout(1000);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getHostName() {
        return fHostname;
    }

    public MulticastSocket getSocket() {
        return this.fSocket;
    }

    public InetAddress getGroup() {
        return this.fGroup;
    }

    public int getPort() {
        return this.fPort;
    }

    public void startListeningThread() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = 0;
                try {
                    while (true) {
                        try {
                            String string = MulticastTester.this.receiveString();
                            if (MulticastTester.this.fKeepFromSelf || !MulticastTester.this.isMessageFromThisHost(string)) {
                                System.out.println(n++ + " : " + string);
                                MulticastTester.this.fKeepFromSelf = false;
                            }
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            // empty catch block
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Listening thread exiting");
                }
            }
        };
        if (this.fListeningThread == null) {
            this.fListeningThread = new Thread(runnable);
            this.fListeningThread.start();
        }
    }

    public void stopListeningThread() {
        if (this.fListeningThread != null) {
            this.fListeningThread.interrupt();
            this.fListeningThread = null;
        }
    }

    public void startSendingThread() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = 0;
                try {
                    while (true) {
                        MulticastTester.this.sendString(fHostname + " : " + n++);
                        Thread.sleep(5000L);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Sending thread exiting");
                }
            }
        };
        if (this.fSendingThread == null) {
            this.fSendingThread = new Thread(runnable);
            this.fSendingThread.start();
        }
    }

    public void stopSendingThread() {
        if (this.fSendingThread != null) {
            this.fSendingThread.interrupt();
            this.fSendingThread = null;
        }
    }

    public void sendString(String string) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.length(), this.fGroup, this.fPort);
        this.fSocket.send(datagramPacket);
    }

    public String receiveString() throws IOException {
        byte[] byArray = new byte[1000];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.fSocket.receive(datagramPacket);
        int n = 0;
        return new String(byArray, n, datagramPacket.getLength());
    }

    public boolean isMessageFromThisHost(String string) {
        int n = string.lastIndexOf(" : ");
        if (n <= 0) {
            return false;
        }
        String string2 = string.substring(0, n);
        return fHostname.equals(string2);
    }

    public static void main(String[] stringArray) {
        String string = "239.1.1.1";
        int n = 9999;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (stringArray.length > 1) {
            n = Integer.parseInt(stringArray[1]);
        }
        MulticastTester multicastTester = new MulticastTester(string, n);
        multicastTester.startListeningThread();
        multicastTester.startSendingThread();
    }
}

