/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.cli;

import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import com.mathworks.toolbox.distcomp.remote.CopyFromRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.CopyToRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.cli.CommandCreationErrorCode;
import com.mathworks.toolbox.distcomp.remote.cli.CommandFactory;
import com.mathworks.toolbox.distcomp.remote.cli.I18nCommandCreationException;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import java.io.File;
import java.util.List;

class CopyCommandFactory
implements CommandFactory<CopyCommand> {
    private static final String COPY_COMMAND_TYPE = "copy";
    private static final ParameterSet COMMAND_PARAMETERS = new ParameterSet(CopyParameter.LOCAL_FILE, CopyParameter.REMOTE_FILE, CopyParameter.FROM_REMOTE, CopyParameter.TO_REMOTE);

    CopyCommandFactory() {
    }

    @Override
    public CopyCommand createCommand(ParameterMap parameterMap, List<String> list) throws I18nCommandCreationException {
        String string = parameterMap.get(CopyParameter.LOCAL_FILE);
        if (string == null) {
            throw new CommandCreationLocalFileException();
        }
        File file = new File(string);
        String string2 = parameterMap.get(CopyParameter.REMOTE_FILE);
        if (string2 == null) {
            throw new CommandCreationRemoteFileException();
        }
        if (parameterMap.containsKey(CopyParameter.TO_REMOTE)) {
            if (parameterMap.containsKey(CopyParameter.FROM_REMOTE)) {
                throw new CommandCreationMultipleDirectionException();
            }
            return new CopyToRemoteCommand(file, string2);
        }
        if (parameterMap.containsKey(CopyParameter.FROM_REMOTE)) {
            return new CopyFromRemoteCommand(file, string2);
        }
        throw new CommandCreationNoDirectionException();
    }

    public static CopyCommand createCommand(CopyCommand copyCommand, String string) {
        File file = new File(copyCommand.getLocalFile().toString() + string);
        if (copyCommand instanceof CopyToRemoteCommand) {
            return new CopyToRemoteCommand(file, copyCommand.getRemoteFile());
        }
        if (copyCommand instanceof CopyFromRemoteCommand) {
            return new CopyFromRemoteCommand(file, copyCommand.getRemoteFile());
        }
        throw new UnsupportedOperationException("command is an unsupported " + copyCommand.getClass() + " not a " + CopyToRemoteCommand.class + " or a " + CopyFromRemoteCommand.class);
    }

    @Override
    public Class<CopyCommand> getCommandClass() {
        return CopyCommand.class;
    }

    @Override
    public String getCommandType() {
        return COPY_COMMAND_TYPE;
    }

    @Override
    public ParameterSet getParameterSet() {
        return COMMAND_PARAMETERS;
    }

    @Override
    public void setRemotePlatform(PathUtils.Platform platform) {
    }

    private static final class CommandCreationNoDirectionException
    extends I18nCommandCreationException {
        private static final Object[] OBJECTS = new Object[0];

        CommandCreationNoDirectionException() {
            super(CommandCreationErrorCode.CopyCommandFactoryNoDirection);
        }

        @Override
        protected Object[] getMessageArguments() {
            return OBJECTS;
        }
    }

    private static final class CommandCreationMultipleDirectionException
    extends I18nCommandCreationException {
        private static final Object[] OBJECTS = new Object[0];

        CommandCreationMultipleDirectionException() {
            super(CommandCreationErrorCode.CopyCommandFactoryMultipleDirection);
        }

        @Override
        protected Object[] getMessageArguments() {
            return OBJECTS;
        }
    }

    private static final class CommandCreationRemoteFileException
    extends I18nCommandCreationException {
        private static final Object[] OBJECTS = new Object[0];

        CommandCreationRemoteFileException() {
            super(CommandCreationErrorCode.CopyCommandFactoryRemoteFile);
        }

        @Override
        protected Object[] getMessageArguments() {
            return OBJECTS;
        }
    }

    private static final class CommandCreationLocalFileException
    extends I18nCommandCreationException {
        private static final Object[] OBJECTS = new Object[0];

        CommandCreationLocalFileException() {
            super(CommandCreationErrorCode.CopyCommandFactoryLocalFile);
        }

        @Override
        protected Object[] getMessageArguments() {
            return OBJECTS;
        }
    }

    private static class CopyParameter<V>
    extends ParameterImpl<V> {
        public static final Parameter<String> LOCAL_FILE = new CopyParameter<String>(Key.LOCAL_FILE, true, String.class);
        public static final Parameter<String> REMOTE_FILE = new CopyParameter<String>(Key.REMOTE_FILE, true, String.class);
        public static final Parameter<Boolean> FROM_REMOTE = new CopyParameter<Boolean>(Key.FROM_REMOTE, false, Boolean.class);
        public static final Parameter<Boolean> TO_REMOTE = new CopyParameter<Boolean>(Key.TO_REMOTE, false, Boolean.class);

        private CopyParameter(Parameter.PersistentKey persistentKey, boolean bl, Class<V> clazz) {
            super(persistentKey, bl, clazz);
        }

        @Override
        protected String getSimpleName() {
            return CopyParameter.class.getSimpleName();
        }

        private static enum Key implements Parameter.PersistentKey
        {
            LOCAL_FILE,
            REMOTE_FILE,
            FROM_REMOTE,
            TO_REMOTE;

        }
    }
}

