/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.process;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.process.InvalidUserOrPasswordException;
import com.mathworks.toolbox.distcomp.process.IoPipe;
import com.mathworks.toolbox.distcomp.process.IoPipeInputStream;
import com.mathworks.toolbox.distcomp.process.IoPipeOutputStream;
import com.mathworks.toolbox.distcomp.process.IoPipeStreamRedirector;
import com.mathworks.toolbox.distcomp.process.PackageInfo;
import com.mathworks.toolbox.distcomp.util.NullInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class ProcessImpl
extends Process {
    private static final Logger LOGGER = PackageInfo.LOGGER;
    private static final String TERMINATE_TIMEOUT_SECONDS = "com.mathworks.toolbox.distcomp.process.terminateTimeout";
    private static final long DEFAULT_TERMINATE_TIMEOUT_SECONDS = 10L;
    private static final InputStream NULL_INPUT_STREAM;
    private long fProcessPtr = 0L;
    private final IoPipeInputStream fInputStream;
    private final IoPipeInputStream fErrorStream;
    private final IoPipeOutputStream fOutputStream;
    private final IoPipeStreamRedirector fStdOutRedirector;
    private final IoPipeStreamRedirector fStdErrRedirector;
    private Lock fProcessExitLock = new ReentrantLock();
    private Condition fProcessExitedCondition = this.fProcessExitLock.newCondition();
    private int fExitValue;
    private boolean fHasExited = false;

    ProcessImpl() {
        this(null, null);
    }

    ProcessImpl(OutputStream outputStream, OutputStream outputStream2) {
        this.fInputStream = new IoPipeInputStream();
        this.fErrorStream = new IoPipeInputStream();
        this.fOutputStream = new IoPipeOutputStream();
        this.fStdOutRedirector = outputStream == null ? null : new IoPipeStreamRedirector(this.fInputStream, outputStream);
        this.fStdErrRedirector = outputStream2 == null ? null : new IoPipeStreamRedirector(this.fErrorStream, outputStream2);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    @Override
    public InputStream getInputStream() {
        if (this.fStdOutRedirector == null) {
            return this.fInputStream;
        }
        return NULL_INPUT_STREAM;
    }

    @Override
    public InputStream getErrorStream() {
        if (this.fStdErrRedirector == null) {
            return this.fErrorStream;
        }
        return NULL_INPUT_STREAM;
    }

    @Override
    public int waitFor() throws InterruptedException {
        this.waitForProcessExit();
        this.waitForRedirection();
        return this.fExitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exitValue() {
        this.fProcessExitLock.lock();
        try {
            if (!this.fHasExited) {
                throw new IllegalThreadStateException("process hasn't exited");
            }
            int n = this.fExitValue;
            return n;
        }
        finally {
            this.fProcessExitLock.unlock();
        }
    }

    private long getTerminateTimeout() {
        return Long.getLong(TERMINATE_TIMEOUT_SECONDS, 10L);
    }

    @Override
    public void destroy() {
        assert (this.fProcessPtr != 0L) : "Process is NULL";
        if (!this.fHasExited) {
            LOGGER.log(DistcompLevel.SIX, "ProcessImpl.destroy(): terminating process");
            ProcessImpl.nativeTerminate(this.fProcessPtr);
        }
        long l = this.getTerminateTimeout();
        this.waitForProcessExitUninterruptibly(l, TimeUnit.SECONDS);
        if (!this.fHasExited) {
            LOGGER.log(DistcompLevel.ONE, "ProcessImpl.destroy(): process failed to respond to terminate after 10 seconds - killing");
            ProcessImpl.nativeKill(this.fProcessPtr);
        }
        this.closeAllStreams();
    }

    void start(String[] stringArray, String string, Map<String, String> map, boolean bl, String string2, String string3) throws IOException, InvalidUserOrPasswordException {
        IoPipe ioPipe = this.fInputStream.getIoPipe();
        IoPipe ioPipe2 = this.fErrorStream.getIoPipe();
        IoPipe ioPipe3 = this.fOutputStream.getIoPipe();
        String[] stringArray2 = map.keySet().toArray(new String[map.size()]);
        String[] stringArray3 = map.values().toArray(new String[map.size()]);
        this.fProcessPtr = ProcessImpl.nativeStart(stringArray, string, stringArray2, stringArray3, bl, ioPipe, ioPipe2, ioPipe3, string2, string3);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int n = ProcessImpl.nativeWaitFor(ProcessImpl.this.fProcessPtr);
                ProcessImpl.this.fProcessExitLock.lock();
                try {
                    ProcessImpl.this.fExitValue = n;
                    ProcessImpl.this.fHasExited = true;
                    LOGGER.log(DistcompLevel.SIX, "ProcessImpl.destroy(): signalling process has ended with exit value: " + ProcessImpl.this.fExitValue);
                    ProcessImpl.this.fProcessExitedCondition.signalAll();
                }
                finally {
                    ProcessImpl.this.fProcessExitLock.unlock();
                }
            }
        };
        Thread thread = new Thread(runnable, "process waiter");
        thread.setDaemon(true);
        thread.start();
        this.redirectOutputStreams();
    }

    private void redirectOutputStreams() {
        if (this.fStdOutRedirector != null) {
            new Thread((Runnable)this.fStdOutRedirector, "ProcessImpl stdout redirection").start();
        }
        if (this.fStdErrRedirector != null) {
            new Thread((Runnable)this.fStdErrRedirector, "ProcessImpl stderr redirection").start();
        }
    }

    private void waitForRedirection() throws InterruptedException {
        if (this.fStdOutRedirector != null) {
            this.fStdOutRedirector.awaitEof();
        }
        if (this.fStdErrRedirector != null) {
            this.fStdErrRedirector.awaitEof();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForProcessExit() throws InterruptedException {
        this.fProcessExitLock.lock();
        try {
            while (!this.fHasExited) {
                this.fProcessExitedCondition.await();
            }
        }
        finally {
            this.fProcessExitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForProcessExitUninterruptibly(long l, TimeUnit timeUnit) {
        boolean bl = false;
        long l2 = timeUnit.toNanos(l);
        this.fProcessExitLock.lock();
        try {
            while (!this.fHasExited) {
                if (l2 > 0L) {
                    try {
                        l2 = this.fProcessExitedCondition.awaitNanos(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                    continue;
                }
                return;
            }
        }
        finally {
            this.fProcessExitLock.unlock();
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void closeAllStreams() {
        try {
            this.fInputStream.close();
        }
        catch (IOException iOException) {
            LOGGER.log(DistcompLevel.ONE, "Failed to close InputStream");
        }
        try {
            this.fOutputStream.close();
        }
        catch (IOException iOException) {
            LOGGER.log(DistcompLevel.ONE, "Failed to close OutputStream");
        }
        try {
            this.fErrorStream.close();
        }
        catch (IOException iOException) {
            LOGGER.log(DistcompLevel.ONE, "Failed to close ErrorStream");
        }
    }

    protected void finalize() throws Throwable {
        this.fProcessPtr = ProcessImpl.nativeFinalize(this.fProcessPtr);
    }

    private static synchronized native long nativeStart(String[] var0, String var1, String[] var2, String[] var3, boolean var4, IoPipe var5, IoPipe var6, IoPipe var7, String var8, String var9) throws IOException, InvalidUserOrPasswordException;

    private static native int nativeWaitFor(long var0);

    private static native void nativeTerminate(long var0);

    private static native void nativeKill(long var0);

    private static native long nativeFinalize(long var0);

    static {
        System.loadLibrary("nativepctprocess");
        NULL_INPUT_STREAM = new NullInputStream();
    }
}

