/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.transfer;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.transfer.DataReceiver;
import com.mathworks.toolbox.distcomp.pmode.transfer.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferACKOfDataReceived;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferCommand;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferDataItem;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferHeader;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferPayload;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class DataReceiverImpl
extends DataReceiver {
    private OutputGroup fOutGroup;
    private long fTransferSeqNumber;
    private AtomicReference<TransferHeader> fTransferHeader;
    private AtomicLong fLastReceivedBlock;
    private long fLastBlockReturnedIntoM;
    private Instance fSrcID;
    private List<TransferPayload> fDataQueue;

    public DataReceiverImpl(OutputGroup outputGroup) {
        this.fOutGroup = outputGroup;
        this.fDataQueue = Collections.synchronizedList(new LinkedList());
        this.fLastReceivedBlock = new AtomicLong(-1L);
        this.fTransferHeader = new AtomicReference<Object>(null);
        this.reset();
    }

    @Override
    public byte[] getNextBlock() {
        TransferDataItem transferDataItem;
        if (!this.isTransferInProgress()) {
            return null;
        }
        byte[] byArray = null;
        if (this.fLastBlockReturnedIntoM < this.fLastReceivedBlock.get()) {
            assert (!this.fDataQueue.isEmpty()) : "Data queue should not be empty when we have received more blocks than we have returned.";
            transferDataItem = this.fDataQueue.remove(0);
            byArray = ((TransferPayload)transferDataItem).fData;
            ++this.fLastBlockReturnedIntoM;
        }
        if ((transferDataItem = this.fTransferHeader.get()) != null && this.fLastBlockReturnedIntoM == transferDataItem.fNumberOfBlocks) {
            this.reset();
        }
        return byArray;
    }

    @Override
    public TransferHeader getHeader() {
        return this.fTransferHeader.get();
    }

    @Override
    public void dispatch(TransferDataItem transferDataItem, Instance instance) {
        assert (this.fSrcID.equals(instance)) : "Received a TransferDataItem from source " + instance + ". Expected source to be " + this.fSrcID + ".";
        assert (this.isTransferInProgress()) : "Received data of type " + transferDataItem.getClass().getName() + "when transfer was not in progress.";
        this.assertSeqNumber(transferDataItem.getTransferSeqNumber());
        if (transferDataItem instanceof TransferPayload) {
            TransferPayload transferPayload = (TransferPayload)transferDataItem;
            this.receiveDataBlock(transferPayload);
        } else if (transferDataItem instanceof TransferHeader) {
            this.fTransferHeader.set((TransferHeader)transferDataItem);
        } else {
            String string = DataReceiverImpl.sMsgUnexpectedTransferCommand(transferDataItem);
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
            assert (false) : string;
        }
    }

    @Override
    public void prepareForTransfer(long l, Instance instance) {
        this.reset();
        this.fTransferSeqNumber = l;
        this.fSrcID = instance;
    }

    private void receiveDataBlock(TransferPayload transferPayload) {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Received block " + (transferPayload.fBlockNumber + 1L) + " out of " + this.fTransferHeader.get().fNumberOfBlocks + ".");
        assert (transferPayload.fBlockNumber == this.fLastReceivedBlock.get() + 1L) : "Received blocks out-of-order. Expected block " + (this.fLastReceivedBlock.get() + 1L) + " but received block " + transferPayload.fBlockNumber + ".";
        this.fOutGroup.sendTo(this.fSrcID, new TransferACKOfDataReceived(this.fTransferSeqNumber, transferPayload.fBlockNumber));
        this.fDataQueue.add(transferPayload);
        this.fLastReceivedBlock.incrementAndGet();
    }

    private boolean isTransferInProgress() {
        return this.fTransferSeqNumber >= 0L;
    }

    private void reset() {
        this.fTransferSeqNumber = -1L;
        this.fTransferHeader.set(null);
        this.fLastReceivedBlock.set(-1L);
        this.fLastBlockReturnedIntoM = -1L;
        this.fSrcID = null;
        while (!this.fDataQueue.isEmpty()) {
            this.fDataQueue.remove(0);
        }
    }

    private void assertSeqNumber(long l) {
        assert (this.fTransferSeqNumber == l) : "Invalid Transfer sequence number. Was " + l + ". Expected " + this.fTransferSeqNumber + ".";
    }

    private static String sMsgUnexpectedTransferCommand(TransferCommand transferCommand) {
        return "Received unexpected transfer object of type " + transferCommand.getClass().getName() + " with transfer sequence number " + transferCommand.getTransferSeqNumber() + ".";
    }
}

