/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolConnector;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.io.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnector;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredSocketConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

final class MatlabPoolBrokeredConnector
extends MatlabPoolConnector {
    private final BrokeredConnector fBrokeredConnector;
    private final MatlabPoolPeerInstance fLocalPeer;
    private final String fHostname;
    private Map<ProcessInstance, ConnectInfo> fProcessInstancesToConnectInfos;
    private final UUID fGroupUUID;

    MatlabPoolBrokeredConnector(MatlabPoolPeerInstance matlabPoolPeerInstance, String string, UUID uUID) throws PeerMessagingException {
        this.fLocalPeer = matlabPoolPeerInstance;
        this.fGroupUUID = uUID;
        this.fHostname = string;
        this.fBrokeredConnector = new BrokeredConnector(matlabPoolPeerInstance);
        this.fProcessInstancesToConnectInfos = new HashMap<ProcessInstance, ConnectInfo>();
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "ConnectionManager (" + this.fGroupUUID + ") constructed.");
    }

    @Override
    ProcessInstance registerClientConnectInfo(ConnectInfo connectInfo) {
        ProcessInstance processInstance = ProcessInstance.getClientInstance();
        String string = System.getenv("MDCE_OVERRIDE_CLIENT_HOST");
        if (string != null && string.length() > 0 && connectInfo instanceof ServerSocketConnectInfo && ((ServerSocketConnectInfo)connectInfo).getSocketAddress() != null) {
            ServerSocketConnectInfo serverSocketConnectInfo = (ServerSocketConnectInfo)connectInfo;
            InetSocketAddress inetSocketAddress = serverSocketConnectInfo.getSocketAddress();
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Using overriding client hostname: " + string + " to override " + inetSocketAddress);
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, inetSocketAddress.getPort());
            ServerSocketConnectInfo serverSocketConnectInfo2 = new ServerSocketConnectInfo(inetSocketAddress2, connectInfo.getGroupUUID(), connectInfo.getConnectorSecurityDescription(), connectInfo.getHandShakeTimeout());
            this.fProcessInstancesToConnectInfos.put(processInstance, serverSocketConnectInfo2);
        } else {
            this.fProcessInstancesToConnectInfos.put(processInstance, connectInfo);
        }
        return processInstance;
    }

    @Override
    Connection activelyConnectTo(ProcessInstance processInstance) throws InterruptedException, PeerMessagingException {
        if (!this.fProcessInstancesToConnectInfos.containsKey(processInstance)) {
            assert (false) : "No address for: " + processInstance;
            return null;
        }
        ConnectInfo connectInfo = this.fProcessInstancesToConnectInfos.get(processInstance);
        if (connectInfo instanceof BrokeredSocketConnectInfo) {
            BrokeredSocketConnectInfo brokeredSocketConnectInfo = (BrokeredSocketConnectInfo)connectInfo;
            Connection connection = this.fBrokeredConnector.activelyConnectTo(brokeredSocketConnectInfo, this.fHostname);
            if (connection != null) {
                connection.switchToMatlabPoolProcessInstance();
            }
            return connection;
        }
        throw new IllegalArgumentException("Does not understand how to connect using a " + connectInfo.getClass());
    }

    @Override
    void close() {
    }

    public String toString() {
        return "MatlabPoolBrokeredConnector{, fBrokeredConnector=" + this.fBrokeredConnector + ", fLocalPeer=" + this.fLocalPeer + ", fProcessInstancesToConnectInfos.size()=" + this.fProcessInstancesToConnectInfos.size() + ", fGroupUUID=" + this.fGroupUUID + '}';
    }
}

