/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import java.io.Serializable;
import java.util.Vector;

class BufferHelper
implements Serializable {
    private transient ByteBufferHandle[] fBufferHandles;
    private Object[] fAllData;
    private Integer[] fBufIndices;

    BufferHelper(Object object) {
        this.fAllData = object instanceof Object[] ? (Object[])object : new Object[]{object};
        this.disentangleByteBuffers();
    }

    ByteBufferHandle[] getByteBuffers() {
        return this.fBufferHandles;
    }

    void setByteBuffers(ByteBufferHandle[] byteBufferHandleArray) {
        this.fBufferHandles = byteBufferHandleArray;
        this.reinstateByteBuffers();
    }

    Object[] getAll() {
        return this.fAllData;
    }

    private void disentangleByteBuffers() {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<ByteBufferHandle> vector2 = new Vector<ByteBufferHandle>();
        for (int i = 0; i < this.fAllData.length; ++i) {
            Object object = this.fAllData[i];
            if (!(object instanceof ByteBufferHandle)) continue;
            vector.addElement(i);
            vector2.addElement((ByteBufferHandle)object);
            this.fAllData[i] = null;
        }
        this.fBufferHandles = new ByteBufferHandle[vector2.size()];
        vector2.copyInto(this.fBufferHandles);
        this.fBufIndices = new Integer[vector.size()];
        vector.copyInto(this.fBufIndices);
    }

    private void reinstateByteBuffers() {
        if (this.fBufferHandles.length > 0) {
            for (int i = 0; i < this.fBufIndices.length; ++i) {
                assert (this.fBufIndices[i] < this.fAllData.length) : "Invalid stored buffer index";
                this.fAllData[this.fBufIndices[i].intValue()] = this.fBufferHandles[i];
            }
        }
    }
}

