/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pml;

import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcher;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcherForParallelJobs;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.pml.LabCompatibilityChecker;
import com.mathworks.toolbox.distcomp.pml.PackageInfo;
import com.mathworks.toolbox.distcomp.pml.ParallelJob;
import com.mathworks.toolbox.distcomp.pml.ParallelJobSetupInfo;
import com.mathworks.toolbox.distcomp.pml.ParallelJobSingleTaskException;
import com.mathworks.toolbox.distcomp.storage.DataStorageException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.JobStateException;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import com.mathworks.toolbox.distcomp.workunit.WorkerSortStrategy;
import com.mathworks.toolbox.distcomp.workunit.WorkerTaskInfo;
import java.util.Collection;
import java.util.Vector;
import net.jini.id.Uuid;

public class ParallelJobImpl
extends JobImpl
implements ParallelJob {
    private static final WorkerSortStrategy DEFAULT_PARALLEL_STRATEGY = WorkerSortStrategy.FEWEST_MACHINES;
    private String fParallelTag = "";
    private int fNumLabs = 0;
    private Uuid fLeadingTaskUuid;

    public ParallelJobImpl(long l, int n, String string) {
        super(l, n, string);
        this.setWorkerSortStrategy(DEFAULT_PARALLEL_STRATEGY);
    }

    public ParallelJobImpl(long l, int n, String string, TimeProvider timeProvider) {
        super(l, n, string, timeProvider);
        this.setWorkerSortStrategy(DEFAULT_PARALLEL_STRATEGY);
    }

    @Override
    public ParallelJobSetupInfo getParallelJobSetupInfo() {
        return (ParallelJobSetupInfo)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                if (ParallelJobImpl.this.fNumLabs >= 1 && !ParallelJobImpl.this.fParallelTag.equals("")) {
                    return new ParallelJobSetupInfo(ParallelJobImpl.this.fParallelTag, ParallelJobImpl.this.fNumLabs);
                }
                return null;
            }
        });
    }

    @Override
    public boolean isLeadingTask(final Uuid uuid) {
        return (Boolean)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                if (uuid != null) {
                    return new Boolean(uuid.equals((Object)ParallelJobImpl.this.fLeadingTaskUuid));
                }
                return Boolean.FALSE;
            }
        });
    }

    @Override
    public void setParallelTag(final String string) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                ParallelJobImpl.this.fParallelTag = string;
                return null;
            }
        });
    }

    public void setNumLabs(final int n) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                ParallelJobImpl.this.fNumLabs = n;
                return null;
            }
        });
    }

    @Override
    public String workUnitTypeForPrinting() {
        return "parallel job";
    }

    @Override
    public Uuid createTask(final TaskInfo taskInfo) throws MJSException {
        return (Uuid)this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws MJSException {
                if (ParallelJobImpl.this.fState == 2) {
                    throw new JobStateException("A task cannot be added to a running parallel job");
                }
                int n = ParallelJobImpl.this.getJobStorage().countTasksByJobID(ParallelJobImpl.this.getID());
                if (n != 0) {
                    throw new ParallelJobSingleTaskException();
                }
                ParallelJobImpl.this.fLeadingTaskUuid = ParallelJobImpl.this.createTaskAndSetInfo(taskInfo);
                return ParallelJobImpl.this.fLeadingTaskUuid;
            }
        });
    }

    public void createCopiesOfTask(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws MJSException {
                if (ParallelJobImpl.this.fState == 3) {
                    throw new JobStateException("Cannot add tasks to a finished job");
                }
                TaskImpl taskImpl = ParallelJobImpl.this.getFirstTask();
                for (int i = 0; i < n; ++i) {
                    TaskImpl taskImpl2 = ParallelJobImpl.this.createCopyOfTask(taskImpl);
                    ParallelJobImpl.this.getJobStorage().putTask(taskImpl2);
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, "task " + taskImpl2.getNum() + " of " + ParallelJobImpl.this.workUnitTypeForPrinting() + " " + ParallelJobImpl.this.fNum + " has been created");
                }
                return null;
            }
        });
        this.notifyJobRunnerOfNewTask();
    }

    protected TaskImpl createCopyOfTask(TaskImpl taskImpl) throws DataStorageException {
        return taskImpl.deepCopy(this.nextTaskSequenceNum(), this.getID(), this.getWorkUnitUserName());
    }

    public void destroyPendingTasks() {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoStorageUpdateNoException(){

            @Override
            public Object invoke() {
                Uuid[][] uuidArray = ParallelJobImpl.this.getJobStorage().readTasksByJobIDAndState(ParallelJobImpl.this.getID(), new int[]{0});
                Uuid[] uuidArray2 = uuidArray[0];
                for (int i = 0; i < uuidArray2.length; ++i) {
                    try {
                        TaskImpl taskImpl = (TaskImpl)ParallelJobImpl.this.getJobStorage().readWorkUnit(uuidArray2[i]);
                        boolean bl = true;
                        taskImpl.destroyWithoutNotifyingJob(bl);
                        continue;
                    }
                    catch (WorkUnitNotFoundException workUnitNotFoundException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    @Override
    public TaskDispatcher getTaskDispatcherToUse() {
        return TaskDispatcherForParallelJobs.instance();
    }

    @Override
    protected void checkNumTasksBeforeRunning() throws JobStateException {
        int n = this.getJobStorage().countTasksByJobIDAndState(this.getID(), 0);
        if (n != 1) {
            this.cancelJobBeforeRunning("The parallel job was cancelled because the number of tasks in the job, " + n + ", was not equal to 1.");
        }
    }

    @Override
    public int getMinimumTasksToDispatch() {
        return this.getMinWorkers();
    }

    @Override
    protected void taskCompleted(TaskImpl taskImpl) {
        super.taskCompleted(taskImpl);
        int n = this.getJobStorage().countTasksByJobID(this.getID());
        if (taskImpl.isFinishedAbnormally() && (this.fState != 0 || n != 0)) {
            long l = taskImpl.getNum();
            String string = taskImpl.getErrorMessage();
            String string2 = "The parallel job was cancelled because the task with ID " + l + "\nterminated abnormally for the following reason:\n" + string;
            this.cancel(string2);
        }
    }

    @Override
    protected void checkTotalNumberOfWorkers(Worker[][] workerArray) throws JobStateException {
        Worker[] workerArray2 = workerArray[0];
        Worker[] workerArray3 = workerArray[1];
        Worker[] workerArray4 = new Worker[workerArray2.length + workerArray3.length];
        System.arraycopy(workerArray2, 0, workerArray4, 0, workerArray2.length);
        System.arraycopy(workerArray3, 0, workerArray4, workerArray2.length, workerArray3.length);
        Worker[][] workerArray5 = LabCompatibilityChecker.instance().getCompatibleLabs(workerArray4);
        int n = 0;
        for (int i = 0; i < workerArray5.length; ++i) {
            if (workerArray5[i].length <= n) continue;
            n = workerArray5[i].length;
        }
        if (this.fMinWorkers > n) {
            if (n < workerArray4.length) {
                this.cancelJobBeforeRunning("The job was cancelled because there are not enough workers of the same OS and architecture to run a parallel job.\nYour NumWorkersRange is [" + this.fMinWorkers + " " + this.fMaxWorkers + "], but the " + "number of qualified workers is " + n + ".");
            } else {
                this.cancelJobBeforeRunning("The job was cancelled because the cluster does not have enough workers to meet the minimum of the job's NumWorkersRange property ([" + this.fMinWorkers + " " + this.fMaxWorkers + "]).");
            }
        }
    }

    @Override
    protected Worker[] chooseIdleWorkersForQueuedJob(Worker[][] workerArray) {
        Worker[] workerArray2 = workerArray[0];
        Worker[][] workerArray3 = LabCompatibilityChecker.instance().getCompatibleLabs(workerArray2);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < workerArray3.length; ++i) {
            if (workerArray3[i].length <= n) continue;
            n = workerArray3[i].length;
            n2 = i;
        }
        if (n < this.fMinWorkers) {
            return null;
        }
        return workerArray3[n2];
    }

    @Override
    protected Worker[] chooseIdleWorkersForRunningJob(Worker[][] workerArray) {
        return this.chooseIdleWorkersForQueuedJob(workerArray);
    }

    protected TaskImpl getFirstTask() throws ParallelJobSingleTaskException {
        assert (this.haveWriteLock()) : "Caller does not have the write lock.";
        int n = this.getJobStorage().countTasksByJobID(this.getID());
        if (n != 1) {
            throw new ParallelJobSingleTaskException();
        }
        try {
            return (TaskImpl)this.getJobStorage().readWorkUnit(this.fLeadingTaskUuid);
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            throw new ParallelJobSingleTaskException();
        }
    }

    @Override
    protected Collection<WorkerTaskInfo> rerunTask(TaskImpl taskImpl, String string) throws MJSException {
        String string2 = "The " + this.workUnitTypeForPrinting() + " is being rerun because " + "the task with ID " + taskImpl.getNum() + " terminated abnormally " + "for the following reason:\n" + string;
        return this.rerunJob(string2);
    }

    @Override
    protected void checkJobCanRerun() throws WorkUnitStateException {
        TaskImpl taskImpl;
        super.checkJobCanRerun();
        try {
            taskImpl = (TaskImpl)this.getJobStorage().readWorkUnit(this.fLeadingTaskUuid);
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            throw new WorkUnitStateException(this.workUnitTypeForPrinting() + " seems to have no leading task");
        }
        taskImpl.checkTaskCanRerun();
    }

    @Override
    protected Collection<WorkerTaskInfo> prepareTaskToRerun(TaskImpl taskImpl, String string) throws WorkUnitStateException {
        Vector<WorkerTaskInfo> vector = new Vector<WorkerTaskInfo>();
        vector.add(taskImpl.getWorkerTaskInfo());
        if (this.isLeadingTask(taskImpl.getID())) {
            taskImpl.setErrorIdentifier("distcomp:task:Cancelled");
            taskImpl.setErrorMessage(string);
            taskImpl.prepareToRerun();
        } else {
            taskImpl.destroyWithoutNotifyingJob(false);
        }
        return vector;
    }

    @Override
    protected void prepareToRerun() {
        this.setParallelTag("");
        this.resetTaskSequenceNum();
        super.prepareToRerun();
    }
}

