/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.remoteio;

import com.mathworks.toolbox.distcomp.mjs.remoteio.ReadableRemoteStream;
import com.mathworks.toolbox.distcomp.service.Exporter;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.server.ExportException;

public class ReadableRemoteStreamImpl
implements ReadableRemoteStream {
    private Exporter fExporter;
    private InputStream fLocalStream;

    public ReadableRemoteStreamImpl(InputStream inputStream, Exporter exporter) throws ExportException {
        this.fLocalStream = inputStream;
        this.fExporter = exporter;
    }

    public ReadableRemoteStream export() throws ExportException {
        return (ReadableRemoteStream)this.fExporter.export(this);
    }

    @Override
    public byte[] read(int n) throws IOException {
        byte[] byArray;
        assert (n > 0) : "Number of bytes to read cannot be 0";
        byte[] byArray2 = new byte[n];
        int n2 = this.fLocalStream.read(byArray2);
        if (n2 < byArray2.length) {
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        } else {
            byArray = byArray2;
        }
        return byArray;
    }

    @Override
    public void close() throws IOException {
        this.fExporter.unexport(true);
        this.fLocalStream.close();
    }
}

