/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerlookupservice;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.Log;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.PeerLookupService;
import com.mathworks.toolbox.distcomp.mjs.security.SharedSecret;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.AbstractPeerAcceptor;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorPlainSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSSLSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.util.UnicastAccessor;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.activation.ActivationID;
import java.security.cert.Certificate;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import net.jini.export.ProxyAccessor;

public final class ActivatablePeerLookupService
implements ProxyAccessor {
    private final PeerLookupService fPeerLookupService;

    public ActivatablePeerLookupService(ActivationID activationID, MarshalledObject marshalledObject) throws ClassNotFoundException, AbstractPeerAcceptor.InitializeServerSocketChannelException, IOException {
        String[] stringArray = (String[])marshalledObject.get();
        this.fPeerLookupService = ActivatablePeerLookupService.createFromArguments(stringArray);
    }

    private static PeerLookupService createFromArguments(String[] stringArray) throws DistcompException, AbstractPeerAcceptor.InitializeServerSocketChannelException {
        AcceptorSecurityDescription acceptorSecurityDescription;
        Object object;
        LookupServiceArguments lookupServiceArguments = new LookupServiceArguments(stringArray);
        Log.LOGGER.setLevel(lookupServiceArguments.LogLevel);
        Log.LOGGER.addHandler(new ConsoleHandler());
        if (!lookupServiceArguments.IsEnabled) {
            return new PeerLookupService();
        }
        if (lookupServiceArguments.IsSecureLookup) {
            boolean bl = false;
            object = SharedSecret.getInstance().createServerSSLContext();
            Certificate certificate = null;
            acceptorSecurityDescription = new AcceptorSSLSecurityDescription((SSLContext)object, bl, certificate);
        } else {
            acceptorSecurityDescription = new AcceptorPlainSecurityDescription();
        }
        UnicastAccessor unicastAccessor = new UnicastAccessor(lookupServiceArguments.LookupURL);
        object = new PeerLookupService(lookupServiceArguments.HostName, lookupServiceArguments.Port, lookupServiceArguments.Backlog, acceptorSecurityDescription, unicastAccessor);
        Log.LOGGER.info("Created " + object);
        return object;
    }

    public Object getProxy() {
        return new NullProxy();
    }

    private static class LookupServiceArguments {
        private String HostName = null;
        private Integer Port = null;
        private String LookupURL = null;
        private boolean IsSecureLookup = true;
        private boolean IsEnabled = false;
        private int Backlog = 10;
        private Level LogLevel = DistcompLevel.ZERO;

        private LookupServiceArguments(String[] stringArray) {
            for (int i = 0; i < stringArray.length; i += 2) {
                String string = stringArray[i];
                String string2 = stringArray[i + 1];
                if (string.equalsIgnoreCase("ENABLED")) {
                    this.IsEnabled = Boolean.parseBoolean(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("HOSTNAME")) {
                    this.HostName = string2;
                    continue;
                }
                if (string.equalsIgnoreCase("PORT")) {
                    this.Port = Integer.parseInt(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("LOOKUPURL")) {
                    this.LookupURL = string2;
                    continue;
                }
                if (string.equalsIgnoreCase("BACKLOG")) {
                    this.Backlog = Integer.parseInt(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("SECURE")) {
                    this.IsSecureLookup = Boolean.parseBoolean(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("LOGLEVEL")) {
                    this.LogLevel = DistcompLevel.getLevelFromValue(Integer.parseInt(string2));
                    continue;
                }
                throw new IllegalArgumentException("Unknown argument: " + string);
            }
            if (this.HostName == null || this.Port == null || this.LookupURL == null) {
                throw new IllegalArgumentException("Must specify hostname, port and lookup URL");
            }
        }
    }

    private static class NullProxy
    implements Remote,
    Serializable {
        private NullProxy() {
        }
    }
}

