/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.serviceinfo;

import com.mathworks.toolbox.distcomp.control.ServiceType;
import com.mathworks.toolbox.distcomp.control.serviceinfo.InvalidCheckpointDirException;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.util.ConfigUtil;
import java.io.File;

class CheckpointDir {
    private static ServiceType[] serviceTypesToCheck = ServiceType.values();
    private String iMDCSHostname;
    private String iServiceName;
    private ServiceType iServiceType;

    CheckpointDir(String string) throws InvalidCheckpointDirException {
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new InvalidCheckpointDirException("Path '" + string + " is no directory.");
        }
        String string2 = file.getName();
        String[] stringArray = string2.split("_", 2);
        if (stringArray.length != 2) {
            throw new InvalidCheckpointDirException("Cannot split hostname from dir '" + string2 + "'");
        }
        this.iMDCSHostname = stringArray[0];
        for (ServiceType serviceType : serviceTypesToCheck) {
            String string3 = ConfigUtil.getServicePostfix(serviceType.toString());
            int n = stringArray[1].lastIndexOf(string3);
            if (n >= 0) {
                this.iServiceName = stringArray[1].substring(0, n);
                this.iServiceType = serviceType;
                break;
            }
            String string4 = ConfigUtil.getServiceSharedVMPostfix(serviceType.toString());
            int n2 = stringArray[1].lastIndexOf(string4);
            if (n2 < 0) continue;
            this.iServiceName = stringArray[1].substring(0, n2);
            this.iServiceType = serviceType;
            break;
        }
        if (this.iServiceType == null) {
            throw new InvalidCheckpointDirException("Dir '" + string2 + "' does not belong to a service of " + "checked types.");
        }
    }

    public ServiceInfo createServiceInfo(String string) {
        Host host = new Host(string, this.iMDCSHostname);
        if (this.iServiceType == ServiceType.JOBMANAGER) {
            return new JobManagerServiceInfo(this.iServiceName, host);
        }
        if (this.iServiceType == ServiceType.WORKER) {
            return new WorkerServiceInfo(this.iServiceName, host);
        }
        if (this.iServiceType == ServiceType.PHOENIX) {
            return MDCSServiceInfo.createStoppedInfo(host);
        }
        return null;
    }
}

