/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.SignatureModule;
import com.mathworks.toolbox.distcomp.auth.modules.CryptoModuleKeyPairImplHelper;
import com.mathworks.toolbox.distcomp.auth.modules.KeyPairProvider;
import com.mathworks.toolbox.distcomp.auth.modules.ModuleCreationException;
import com.mathworks.toolbox.distcomp.util.ObjectSerializer;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;

public class SignatureModuleKeyPairImpl
implements SignatureModule {
    private KeyPair fKeyPair;

    public SignatureModuleKeyPairImpl(String string) throws ModuleCreationException {
        KeyPairProvider.getKeyPair(string);
    }

    public SignatureModuleKeyPairImpl() throws ModuleCreationException {
        try {
            this.fKeyPair = KeyPairProvider.createKeyPair();
        }
        catch (CryptoException cryptoException) {
            throw new ModuleCreationException(cryptoException);
        }
    }

    public PublicKey getPublicKey() {
        return this.fKeyPair.getPublic();
    }

    @Override
    public SignatureModule.Signer getSigner() {
        return new SignatureModule.Signer(){

            @Override
            public byte[] sign(Erasable erasable) throws CryptoException {
                return CryptoModuleKeyPairImplHelper.sign(erasable.get(), SignatureModuleKeyPairImpl.this.fKeyPair.getPrivate());
            }
        };
    }

    @Override
    public SignatureModule.Verifier getVerifier() {
        return new SignatureModule.Verifier(){

            @Override
            public void verify(Erasable erasable, byte[] byArray, PublicKey publicKey) throws CryptoException {
                if (!CryptoModuleKeyPairImplHelper.verify(erasable.get(), byArray, publicKey)) {
                    throw new SignatureModule.SignatureVerificationException("Credential signature could not be verified");
                }
            }
        };
    }

    public static void writePublicKeyToProperties(PublicKey publicKey) {
        try {
            String string = ObjectSerializer.serializeToString(publicKey);
            System.setProperty("com.mathworks.toolbox.distcomp.jobmanager.serializedPublicKey", string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to serialize public key to string", iOException);
        }
    }

    public static PublicKey readPublicKeyFromProperties() throws ClassNotFoundException, IOException {
        String string = System.getProperty("com.mathworks.toolbox.distcomp.jobmanager.serializedPublicKey");
        return (PublicKey)ObjectSerializer.deserializeFromString(string);
    }
}

