/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.modules.CryptoModuleKeyPairImplHelper;
import com.mathworks.toolbox.distcomp.auth.modules.ModuleCreationException;
import com.mathworks.toolbox.distcomp.auth.modules.PackageInfo;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class KeyPairProvider {
    public static KeyPair getKeyPair(String string) throws ModuleCreationException {
        File file = new File(string);
        try {
            return KeyPairProvider.readKeyPair(file);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Unable to read keys from " + file);
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating new key pair.");
            KeyPair keyPair = KeyPairProvider.createKeyPair();
            KeyPairProvider.storeKeyPair(keyPair, file);
            return keyPair;
        }
        catch (CryptoException cryptoException) {
            throw new ModuleCreationException("Could not generate keypair", cryptoException);
        }
        catch (IOException iOException) {
            throw new ModuleCreationException("Unable to write key information to " + file, iOException);
        }
    }

    public static KeyPair createKeyPair() throws CryptoException {
        return CryptoModuleKeyPairImplHelper.generateKeyPair();
    }

    private static KeyPair readKeyPair(File file) throws IOException, ClassNotFoundException {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Reading key pair from " + file);
        File file2 = new File(file, "public");
        File file3 = new File(file, "private");
        PublicKey publicKey = (PublicKey)KeyPairProvider.readKey(file2);
        PrivateKey privateKey = (PrivateKey)KeyPairProvider.readKey(file3);
        return new KeyPair(publicKey, privateKey);
    }

    private static void storeKeyPair(KeyPair keyPair, File file) throws IOException {
        boolean bl;
        File file2 = new File(file, "public");
        File file3 = new File(file, "private");
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new IOException("Unable to create security directory " + file);
        }
        KeyPairProvider.writeKey(keyPair.getPublic(), file2);
        KeyPairProvider.writeKey(keyPair.getPrivate(), file3);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Wrote key pair to security dir " + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key readKey(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        try {
            Key key = (Key)objectInputStream.readObject();
            return key;
        }
        finally {
            objectInputStream.close();
        }
    }

    private static void writeKey(Key key, File file) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(key);
        objectOutputStream.close();
    }
}

