/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.AllowedUserList;
import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModuleConfig;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.InvalidAdminPasswordException;
import com.mathworks.toolbox.distcomp.auth.InvalidPasswordException;
import com.mathworks.toolbox.distcomp.auth.NoAuthorisedUserFoundException;
import com.mathworks.toolbox.distcomp.auth.NotAdminUserException;
import com.mathworks.toolbox.distcomp.auth.PasswordRetrievalException;
import com.mathworks.toolbox.distcomp.auth.SecurityModuleProvider;
import com.mathworks.toolbox.distcomp.auth.UnknownUserException;
import com.mathworks.toolbox.distcomp.auth.UserCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialRole;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedAuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedUserCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.PlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialTransferException;
import com.mathworks.toolbox.distcomp.storage.CredentialStorage;
import com.mathworks.toolbox.distcomp.storage.CredentialStorageException;
import com.mathworks.toolbox.distcomp.storage.CredentialsNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AuthorisationModuleImpl
implements AuthorisationModule {
    private static byte[] sSalt = new byte[0];
    private static boolean sStoreEncrypted = true;
    private final int fSecurityLevel;
    private final CryptoModule fCryptoModule;
    private final CredentialStorage fCredentialStorage;
    private final UserIdentity fAdminUserIdentity;
    private final AllowedUserList fAllowedUsers;
    private UserIdentity fCachedUser;
    private CredentialProviderLocal fCachedProvider;

    AuthorisationModuleImpl(AuthorisationModuleConfig authorisationModuleConfig) {
        this.fSecurityLevel = authorisationModuleConfig.getSecurityLevel();
        this.fCryptoModule = authorisationModuleConfig.getCryptoModule();
        this.fCredentialStorage = authorisationModuleConfig.getCredentialStorage();
        this.fAdminUserIdentity = authorisationModuleConfig.getAdminUserIdentity();
        this.fAllowedUsers = authorisationModuleConfig.getAllowedUsers();
    }

    @Override
    public void checkCredentials(UserIdentity userIdentity, List<UserIdentity> list, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        list.add(this.fAdminUserIdentity);
        this.checkCredentialsOfUserAndAuthorisedUsers(userIdentity, list, credentialProviderLocal);
    }

    @Override
    public void checkCredentialsAdminOnly(CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        try {
            this.checkCredentials(this.fAdminUserIdentity, credentialProviderLocal);
        }
        catch (PasswordRetrievalException passwordRetrievalException) {
            throw new NotAdminUserException("Only the admin user can perform this operation.", this.fAdminUserIdentity, passwordRetrievalException);
        }
        catch (InvalidPasswordException invalidPasswordException) {
            throw new InvalidAdminPasswordException("The password you entered does not match the administrator password.", this.fAdminUserIdentity, invalidPasswordException);
        }
    }

    @Override
    public void checkCredentialsUserOnly(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        List<UserIdentity> list = Collections.emptyList();
        this.checkCredentialsOfUserAndAuthorisedUsers(userIdentity, list, credentialProviderLocal);
    }

    private void checkCredentialsOfUserAndAuthorisedUsers(UserIdentity userIdentity, List<UserIdentity> list, CredentialProviderLocal credentialProviderLocal) throws NoAuthorisedUserFoundException, CredentialStorageException {
        try {
            this.checkCredentials(userIdentity, credentialProviderLocal);
            return;
        }
        catch (AuthorisationFailedException authorisationFailedException) {
            NoAuthorisedUserFoundException noAuthorisedUserFoundException = new NoAuthorisedUserFoundException(userIdentity);
            noAuthorisedUserFoundException.put(userIdentity, authorisationFailedException);
            for (UserIdentity userIdentity2 : list) {
                try {
                    this.checkCredentials(userIdentity2, credentialProviderLocal);
                    return;
                }
                catch (AuthorisationFailedException authorisationFailedException2) {
                    noAuthorisedUserFoundException.put(userIdentity2, authorisationFailedException2);
                }
            }
            throw noAuthorisedUserFoundException;
        }
    }

    private void checkCredentials(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        AuthenticationToken authenticationToken;
        AuthenticationToken authenticationToken2;
        if (this.cachedSuccess(userIdentity, credentialProviderLocal)) {
            return;
        }
        try {
            authenticationToken2 = this.retrieveAuthenticationToken(userIdentity);
        }
        catch (CredentialsNotFoundException credentialsNotFoundException) {
            throw new UnknownUserException(userIdentity);
        }
        try {
            authenticationToken = (AuthenticationToken)credentialProviderLocal.getCredentials(userIdentity, this.fCryptoModule);
        }
        catch (CredentialTransferException credentialTransferException) {
            throw new PasswordRetrievalException(credentialTransferException.getUserIdentity(), credentialTransferException.getCause());
        }
        this.checkTokens(authenticationToken2, authenticationToken);
        this.cacheSuccess(userIdentity, credentialProviderLocal);
    }

    protected void checkTokens(AuthenticationToken authenticationToken, AuthenticationToken authenticationToken2) throws InvalidPasswordException {
        if (!authenticationToken2.equals(authenticationToken)) {
            throw new InvalidPasswordException(authenticationToken2.getUserIdentity());
        }
    }

    @Override
    public final UserCredentials getCredentials(UserIdentity userIdentity) throws CredentialCreationException, CredentialStorageException, CredentialsNotFoundException {
        return this.retrieveUserCredentials(userIdentity);
    }

    @Override
    public boolean userExists(UserIdentity userIdentity) throws CredentialStorageException {
        try {
            this.fCredentialStorage.getCredentials(userIdentity, CredentialRole.AUTH_TOKEN);
            return true;
        }
        catch (CredentialsNotFoundException credentialsNotFoundException) {
            return false;
        }
    }

    @Override
    public final void addNewUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        if (this.userExists(userIdentity)) {
            return;
        }
        if (this.fAdminUserIdentity.equals(userIdentity) || !this.fAllowedUsers.isUserAllowed(userIdentity)) {
            throw new UserCreationException(userIdentity);
        }
        this.addPasswordToDatabase(this.retrieveUser(userIdentity, credentialProviderLocal));
    }

    protected final PlainCredentials retrieveUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException {
        return (PlainCredentials)credentialProviderLocal.getCredentials(userIdentity, this.fCryptoModule);
    }

    @Override
    public final void addAdminUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        if (this.userExists(userIdentity)) {
            return;
        }
        this.addPasswordToDatabase(this.retrieveAdminUser(userIdentity, credentialProviderLocal));
    }

    protected PlainCredentials retrieveAdminUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException {
        return (PlainCredentials)credentialProviderLocal.getCredentials(userIdentity, this.fCryptoModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPasswordToDatabase(PlainCredentials plainCredentials) throws CredentialCreationException, CredentialStorageException {
        try {
            Map<CredentialRole, TransferableCredentials> map = this.generateCredentialMapForPlainCredentials(plainCredentials);
            this.fCredentialStorage.putMultipleCredentials(map);
        }
        finally {
            plainCredentials.erase();
        }
    }

    @Override
    public void changeCredentialsOfExistingUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal, CredentialProviderLocal credentialProviderLocal2) throws AuthorisationFailedException, CredentialStorageException {
        if (!this.userExists(userIdentity)) {
            throw new UnknownUserException(userIdentity);
        }
        this.checkCredentialsOfUserAndAdmin(userIdentity, credentialProviderLocal);
        this.changePasswordInDatabase(userIdentity, credentialProviderLocal2);
    }

    private void checkCredentialsOfUserAndAdmin(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        List<UserIdentity> list = Collections.singletonList(this.fAdminUserIdentity);
        this.checkCredentialsOfUserAndAuthorisedUsers(userIdentity, list, credentialProviderLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePasswordInDatabase(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws CredentialCreationException, CredentialTransferException, CredentialStorageException {
        PlainCredentials plainCredentials = (PlainCredentials)credentialProviderLocal.getCredentials(userIdentity, this.fCryptoModule);
        try {
            Map<CredentialRole, TransferableCredentials> map = this.generateCredentialMapForPlainCredentials(plainCredentials);
            this.fCredentialStorage.updateMultipleCredentials(map);
        }
        finally {
            plainCredentials.erase();
        }
    }

    private Map<CredentialRole, TransferableCredentials> generateCredentialMapForPlainCredentials(PlainCredentials plainCredentials) throws CredentialCreationException {
        HashMap<CredentialRole, TransferableCredentials> hashMap = new HashMap<CredentialRole, TransferableCredentials>(2);
        AuthenticationToken authenticationToken = plainCredentials.createAuthenticationToken(this.fCryptoModule.getHasher());
        hashMap.put(CredentialRole.AUTH_TOKEN, authenticationToken.prepare());
        if (SecurityModuleProvider.isRunAsUser(this.fSecurityLevel)) {
            hashMap.put(CredentialRole.PASSWORD, plainCredentials.prepare(sStoreEncrypted, sSalt, this.fCryptoModule.getEncryptor()));
        }
        return hashMap;
    }

    private UserCredentials retrieveUserCredentials(UserIdentity userIdentity) throws CredentialCreationException, CredentialStorageException, CredentialsNotFoundException {
        Map<CredentialRole, TransferableCredentials> map = this.fCredentialStorage.getAllCredentials(userIdentity);
        EncryptedUserCredentials encryptedUserCredentials = new EncryptedUserCredentials(userIdentity, map);
        return encryptedUserCredentials.unpack(sSalt, this.fCryptoModule.getDecryptor());
    }

    private AuthenticationToken retrieveAuthenticationToken(UserIdentity userIdentity) throws CredentialCreationException, CredentialStorageException, CredentialsNotFoundException {
        TransferableCredentials transferableCredentials = this.fCredentialStorage.getCredentials(userIdentity, CredentialRole.AUTH_TOKEN);
        return ((EncryptedAuthenticationToken)transferableCredentials).unpack();
    }

    private boolean cachedSuccess(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) {
        return userIdentity.equals(this.fCachedUser) && credentialProviderLocal.equals(this.fCachedProvider);
    }

    private void cacheSuccess(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) {
        this.fCachedUser = userIdentity;
        this.fCachedProvider = credentialProviderLocal;
    }
}

