/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequest;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequestCreator;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ResponseHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ServiceAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.SubmissionProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.view.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StopActionEnum;
import com.mathworks.toolbox.distcomp.control.PortConfig;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerSCShellSender;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.MdceShellCommand;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.NoCommonProtocolSetException;
import com.mathworks.toolbox.distcomp.remote.NoMatchingProtocolException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutor;
import com.mathworks.toolbox.distcomp.remote.RemoteStreamException;
import com.mathworks.toolbox.distcomp.remote.ShellFuture;
import com.mathworks.toolbox.distcomp.remote.SimpleShellFuture;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import com.mathworks.toolbox.distcomp.ui.DetailsDialog;
import com.mathworks.toolbox.distcomp.ui.remote.ParameterPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StopMDCEAction
extends ServiceAction {
    public StopMDCEAction(StopActionEnum stopActionEnum, TargetSource targetSource, String string, ResponseHandler responseHandler, ClientMonitor clientMonitor, SubmissionProgressListener submissionProgressListener, SystemErrorHandler systemErrorHandler) {
        super(StopMDCEAction.getLabel(stopActionEnum), targetSource, string, new StopMDCEActionRequestCreator(stopActionEnum), responseHandler, clientMonitor, submissionProgressListener, systemErrorHandler);
    }

    private static String getLabel(StopActionEnum stopActionEnum) {
        switch (stopActionEnum) {
            case STOP: {
                return ResourceStatics.sRes.getString("module.hosts.action.stopmdce");
            }
            case DESTROY: {
                return ResourceStatics.sRes.getString("module.hosts.action.destroymdce");
            }
            case RESTART: {
                assert (false) : "Unsupported stop action Enum";
                break;
            }
        }
        return null;
    }

    private static class StopMDCEActionRequestCreator
    implements ActionRequestCreator {
        private StopActionEnum iStopActionEnum;

        private StopMDCEActionRequestCreator(StopActionEnum stopActionEnum) {
            this.iStopActionEnum = stopActionEnum;
        }

        @Override
        public ActionRequest createActionServiceRequest(ActionEvent actionEvent, ClientMonitor clientMonitor, TargetSource targetSource, SystemErrorHandler systemErrorHandler) {
            ParameterSet parameterSet;
            PathUtils.Platform platform;
            MDCSServiceInfo[] mDCSServiceInfoArray;
            block10: {
                mDCSServiceInfoArray = targetSource.getTargets().toArray(new MDCSServiceInfo[targetSource.getTargets().size()]);
                PathUtils.PlatformType platformType = mDCSServiceInfoArray[0].getSystemArchitecture().isWindows() ? PathUtils.PlatformType.WINDOWS : PathUtils.PlatformType.UNIX;
                for (MDCSServiceInfo serializable2 : mDCSServiceInfoArray) {
                    PathUtils.PlatformType platformType2;
                    PathUtils.PlatformType platformType3 = platformType2 = serializable2.getSystemArchitecture().isWindows() ? PathUtils.PlatformType.WINDOWS : PathUtils.PlatformType.UNIX;
                    if (platformType == platformType2) continue;
                    MJOptionPane.showMessageDialog((Component)MJAbstractAction.getFrame((ActionEvent)actionEvent), (Object)ResourceStatics.sRes.getString("services.dialog.stopmdceservices.platformerrormsg"), (String)ResourceStatics.sRes.getString("services.dialog.stopmdceservices.platformerrortitle"), (int)0);
                    ArrayList<ServiceRequest> arrayList = new ArrayList<ServiceRequest>();
                    return new ActionRequest(clientMonitor, true, arrayList, systemErrorHandler);
                }
                platform = mDCSServiceInfoArray[0].getSystemArchitecture().isWindows() ? new PathUtils.Platform(PathUtils.PlatformType.WINDOWS, PathUtils.Separator.BACKSLASH) : new PathUtils.Platform(PathUtils.PlatformType.UNIX, PathUtils.Separator.SLASH);
                HashSet<Class<? extends Command>> hashSet = new HashSet<Class<? extends Command>>();
                hashSet.add(MdceShellCommand.class);
                parameterSet = null;
                try {
                    parameterSet = RemoteExecutor.getParameterSet(platform.getPlatformType(), hashSet);
                }
                catch (NoCommonProtocolSetException noCommonProtocolSetException) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)"For MDCEShellCommand there should be a common protocol set.");
                }
            }
            HashMap<String, ParameterMap> hashMap = new HashMap<String, ParameterMap>();
            if (parameterSet.hasCredentialParameter()) {
                ParameterMap parameterMap = ParameterPanel.showDialog(ResourceStatics.sRes.getString("services.dialog.stopmdceservices.credentialtitle"), parameterSet);
                if (parameterMap == null) {
                    ArrayList<ServiceRequest> arrayList = new ArrayList<ServiceRequest>();
                    return new ActionRequest(clientMonitor, true, arrayList, systemErrorHandler);
                }
                for (MDCSServiceInfo mDCSServiceInfo : mDCSServiceInfoArray) {
                    hashMap.put(mDCSServiceInfo.getHostName(), parameterMap);
                }
            } else {
                for (MDCSServiceInfo mDCSServiceInfo : mDCSServiceInfoArray) {
                    ParameterMap parameterMap = new ParameterMap();
                    parameterMap.put(PathUtils.MatlabRootParameter.MATLAB_ROOT, mDCSServiceInfo.getMatlabRoot());
                    parameterMap.put(PeerSCShellSender.PeerSCParameter.PORT, PortConfig.getRemoteExecutionPort(clientMonitor.getBaseport()));
                    hashMap.put(mDCSServiceInfo.getHostName(), parameterMap);
                }
            }
            Map<String, MdceShellCommand> map = this.createHostnameToStopOrDestroyCommandMap(mDCSServiceInfoArray, platform);
            Map<String, String> map2 = StopMDCEActionRequestCreator.runMdcsShellCommandAndWait(map, platform, hashMap);
            if (platform.getPlatformType().isWindows() && this.iStopActionEnum.equals((Object)StopActionEnum.DESTROY)) {
                Map<String, MdceShellCommand> map3 = StopMDCEActionRequestCreator.createHostnameToUninstallCommandMap(mDCSServiceInfoArray, platform);
                Map<String, String> map4 = StopMDCEActionRequestCreator.runMdcsShellCommandAndWait(map3, platform, hashMap);
                map2.putAll(map4);
            }
            if (!map2.isEmpty()) {
                StopMDCEActionRequestCreator.showErrorDialog(MJAbstractAction.getFrame((ActionEvent)actionEvent), map2);
            }
            ArrayList<ServiceRequest> arrayList = new ArrayList<ServiceRequest>();
            return new ActionRequest(clientMonitor, false, arrayList, systemErrorHandler);
        }

        private static void showErrorDialog(Frame frame, Map<String, String> map) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String object2 : map.keySet()) {
                stringBuilder.append("Error on machine " + object2 + ":\n");
                stringBuilder.append(map.get(object2) + "\n");
            }
            String string = MessageFormat.format(ResourceStatics.sRes.getString("services.dialog.stopmdceservices.stoperrormsg"), map.size());
            DetailsDialog detailsDialog = new DetailsDialog(frame, ResourceStatics.sRes.getString("services.dialog.stopmdceservices.stoperrortitle"), string, 0, stringBuilder.toString());
            ((Window)((Object)detailsDialog)).setLocationRelativeTo(frame);
            ((Dialog)((Object)detailsDialog)).setVisible(true);
        }

        private static Map<String, String> runMdcsShellCommandAndWait(Map<String, MdceShellCommand> map, PathUtils.Platform platform, Map<String, ParameterMap> map2) {
            Object object;
            HashMap<String, SimpleShellFuture> hashMap = new HashMap<String, SimpleShellFuture>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            for (String string : map.keySet()) {
                object = map.get(string);
                ParameterMap parameterMap = map2.get(string);
                try {
                    ShellFuture shellFuture = (ShellFuture)RemoteExecutor.execute((Command)object, string, parameterMap, platform.getPlatformType());
                    hashMap.put(string, new SimpleShellFuture(shellFuture));
                }
                catch (DispatchException dispatchException) {
                    hashMap2.put(string, dispatchException.getMessage());
                    PackageInfo.LOGGER.log(DistcompLevel.WARNING, "Unable to execute mdcs shell command", dispatchException);
                }
                catch (NoMatchingProtocolException noMatchingProtocolException) {
                    assert (false) : noMatchingProtocolException.getMessage();
                }
                catch (NoCommonProtocolSetException noCommonProtocolSetException) {
                    assert (false) : noCommonProtocolSetException.getMessage();
                }
                catch (RemoteStreamException remoteStreamException) {
                    assert (false) : "Something has caused a problem with the remote stream.";
                }
            }
            for (String string : hashMap.keySet()) {
                try {
                    object = (SimpleShellFuture)hashMap.get(string);
                    ((SimpleShellFuture)object).awaitEnd();
                    if (((SimpleShellFuture)object).getExitStatus() == 0) continue;
                    if (!((SimpleShellFuture)object).getErrorString().isEmpty()) {
                        hashMap2.put(string, ((SimpleShellFuture)object).getErrorString());
                        continue;
                    }
                    if (((SimpleShellFuture)object).getOutputString().isEmpty()) continue;
                    hashMap2.put(string, ((SimpleShellFuture)object).getOutputString());
                }
                catch (FulfillmentException fulfillmentException) {
                    hashMap2.put(string, fulfillmentException.getMessage());
                    PackageInfo.LOGGER.log(DistcompLevel.WARNING, "Unable to wait for shell future to be done", fulfillmentException);
                }
                catch (InterruptedException interruptedException) {
                    assert (false) : "Something has interrupted the mdce stop shell future unexpectedly.";
                }
            }
            return hashMap2;
        }

        private Map<String, MdceShellCommand> createHostnameToStopOrDestroyCommandMap(MDCSServiceInfo[] mDCSServiceInfoArray, PathUtils.Platform platform) {
            HashMap<String, MdceShellCommand> hashMap = new HashMap<String, MdceShellCommand>();
            for (MDCSServiceInfo mDCSServiceInfo : mDCSServiceInfoArray) {
                String string = mDCSServiceInfo.getHostName();
                String string2 = mDCSServiceInfo.getMatlabRoot();
                String string3 = mDCSServiceInfo.getMdceDefFile();
                MdceShellCommand mdceShellCommand = null;
                switch (this.iStopActionEnum) {
                    case STOP: {
                        mdceShellCommand = MdceShellCommand.createStopMdceShellCommand(string2, string3, platform);
                        break;
                    }
                    case DESTROY: {
                        mdceShellCommand = MdceShellCommand.createDestroyMdceShellCommand(string2, string3, platform);
                        break;
                    }
                    case RESTART: {
                        assert (false) : "Restart is not supported";
                        break;
                    }
                }
                hashMap.put(string, mdceShellCommand);
            }
            return hashMap;
        }

        private static Map<String, MdceShellCommand> createHostnameToUninstallCommandMap(MDCSServiceInfo[] mDCSServiceInfoArray, PathUtils.Platform platform) {
            HashMap<String, MdceShellCommand> hashMap = new HashMap<String, MdceShellCommand>();
            for (MDCSServiceInfo mDCSServiceInfo : mDCSServiceInfoArray) {
                String string = mDCSServiceInfo.getHostName();
                String string2 = mDCSServiceInfo.getMatlabRoot();
                String string3 = mDCSServiceInfo.getMdceDefFile();
                MdceShellCommand mdceShellCommand = MdceShellCommand.createUninstallMdceShellCommand(string2, string3, platform);
                hashMap.put(string, mdceShellCommand);
            }
            return hashMap;
        }
    }
}

