/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceInfoTable;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import java.util.Collection;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ServiceInfoTableTargetSource
extends TargetSource {
    private final ServiceInfoTable<?> fTable;
    private final CountQuality fCountQuality;

    ServiceInfoTableTargetSource(ClientMonitor clientMonitor, ServiceInfoTable<?> serviceInfoTable) {
        this(clientMonitor, serviceInfoTable, CountQuality.AT_LEAST_ONE);
    }

    ServiceInfoTableTargetSource(ClientMonitor clientMonitor, ServiceInfoTable<?> serviceInfoTable, CountQuality countQuality) {
        this.fTable = serviceInfoTable;
        this.fCountQuality = countQuality;
        this.fTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ServiceInfoTableTargetSource.this.fireTargetsChanges();
                }
            }
        });
        clientMonitor.addUpdateProgressListener(new UpdateProgressListener(){

            @Override
            public void updateStarted(boolean bl) {
            }

            @Override
            public void updateFinished(boolean bl) {
                ServiceInfoTableTargetSource.this.fireTargetsChanges();
            }

            @Override
            public void updateFinishing() {
            }
        });
    }

    @Override
    public Collection<ServiceInfo> getTargets() {
        return this.fTable.getSelectedInfo();
    }

    @Override
    protected boolean areTargetsProper() {
        return this.isProperCount(this.fTable.getSelectedRowCount());
    }

    private boolean isProperCount(int n) {
        switch (this.fCountQuality) {
            case AT_LEAST_ONE: {
                return n > 0;
            }
            case EXACTLY_ONE: {
                return n == 1;
            }
        }
        return false;
    }

    protected ServiceInfoTable<?> getTable() {
        return this.fTable;
    }

    public static enum CountQuality {
        EXACTLY_ONE,
        AT_LEAST_ONE;

    }
}

