/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.toolbox.distcomp.admincenter.services.model.Hostname;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceTableModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StatusModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.WorkerColumn;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;

public class WorkerTableModel
extends ServiceTableModel<WorkerServiceInfo, WorkerColumn> {
    public int getRunningWorkers() {
        int n = 0;
        for (WorkerServiceInfo workerServiceInfo : this.getInfoList()) {
            if (workerServiceInfo.getStatus() != ServiceStatus.RUNNING) continue;
            ++n;
        }
        return n;
    }

    @Override
    protected Class<WorkerColumn> initColumnEnum() {
        return WorkerColumn.class;
    }

    @Override
    protected Object getValue(WorkerServiceInfo workerServiceInfo, WorkerColumn workerColumn) {
        assert (workerServiceInfo != null) : "info must not be null.";
        assert (workerColumn != null) : "column must not be null.";
        switch (workerColumn) {
            case HOST: {
                return new Hostname(workerServiceInfo);
            }
            case JM_CONNECTION: {
                return StatusModel.getWorkerConnectionStatusModel(workerServiceInfo);
            }
            case JM_HOST: {
                return workerServiceInfo.getJobManagerHostName();
            }
            case JM_NAME: {
                return workerServiceInfo.getJobManagerName();
            }
            case NAME: {
                return workerServiceInfo.getServiceName();
            }
            case START_TIME: {
                return workerServiceInfo.getStartTime();
            }
            case STATUS: {
                return StatusModel.getWorkerStatusModel(workerServiceInfo);
            }
        }
        return null;
    }
}

