/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.toolbox.distcomp.admincenter.services.infra.ServiceManager;
import com.mathworks.toolbox.distcomp.admincenter.services.infra.ServiceUpdate;
import com.mathworks.toolbox.distcomp.admincenter.services.infra.ServiceUpdateObserver;
import com.mathworks.toolbox.distcomp.admincenter.services.model.HostTableModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.JobManagerTableModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ModelImporter;
import com.mathworks.toolbox.distcomp.admincenter.services.model.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceRequestException;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateVetoer;
import com.mathworks.toolbox.distcomp.admincenter.services.model.WorkerTableModel;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequestResponse;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ClientMonitor {
    private final HostTableModel fHostTableModel = new HostTableModel();
    private final JobManagerTableModel fJobManagerTableModel = new JobManagerTableModel();
    private final WorkerTableModel fWorkerTableModel = new WorkerTableModel();
    private ServiceManager fServiceManager;
    private final List<UpdateProgressListener> fUpdateListeners = new ArrayList<UpdateProgressListener>();
    private final List<HostNameListener> fHostNameListeners = new ArrayList<HostNameListener>();
    private final List<BasePortListener> fBasePortListeners = new ArrayList<BasePortListener>();
    private ServiceUpdateRequester fServiceUpdateRequester = new ServiceUpdateRequester();

    public ClientMonitor() throws ServiceRequestException {
        try {
            this.fServiceManager = new ServiceManager();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceRequestException(illegalArgumentException);
        }
    }

    public void addUpdateProgressListener(UpdateProgressListener updateProgressListener) {
        this.fUpdateListeners.add(updateProgressListener);
    }

    public void removeUpdateProgressListener(UpdateProgressListener updateProgressListener) {
        this.fUpdateListeners.remove(updateProgressListener);
    }

    public void addHostNameListener(HostNameListener hostNameListener) {
        this.fHostNameListeners.add(hostNameListener);
    }

    public void removeHostNameListener(HostNameListener hostNameListener) {
        this.fHostNameListeners.remove(hostNameListener);
    }

    public void addBasePortListener(BasePortListener basePortListener) {
        this.fBasePortListeners.add(basePortListener);
    }

    public void removeBasePortListener(BasePortListener basePortListener) {
        this.fBasePortListeners.remove(basePortListener);
    }

    public synchronized void setBaseport(int n, boolean bl) throws ServiceRequestException {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        if (n == this.fServiceManager.getBasePort()) {
            return;
        }
        try {
            this.fServiceManager = new ServiceManager(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceRequestException(illegalArgumentException);
        }
        if (bl) {
            this.clearInfo();
            for (BasePortListener basePortListener : this.fBasePortListeners) {
                basePortListener.basePortChanged(n);
            }
        } else {
            this.startUpdate(true);
        }
    }

    public synchronized int getBaseport() {
        return this.fServiceManager.getBasePort();
    }

    public HostTableModel getHostTableModel() {
        return this.fHostTableModel;
    }

    public JobManagerTableModel getJobManagerTableModel() {
        return this.fJobManagerTableModel;
    }

    public WorkerTableModel getWorkerTableModel() {
        return this.fWorkerTableModel;
    }

    public void clearInfo() throws ServiceRequestException {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        HashSet<String> hashSet = new HashSet<String>();
        for (Host host : this.fHostTableModel.getHosts()) {
            hashSet.add(host.getHostname());
        }
        this.removeHosts(hashSet);
    }

    public void importData(ModelImporter modelImporter) {
        this.importData(modelImporter, false);
    }

    public void importData(final ModelImporter modelImporter, boolean bl) {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        assert (modelImporter != null) : "Impoerter object must not be null.";
        this.fServiceUpdateRequester.close();
        this.fireUpdateStarted(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    final int n = modelImporter.getBaseport();
                    final Collection<ServiceInfo> collection = modelImporter.getServiceInfo();
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ClientMonitor.this.setServiceInfo(collection, n);
                            }
                            catch (ServiceRequestException serviceRequestException) {
                                modelImporter.handleException(serviceRequestException);
                            }
                            finally {
                                ClientMonitor.this.fireUpdateFinished(true);
                            }
                        }
                    };
                    if (!EventQueue.isDispatchThread()) {
                        EventQueue.invokeLater(runnable);
                    } else {
                        runnable.run();
                    }
                }
                catch (Exception exception) {
                    modelImporter.handleException(exception);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ClientMonitor.this.fireUpdateFinished(true);
                        }
                    });
                }
            }
        };
        if (!bl) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    public void startUpdate(boolean bl) throws ServiceRequestException {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        this.fServiceUpdateRequester.requestUpdate(this.fHostTableModel.getHosts(), bl);
    }

    public boolean isUpdating() {
        return this.fServiceUpdateRequester.isUpdating();
    }

    public void addHosts(Collection<String> collection, UpdateVetoer updateVetoer) throws ServiceRequestException {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        ServiceUpdateRequester serviceUpdateRequester = this.fServiceUpdateRequester;
        if (updateVetoer != null) {
            this.fServiceUpdateRequester.close();
            serviceUpdateRequester = new ServiceUpdateRequester(updateVetoer);
        }
        for (HostNameListener object : this.fHostNameListeners) {
            object.addedHosts(collection);
        }
        HashSet<Host> hashSet = new HashSet<Host>(this.fHostTableModel.getHosts());
        for (String string : collection) {
            hashSet.add(new Host(string, null));
        }
        serviceUpdateRequester.requestUpdate((Collection<Host>)hashSet, true);
    }

    public void removeHosts(Collection<String> collection) throws ServiceRequestException {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        this.setIgnoreUpdates(true);
        HashSet<Host> hashSet = new HashSet<Host>(this.fHostTableModel.getHosts());
        Iterator<Object> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Host object = (Host)iterator.next();
            if (!collection.contains(object.getHostname())) continue;
            iterator.remove();
        }
        for (HostNameListener hostNameListener : this.fHostNameListeners) {
            hostNameListener.removedHosts(collection);
        }
        this.setIgnoreUpdates(false);
        this.fServiceUpdateRequester.requestUpdate(hashSet, true);
    }

    protected void fireUpdateStarted(boolean bl) {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        for (UpdateProgressListener updateProgressListener : this.getUpdateListeners()) {
            updateProgressListener.updateStarted(bl);
        }
    }

    protected void fireUpdateFinished(boolean bl) {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        this.resetServiceUpdateRequester();
        for (UpdateProgressListener updateProgressListener : this.getUpdateListeners()) {
            updateProgressListener.updateFinished(bl);
        }
    }

    protected void fireUpdateFinishing() {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        for (UpdateProgressListener updateProgressListener : this.getUpdateListeners()) {
            updateProgressListener.updateFinishing();
        }
    }

    private void setIgnoreUpdates(boolean bl) {
        if (bl) {
            this.fServiceUpdateRequester.close();
        } else {
            this.resetServiceUpdateRequester();
        }
    }

    private void resetServiceUpdateRequester() {
        if (this.fServiceUpdateRequester == null || this.fServiceUpdateRequester.isClosed()) {
            this.fServiceUpdateRequester = new ServiceUpdateRequester();
        }
    }

    private UpdateProgressListener[] getUpdateListeners() {
        return this.fUpdateListeners.toArray(new UpdateProgressListener[this.fUpdateListeners.size()]);
    }

    protected synchronized void setServiceInfo(Collection<ServiceInfo> collection) {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        ArrayList<MDCSServiceInfo> arrayList = new ArrayList<MDCSServiceInfo>();
        ArrayList<JobManagerServiceInfo> arrayList2 = new ArrayList<JobManagerServiceInfo>();
        ArrayList<WorkerServiceInfo> arrayList3 = new ArrayList<WorkerServiceInfo>();
        for (ServiceInfo serviceInfo : collection) {
            if (serviceInfo instanceof MDCSServiceInfo) {
                arrayList.add((MDCSServiceInfo)serviceInfo);
                Throwable throwable = ((MDCSServiceInfo)serviceInfo).getException();
                if (throwable == null) continue;
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Host info contains an exception", throwable);
                continue;
            }
            if (serviceInfo instanceof JobManagerServiceInfo) {
                arrayList2.add((JobManagerServiceInfo)serviceInfo);
                continue;
            }
            if (!(serviceInfo instanceof WorkerServiceInfo)) continue;
            arrayList3.add((WorkerServiceInfo)serviceInfo);
        }
        this.getHostTableModel().updateInfo(arrayList);
        this.getJobManagerTableModel().updateInfo(arrayList2);
        this.getWorkerTableModel().updateInfo(arrayList3);
    }

    protected synchronized void setServiceInfo(Collection<ServiceInfo> collection, int n) throws ServiceRequestException {
        assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
        try {
            this.fServiceManager = new ServiceManager(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceRequestException(illegalArgumentException);
        }
        this.setServiceInfo(collection);
    }

    public synchronized Collection<ServiceInfo> getServiceInfo() {
        ArrayList<ServiceInfo> arrayList = new ArrayList<ServiceInfo>();
        arrayList.addAll(this.getHostTableModel().getInfoList());
        arrayList.addAll(this.getJobManagerTableModel().getInfoList());
        arrayList.addAll(this.getWorkerTableModel().getInfoList());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<ServiceRequestResponse> submitServiceRequests(Collection<ServiceRequest> collection) {
        this.setIgnoreUpdates(true);
        try {
            Collection<ServiceRequestResponse> collection2 = this.fServiceManager.submitRequests(collection);
            return collection2;
        }
        finally {
            this.setIgnoreUpdates(false);
        }
    }

    public static interface BasePortListener {
        public void basePortChanged(int var1);
    }

    public static interface HostNameListener {
        public void addedHosts(Collection<String> var1);

        public void removedHosts(Collection<String> var1);
    }

    private class ServiceUpdateRequester
    implements ServiceUpdateObserver {
        private Date fLastRequested = null;
        private boolean fFreezeUI = false;
        private ServiceUpdate fLastUpdate = null;
        private boolean fClosed = false;
        private final UpdateVetoer fVetoer;

        ServiceUpdateRequester() {
            this(null);
        }

        ServiceUpdateRequester(UpdateVetoer updateVetoer) {
            this.fVetoer = updateVetoer;
        }

        public synchronized void requestUpdate(Collection<Host> collection, boolean bl) throws ServiceRequestException {
            assert (EventQueue.isDispatchThread()) : "Must be called from dispatch thread.";
            if (this.isClosed()) {
                return;
            }
            try {
                this.fFreezeUI |= bl;
                ClientMonitor.this.fireUpdateStarted(this.fFreezeUI);
                this.fLastRequested = ClientMonitor.this.fServiceManager.requestUpdate(collection, this);
                this.checkStatus();
            }
            catch (Exception exception) {
                throw new ServiceRequestException(exception);
            }
        }

        @Override
        public synchronized void updateCompleted(ServiceUpdate serviceUpdate) {
            if (this.isClosed()) {
                return;
            }
            this.fLastUpdate = serviceUpdate;
            this.checkStatus();
        }

        public synchronized void close() {
            this.fClosed = true;
            this.fLastRequested = null;
            this.fLastUpdate = null;
        }

        public synchronized boolean isUpdating() {
            return this.fLastRequested != null;
        }

        private void checkStatus() {
            if (this.fLastUpdate == null) {
                return;
            }
            if (this.fLastRequested == null) {
                return;
            }
            if (!this.fLastRequested.after(this.fLastUpdate.getStartTime())) {
                final ServiceUpdate serviceUpdate = this.fLastUpdate;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ClientMonitor.this.fireUpdateFinishing();
                        Collection<ServiceInfo> collection = serviceUpdate.getServiceInfoList();
                        if (ServiceUpdateRequester.this.fVetoer == null || ServiceUpdateRequester.this.fVetoer.isUpdateOkay(collection)) {
                            ClientMonitor.this.setServiceInfo(collection);
                        }
                        ClientMonitor.this.fireUpdateFinished(false);
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    runnable.run();
                } else {
                    EventQueue.invokeLater(runnable);
                }
                this.fLastRequested = null;
                this.fLastUpdate = null;
                this.fFreezeUI = false;
            } else {
                this.fLastUpdate = null;
            }
        }

        synchronized boolean isClosed() {
            return this.fClosed;
        }
    }
}

