/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.action;

import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequest;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequestCreator;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ModuleAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ResponseHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.SubmissionProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateProgressListener;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequestResponse;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Icon;

public class ServiceAction
extends ModuleAction {
    private final ActionRequestCreator fRequestCreator;
    private final ClientMonitor fMonitor;
    private final ResponseHandler fResponseHandler;
    private final SubmissionProgressListener fProgressListener;
    private final SystemErrorHandler fErrorHandler;

    public ServiceAction(String string, TargetSource targetSource, String string2, ActionRequestCreator actionRequestCreator, ResponseHandler responseHandler, ClientMonitor clientMonitor, SubmissionProgressListener submissionProgressListener, SystemErrorHandler systemErrorHandler) {
        this(string, null, targetSource, string2, actionRequestCreator, responseHandler, clientMonitor, submissionProgressListener, systemErrorHandler);
    }

    public ServiceAction(String string, Icon icon, TargetSource targetSource, String string2, ActionRequestCreator actionRequestCreator, ResponseHandler responseHandler, ClientMonitor clientMonitor, SubmissionProgressListener submissionProgressListener, SystemErrorHandler systemErrorHandler) {
        super(string, icon, targetSource, string2);
        assert (actionRequestCreator != null) : "requestCreator may not be null.";
        assert (clientMonitor != null) : "monitor may not be null.";
        assert (responseHandler != null) : "responseHandler may not be null.";
        assert (submissionProgressListener != null) : "progressListener may not be null.";
        assert (systemErrorHandler != null) : "errorHandler may not be null.";
        this.fErrorHandler = systemErrorHandler;
        this.fProgressListener = submissionProgressListener;
        this.fResponseHandler = responseHandler;
        this.fRequestCreator = actionRequestCreator;
        this.fMonitor = clientMonitor;
    }

    public void actionPerformed(final ActionEvent actionEvent) {
        assert (EventQueue.isDispatchThread()) : "Must be called on dispatch thread.";
        final ActionRequest actionRequest = this.fRequestCreator.createActionServiceRequest(actionEvent, this.fMonitor, this.getTargetSource(), this.fErrorHandler);
        if (actionRequest.isUserCancelled()) {
            return;
        }
        final Collection<ServiceRequest> collection = actionRequest.getServiceRequests();
        this.fProgressListener.submissionStarting(actionEvent);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean bl;
                Collection<ServiceRequestResponse> collection3 = null;
                boolean bl2 = bl = collection != null && !collection.isEmpty();
                if (bl) {
                    ServiceAction.this.fProgressListener.serviceRequestStarting(actionEvent, collection);
                    try {
                        collection3 = ServiceAction.this.fMonitor.submitServiceRequests(collection);
                    }
                    finally {
                        ServiceAction.this.fProgressListener.serviceRequestCompleted(actionEvent, collection3);
                    }
                }
                final Collection<ServiceRequestResponse> collection2 = collection3;
                UpdateProgressListener updateProgressListener = new UpdateProgressListener(){

                    @Override
                    public void updateStarted(boolean bl2) {
                        if (bl2) {
                            ServiceAction.this.fProgressListener.updateStarted(actionEvent, actionRequest.getUpdateAction());
                        }
                    }

                    @Override
                    public void updateFinished(boolean bl2) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (bl) {
                                    ServiceAction.this.fResponseHandler.handleResponses(actionEvent, collection2);
                                }
                            }
                        });
                        ServiceAction.this.fMonitor.removeUpdateProgressListener(this);
                    }

                    @Override
                    public void updateFinishing() {
                        ServiceAction.this.fProgressListener.updateCompleted(actionEvent);
                        ServiceAction.this.fProgressListener.submissionCompleted(actionEvent);
                    }
                };
                ServiceAction.this.fMonitor.addUpdateProgressListener(updateProgressListener);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        actionRequest.startUpdate();
                    }
                });
            }
        };
        new Thread(runnable).start();
    }
}

