/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DocumentProxy;
import ice.storm.DynamicObject;
import ice.storm.LoadSession;
import ice.storm.LoadThread;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.ViewportGuiParams;
import ice.storm.ViewportVisitor;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.Listeners;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class Viewport {
    private static final String DEFAULT_NAME = new String("view");
    private static final Object counterLock = new Object();
    private static long viewportCounter = 0L;
    private static final Method createWindowObj = Viewport.getCreateWindowObj();
    private StormBase stormBase;
    private final Object dataLock = new Object();
    private String id;
    private String name;
    protected Viewport parent = null;
    private Viewport first;
    private Viewport last;
    private Viewport next;
    private Viewport prev;
    private final Object loadLock = new Object();
    private LoadSession loadSession;
    private LoadThread loadThread;
    volatile String stateString = "empty";
    protected Container container = null;
    protected Pilot pilot = null;
    private Component pilotComponent = null;
    private final HashArray params = new HashArray();
    private ViewportGuiParams guiParams;
    private Object propertyListeners;
    private int zoom = 256;
    private DynamicObject _windowObj;
    private String historyId = null;
    private String _locationUrl;
    private String _baseUrl;
    private volatile int documentId = 1;
    private boolean frameArrayMember;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeDefaultId(String string) {
        long l;
        Object object = counterLock;
        synchronized (object) {
            l = viewportCounter++;
        }
        return '_' + string + '_' + l;
    }

    private static Method getCreateWindowObj() {
        Class[] classArray = new Class[]{StormBase.class, Viewport.class};
        Method method = Defs.getMethod((String)"ice.scripters.WindowObj", (String)"create", (Class[])classArray);
        if (method == null && Debug.trace) {
            Debug.trace((String)"No scripting support");
        }
        return method;
    }

    public Viewport(StormBase stormBase) {
        this(stormBase, null);
    }

    public Viewport(StormBase stormBase, String string) {
        if (stormBase == null) {
            throw new IllegalArgumentException("StormBase can not be null");
        }
        this.stormBase = stormBase;
        this.name = string != null ? string : DEFAULT_NAME;
        this.id = Viewport.makeDefaultId(this.name);
    }

    final StormBase getStormBase() {
        return this.stormBase;
    }

    public String toString() {
        return "{Viewport id=" + this.id + " name=" + this.name + "}";
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isSyntheticName() {
        if (this.name == DEFAULT_NAME) {
            return true;
        }
        return this.name == this.stormBase.initialViewportName;
    }

    public void setName(String string) {
        if (string != null && string.length() != 0) {
            this.stormBase.sendViewportMessage(this, "nameChange", this.name, string);
            this.name = string;
        }
    }

    public int getDocumentId() {
        return this.documentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void increseDocumentId() {
        Object object = this.dataLock;
        synchronized (object) {
            ++this.documentId;
        }
    }

    public void setZoom(int n) {
        Object object;
        if (n <= 0) {
            throw new IllegalArgumentException("Zoom factor must be positive");
        }
        if (this.zoom != n) {
            this.zoom = n;
            object = this.getPilot();
            if (object != null) {
                ((Pilot)object).setZoom(n);
            }
        }
        for (object = this.first; object != null; object = ((Viewport)object).getNextSibling()) {
            ((Viewport)object).setZoom(this.zoom);
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = this.dataLock;
        synchronized (object) {
            this.propertyListeners = Listeners.add((Object)this.propertyListeners, (Object)propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = this.dataLock;
        synchronized (object) {
            this.propertyListeners = Listeners.remove((Object)this.propertyListeners, (Object)propertyChangeListener);
        }
    }

    final Object getPropertyListeners() {
        return this.propertyListeners;
    }

    public Container getContainer() {
        return this.container;
    }

    public Container getTopLevelContainer() {
        Container container = this.container;
        if (container != null) {
            Container container2;
            while ((container2 = container.getParent()) != null) {
                container = container2;
            }
        }
        return container;
    }

    public void setContainer(Container container) {
        if (Debug.trace && this.container != null) {
            Debug.trace((String)("Replacing AWT container in " + this));
        }
        this.container = container;
        for (Viewport viewport = this.first; viewport != null; viewport = viewport.getNextSibling()) {
            viewport.setContainer(container);
        }
    }

    public void setProperty(Object object, Object object2) {
        this.params.put(object, object2);
    }

    public void removeProperty(Object object) {
        this.params.remove(object);
    }

    public Object getProperty(Object object) {
        return this.params.get(object);
    }

    public ViewportGuiParams getGuiParams() {
        return this.guiParams;
    }

    public void setGuiParams(ViewportGuiParams viewportGuiParams) {
        this.guiParams = viewportGuiParams;
    }

    public boolean isStopRequested() {
        Thread thread = Thread.currentThread();
        return thread instanceof LoadThread && ((LoadThread)((Object)thread)).isStopRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopLoading() {
        Object object = this.loadLock;
        synchronized (object) {
            this.stopLoadingImpl();
        }
        object = this.pilot;
        if (object != null) {
            ((Pilot)object).stopLoading();
        }
    }

    private void stopLoadingImpl() {
        if (this.loadThread != null) {
            this.loadThread.shouldStop();
            this.loadThread.interrupt();
            this.loadThread = null;
        }
        if (this.loadSession != null) {
            if (this.loadSession.onloadParent != null) {
                this.loadSession.onloadParent.removeOnloadBlocker(this.loadSession.parentSessionTag, this.loadLock);
            }
            this.loadSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueRenderContent(ContentLoader contentLoader) {
        Object object = this.loadLock;
        synchronized (object) {
            this.stopLoadingImpl();
            this.loadSession = new LoadSession(contentLoader);
            this.loadSession.onloadParent = this.parent;
            this.loadSession.selfSessionTag = this.addOnloadBlocker(this.loadLock);
            if (this.loadSession.selfSessionTag != this.loadSession) {
                throw new IllegalArgumentException("BAD SESSION CODE");
            }
            if (this.loadSession.onloadParent != null) {
                this.loadSession.parentSessionTag = this.loadSession.onloadParent.addOnloadBlocker(this.loadLock);
            }
            this.loadThread = LoadThread.create(this);
            this.loadThread.loadSession = this.loadSession;
            this.loadThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runAsynchronousLoad(LoadSession loadSession) {
        try {
            try {
                this.stateString = "busy";
                this.stormBase.do_render_content(loadSession.getContentLoader(), this);
            }
            catch (NullPointerException nullPointerException) {
                Object var4_3 = null;
                this.stateString = "ready";
                Thread thread2 = Thread.currentThread();
                Object object2 = this.loadLock;
                synchronized (object2) {
                    if (thread2 == this.loadThread) {
                        this.loadThread = null;
                    }
                }
                this.removeOnloadBlocker(loadSession.selfSessionTag, this.loadLock);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Object var4_4 = null;
                this.stateString = "ready";
                Thread thread3 = Thread.currentThread();
                Object object3 = this.loadLock;
                synchronized (object3) {
                    if (thread3 == this.loadThread) {
                        this.loadThread = null;
                    }
                }
                this.removeOnloadBlocker(loadSession.selfSessionTag, this.loadLock);
                return;
            }
            Object var4_2 = null;
            this.stateString = "ready";
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.stateString = "ready";
            Thread thread = Thread.currentThread();
            Object object = this.loadLock;
            synchronized (object) {
                if (thread == this.loadThread) {
                    this.loadThread = null;
                }
            }
            this.removeOnloadBlocker(loadSession.selfSessionTag, this.loadLock);
            throw throwable;
        }
        Thread thread = Thread.currentThread();
        Object object = this.loadLock;
        synchronized (object) {
            if (thread == this.loadThread) {
                this.loadThread = null;
            }
        }
        this.removeOnloadBlocker(loadSession.selfSessionTag, this.loadLock);
    }

    public Viewport getNextSibling() {
        return this.next;
    }

    public Viewport getFirstChild() {
        return this.first;
    }

    public void addChild(Viewport viewport) {
        viewport.setParent(this);
        viewport.prev = this.last;
        viewport.next = null;
        if (this.last != null) {
            this.last.next = viewport;
        } else {
            this.first = viewport;
        }
        this.last = viewport;
        viewport.setZoom(this.zoom);
    }

    public Enumeration getChildren() {
        if (this.first == null) {
            return null;
        }
        return new ChildrenEnumerator(this.first);
    }

    public int getChildrenCount() {
        int n = 0;
        for (Viewport viewport = this.first; viewport != null; viewport = viewport.getNextSibling()) {
            ++n;
        }
        return n;
    }

    public Viewport getChildByIndex(int n) {
        Viewport viewport;
        for (viewport = this.first; n > 0 && viewport != null; --n, viewport = viewport.getNextSibling()) {
        }
        return viewport;
    }

    String getHistoryId() {
        if (this.historyId != null) {
            return this.historyId;
        }
        Viewport viewport = this.getParent();
        if (viewport == null) {
            return this.id;
        }
        this.historyId = "";
        for (Viewport viewport2 = viewport; viewport2 != null; viewport2 = viewport2.getParent()) {
            this.historyId = this.historyId + "_" + viewport2.getChildIndex(this);
        }
        this.historyId = this.historyId + "_" + viewport.getLocation();
        return this.historyId;
    }

    private int getChildIndex(Viewport viewport) {
        Viewport viewport2;
        int n = 0;
        for (viewport2 = this.first; viewport2 != null && viewport2 != viewport; viewport2 = viewport2.getNextSibling()) {
            ++n;
        }
        if (viewport2 == null) {
            return -1;
        }
        return n;
    }

    public Viewport getParent() {
        return this.parent;
    }

    public Viewport getTopParent() {
        Viewport viewport;
        Viewport viewport2 = this;
        while ((viewport = viewport2.getParent()) != null) {
            viewport2 = viewport;
        }
        return viewport2;
    }

    void setParent(Viewport viewport) {
        if (this.parent != null) {
            return;
        }
        this.parent = viewport;
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    public void iterate(ViewportVisitor viewportVisitor) {
        if (viewportVisitor == null) {
            return;
        }
        viewportVisitor.visit(this);
        for (Viewport viewport = this.first; viewport != null; viewport = viewport.getNextSibling()) {
            viewport.iterate(viewportVisitor);
        }
    }

    public void getViewAndAllChildren(Vector vector) {
        vector.addElement(this);
        for (Viewport viewport = this.first; viewport != null; viewport = viewport.getNextSibling()) {
            viewport.getViewAndAllChildren(vector);
        }
    }

    public Viewport findViewportByName(String string) {
        if (string.equals(this.id) || string.equals(this.name)) {
            return this;
        }
        for (Viewport viewport = this.first; viewport != null; viewport = viewport.getNextSibling()) {
            Viewport viewport2 = viewport.findViewportByName(string);
            if (viewport2 == null) continue;
            return viewport2;
        }
        return null;
    }

    Viewport findViewportByHistoryId(String string) {
        if (string.equals(this.getHistoryId())) {
            return this;
        }
        for (Viewport viewport = this.first; viewport != null; viewport = viewport.getNextSibling()) {
            Viewport viewport2 = viewport.findViewportByHistoryId(string);
            if (viewport2 == null) continue;
            return viewport2;
        }
        return null;
    }

    public Viewport findImmediateChild(String string) {
        for (Viewport viewport = this.first; viewport != null; viewport = viewport.getNextSibling()) {
            if (!string.equals(viewport.id) && !string.equals(viewport.name)) continue;
            return viewport;
        }
        return null;
    }

    public Viewport getImmediateChildWithProperty(Object object, Object object2) {
        for (Viewport viewport = this.first; viewport != null; viewport = viewport.getNextSibling()) {
            if (viewport.getProperty(object) != object2) continue;
            return viewport;
        }
        return null;
    }

    public Viewport findViewportInTreeByName(String string) {
        switch (string.length()) {
            case 4: {
                if (!"_top".equals(string)) break;
                return this.getTopParent();
            }
            case 5: {
                if (!"_self".equals(string)) break;
                return this;
            }
            case 7: {
                if (!"_parent".equals(string)) break;
                Viewport viewport = this.getParent();
                if (viewport == null) {
                    viewport = this;
                }
                return viewport;
            }
        }
        Viewport viewport = this;
        do {
            Viewport viewport2;
            if ((viewport2 = viewport.findViewportByName(string)) == null) continue;
            return viewport2;
        } while ((viewport = viewport.getParent()) != null);
        return this.stormBase.findViewportByName(string);
    }

    public Component getPilotComponent() {
        return this.pilotComponent;
    }

    public Pilot getPilot() {
        return this.pilot;
    }

    public Pilot getParentChainPilot() {
        Viewport viewport = this;
        do {
            Pilot pilot;
            if ((pilot = viewport.getPilot()) == null) continue;
            return pilot;
        } while ((viewport = viewport.getParent()) != null);
        return null;
    }

    protected void setPilot(Pilot pilot) {
        this.removePilot();
        this.pilot = pilot;
        this.pilot.setZoom(this.zoom);
        if (this.first == null) {
            this.pilotComponent = this.pilot.createComponent();
            if (this.pilotComponent != null && this.container != null) {
                this.pilotComponent.setSize(this.container.getSize());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (Viewport.this.container != null && Viewport.this.pilotComponent != null) {
                            Viewport.this.container.add(Viewport.this.pilotComponent);
                            Viewport.this.scheduleValidate(Viewport.this.container);
                        }
                    }
                });
            }
        }
    }

    protected void scheduleValidate(final Component component) {
        this.stormBase.runOnEventThreadLater(new Runnable(){

            public void run() {
                component.validate();
            }
        }, 0L);
    }

    protected void removePilot() {
        this.increseDocumentId();
        if (this.pilot == null) {
            return;
        }
        this.pilot.dispose();
        if (this.pilotComponent != null) {
            if (this.container != null) {
                this.container.remove(this.pilotComponent);
            }
            this.pilotComponent = null;
        }
        this.pilot = null;
    }

    protected void dispose() {
        this.removePilot();
        for (Viewport viewport = this.first; viewport != null; viewport = viewport.getNextSibling()) {
            viewport.dispose();
        }
        this.last = null;
        this.first = null;
        this.stormBase.getHistoryManager().clearHistoryForViewport(this);
        this.clearWindowObj();
        this.container = null;
        this.parent = null;
    }

    void clearContent() {
        this.increseDocumentId();
        for (Viewport viewport = this.first; viewport != null; viewport = viewport.getNextSibling()) {
            viewport.dispose();
        }
        this.last = null;
        this.first = null;
        if (this.pilot != null && this.pilotComponent == null) {
            this.pilotComponent = this.pilot.createComponent();
            if (this.pilotComponent != null && this.container != null) {
                this.pilotComponent.setSize(this.container.getSize());
                this.container.add(this.pilotComponent);
                this.scheduleValidate(this.container);
            }
        }
    }

    public void removePilotComponent() {
        if (this.pilotComponent != null) {
            if (this.container != null) {
                this.container.remove(this.pilotComponent);
            }
            this.pilotComponent = null;
        }
    }

    public void viewportLayout(int n, int n2, int n3, int n4) {
        Pilot pilot = this.pilot;
        if (pilot != null) {
            DocPane docPane = pilot.getDocPane();
            if (docPane != null) {
                docPane.revalidate(n, n2, n3, n4);
            } else {
                Component component = this.pilotComponent;
                if (component != null) {
                    component.setBounds(n, n2, n3, n4);
                    this.scheduleValidate(component);
                }
            }
        }
    }

    public String getLocation() {
        return this._locationUrl;
    }

    public void setLocationUrl(String string) {
        this._locationUrl = string;
        this._baseUrl = null;
    }

    public URL getBaseURL() {
        String string = this.getBaseUrl();
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getBaseUrl() {
        String string = this._baseUrl;
        if (string == null) {
            if (this._locationUrl != null) {
                string = this._locationUrl;
            } else if (this.parent != null) {
                string = this.parent.getBaseUrl();
            }
        }
        return string;
    }

    public void setBaseUrl(String string) {
        if (string == null) {
            Debug.bug();
        }
        this._baseUrl = string;
    }

    public DynamicObject getDynamicWrapper() {
        return this.getWindowObj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DynamicObject getWindowObj() {
        DynamicObject dynamicObject = this._windowObj;
        if (dynamicObject == null && createWindowObj != null) {
            Object[] objectArray = new Object[]{this.stormBase, this};
            Object object = this.dataLock;
            synchronized (object) {
                block9: {
                    dynamicObject = this._windowObj;
                    if (dynamicObject == null) {
                        try {
                            dynamicObject = this._windowObj = (DynamicObject)createWindowObj.invoke(null, objectArray);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (Debug.ex) {
                                Debug.ex((Throwable)illegalAccessException);
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (!Debug.ex) break block9;
                            Debug.ex((Throwable)invocationTargetException.getTargetException());
                        }
                    }
                }
            }
        }
        return dynamicObject;
    }

    final void removeWindowVariables() {
        DynamicObject dynamicObject = this._windowObj;
        if (dynamicObject != null) {
            dynamicObject.unlinkAllSlots();
        }
    }

    final void clearWindowObj() {
        DynamicObject dynamicObject = this._windowObj;
        if (dynamicObject != null) {
            dynamicObject.unlinkAllSlots();
        }
        this._windowObj = null;
    }

    public Viewport getContextViewport() {
        return Scripter.contextViewportImpl();
    }

    public DynamicObject getDocumentObject() {
        DynamicObject dynamicObject = null;
        Pilot pilot = this.getPilot();
        if (pilot != null) {
            dynamicObject = pilot.getDocumentObject();
        }
        if (dynamicObject == null) {
            dynamicObject = new DocumentProxy(this);
        }
        return dynamicObject;
    }

    public boolean isFrameArrayMember() {
        return this.frameArrayMember;
    }

    public void setFrameArrayMember() {
        this.frameArrayMember = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object addOnloadBlocker(Object object) {
        LoadSession loadSession;
        Object object2 = this.loadLock;
        synchronized (object2) {
            loadSession = this.loadSession;
            if (loadSession != null) {
                loadSession.onloadBlockers.put(object, (Object)Boolean.TRUE);
            }
        }
        return loadSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeOnloadBlocker(Object object, Object object2) {
        LoadSession loadSession = (LoadSession)object;
        LoadSession loadSession2 = null;
        Object object3 = this.loadLock;
        synchronized (object3) {
            if (this.loadSession != null && loadSession == this.loadSession) {
                this.loadSession.onloadBlockers.remove(object2);
                if (this.loadSession.onloadBlockers.size() == 0) {
                    loadSession2 = this.loadSession;
                    this.loadSession = null;
                }
            }
        }
        if (loadSession2 != null) {
            try {
                object3 = this.pilot;
                final int n = this.getDocumentId();
                if (object3 != null) {
                    this.stormBase.runOnEventThreadLater(new Runnable((Pilot)object3){
                        private final /* synthetic */ Pilot val$p;
                        {
                            this.val$p = pilot;
                        }

                        public void run() {
                            if (n == Viewport.this.getDocumentId()) {
                                this.val$p.onLoadingDone();
                            }
                        }
                    }, 0L);
                }
                Object var8_8 = null;
                if (loadSession2.onloadParent != null) {
                    loadSession2.onloadParent.removeOnloadBlocker(loadSession2.parentSessionTag, this.loadLock);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (loadSession2.onloadParent != null) {
                    loadSession2.onloadParent.removeOnloadBlocker(loadSession2.parentSessionTag, this.loadLock);
                }
                throw throwable;
            }
        }
    }

    private static final class ChildrenEnumerator
    implements Enumeration {
        private Viewport cursor;

        ChildrenEnumerator(Viewport viewport) {
            this.cursor = viewport;
        }

        public boolean hasMoreElements() {
            return this.cursor != null;
        }

        public Object nextElement() {
            Viewport viewport = this.cursor;
            this.cursor = this.cursor.getNextSibling();
            return viewport;
        }
    }
}

