/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSLexCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class CSSLex {
    private Reader reader = null;
    private InputStream inputStream = null;
    private char[] buf = null;
    private int pos = 0;
    private int numRead = 0;
    private char c = '\u0000';
    private int openedBlocks = 0;
    private CSSLexCallback callback = null;
    private static final char[] important = new char[]{'!', 'i', 'm', 'p', 'o', 'r', 't', 'a', 'n', 't'};
    private boolean[] quotes = new boolean[32];

    public void setLexCallback(CSSLexCallback cSSLexCallback) {
        this.callback = cSSLexCallback;
    }

    void setReader(Reader reader) {
        this.reader = reader;
    }

    public void parseInlineDeclaration(String string) {
        this.buf = string.toCharArray();
        this.openedBlocks = 0;
        this.pos = 0;
        this.numRead = this.buf.length;
        while (this.parseDeclaration()) {
        }
        this.buf = null;
    }

    public void parse() throws IOException {
        this.loadData();
        if (this.buf == null) {
            return;
        }
        this.callback.startStylesheet();
        this.openedBlocks = 0;
        this.pos = 0;
        this.numRead = this.buf.length;
        int n = 0;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f') {
                this.skipWhitespaceChars();
            } else if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
            } else if (this.c == '/' && this.buf[this.pos + 1] == '/') {
                this.skipLine();
            } else if (this.c == '@') {
                this.parseAtRule();
            } else if (this.c == '}') {
                if (this.openedBlocks > 0) {
                    --this.openedBlocks;
                    this.callback.endBlock();
                }
                ++this.pos;
            } else if (this.c == '<' && this.buf[this.pos + 1] == '!') {
                this.pos += 4;
            } else if (this.c == '-' && this.buf[this.pos + 1] == '-') {
                this.pos += 3;
                this.callback.resetSelector();
            } else {
                this.parseSelector();
                if (this.c == '{') {
                    this.callback.startDeclBlock();
                    ++this.pos;
                    while (this.parseDeclaration()) {
                    }
                    this.callback.endDeclBlock();
                    ++this.pos;
                }
            }
            if (n == this.pos) {
                // empty if block
            }
            n = ++this.pos;
        }
        this.callback.endStylesheet();
    }

    private final void skipComment() {
        this.pos += 2;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == '*' && this.pos + 1 < this.numRead && this.buf[this.pos + 1] == '/') {
                this.pos += 2;
                if (this.pos >= this.numRead) break;
                this.c = this.buf[this.pos];
                break;
            }
            ++this.pos;
        }
    }

    private final void skipLine() {
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == '\n' || this.c == '\r' || this.c == '\f') {
                this.pos += 2;
                if (this.pos >= this.numRead) break;
                this.c = this.buf[this.pos];
                break;
            }
            ++this.pos;
        }
    }

    private final void skipWhitespaceChars() {
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c != ' ' && this.c != '\t' && this.c != '\n' && this.c != '\r' && this.c != '\f') break;
            ++this.pos;
        }
    }

    private final void parseAtRule() {
        int n = this.pos;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ';' || this.c == '{') break;
            if (this.c == '\'' || this.c == '\"') {
                this.skipString();
                continue;
            }
            ++this.pos;
        }
        this.callback.atRule(this.buf, n + 1, this.pos - n - 1);
        if (this.c == '{') {
            ++this.openedBlocks;
            this.callback.startBlock();
        }
        ++this.pos;
    }

    private final void parseSelector() {
        this.callback.startSelector();
        while (this.pos < this.buf.length - 1) {
            this.parseSimpleSelector();
            this.skipWhitespaceChars();
            if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
            }
            if (this.c == '/' && this.buf[this.pos + 1] == '/') {
                this.skipLine();
            }
            if (this.c == '-' && this.buf[this.pos + 1] == '-') {
                return;
            }
            if (this.c == '{') break;
            if (this.c == '+' || this.c == '>') {
                this.callback.selectorCombinator(this.c);
                ++this.pos;
                this.skipWhitespaceChars();
                if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                    this.skipComment();
                }
                if (this.c != '/' || this.buf[this.pos + 1] != '/') continue;
                this.skipLine();
                continue;
            }
            if (this.c == ',') {
                this.callback.endSelector();
                ++this.pos;
                this.callback.startSelector();
                this.skipWhitespaceChars();
                if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                    this.skipComment();
                }
                if (this.c != '/' || this.buf[this.pos + 1] != '/') continue;
                this.skipLine();
                continue;
            }
            this.callback.selectorCombinator(' ');
        }
        this.callback.endSelector();
    }

    private final void parseSimpleSelector() {
        int n = this.pos;
        int n2 = 0;
        boolean bl = false;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f') {
                bl = true;
                break;
            }
            if (this.c == '+' || this.c == '>') {
                bl = true;
                break;
            }
            if (this.c == ',') {
                bl = true;
                break;
            }
            if (this.c == '{') {
                bl = true;
                break;
            }
            if (this.c == '.' || this.c == '#' || this.c == '[' || this.c == ':') break;
            if (this.c == '|') {
                n2 = this.pos - n + 1;
            } else if (this.c == '-' && this.pos + 1 < this.numRead && this.buf[this.pos + 1] == '-') {
                return;
            }
            ++this.pos;
        }
        if (n < this.pos) {
            this.callback.typeSelector(this.buf, n, this.pos - n, n2);
        }
        if (bl) {
            return;
        }
        while (this.pos < this.numRead) {
            if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
            }
            if (this.c == '/' && this.buf[this.pos + 1] == '/') {
                this.skipLine();
            }
            if (this.c == '{' || this.c == ',') break;
            if (this.c == '.') {
                n = ++this.pos;
                while (this.pos < this.numRead) {
                    this.c = this.buf[this.pos];
                    if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f' || this.c == '+' || this.c == '>' || this.c == '.' || this.c == '#' || this.c == '[' || this.c == '/' || this.c == '{' || this.c == ',' || this.c == ':') break;
                    ++this.pos;
                }
                if (this.pos <= n) continue;
                this.callback.classSelector(this.buf, n, this.pos - n);
                continue;
            }
            if (this.c == '#') {
                n = ++this.pos;
                while (this.pos < this.numRead) {
                    this.c = this.buf[this.pos];
                    if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f' || this.c == '+' || this.c == '>' || this.c == '.' || this.c == '#' || this.c == '[' || this.c == '/' || this.c == '{' || this.c == ',' || this.c == ':') break;
                    ++this.pos;
                }
                if (this.pos <= n) continue;
                this.callback.idSelector(this.buf, n, this.pos - n);
                continue;
            }
            if (this.c == ':') {
                n = ++this.pos;
                while (this.pos < this.numRead) {
                    this.c = this.buf[this.pos];
                    if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f' || this.c == '+' || this.c == '>' || this.c == '.' || this.c == '#' || this.c == '[' || this.c == '/' || this.c == '{' || this.c == ',' || this.c == ':') break;
                    ++this.pos;
                }
                if (this.pos <= n) continue;
                this.callback.pseudoSelector(this.buf, n, this.pos - n);
                continue;
            }
            if (this.c != '[') break;
            n = ++this.pos;
            while (this.pos < this.numRead) {
                this.c = this.buf[this.pos];
                if (this.c == ']') break;
                if (this.c == '\'' || this.c == '\"') {
                    this.skipString();
                    continue;
                }
                ++this.pos;
            }
            if (this.pos > n) {
                this.callback.attributeSelector(this.buf, n, this.pos - n);
            }
            ++this.pos;
        }
    }

    private final boolean parseDeclaration() {
        int n;
        int n2;
        this.skipWhitespaceChars();
        while (this.c == '/' && this.buf[this.pos + 1] == '*') {
            this.skipComment();
            this.skipWhitespaceChars();
        }
        while (this.c == '/' && this.buf[this.pos + 1] == '/') {
            this.skipLine();
        }
        if (this.pos >= this.numRead) {
            return false;
        }
        if (this.c == '}') {
            return false;
        }
        if (this.c == ';') {
            ++this.pos;
            return true;
        }
        int n3 = this.pos;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\r' || this.c == '\f' || this.c == '/' || this.c == ':' || this.c == '=') break;
            ++this.pos;
        }
        if (this.pos >= this.numRead) {
            return false;
        }
        int n4 = this.pos - n3;
        boolean bl = false;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ':' || this.c == '=') {
                bl = true;
                ++this.pos;
                continue;
            }
            if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
                continue;
            }
            if (this.c == '/' && this.buf[this.pos + 1] == '/') {
                this.skipLine();
                continue;
            }
            if (this.c != ' ' && this.c != '\t' && this.c != '\n' && this.c != '\r' && this.c != '\f') break;
            ++this.pos;
        }
        if (this.pos >= this.numRead || !bl) {
            return false;
        }
        int n5 = this.pos;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == '}' || this.c == ';') break;
            if (this.c == '\'' || this.c == '\"') {
                this.skipString();
                continue;
            }
            ++this.pos;
        }
        if (this.pos > this.numRead) {
            return false;
        }
        int n6 = n2 = this.pos;
        while (n2 > n5 && n6 - --n2 < important.length) {
            if (this.buf[n2] == important[important.length - (n6 - n2)]) continue;
            n2 = n6;
            break;
        }
        while (n2 > n5) {
            if ((n = this.buf[--n2]) == 32 || n == 9 || n == 13 || n == 10 || n == 12) continue;
            ++n2;
            break;
        }
        if (n2 == n5) {
            return false;
        }
        n = n2 - n5;
        char c = this.buf[n5];
        char c2 = this.buf[n5 + n - 1];
        if (c == '\'' && c2 == '\'' || c == '\"' && c2 == '\"') {
            this.callback.declaration(this.buf, n3, n4, n5 + 1, n - 2);
        } else {
            this.callback.declaration(this.buf, n3, n4, n5, n);
        }
        if (this.c == ';') {
            ++this.pos;
            return true;
        }
        return false;
    }

    private final void skipString() {
        int n = 1;
        char c = this.buf[this.pos];
        if (c == '\'') {
            this.quotes[0] = false;
        } else if (c == '\"') {
            this.quotes[0] = true;
        } else {
            return;
        }
        ++this.pos;
        while (n > 0 && this.pos < this.numRead) {
            if ((c = this.buf[this.pos++]) == '\'') {
                if (!this.quotes[n - 1]) {
                    --n;
                    continue;
                }
                this.quotes[n++] = false;
                continue;
            }
            if (c != '\"') continue;
            if (this.quotes[n - 1]) {
                --n;
                continue;
            }
            this.quotes[n++] = true;
        }
    }

    private final void loadData() throws IOException {
        boolean bl = false;
        this.pos = 0;
        if (this.reader != null) {
            char[] cArray = new char[2048];
            int n = this.reader.read(cArray, this.pos, cArray.length - this.pos);
            while (n > 0) {
                this.pos += n;
                if (this.pos == cArray.length) {
                    char[] cArray2 = new char[cArray.length * 2];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                }
                n = this.reader.read(cArray, this.pos, cArray.length - this.pos);
            }
            this.buf = new char[this.pos];
            System.arraycopy(cArray, 0, this.buf, 0, this.pos);
            this.reader.close();
            this.reader = null;
        } else {
            byte[] byArray = new byte[2048];
            int n = this.inputStream.read(byArray, this.pos, byArray.length - this.pos);
            while (n > 0) {
                this.pos += n;
                if (this.pos == byArray.length) {
                    byte[] byArray2 = new byte[byArray.length * 2];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    byArray = byArray2;
                }
                n = this.inputStream.read(byArray, this.pos, byArray.length - this.pos);
            }
            this.inputStream.close();
            this.buf = new char[this.pos];
            for (int i = 0; i < this.pos; ++i) {
                this.buf[i] = (char)byArray[i];
            }
            this.inputStream = null;
        }
    }
}

