/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.diagView;

import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.toolbox.dastudio.diagView.DiagnosticMsgContentsInterface;
import com.mathworks.toolbox.dastudio.diagView.DiagnosticMsgInterface;
import com.mathworks.toolbox.dastudio.diagView.DiagnosticViewerInterface;
import com.mathworks.toolbox.dastudio.diagView.DiagnosticViewerSetRunnable;
import com.mathworks.toolbox.dastudio.diagView.DiagnosticViewerTableModel;
import com.mathworks.toolbox.dastudio.diagView.MLStyledTextLabel;
import com.mathworks.toolbox.dastudio.diagView.MatlabWorker;
import com.mathworks.util.ResLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DiagnosticViewerWindow
extends MJFrame {
    private static final int[] DEFAULT_COL_WIDTHS = new int[]{22, 100, 100, 100, 220};
    private static final int ICON_COL_INDEX = 0;
    private static final int MESSAGE_COL_INDEX = 1;
    private static final int SOURCE_COL_INDEX = 2;
    private static final int REPORTER_COL_INDEX = 3;
    private static final int SUMMARY_COL_INDEX = 4;
    private final int NUM_COLUMNS = 5;
    private static ResourceBundle res = ResourceBundle.getBundle("com.mathworks.toolbox.dastudio.diagView.resources.RES_diagViewer");
    private static Class imageLoader = DiagnosticViewerWindow.class;
    private static final ImageIcon BLOCK_ICON = new ImageIcon(imageLoader.getResource("resources/block.gif"));
    private static final ImageIcon NAG_RED_ICON = new ImageIcon(imageLoader.getResource("resources/nag_red.gif"));
    private static final ImageIcon GRAYBALL_ICON = new ImageIcon(imageLoader.getResource("resources/grayball.gif"));
    private static final ImageIcon NAG_BLUE_ICON = new ImageIcon(imageLoader.getResource("resources/nag_blue.gif"));
    private boolean painting = false;
    private JTable viewerTable = new JTable();
    private MLStyledTextLabel summaryText = new MLStyledTextLabel("Summary:");
    private JLabel fullPathText = new JLabel();
    private JLabel fullPathIcon = new JLabel();
    private JButton closeButton = new JButton();
    private JButton openButton = new JButton();
    private JButton helpButton = new JButton();
    private DiagnosticViewerInterface viewerUDD;
    private JMenu sizeMenu = new JMenu(res.getString("diagView.table.fontSize"));
    private JMenu viewMenu = new JMenu(res.getString("diagView.table.view"));
    private JMenuBar menuBar = new JMenuBar();
    private int[] columnIndex = new int[5];
    private TableColumn summaryColumn;
    private TableColumn messageColumn;
    private TableColumn reportColumn;
    private TableColumn sourceColumn;
    private MJCheckBoxMenuItem defaultFontMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.window.defaultFont"), true);
    private MJCheckBoxMenuItem largestFontMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.window.largestFont"), false);
    private MJCheckBoxMenuItem largeFontMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.window.largeFont"), false);
    private MJCheckBoxMenuItem mediumFontMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.window.mediumFont"), false);
    private MJCheckBoxMenuItem smallFontMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.window.smallFont"), false);
    private MJCheckBoxMenuItem smallestFontMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.window.smallestFont"), false);
    private MJCheckBoxMenuItem summaryMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.table.showSummary"), true);
    private MJCheckBoxMenuItem summaryPopMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.table.showSummary"), true);
    private MJCheckBoxMenuItem messageMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.table.showMessage"), true);
    private MJCheckBoxMenuItem messagePopMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.table.showMessage"), true);
    private MJCheckBoxMenuItem sourceMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.table.showSource"), true);
    private MJCheckBoxMenuItem sourcePopMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.table.showSource"), true);
    private MJCheckBoxMenuItem reportMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.table.showReported"), true);
    private MJCheckBoxMenuItem reportPopMenuItem = new MJCheckBoxMenuItem(res.getString("diagView.table.showReported"), true);
    private JPopupMenu viewPopupMenu = new JPopupMenu();
    private JScrollPane tablePane;
    private JSplitPane combinePane;
    private JPanel fullPathPanel;

    public DiagnosticViewerWindow(DiagnosticViewerInterface diagnosticViewerInterface) {
        this.viewerUDD = diagnosticViewerInterface;
        for (int i = 0; i < this.columnIndex.length; ++i) {
            this.columnIndex[i] = i;
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MatlabWorker matlabWorker = new MatlabWorker(){

                    @Override
                    public Object construct() {
                        DiagnosticViewerWindow.this.viewerUDD.setVisible(false);
                        return new Boolean(false);
                    }
                };
                matlabWorker.start();
            }
        });
        this.viewerTable.setSelectionMode(0);
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        Image image = resLoader.loadImage("resources/info.gif");
        this.setIconImage(image);
        this.setSmallIconImage(null);
        this.setTitle(res.getString("diagView.window.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getRootPane().setJMenuBar(this.menuBar);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.sizeMenu);
        class ShowSummaryAction
        extends AbstractAction {
            ShowSummaryAction(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MatlabWorker matlabWorker = new MatlabWorker(){

                    @Override
                    public Object construct() {
                        boolean bl = DiagnosticViewerWindow.this.viewerUDD.getsummaryVisible();
                        boolean bl2 = false;
                        if (!bl) {
                            bl2 = true;
                        }
                        DiagnosticViewerWindow.this.viewerUDD.setsummaryVisible(bl2);
                        return new Boolean(bl2);
                    }
                };
                matlabWorker.start();
            }
        }
        ShowSummaryAction showSummaryAction = new ShowSummaryAction(res.getString("diagView.table.showSummary"));
        class ShowMessageAction
        extends AbstractAction {
            ShowMessageAction(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MatlabWorker matlabWorker = new MatlabWorker(){

                    @Override
                    public Object construct() {
                        boolean bl = DiagnosticViewerWindow.this.viewerUDD.getmessageVisible();
                        boolean bl2 = false;
                        if (!bl) {
                            bl2 = true;
                        }
                        DiagnosticViewerWindow.this.viewerUDD.setmessageVisible(bl2);
                        return new Boolean(true);
                    }
                };
                matlabWorker.start();
            }
        }
        ShowMessageAction showMessageAction = new ShowMessageAction(res.getString("diagView.table.showMessage"));
        class ShowReportAction
        extends AbstractAction {
            ShowReportAction(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MatlabWorker matlabWorker = new MatlabWorker(){

                    @Override
                    public Object construct() {
                        boolean bl = DiagnosticViewerWindow.this.viewerUDD.getreportVisible();
                        boolean bl2 = false;
                        if (!bl) {
                            bl2 = true;
                        }
                        DiagnosticViewerWindow.this.viewerUDD.setreportVisible(bl2);
                        return new Boolean(true);
                    }
                };
                matlabWorker.start();
            }
        }
        ShowReportAction showReportAction = new ShowReportAction(res.getString("diagView.table.showReported"));
        class ShowSourceAction
        extends AbstractAction {
            ShowSourceAction(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MatlabWorker matlabWorker = new MatlabWorker(){

                    @Override
                    public Object construct() {
                        boolean bl = DiagnosticViewerWindow.this.viewerUDD.getsourceVisible();
                        boolean bl2 = false;
                        if (!bl) {
                            bl2 = true;
                        }
                        DiagnosticViewerWindow.this.viewerUDD.setsourceVisible(bl2);
                        return new Boolean(true);
                    }
                };
                matlabWorker.start();
            }
        }
        ShowSourceAction showSourceAction = new ShowSourceAction(res.getString("diagView.table.showSource"));
        this.summaryMenuItem.setAction((Action)showSummaryAction);
        this.summaryPopMenuItem.setAction((Action)showSummaryAction);
        this.messageMenuItem.setAction((Action)showMessageAction);
        this.messagePopMenuItem.setAction((Action)showMessageAction);
        this.reportMenuItem.setAction((Action)showReportAction);
        this.reportPopMenuItem.setAction((Action)showReportAction);
        this.sourceMenuItem.setAction((Action)showSourceAction);
        this.sourcePopMenuItem.setAction((Action)showSourceAction);
        this.viewPopupMenu.add((JMenuItem)this.messagePopMenuItem);
        this.viewMenu.add((JMenuItem)this.messageMenuItem);
        this.viewPopupMenu.add((JMenuItem)this.sourcePopMenuItem);
        this.viewMenu.add((JMenuItem)this.sourceMenuItem);
        this.viewPopupMenu.add((JMenuItem)this.reportPopMenuItem);
        this.viewMenu.add((JMenuItem)this.reportMenuItem);
        this.viewPopupMenu.add((JMenuItem)this.summaryPopMenuItem);
        this.viewMenu.add((JMenuItem)this.summaryMenuItem);
        class ShowDefaultFontAction
        extends AbstractAction {
            ShowDefaultFontAction(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticViewerWindow.this.defaultFontMenuItem.setSelected(true);
                DiagnosticViewerWindow.this.largestFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.largeFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.mediumFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.smallFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.smallestFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.setFontSize(12);
            }
        }
        ShowDefaultFontAction showDefaultFontAction = new ShowDefaultFontAction(res.getString("diagView.window.defaultFont"));
        class ShowLargestFontAction
        extends AbstractAction {
            ShowLargestFontAction(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticViewerWindow.this.largestFontMenuItem.setSelected(true);
                DiagnosticViewerWindow.this.defaultFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.largeFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.mediumFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.smallFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.smallestFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.setFontSize(18);
            }
        }
        ShowLargestFontAction showLargestFontAction = new ShowLargestFontAction(res.getString("diagView.window.largestFont"));
        class ShowLargeFontAction
        extends AbstractAction {
            ShowLargeFontAction(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticViewerWindow.this.largeFontMenuItem.setSelected(true);
                DiagnosticViewerWindow.this.defaultFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.largestFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.mediumFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.smallFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.smallestFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.setFontSize(16);
            }
        }
        ShowLargeFontAction showLargeFontAction = new ShowLargeFontAction(res.getString("diagView.window.largeFont"));
        class ShowMediumFontAction
        extends AbstractAction {
            ShowMediumFontAction(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticViewerWindow.this.mediumFontMenuItem.setSelected(true);
                DiagnosticViewerWindow.this.defaultFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.largestFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.largeFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.smallFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.smallestFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.setFontSize(12);
            }
        }
        ShowMediumFontAction showMediumFontAction = new ShowMediumFontAction(res.getString("diagView.window.mediumFont"));
        class ShowSmallFontAction
        extends AbstractAction {
            ShowSmallFontAction(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticViewerWindow.this.smallFontMenuItem.setSelected(true);
                DiagnosticViewerWindow.this.defaultFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.largestFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.largeFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.mediumFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.smallestFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.setFontSize(9);
            }
        }
        ShowSmallFontAction showSmallFontAction = new ShowSmallFontAction(res.getString("diagView.window.smallFont"));
        class ShowSmallestFontAction
        extends AbstractAction {
            ShowSmallestFontAction(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticViewerWindow.this.smallestFontMenuItem.setSelected(true);
                DiagnosticViewerWindow.this.defaultFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.largestFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.largeFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.mediumFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.smallFontMenuItem.setSelected(false);
                DiagnosticViewerWindow.this.setFontSize(6);
            }
        }
        ShowSmallestFontAction showSmallestFontAction = new ShowSmallestFontAction(res.getString("diagView.window.smallestFont"));
        this.defaultFontMenuItem.setAction((Action)showDefaultFontAction);
        this.largestFontMenuItem.setAction((Action)showLargestFontAction);
        this.largeFontMenuItem.setAction((Action)showLargeFontAction);
        this.mediumFontMenuItem.setAction((Action)showMediumFontAction);
        this.smallFontMenuItem.setAction((Action)showSmallFontAction);
        this.smallestFontMenuItem.setAction((Action)showSmallestFontAction);
        this.sizeMenu.add((JMenuItem)this.defaultFontMenuItem);
        this.sizeMenu.add((JMenuItem)this.largestFontMenuItem);
        this.sizeMenu.add((JMenuItem)this.largeFontMenuItem);
        this.sizeMenu.add((JMenuItem)this.mediumFontMenuItem);
        this.sizeMenu.add((JMenuItem)this.smallFontMenuItem);
        this.sizeMenu.add((JMenuItem)this.smallestFontMenuItem);
        this.summaryText.setBackground(this.getBackground());
        this.summaryText.setScrollOptions(2);
        this.summaryText.setSelectionTracking(true);
        DiagnosticViewerTableModel diagnosticViewerTableModel = new DiagnosticViewerTableModel(this);
        this.modifyDiagnosticViewerTableModel(diagnosticViewerTableModel, true, false);
        diagnosticViewerTableModel.addMouseListenerToHeaderInTable(this.viewerTable);
        class ClickHandler
        extends MouseAdapter {
            ClickHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 1) {
                    final int n2 = DiagnosticViewerWindow.this.viewerTable.getSelectedRow() + 1;
                    if (n2 >= 0) {
                        MatlabWorker matlabWorker = new MatlabWorker(){

                            @Override
                            public Object construct() {
                                DiagnosticViewerWindow.this.viewerUDD.setrowSelected(n2);
                                return new Boolean(true);
                            }
                        };
                        matlabWorker.start();
                    }
                } else if (n == 2) {
                    final int n3 = DiagnosticViewerWindow.this.viewerTable.getSelectedRow() + 1;
                    MatlabWorker matlabWorker = new MatlabWorker(){

                        @Override
                        public Object construct() {
                            DiagnosticViewerWindow.this.viewerUDD.setrowOpen(n3);
                            return new Boolean(true);
                        }
                    };
                    matlabWorker.start();
                }
            }
        }
        ClickHandler clickHandler = new ClickHandler();
        this.viewerTable.addMouseListener(clickHandler);
        class KeyHandler
        extends KeyAdapter {
            private int fLastSelectedRow = 0;

            KeyHandler() {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = DiagnosticViewerWindow.this.viewerTable.getSelectedRow() + 1;
                if (n >= 0) {
                    this.fLastSelectedRow = n;
                    MatlabWorker matlabWorker = new MatlabWorker(){

                        @Override
                        public Object construct() {
                            DiagnosticViewerWindow.this.viewerUDD.setrowSelected(fLastSelectedRow);
                            return new Boolean(true);
                        }
                    };
                    matlabWorker.start();
                }
            }
        }
        KeyHandler keyHandler = new KeyHandler();
        this.viewerTable.addKeyListener(keyHandler);
        this.viewerTable.setDefaultRenderer(ImageIcon.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object == null) {
                    this.setIcon(null);
                    this.setText(null);
                    return this;
                }
                if (n2 == 0) {
                    ImageIcon imageIcon = (ImageIcon)object;
                    this.setIcon(imageIcon);
                    this.setText(null);
                    return this;
                }
                this.setIcon(null);
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.viewerTable.setShowGrid(false);
        this.viewerTable.setAutoResizeMode(0);
        this.viewerTable.setBorder(null);
        this.viewerTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tableColumnModel = this.viewerTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        TableColumn tableColumn3 = tableColumnModel.getColumn(2);
        TableColumn tableColumn4 = tableColumnModel.getColumn(3);
        TableColumn tableColumn5 = tableColumnModel.getColumn(4);
        tableColumn.setMinWidth(DEFAULT_COL_WIDTHS[0]);
        tableColumn.setMaxWidth(DEFAULT_COL_WIDTHS[0]);
        tableColumn2.setMinWidth(DEFAULT_COL_WIDTHS[1]);
        tableColumn3.setMinWidth(DEFAULT_COL_WIDTHS[2]);
        tableColumn4.setMinWidth(DEFAULT_COL_WIDTHS[3]);
        tableColumn5.setMinWidth(DEFAULT_COL_WIDTHS[4]);
        this.tablePane = new JScrollPane(this.viewerTable){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(300, 200);
            }

            @Override
            public void paint(Graphics graphics) {
                graphics.setColor(DiagnosticViewerWindow.this.viewerTable.getBackground());
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                super.paint(graphics);
            }
        };
        this.tablePane.setVerticalScrollBarPolicy(20);
        this.tablePane.setHorizontalScrollBarPolicy(30);
        this.tablePane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DiagnosticViewerWindow.this.resizeAllColumns();
                DiagnosticViewerTableModel diagnosticViewerTableModel = (DiagnosticViewerTableModel)DiagnosticViewerWindow.this.viewerTable.getModel();
                DiagnosticViewerWindow.this.viewerTable.updateUI();
            }
        });
        this.closeButton.setText(res.getString("diagView.window.closeButton"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticViewerWindow.this.summaryText.clearSelection();
                MatlabWorker matlabWorker = new MatlabWorker(){

                    @Override
                    public Object construct() {
                        DiagnosticViewerWindow.this.viewerUDD.setVisible(false);
                        return new Boolean(true);
                    }
                };
                matlabWorker.start();
            }
        });
        this.helpButton.setText(res.getString("diagView.window.helpButton"));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MatlabWorker matlabWorker = new MatlabWorker(){

                    @Override
                    public Object construct() {
                        DiagnosticViewerWindow.this.viewerUDD.helpButton();
                        return new Boolean(true);
                    }
                };
                matlabWorker.start();
            }
        });
        this.openButton.setText(res.getString("diagView.window.openButton"));
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final int n = DiagnosticViewerWindow.this.viewerTable.getSelectedRow() + 1;
                MatlabWorker matlabWorker = new MatlabWorker(){

                    @Override
                    public Object construct() {
                        DiagnosticViewerWindow.this.viewerUDD.setrowOpen(n);
                        return new Boolean(true);
                    }
                };
                matlabWorker.start();
            }
        });
        this.fullPathPanel = new JPanel();
        this.fullPathPanel.add(this.fullPathIcon);
        this.fullPathPanel.add(this.fullPathText);
        this.fullPathPanel.setLayout(new FlowLayout(0, 2, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        EtchedBorder etchedBorder = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.fullPathPanel.setBorder(etchedBorder);
        jPanel.add((Component)((Object)this.summaryText), "Center");
        jPanel.add((Component)this.fullPathPanel, "North");
        this.tablePane.setPreferredSize(new Dimension(600, 200));
        this.fullPathPanel.setPreferredSize(new Dimension(550, 20));
        this.summaryText.setSize(new Dimension(600, 200));
        this.tablePane.getViewport().setBackground(this.viewerTable.getBackground());
        this.setSize(600, 400);
        this.combinePane = new JSplitPane(0, this.tablePane, jPanel);
        this.combinePane.setResizeWeight(0.5);
        this.combinePane.setBorder(null);
        DiagnosticViewerWindow.addComponent(this.getContentPane(), this.combinePane, 0, 0, 1.0, 1.0, 3, 1, 1, new Insets(3, 0, 3, 0), 11);
        DiagnosticViewerWindow.addComponent(this.getContentPane(), this.openButton, 0, 1, 1.0, 0.0, 1, 1, 0, new Insets(3, 0, 7, 3), 13);
        DiagnosticViewerWindow.addComponent(this.getContentPane(), this.helpButton, 1, 1, 0.0, 0.0, 1, 1, 0, new Insets(3, 2, 7, 3), 13);
        DiagnosticViewerWindow.addComponent(this.getContentPane(), this.closeButton, 2, 1, 0.0, 0.0, 1, 1, 0, new Insets(3, 0, 7, 0), 13);
        this.determineComponentLocation();
    }

    public static DiagnosticViewerWindow CreateDiagnosticViewerWindow(DiagnosticViewerInterface diagnosticViewerInterface) {
        SynchronousCreateEvent synchronousCreateEvent = new SynchronousCreateEvent(diagnosticViewerInterface);
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)synchronousCreateEvent);
        return synchronousCreateEvent.getDV();
    }

    public void requestFocus() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.viewerTable.requestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DiagnosticViewerWindow.this.viewerTable.requestFocus();
                }
            });
        }
    }

    public void setMonospacedFontForTextArea() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Font font = DiagnosticViewerWindow.this.viewerTable.getFont();
                Font font2 = new Font("Monospaced", 0, font.getSize());
                DiagnosticViewerWindow.this.summaryText.setFont(font2);
            }
        });
    }

    public void paint(Graphics graphics) {
        this.painting = true;
        int n = this.viewerTable.getRowCount();
        int n2 = this.viewerTable.getSelectedRow();
        if (n > 0 && n2 < 0) {
            this.viewerTable.setRowSelectionInterval(0, 0);
        }
        super.paint(graphics);
        this.painting = false;
    }

    public int getDividerLocation() {
        return this.combinePane.getDividerLocation();
    }

    public void setDividerLocation(double d) {
        SwingUtilities.invokeLater(new DVDividerLocationSetter(d));
    }

    public void postVisible() {
        SynchronousInvokeUtility.SynchronousEvent synchronousEvent = new SynchronousInvokeUtility.SynchronousEvent(){

            public void executeOnSwingThread() {
                DiagnosticViewerWindow.this.combinePane.setDividerLocation(0.5);
            }
        };
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)synchronousEvent);
    }

    public void superSetVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void setVisible(final boolean bl) {
        SynchronousInvokeUtility.SynchronousEvent synchronousEvent = new SynchronousInvokeUtility.SynchronousEvent(){

            public void executeOnSwingThread() {
                DiagnosticViewerWindow.this.superSetVisible(bl);
                if (!bl && DiagnosticViewerWindow.this.isVisible()) {
                    DiagnosticViewerWindow.this.dispose();
                }
            }
        };
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)synchronousEvent);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(120, 120);
        return dimension;
    }

    public void determineComponentLocation() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setBounds(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2, dimension2.width, dimension2.height);
    }

    public void addUDDDiagnosViewer(DiagnosticViewerInterface diagnosticViewerInterface) {
        this.viewerUDD = diagnosticViewerInterface;
    }

    public DiagnosticViewerInterface getUDDDiagnosticViewer() {
        return this.viewerUDD;
    }

    public void setFontSize(int n) {
        SwingUtilities.invokeLater(new DVFontSizeSetter(n));
    }

    public int getSelectedRow() {
        return this.viewerTable.getSelectedRow() + 1;
    }

    public void setSelectedRow(int n) {
        SwingUtilities.invokeLater(new DVSelectedRowSetter(n));
    }

    public JTable getTable() {
        return this.viewerTable;
    }

    public void setWrappingOption(boolean bl) {
        SwingUtilities.invokeLater(new DVWrappingOptionSetter(bl));
    }

    public void setEmptyTextArea() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiagnosticViewerWindow.this.fullPathIcon.setIcon(null);
                DiagnosticViewerWindow.this.fullPathText.setText("");
                DiagnosticViewerWindow.this.summaryText.setText("");
                DiagnosticViewerWindow.this.openButton.setEnabled(false);
            }
        });
    }

    public void setTextArea(DiagnosticMsgInterface diagnosticMsgInterface) throws Exception {
        DiagnosticMsgContentsInterface diagnosticMsgContentsInterface = (DiagnosticMsgContentsInterface)diagnosticMsgInterface.getContents();
        ImageIcon imageIcon = BLOCK_ICON;
        String string = new String("Source:");
        SwingUtilities.invokeLater(new DVTextAreaSetter(imageIcon, diagnosticMsgInterface.getSourceFullName(), diagnosticMsgContentsInterface.getDetails()));
    }

    public int numVisibleColumns() {
        TableColumnModel tableColumnModel = this.viewerTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        return n;
    }

    public boolean isPainting() {
        return this.painting;
    }

    public int numRows() {
        int n = this.viewerTable.getRowCount();
        return n;
    }

    public String getFullPathTextString() {
        String string = this.fullPathText.getText();
        return string;
    }

    public Object getCellValue(int n, int n2) {
        DiagnosticViewerTableModel diagnosticViewerTableModel = (DiagnosticViewerTableModel)this.viewerTable.getModel();
        int n3 = diagnosticViewerTableModel.getRowCount();
        int n4 = diagnosticViewerTableModel.getColumnCount();
        if (n3 < n2 || n4 < n) {
            return null;
        }
        Object object = diagnosticViewerTableModel.getValueAt(n2 - 1, n - 1);
        return object;
    }

    public String getSummaryPanelTextString() {
        String string = this.summaryText.getText();
        return string;
    }

    public void selectDiagnosticMsg(int n) {
        DiagnosticViewerTableModel diagnosticViewerTableModel = (DiagnosticViewerTableModel)this.viewerTable.getModel();
        UDDObject[] uDDObjectArray = this.viewerUDD.getMessages();
        if (uDDObjectArray == null) {
            return;
        }
        int n2 = this.viewerUDD.getrowSelected();
        final int n3 = n;
        if (n2 != n) {
            MatlabWorker matlabWorker = new MatlabWorker(){

                @Override
                public Object construct() {
                    DiagnosticViewerWindow.this.viewerUDD.setrowSelected(n3);
                    return new Boolean(true);
                }
            };
            matlabWorker.start();
        } else {
            MatlabWorker matlabWorker = new MatlabWorker(){

                @Override
                public Object construct() {
                    DiagnosticViewerWindow.this.viewerUDD.setrowSelected(0);
                    DiagnosticViewerWindow.this.viewerUDD.setrowSelected(n3);
                    return new Boolean(true);
                }
            };
            matlabWorker.start();
        }
    }

    public void addDiagnosticMsgs() throws Exception {
        int n;
        DiagnosticViewerTableModel diagnosticViewerTableModel = new DiagnosticViewerTableModel(this);
        UDDObject[] uDDObjectArray = this.viewerUDD.getMessages();
        if (uDDObjectArray == null) {
            return;
        }
        for (n = 0; n < uDDObjectArray.length; ++n) {
            DiagnosticMsgInterface diagnosticMsgInterface = (DiagnosticMsgInterface)uDDObjectArray[n];
            String string = diagnosticMsgInterface.getType();
            ImageIcon imageIcon = string.equalsIgnoreCase("error") ? NAG_RED_ICON : (string.equalsIgnoreCase("warning") ? GRAYBALL_ICON : (string.equalsIgnoreCase("log") || string.equalsIgnoreCase("info") || string.equalsIgnoreCase("diagnostic") ? NAG_BLUE_ICON : NAG_RED_ICON));
            DiagnosticMsgContentsInterface diagnosticMsgContentsInterface = (DiagnosticMsgContentsInterface)diagnosticMsgInterface.getContents();
            String string2 = new String(diagnosticMsgContentsInterface.getType() + " " + diagnosticMsgInterface.getType());
            diagnosticViewerTableModel.addRow(new Object[]{imageIcon, string2, diagnosticMsgInterface.getSourceName(), diagnosticMsgInterface.getComponent(), diagnosticMsgContentsInterface.getSummary()});
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiagnosticViewerWindow.this.openButton.setEnabled(true);
            }
        });
        for (n = 0; n < this.columnIndex.length; ++n) {
            this.columnIndex[n] = n;
        }
        this.modifyDiagnosticViewerTableModel(diagnosticViewerTableModel, true, true);
    }

    public void removeAllMsgs() {
        DiagnosticViewerTableModel diagnosticViewerTableModel = (DiagnosticViewerTableModel)this.viewerTable.getModel();
        this.modifyDiagnosticViewerTableModel(diagnosticViewerTableModel, false, false);
    }

    public void synchronizeColumnVisib() {
        final boolean[] blArray = new boolean[5];
        MatlabWorker matlabWorker = new MatlabWorker(){

            @Override
            public Object construct() {
                blArray[1] = DiagnosticViewerWindow.this.viewerUDD.getmessageVisible();
                blArray[2] = DiagnosticViewerWindow.this.viewerUDD.getsourceVisible();
                blArray[3] = DiagnosticViewerWindow.this.viewerUDD.getreportVisible();
                blArray[4] = DiagnosticViewerWindow.this.viewerUDD.getsummaryVisible();
                return new Boolean(true);
            }

            @Override
            public void finished() {
                double d = DiagnosticViewerWindow.this.totalResizableColumnWidth();
                for (int i = 1; i < 5; ++i) {
                    TableColumnModel tableColumnModel = DiagnosticViewerWindow.this.viewerTable.getColumnModel();
                    if (blArray[i] || DiagnosticViewerWindow.this.columnIndex[i] <= 0) continue;
                    TableColumn tableColumn = tableColumnModel.getColumn(DiagnosticViewerWindow.this.columnIndex[i]);
                    DiagnosticViewerWindow.this.viewerTable.removeColumn(tableColumn);
                    DiagnosticViewerWindow.this.adjustColumnIndicesAfterDeletion(i);
                    ((DiagnosticViewerWindow)DiagnosticViewerWindow.this).columnIndex[i] = -1;
                    DiagnosticViewerWindow.this.resizeColumnsOnHideColumn(i, d);
                }
            }
        };
        matlabWorker.start();
    }

    public void setMessageVisib() {
        MatlabWorker matlabWorker = new MatlabWorker(){

            @Override
            public Object construct() {
                boolean bl = DiagnosticViewerWindow.this.viewerUDD.getmessageVisible();
                Boolean bl2 = new Boolean(bl);
                return bl2;
            }

            @Override
            public void finished() {
                Boolean bl = (Boolean)this.getValue();
                boolean bl2 = bl;
                TableColumnModel tableColumnModel = DiagnosticViewerWindow.this.viewerTable.getColumnModel();
                double d = DiagnosticViewerWindow.this.totalResizableColumnWidth();
                if (!bl2) {
                    DiagnosticViewerWindow.this.messageMenuItem.setState(false);
                    DiagnosticViewerWindow.this.messagePopMenuItem.setState(false);
                    TableColumn tableColumn = tableColumnModel.getColumn(DiagnosticViewerWindow.this.columnIndex[1]);
                    DiagnosticViewerWindow.this.messageColumn = tableColumn;
                    DiagnosticViewerWindow.this.viewerTable.removeColumn(tableColumn);
                    DiagnosticViewerWindow.this.adjustColumnIndicesAfterDeletion(1);
                    ((DiagnosticViewerWindow)DiagnosticViewerWindow.this).columnIndex[1] = -1;
                    DiagnosticViewerWindow.this.printColumnIndices();
                    DiagnosticViewerWindow.this.resizeColumnsOnHideColumn(1, d);
                } else {
                    DiagnosticViewerWindow.this.messageMenuItem.setState(true);
                    DiagnosticViewerWindow.this.messagePopMenuItem.setState(true);
                    DiagnosticViewerWindow.this.viewerTable.addColumn(DiagnosticViewerWindow.this.messageColumn);
                    tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, 1);
                    DiagnosticViewerWindow.this.adjustColumnIndicesAfterAddition(DiagnosticViewerWindow.this.columnIndex[1], 1);
                    ((DiagnosticViewerWindow)DiagnosticViewerWindow.this).columnIndex[1] = 1;
                    DiagnosticViewerWindow.this.printColumnIndices();
                    DiagnosticViewerWindow.this.resizeColumnsOnShowColumn(1, d);
                }
            }
        };
        matlabWorker.start();
    }

    public void setSourceVisib() {
        MatlabWorker matlabWorker = new MatlabWorker(){

            @Override
            public Object construct() {
                Boolean bl = new Boolean(DiagnosticViewerWindow.this.viewerUDD.getsourceVisible());
                return bl;
            }

            @Override
            public void finished() {
                Boolean bl = (Boolean)this.getValue();
                boolean bl2 = bl;
                TableColumnModel tableColumnModel = DiagnosticViewerWindow.this.viewerTable.getColumnModel();
                double d = DiagnosticViewerWindow.this.totalResizableColumnWidth();
                if (!bl2) {
                    DiagnosticViewerWindow.this.sourceMenuItem.setState(false);
                    DiagnosticViewerWindow.this.sourcePopMenuItem.setState(false);
                    TableColumn tableColumn = tableColumnModel.getColumn(DiagnosticViewerWindow.this.columnIndex[2]);
                    DiagnosticViewerWindow.this.sourceColumn = tableColumn;
                    DiagnosticViewerWindow.this.viewerTable.removeColumn(tableColumn);
                    DiagnosticViewerWindow.this.adjustColumnIndicesAfterDeletion(2);
                    ((DiagnosticViewerWindow)DiagnosticViewerWindow.this).columnIndex[2] = -1;
                    DiagnosticViewerWindow.this.printColumnIndices();
                    DiagnosticViewerWindow.this.resizeColumnsOnHideColumn(2, d);
                } else {
                    int n;
                    DiagnosticViewerWindow.this.sourceMenuItem.setState(true);
                    DiagnosticViewerWindow.this.sourcePopMenuItem.setState(true);
                    DiagnosticViewerWindow.this.viewerTable.addColumn(DiagnosticViewerWindow.this.sourceColumn);
                    ((DiagnosticViewerWindow)DiagnosticViewerWindow.this).columnIndex[2] = n = DiagnosticViewerWindow.this.findIndexForColumnInsertion(2);
                    tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, DiagnosticViewerWindow.this.columnIndex[2]);
                    DiagnosticViewerWindow.this.adjustColumnIndicesAfterAddition(DiagnosticViewerWindow.this.columnIndex[2], 2);
                    DiagnosticViewerWindow.this.printColumnIndices();
                    DiagnosticViewerWindow.this.resizeColumnsOnShowColumn(2, d);
                }
            }
        };
        matlabWorker.start();
    }

    public void setReportedVisib() {
        MatlabWorker matlabWorker = new MatlabWorker(){

            @Override
            public Object construct() {
                Boolean bl = new Boolean(DiagnosticViewerWindow.this.viewerUDD.getreportVisible());
                return bl;
            }

            @Override
            public void finished() {
                TableColumnModel tableColumnModel = DiagnosticViewerWindow.this.viewerTable.getColumnModel();
                Boolean bl = (Boolean)this.getValue();
                boolean bl2 = bl;
                double d = DiagnosticViewerWindow.this.totalResizableColumnWidth();
                if (!bl2) {
                    DiagnosticViewerWindow.this.reportMenuItem.setState(false);
                    DiagnosticViewerWindow.this.reportPopMenuItem.setState(false);
                    TableColumn tableColumn = tableColumnModel.getColumn(DiagnosticViewerWindow.this.columnIndex[3]);
                    DiagnosticViewerWindow.this.reportColumn = tableColumn;
                    DiagnosticViewerWindow.this.viewerTable.removeColumn(tableColumn);
                    DiagnosticViewerWindow.this.adjustColumnIndicesAfterDeletion(3);
                    ((DiagnosticViewerWindow)DiagnosticViewerWindow.this).columnIndex[3] = -1;
                    DiagnosticViewerWindow.this.printColumnIndices();
                    DiagnosticViewerWindow.this.resizeColumnsOnHideColumn(3, d);
                } else {
                    int n;
                    DiagnosticViewerWindow.this.reportMenuItem.setState(true);
                    DiagnosticViewerWindow.this.reportPopMenuItem.setState(true);
                    DiagnosticViewerWindow.this.viewerTable.addColumn(DiagnosticViewerWindow.this.reportColumn);
                    ((DiagnosticViewerWindow)DiagnosticViewerWindow.this).columnIndex[3] = n = DiagnosticViewerWindow.this.findIndexForColumnInsertion(3);
                    tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, DiagnosticViewerWindow.this.columnIndex[3]);
                    DiagnosticViewerWindow.this.adjustColumnIndicesAfterAddition(DiagnosticViewerWindow.this.columnIndex[3], 3);
                    DiagnosticViewerWindow.this.printColumnIndices();
                    DiagnosticViewerWindow.this.resizeColumnsOnShowColumn(3, d);
                }
            }
        };
        matlabWorker.start();
    }

    public void setSummaryVisib() {
        MatlabWorker matlabWorker = new MatlabWorker(){

            @Override
            public Object construct() {
                Boolean bl = new Boolean(DiagnosticViewerWindow.this.viewerUDD.getsummaryVisible());
                return bl;
            }

            @Override
            public void finished() {
                Boolean bl = (Boolean)this.getValue();
                boolean bl2 = bl;
                TableColumnModel tableColumnModel = DiagnosticViewerWindow.this.viewerTable.getColumnModel();
                double d = DiagnosticViewerWindow.this.totalResizableColumnWidth();
                if (!bl2) {
                    DiagnosticViewerWindow.this.summaryMenuItem.setState(false);
                    DiagnosticViewerWindow.this.summaryPopMenuItem.setState(false);
                    TableColumn tableColumn = tableColumnModel.getColumn(DiagnosticViewerWindow.this.columnIndex[4]);
                    DiagnosticViewerWindow.this.summaryColumn = tableColumn;
                    DiagnosticViewerWindow.this.viewerTable.removeColumn(tableColumn);
                    DiagnosticViewerWindow.this.adjustColumnIndicesAfterDeletion(4);
                    ((DiagnosticViewerWindow)DiagnosticViewerWindow.this).columnIndex[4] = -1;
                    DiagnosticViewerWindow.this.printColumnIndices();
                    DiagnosticViewerWindow.this.resizeColumnsOnHideColumn(4, d);
                } else {
                    DiagnosticViewerWindow.this.summaryMenuItem.setState(true);
                    DiagnosticViewerWindow.this.summaryPopMenuItem.setState(true);
                    DiagnosticViewerWindow.this.viewerTable.addColumn(DiagnosticViewerWindow.this.summaryColumn);
                    ((DiagnosticViewerWindow)DiagnosticViewerWindow.this).columnIndex[4] = tableColumnModel.getColumnCount() - 1;
                    DiagnosticViewerWindow.this.printColumnIndices();
                    DiagnosticViewerWindow.this.resizeColumnsOnShowColumn(4, d);
                }
            }
        };
        matlabWorker.start();
    }

    public JPopupMenu getVisibPopupMenu() {
        return this.viewPopupMenu;
    }

    private void adjustColumnIndicesAfterDeletion(int n) {
        for (int i = n + 1; i < this.columnIndex.length; ++i) {
            if (this.columnIndex[i] <= 0) continue;
            int n2 = i;
            this.columnIndex[n2] = this.columnIndex[n2] - 1;
        }
    }

    private int findIndexForColumnInsertion(int n) {
        int n2 = -1;
        TableColumnModel tableColumnModel = this.viewerTable.getColumnModel();
        for (int i = n + 1; i < this.columnIndex.length; ++i) {
            if (this.columnIndex[i] <= 0) continue;
            n2 = this.columnIndex[i];
            break;
        }
        if (n2 == -1) {
            n2 = tableColumnModel.getColumnCount() - 1;
        }
        return n2;
    }

    private void adjustColumnIndicesAfterAddition(int n, int n2) {
        for (int i = n + 1; i < this.columnIndex.length; ++i) {
            if (this.columnIndex[i] <= 0 || i == n2) continue;
            int n3 = i;
            this.columnIndex[n3] = this.columnIndex[n3] + 1;
        }
    }

    private void printColumnIndices() {
    }

    private static void addComponent(Container container, Component component, int n, int n2, double d, double d2, int n3, int n4, int n5, Insets insets, int n6) {
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n5;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = n6;
        container.add(component, gridBagConstraints);
    }

    public void setTitleFromUDD(String string) {
        this.setTitle(string);
    }

    public void modifyDiagnosticViewerTableModel(DiagnosticViewerTableModel diagnosticViewerTableModel, boolean bl, boolean bl2) {
        try {
            DiagnosticViewerSetRunnable diagnosticViewerSetRunnable = bl ? (bl2 ? new DiagnosticViewerSetRunnable(this, this.viewerTable, diagnosticViewerTableModel, true) : new DiagnosticViewerSetRunnable(this, this.viewerTable, diagnosticViewerTableModel, false)) : new DiagnosticViewerSetRunnable(this, diagnosticViewerTableModel);
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter((Runnable)diagnosticViewerSetRunnable));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resizeColumnsOnShowColumn(int n, double d) {
        double[] dArray = new double[5];
        TableColumnModel tableColumnModel = this.viewerTable.getColumnModel();
        double d2 = DEFAULT_COL_WIDTHS[n];
        for (int i = 1; i < 5; ++i) {
            int n2 = this.columnIndex[i];
            if (n2 <= 0 || i == n) continue;
            double d3 = (double)tableColumnModel.getColumn(n2).getWidth() / d;
            double d4 = (d - d2) * d3;
            d4 = Math.max((double)DEFAULT_COL_WIDTHS[i], d4);
            tableColumnModel.getColumn(n2).setPreferredWidth((int)Math.round(d4));
        }
        tableColumnModel.getColumn(this.columnIndex[n]).setPreferredWidth(DEFAULT_COL_WIDTHS[n]);
    }

    private void resizeColumnsOnHideColumn(int n, double d) {
        double[] dArray = new double[5];
        TableColumnModel tableColumnModel = this.viewerTable.getColumnModel();
        double d2 = d - this.totalResizableColumnWidth();
        for (int i = 1; i < 5; ++i) {
            int n2 = this.columnIndex[i];
            if (n2 <= 0 || i == n) continue;
            double d3 = (double)tableColumnModel.getColumn(n2).getWidth() / (d - d2);
            double d4 = d * d3;
            tableColumnModel.getColumn(n2).setPreferredWidth((int)Math.round(d4));
        }
    }

    private double totalResizableColumnWidth() {
        TableColumnModel tableColumnModel = this.viewerTable.getColumnModel();
        double d = 0.0;
        for (int i = 1; i < tableColumnModel.getColumnCount(); ++i) {
            d += (double)tableColumnModel.getColumn(i).getWidth();
        }
        return d;
    }

    public void resizeAllColumns() {
        int n;
        int n2 = this.tablePane.getSize().width;
        TableColumnModel tableColumnModel = this.viewerTable.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[5];
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        int[] nArray = new int[5];
        int n3 = 0;
        int n4 = 0;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.viewerTable.getModel();
        int n5 = defaultTableModel.getColumnCount();
        if (n5 <= 0) {
            return;
        }
        TableColumn tableColumn2 = tableColumnModel.getColumn(0);
        tableColumn2.setMinWidth(DEFAULT_COL_WIDTHS[0]);
        tableColumn2.setMaxWidth(DEFAULT_COL_WIDTHS[0]);
        for (n = 0; n < 5; ++n) {
            int n6 = n;
            if (this.columnIndex[n] > 0) {
                n6 = this.columnIndex[n];
                tableColumnArray[n] = tableColumnModel.getColumn(n6);
                if (n > 0) {
                    tableColumnArray[n].setWidth(DEFAULT_COL_WIDTHS[n]);
                }
                nArray[n] = tableColumnArray[n].getWidth();
                tableColumn = tableColumnArray[n];
                n3 = n;
            }
            n4 += nArray[n];
        }
        if (n2 > n4) {
            tableColumn.setWidth(nArray[n3] + n2 - n4 + 45);
        } else {
            n = nArray[n3] - (n4 - n2) + 45;
            if (n > DEFAULT_COL_WIDTHS[n3]) {
                tableColumn.setWidth(n);
            } else {
                tableColumn.setWidth(DEFAULT_COL_WIDTHS[n3]);
            }
        }
        this.viewerTable.sizeColumnsToFit(tableColumnModel.getColumnCount() - 1);
    }

    class DVTextAreaSetter
    implements Runnable {
        private ImageIcon mIcon;
        private String mIconText;
        private String mSummaryText;

        public DVTextAreaSetter(ImageIcon imageIcon, String string, String string2) {
            this.mIcon = imageIcon;
            this.mIconText = string;
            this.mSummaryText = string2;
        }

        @Override
        public void run() {
            DiagnosticViewerWindow.this.fullPathIcon.setIcon(this.mIcon);
            DiagnosticViewerWindow.this.fullPathText.setText(this.mIconText);
            DiagnosticViewerWindow.this.summaryText.setText(this.mSummaryText);
            DiagnosticViewerWindow.this.summaryText.setSelectionTracking(true);
            DiagnosticViewerWindow.this.summaryText.clearSelection();
        }
    }

    class DVWrappingOptionSetter
    implements Runnable {
        private boolean mAutoWrap;

        public DVWrappingOptionSetter(boolean bl) {
            this.mAutoWrap = bl;
        }

        @Override
        public void run() {
            DiagnosticViewerWindow.this.summaryText.setAutoWrap(this.mAutoWrap);
        }
    }

    class DVSelectedRowSetter
    implements Runnable {
        private int mRow;

        public DVSelectedRowSetter(int n) {
            this.mRow = n;
        }

        @Override
        public void run() {
            DiagnosticViewerWindow.this.viewerTable.setRowSelectionInterval(this.mRow - 1, this.mRow - 1);
        }
    }

    class DVFontSizeSetter
    implements Runnable {
        private int mSize;

        public DVFontSizeSetter(int n) {
            this.mSize = n;
        }

        @Override
        public void run() {
            Font font = DiagnosticViewerWindow.this.viewerTable.getFont();
            Font font2 = new Font("SansSerif", 0, this.mSize);
            if (this.mSize == 18) {
                DiagnosticViewerWindow.this.fullPathPanel.setPreferredSize(new Dimension(550, 28));
            } else if (this.mSize == 16) {
                DiagnosticViewerWindow.this.fullPathPanel.setPreferredSize(new Dimension(550, 25));
            } else {
                DiagnosticViewerWindow.this.fullPathPanel.setPreferredSize(new Dimension(550, 20));
            }
            DiagnosticViewerWindow.this.summaryText.setFont(font2);
            DiagnosticViewerWindow.this.fullPathText.setFont(font2);
            DiagnosticViewerWindow.this.viewerTable.setFont(font2);
            DiagnosticViewerWindow.this.viewerTable.setRowHeight(this.mSize + 4);
        }
    }

    class DVDividerLocationSetter
    implements Runnable {
        private double mNewLocation;

        public DVDividerLocationSetter(double d) {
            this.mNewLocation = d;
        }

        @Override
        public void run() {
            DiagnosticViewerWindow.this.combinePane.setDividerLocation(this.mNewLocation);
        }
    }

    private static class SynchronousCreateEvent
    extends SynchronousInvokeUtility.SynchronousEvent {
        private DiagnosticViewerWindow _dv = null;
        private DiagnosticViewerInterface _viewerIn;

        public DiagnosticViewerWindow getDV() {
            return this._dv;
        }

        public SynchronousCreateEvent(DiagnosticViewerInterface diagnosticViewerInterface) {
            this._viewerIn = diagnosticViewerInterface;
        }

        public void executeOnSwingThread() {
            this._dv = new DiagnosticViewerWindow(this._viewerIn);
        }
    }
}

