/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineSound
extends DefinitionTag {
    public static final int NONE = 0;
    public static final int ADPCM = 1;
    public static final int MP3 = 2;
    public static final int NELLYMOSER = 3;
    public static final int RATE_5_5 = 0;
    public static final int RATE_11 = 1;
    public static final int RATE_22 = 2;
    public static final int RATE_44 = 3;
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int MONO = 0;
    public static final int STEREO = 1;
    private int character;
    private int format;
    private int rate;
    private int size;
    private boolean stereo;
    private long samples;
    private int[] data;

    public DefineSound(int id, int format, int rate, int size, boolean stereo, long samples, int[] data) {
        this();
        this.character = id;
        this.format = format;
        this.rate = rate;
        this.size = size;
        this.stereo = stereo;
        this.samples = samples;
        this.data = data;
    }

    public DefineSound() {
        super(14, 1);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineSound tag = new DefineSound();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        tag.format = (int)swf.readUBits(4);
        tag.rate = (int)swf.readUBits(2);
        tag.size = swf.readBitFlag() ? 1 : 0;
        tag.stereo = swf.readBitFlag();
        tag.samples = swf.readUnsignedInt();
        tag.data = swf.readUnsignedByte(len - 7);
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.writeUBits(this.format, 4);
        swf.writeUBits(this.rate, 2);
        swf.writeBitFlag(this.size == 1);
        swf.writeBitFlag(this.stereo);
        swf.writeUnsignedInt(this.samples);
        swf.writeUnsignedByte(this.data);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character + "\n");
        s.append("  format:" + this.format + "\n");
        s.append("  rate:" + this.rate + "\n");
        s.append("  size:" + this.size + "\n");
        s.append("  stereo:" + this.stereo + "\n");
        s.append("  samples:" + this.samples + "\n");
        s.append("  length:" + this.data.length + "\n");
        return s.toString();
    }
}

