/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.process.CommandLine;
import com.mathworks.toolbox.distcomp.process.InvalidUserOrPasswordException;
import com.mathworks.toolbox.distcomp.util.concurrent.Predicate;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import com.mathworks.toolbox.distcomp.worker.matlab.PackageInfo;
import com.mathworks.toolbox.distcomp.worker.matlab.Pinger;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessEndedListener;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessShepherd;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessStateListener;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessTimeoutException;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessWatcher;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class ProcessShepherdImpl
implements ProcessShepherd {
    private final ReentrantLock fLock = new ReentrantLock();
    private final Condition fProcessShutdown = this.fLock.newPredicateCondition(new Predicate(){

        @Override
        public boolean test() {
            return ProcessShepherdImpl.this.getState() == ProcessShepherd.State.SHUTDOWN;
        }
    });
    private final Condition fProcessHasStoppedStarting = this.fLock.newPredicateCondition(new Predicate(){

        @Override
        public boolean test() {
            return ProcessShepherdImpl.this.getState() != ProcessShepherd.State.STARTING;
        }
    });
    private final ProcessEndedListener fProcessEndedListener;
    private final Pinger fPinger;
    private ProcessShepherd.State fState = ProcessShepherd.State.SHUTDOWN;
    private Process fProcess = null;

    public ProcessShepherdImpl(Pinger pinger, ProcessEndedListener processEndedListener) {
        this.fPinger = pinger;
        this.fProcessEndedListener = processEndedListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessShepherd.State getState() {
        this.fLock.lock();
        try {
            ProcessShepherd.State state = this.fState;
            return state;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public synchronized void start(CommandLine commandLine) throws IOException, InvalidUserOrPasswordException {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Starting process");
        int n = 5;
        long l = 500L;
        this.fProcess = commandLine.start(n, l);
        this.changeStateFromShutdownToStarting();
        ProcessStateListener processStateListener = new ProcessStateListener(){

            @Override
            public void processStarted() {
                ProcessShepherdImpl.this.changeStateFromStartingToRunning();
            }

            @Override
            public void processShutdown(int n) {
                ProcessShepherdImpl.this.changeStateToShutdown(n);
            }
        };
        ProcessWatcher processWatcher = new ProcessWatcher(this.fProcess, this.fPinger, processStateListener);
        processWatcher.startWatching();
    }

    @Override
    public synchronized void shutdown() {
        assert (this.fProcess != null) : "Can't shutdown a null process.";
        this.fProcess.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStateToShutdown(int n) {
        if (this.fProcessEndedListener != null) {
            this.fProcessEndedListener.processEnded(n);
        }
        this.fLock.lock();
        try {
            this.setState(ProcessShepherd.State.SHUTDOWN);
            this.fProcessHasStoppedStarting.signalAll();
            this.fProcessShutdown.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStateFromShutdownToStarting() {
        this.fLock.lock();
        try {
            this.setState(ProcessShepherd.State.STARTING);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStateFromStartingToRunning() {
        this.fLock.lock();
        try {
            this.setState(ProcessShepherd.State.RUNNING);
            this.fProcessHasStoppedStarting.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForProcessToShutdown() throws InterruptedException {
        this.fLock.lock();
        try {
            this.fProcessShutdown.await();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForProcessToShutdown(int n, TimeUnit timeUnit) throws InterruptedException {
        this.fLock.lock();
        try {
            boolean bl = this.fProcessShutdown.await(n, timeUnit);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForProcessToStopStarting(long l, TimeUnit timeUnit) throws ProcessTimeoutException, InterruptedException {
        this.fLock.lock();
        try {
            boolean bl = this.fProcessHasStoppedStarting.await(l, timeUnit);
            if (!bl) {
                throw new ProcessTimeoutException("Timeout while waiting for process startup to complete", l, timeUnit);
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ProcessShepherd.State state) {
        this.fLock.lock();
        try {
            this.fState = state;
        }
        finally {
            this.fLock.unlock();
        }
    }
}

