/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.util.ArraySerializer;
import com.mathworks.toolbox.distcomp.worker.matlab.AbstractFevalProvider;
import com.mathworks.toolbox.distcomp.worker.matlab.MatlabTaskEvaluator;
import com.mathworks.toolbox.distcomp.worker.matlab.NativeIpc;
import com.mathworks.toolbox.distcomp.worker.matlab.PackageInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

class NativeIpcFevalProvider
extends AbstractFevalProvider {
    private static final String FEVAL_GATEWAY = "com.mathworks.toolbox.distcomp.cwo.FevalGateway.feval";
    private MatlabTaskEvaluator fMatlabTaskEvaluator;

    public NativeIpcFevalProvider(MatlabTaskEvaluator matlabTaskEvaluator) {
        this.fMatlabTaskEvaluator = matlabTaskEvaluator;
    }

    @Override
    public boolean feval(String string, Object[] objectArray) throws IOException {
        String string2 = this.fMatlabTaskEvaluator.getIpcAddressForCurrentUserIdentity();
        Object[] objectArray2 = this.prependFunctionName(string, objectArray);
        byte[] byArray = ArraySerializer.serialize(objectArray2);
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Calling MATLAB to feval '" + string + '\"');
        try {
            int n = NativeIpc.feval(string2, FEVAL_GATEWAY, byArray);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "MATLAB returned execution status " + n);
            int n2 = 0;
            return n == n2;
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "feval threw exception: " + iOException.getMessage());
            throw iOException;
        }
    }

    private Object[] prependFunctionName(String string, Object[] objectArray) {
        LinkedList<Object> linkedList = new LinkedList<Object>(Arrays.asList(objectArray));
        linkedList.addFirst(string);
        return linkedList.toArray();
    }
}

