/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import java.rmi.Naming;
import java.rmi.activation.ActivationSystem;

public class ActivationSystemFinder {
    private String fHost;
    private int fPort;
    private static final Object MDCS_NOT_FOUND_CAUSE = "MDCS_NOT_FOUND_CAUSE";
    private static final Object MDCS_NOT_FOUND = "MDCS_NOT_FOUND";

    public ActivationSystemFinder(String string, int n) {
        this.fHost = string;
        this.fPort = n;
        this.fHost = this.fHost == null ? "" : this.fHost;
        this.fPort = this.fPort <= 0 ? 1098 : this.fPort;
    }

    public ActivationSystem findSystemTryOnce() {
        try {
            return (ActivationSystem)Naming.lookup("//" + this.fHost + ":" + this.fPort + "/java.rmi.activation.ActivationSystem");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ActivationSystem findSystemTryManyTimes() {
        ActivationSystem activationSystem = null;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        while (activationSystem == null && l2 + 5000L <= 60000L) {
            if (l2 > 0L) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            activationSystem = this.findSystemTryOnce();
            l2 = System.currentTimeMillis() - l;
        }
        return activationSystem;
    }

    public ActivationSystem verifySystemTryManyTimes() throws DistcompDiagnosticException {
        ActivationSystem activationSystem = this.findSystemTryManyTimes();
        if (activationSystem == null) {
            throw this.getNotFoundException();
        }
        return activationSystem;
    }

    public ActivationSystem verifySystemTryOnce() throws DistcompDiagnosticException {
        ActivationSystem activationSystem = this.findSystemTryOnce();
        if (activationSystem == null) {
            throw this.getNotFoundException();
        }
        return activationSystem;
    }

    private DistcompDiagnosticException getNotFoundException() {
        return new DistcompNotFoundException(this.fHost, this.fPort);
    }

    private static class DistcompNotFoundException
    extends DistcompDiagnosticException {
        public DistcompNotFoundException(String string, int n) {
            super(new DistcompDiagnosticException(null, MDCS_NOT_FOUND_CAUSE, new Object[0]), MDCS_NOT_FOUND, string, n);
        }
    }
}

